<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mbkm_jadwal_view = new mbkm_jadwal_view();

// Run the page
$mbkm_jadwal_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mbkm_jadwal_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$mbkm_jadwal_view->isExport()) { ?>
<script>
var fmbkm_jadwalview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fmbkm_jadwalview = currentForm = new ew.Form("fmbkm_jadwalview", "view");
	loadjs.done("fmbkm_jadwalview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$mbkm_jadwal_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $mbkm_jadwal_view->ExportOptions->render("body") ?>
<?php $mbkm_jadwal_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $mbkm_jadwal_view->showPageHeader(); ?>
<?php
$mbkm_jadwal_view->showMessage();
?>
<form name="fmbkm_jadwalview" id="fmbkm_jadwalview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mbkm_jadwal">
<input type="hidden" name="modal" value="<?php echo (int)$mbkm_jadwal_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($mbkm_jadwal_view->Kode_Fak->Visible) { // Kode_Fak ?>
	<tr id="r_Kode_Fak">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_Kode_Fak"><?php echo $mbkm_jadwal_view->Kode_Fak->caption() ?></span></td>
		<td data-name="Kode_Fak" <?php echo $mbkm_jadwal_view->Kode_Fak->cellAttributes() ?>>
<span id="el_mbkm_jadwal_Kode_Fak">
<span<?php echo $mbkm_jadwal_view->Kode_Fak->viewAttributes() ?>><?php echo $mbkm_jadwal_view->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->Tahun_Akd->Visible) { // Tahun_Akd ?>
	<tr id="r_Tahun_Akd">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_Tahun_Akd"><?php echo $mbkm_jadwal_view->Tahun_Akd->caption() ?></span></td>
		<td data-name="Tahun_Akd" <?php echo $mbkm_jadwal_view->Tahun_Akd->cellAttributes() ?>>
<span id="el_mbkm_jadwal_Tahun_Akd">
<span<?php echo $mbkm_jadwal_view->Tahun_Akd->viewAttributes() ?>><?php echo $mbkm_jadwal_view->Tahun_Akd->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->Periode->Visible) { // Periode ?>
	<tr id="r_Periode">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_Periode"><?php echo $mbkm_jadwal_view->Periode->caption() ?></span></td>
		<td data-name="Periode" <?php echo $mbkm_jadwal_view->Periode->cellAttributes() ?>>
<span id="el_mbkm_jadwal_Periode">
<span<?php echo $mbkm_jadwal_view->Periode->viewAttributes() ?>><?php echo $mbkm_jadwal_view->Periode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->Status_Akd->Visible) { // Status_Akd ?>
	<tr id="r_Status_Akd">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_Status_Akd"><?php echo $mbkm_jadwal_view->Status_Akd->caption() ?></span></td>
		<td data-name="Status_Akd" <?php echo $mbkm_jadwal_view->Status_Akd->cellAttributes() ?>>
<span id="el_mbkm_jadwal_Status_Akd">
<span<?php echo $mbkm_jadwal_view->Status_Akd->viewAttributes() ?>><?php echo $mbkm_jadwal_view->Status_Akd->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->TM->Visible) { // TM ?>
	<tr id="r_TM">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_TM"><?php echo $mbkm_jadwal_view->TM->caption() ?></span></td>
		<td data-name="TM" <?php echo $mbkm_jadwal_view->TM->cellAttributes() ?>>
<span id="el_mbkm_jadwal_TM">
<span<?php echo $mbkm_jadwal_view->TM->viewAttributes() ?>><?php echo $mbkm_jadwal_view->TM->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->TS->Visible) { // TS ?>
	<tr id="r_TS">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_TS"><?php echo $mbkm_jadwal_view->TS->caption() ?></span></td>
		<td data-name="TS" <?php echo $mbkm_jadwal_view->TS->cellAttributes() ?>>
<span id="el_mbkm_jadwal_TS">
<span<?php echo $mbkm_jadwal_view->TS->viewAttributes() ?>><?php echo $mbkm_jadwal_view->TS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->NoSKPenugasan->Visible) { // NoSKPenugasan ?>
	<tr id="r_NoSKPenugasan">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_NoSKPenugasan"><?php echo $mbkm_jadwal_view->NoSKPenugasan->caption() ?></span></td>
		<td data-name="NoSKPenugasan" <?php echo $mbkm_jadwal_view->NoSKPenugasan->cellAttributes() ?>>
<span id="el_mbkm_jadwal_NoSKPenugasan">
<span<?php echo $mbkm_jadwal_view->NoSKPenugasan->viewAttributes() ?>><?php echo $mbkm_jadwal_view->NoSKPenugasan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->TglST->Visible) { // TglST ?>
	<tr id="r_TglST">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_TglST"><?php echo $mbkm_jadwal_view->TglST->caption() ?></span></td>
		<td data-name="TglST" <?php echo $mbkm_jadwal_view->TglST->cellAttributes() ?>>
<span id="el_mbkm_jadwal_TglST">
<span<?php echo $mbkm_jadwal_view->TglST->viewAttributes() ?>><?php echo $mbkm_jadwal_view->TglST->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->PejabatTTD->Visible) { // PejabatTTD ?>
	<tr id="r_PejabatTTD">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_PejabatTTD"><?php echo $mbkm_jadwal_view->PejabatTTD->caption() ?></span></td>
		<td data-name="PejabatTTD" <?php echo $mbkm_jadwal_view->PejabatTTD->cellAttributes() ?>>
<span id="el_mbkm_jadwal_PejabatTTD">
<span<?php echo $mbkm_jadwal_view->PejabatTTD->viewAttributes() ?>><?php echo $mbkm_jadwal_view->PejabatTTD->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mbkm_jadwal_view->NIDNTTD->Visible) { // NIDNTTD ?>
	<tr id="r_NIDNTTD">
		<td class="<?php echo $mbkm_jadwal_view->TableLeftColumnClass ?>"><span id="elh_mbkm_jadwal_NIDNTTD"><?php echo $mbkm_jadwal_view->NIDNTTD->caption() ?></span></td>
		<td data-name="NIDNTTD" <?php echo $mbkm_jadwal_view->NIDNTTD->cellAttributes() ?>>
<span id="el_mbkm_jadwal_NIDNTTD">
<span<?php echo $mbkm_jadwal_view->NIDNTTD->viewAttributes() ?>><?php echo $mbkm_jadwal_view->NIDNTTD->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("mbkm_siswa", explode(",", $mbkm_jadwal->getCurrentDetailTable())) && $mbkm_siswa->DetailView) {
?>
<?php if ($mbkm_jadwal->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("mbkm_siswa", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $mbkm_jadwal_view->mbkm_siswa_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "mbkm_siswagrid.php" ?>
<?php } ?>
</form>
<?php
$mbkm_jadwal_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$mbkm_jadwal_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$mbkm_jadwal_view->terminate();
?>