<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mbkm_siswa_list = new mbkm_siswa_list();

// Run the page
$mbkm_siswa_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mbkm_siswa_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$mbkm_siswa_list->isExport()) { ?>
<script>
var fmbkm_siswalist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fmbkm_siswalist = currentForm = new ew.Form("fmbkm_siswalist", "list");
	fmbkm_siswalist.formKeyCountName = '<?php echo $mbkm_siswa_list->FormKeyCountName ?>';

	// Validate form
	fmbkm_siswalist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($mbkm_siswa_list->Kode_Jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->Kode_Jp->caption(), $mbkm_siswa_list->Kode_Jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->Nim->caption(), $mbkm_siswa_list->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->Kmbkm->Required) { ?>
				elm = this.getElements("x" + infix + "_Kmbkm");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->Kmbkm->caption(), $mbkm_siswa_list->Kmbkm->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->NIDN->caption(), $mbkm_siswa_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->Title->Required) { ?>
				elm = this.getElements("x" + infix + "_Title");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->Title->caption(), $mbkm_siswa_list->Title->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->dari->Required) { ?>
				elm = this.getElements("x" + infix + "_dari");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->dari->caption(), $mbkm_siswa_list->dari->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($mbkm_siswa_list->sampai->Required) { ?>
				elm = this.getElements("x" + infix + "_sampai");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mbkm_siswa_list->sampai->caption(), $mbkm_siswa_list->sampai->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fmbkm_siswalist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fmbkm_siswalist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fmbkm_siswalist.lists["x_Kode_Jp"] = <?php echo $mbkm_siswa_list->Kode_Jp->Lookup->toClientList($mbkm_siswa_list) ?>;
	fmbkm_siswalist.lists["x_Kode_Jp"].options = <?php echo JsonEncode($mbkm_siswa_list->Kode_Jp->lookupOptions()) ?>;
	fmbkm_siswalist.lists["x_Nim"] = <?php echo $mbkm_siswa_list->Nim->Lookup->toClientList($mbkm_siswa_list) ?>;
	fmbkm_siswalist.lists["x_Nim"].options = <?php echo JsonEncode($mbkm_siswa_list->Nim->lookupOptions()) ?>;
	fmbkm_siswalist.lists["x_Kmbkm"] = <?php echo $mbkm_siswa_list->Kmbkm->Lookup->toClientList($mbkm_siswa_list) ?>;
	fmbkm_siswalist.lists["x_Kmbkm"].options = <?php echo JsonEncode($mbkm_siswa_list->Kmbkm->lookupOptions()) ?>;
	fmbkm_siswalist.lists["x_NIDN"] = <?php echo $mbkm_siswa_list->NIDN->Lookup->toClientList($mbkm_siswa_list) ?>;
	fmbkm_siswalist.lists["x_NIDN"].options = <?php echo JsonEncode($mbkm_siswa_list->NIDN->lookupOptions()) ?>;
	loadjs.done("fmbkm_siswalist");
});
var fmbkm_siswalistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fmbkm_siswalistsrch = currentSearchForm = new ew.Form("fmbkm_siswalistsrch");

	// Validate function for search
	fmbkm_siswalistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fmbkm_siswalistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fmbkm_siswalistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fmbkm_siswalistsrch.lists["x_Kode_Jp"] = <?php echo $mbkm_siswa_list->Kode_Jp->Lookup->toClientList($mbkm_siswa_list) ?>;
	fmbkm_siswalistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($mbkm_siswa_list->Kode_Jp->lookupOptions()) ?>;

	// Filters
	fmbkm_siswalistsrch.filterList = <?php echo $mbkm_siswa_list->getFilterList() ?>;
	loadjs.done("fmbkm_siswalistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$mbkm_siswa_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mbkm_siswa_list->TotalRecords > 0 && $mbkm_siswa_list->ExportOptions->visible()) { ?>
<?php $mbkm_siswa_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_siswa_list->ImportOptions->visible()) { ?>
<?php $mbkm_siswa_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_siswa_list->SearchOptions->visible()) { ?>
<?php $mbkm_siswa_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_siswa_list->FilterOptions->visible()) { ?>
<?php $mbkm_siswa_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$mbkm_siswa_list->isExport() || Config("EXPORT_MASTER_RECORD") && $mbkm_siswa_list->isExport("print")) { ?>
<?php
if ($mbkm_siswa_list->DbMasterFilter != "" && $mbkm_siswa->getCurrentMasterTable() == "mbkm_jadwal") {
	if ($mbkm_siswa_list->MasterRecordExists) {
		include_once "mbkm_jadwalmaster.php";
	}
}
?>
<?php } ?>
<?php
$mbkm_siswa_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mbkm_siswa_list->isExport() && !$mbkm_siswa->CurrentAction) { ?>
<form name="fmbkm_siswalistsrch" id="fmbkm_siswalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fmbkm_siswalistsrch-search-panel" class="<?php echo $mbkm_siswa_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mbkm_siswa">
	<div class="ew-extended-search">
<?php

// Render search row
$mbkm_siswa->RowType = ROWTYPE_SEARCH;
$mbkm_siswa->resetAttributes();
$mbkm_siswa_list->renderRow();
?>
<?php if ($mbkm_siswa_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$mbkm_siswa_list->SearchColumnCount++;
		if (($mbkm_siswa_list->SearchColumnCount - 1) % $mbkm_siswa_list->SearchFieldsPerRow == 0) {
			$mbkm_siswa_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $mbkm_siswa_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $mbkm_siswa_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_mbkm_siswa_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Kode_Jp" data-value-separator="<?php echo $mbkm_siswa_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $mbkm_siswa_list->Kode_Jp->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Kode_Jp->Lookup->getParamTag($mbkm_siswa_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($mbkm_siswa_list->SearchColumnCount % $mbkm_siswa_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($mbkm_siswa_list->SearchColumnCount % $mbkm_siswa_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $mbkm_siswa_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($mbkm_siswa_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($mbkm_siswa_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mbkm_siswa_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mbkm_siswa_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mbkm_siswa_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mbkm_siswa_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mbkm_siswa_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $mbkm_siswa_list->showPageHeader(); ?>
<?php
$mbkm_siswa_list->showMessage();
?>
<?php if ($mbkm_siswa_list->TotalRecords > 0 || $mbkm_siswa->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mbkm_siswa_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mbkm_siswa">
<form name="fmbkm_siswalist" id="fmbkm_siswalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mbkm_siswa">
<?php if ($mbkm_siswa->getCurrentMasterTable() == "mbkm_jadwal" && $mbkm_siswa->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="mbkm_jadwal">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Fak->getSessionValue()) ?>">
<input type="hidden" name="fk_Tahun_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Tahun_Akd->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($mbkm_siswa_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Status_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Status_Akd->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_mbkm_siswa" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($mbkm_siswa_list->TotalRecords > 0 || $mbkm_siswa_list->isGridEdit()) { ?>
<table id="tbl_mbkm_siswalist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mbkm_siswa->RowType = ROWTYPE_HEADER;

// Render list options
$mbkm_siswa_list->renderListOptions();

// Render list options (header, left)
$mbkm_siswa_list->ListOptions->render("header", "left");
?>
<?php if ($mbkm_siswa_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $mbkm_siswa_list->Kode_Jp->headerCellClass() ?>"><div id="elh_mbkm_siswa_Kode_Jp" class="mbkm_siswa_Kode_Jp"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $mbkm_siswa_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->Kode_Jp) ?>', 1);"><div id="elh_mbkm_siswa_Kode_Jp" class="mbkm_siswa_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->Nim->Visible) { // Nim ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $mbkm_siswa_list->Nim->headerCellClass() ?>"><div id="elh_mbkm_siswa_Nim" class="mbkm_siswa_Nim"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $mbkm_siswa_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->Nim) ?>', 1);"><div id="elh_mbkm_siswa_Nim" class="mbkm_siswa_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->Kmbkm->Visible) { // Kmbkm ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->Kmbkm) == "") { ?>
		<th data-name="Kmbkm" class="<?php echo $mbkm_siswa_list->Kmbkm->headerCellClass() ?>"><div id="elh_mbkm_siswa_Kmbkm" class="mbkm_siswa_Kmbkm"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Kmbkm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kmbkm" class="<?php echo $mbkm_siswa_list->Kmbkm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->Kmbkm) ?>', 1);"><div id="elh_mbkm_siswa_Kmbkm" class="mbkm_siswa_Kmbkm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Kmbkm->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->Kmbkm->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->Kmbkm->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->NIDN->Visible) { // NIDN ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $mbkm_siswa_list->NIDN->headerCellClass() ?>"><div id="elh_mbkm_siswa_NIDN" class="mbkm_siswa_NIDN"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $mbkm_siswa_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->NIDN) ?>', 1);"><div id="elh_mbkm_siswa_NIDN" class="mbkm_siswa_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->Title->Visible) { // Title ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->Title) == "") { ?>
		<th data-name="Title" class="<?php echo $mbkm_siswa_list->Title->headerCellClass() ?>"><div id="elh_mbkm_siswa_Title" class="mbkm_siswa_Title"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Title" class="<?php echo $mbkm_siswa_list->Title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->Title) ?>', 1);"><div id="elh_mbkm_siswa_Title" class="mbkm_siswa_Title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->Title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->Title->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->Title->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->dari->Visible) { // dari ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->dari) == "") { ?>
		<th data-name="dari" class="<?php echo $mbkm_siswa_list->dari->headerCellClass() ?>"><div id="elh_mbkm_siswa_dari" class="mbkm_siswa_dari"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->dari->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dari" class="<?php echo $mbkm_siswa_list->dari->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->dari) ?>', 1);"><div id="elh_mbkm_siswa_dari" class="mbkm_siswa_dari">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->dari->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->dari->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->dari->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_siswa_list->sampai->Visible) { // sampai ?>
	<?php if ($mbkm_siswa_list->SortUrl($mbkm_siswa_list->sampai) == "") { ?>
		<th data-name="sampai" class="<?php echo $mbkm_siswa_list->sampai->headerCellClass() ?>"><div id="elh_mbkm_siswa_sampai" class="mbkm_siswa_sampai"><div class="ew-table-header-caption"><?php echo $mbkm_siswa_list->sampai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sampai" class="<?php echo $mbkm_siswa_list->sampai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_siswa_list->SortUrl($mbkm_siswa_list->sampai) ?>', 1);"><div id="elh_mbkm_siswa_sampai" class="mbkm_siswa_sampai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_siswa_list->sampai->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_siswa_list->sampai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_siswa_list->sampai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mbkm_siswa_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mbkm_siswa_list->ExportAll && $mbkm_siswa_list->isExport()) {
	$mbkm_siswa_list->StopRecord = $mbkm_siswa_list->TotalRecords;
} else {

	// Set the last record to display
	if ($mbkm_siswa_list->TotalRecords > $mbkm_siswa_list->StartRecord + $mbkm_siswa_list->DisplayRecords - 1)
		$mbkm_siswa_list->StopRecord = $mbkm_siswa_list->StartRecord + $mbkm_siswa_list->DisplayRecords - 1;
	else
		$mbkm_siswa_list->StopRecord = $mbkm_siswa_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($mbkm_siswa->isConfirm() || $mbkm_siswa_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($mbkm_siswa_list->FormKeyCountName) && ($mbkm_siswa_list->isGridAdd() || $mbkm_siswa_list->isGridEdit() || $mbkm_siswa->isConfirm())) {
		$mbkm_siswa_list->KeyCount = $CurrentForm->getValue($mbkm_siswa_list->FormKeyCountName);
		$mbkm_siswa_list->StopRecord = $mbkm_siswa_list->StartRecord + $mbkm_siswa_list->KeyCount - 1;
	}
}
$mbkm_siswa_list->RecordCount = $mbkm_siswa_list->StartRecord - 1;
if ($mbkm_siswa_list->Recordset && !$mbkm_siswa_list->Recordset->EOF) {
	$mbkm_siswa_list->Recordset->moveFirst();
	$selectLimit = $mbkm_siswa_list->UseSelectLimit;
	if (!$selectLimit && $mbkm_siswa_list->StartRecord > 1)
		$mbkm_siswa_list->Recordset->move($mbkm_siswa_list->StartRecord - 1);
} elseif (!$mbkm_siswa->AllowAddDeleteRow && $mbkm_siswa_list->StopRecord == 0) {
	$mbkm_siswa_list->StopRecord = $mbkm_siswa->GridAddRowCount;
}

// Initialize aggregate
$mbkm_siswa->RowType = ROWTYPE_AGGREGATEINIT;
$mbkm_siswa->resetAttributes();
$mbkm_siswa_list->renderRow();
if ($mbkm_siswa_list->isGridEdit())
	$mbkm_siswa_list->RowIndex = 0;
while ($mbkm_siswa_list->RecordCount < $mbkm_siswa_list->StopRecord) {
	$mbkm_siswa_list->RecordCount++;
	if ($mbkm_siswa_list->RecordCount >= $mbkm_siswa_list->StartRecord) {
		$mbkm_siswa_list->RowCount++;
		if ($mbkm_siswa_list->isGridAdd() || $mbkm_siswa_list->isGridEdit() || $mbkm_siswa->isConfirm()) {
			$mbkm_siswa_list->RowIndex++;
			$CurrentForm->Index = $mbkm_siswa_list->RowIndex;
			if ($CurrentForm->hasValue($mbkm_siswa_list->FormActionName) && ($mbkm_siswa->isConfirm() || $mbkm_siswa_list->EventCancelled))
				$mbkm_siswa_list->RowAction = strval($CurrentForm->getValue($mbkm_siswa_list->FormActionName));
			elseif ($mbkm_siswa_list->isGridAdd())
				$mbkm_siswa_list->RowAction = "insert";
			else
				$mbkm_siswa_list->RowAction = "";
		}

		// Set up key count
		$mbkm_siswa_list->KeyCount = $mbkm_siswa_list->RowIndex;

		// Init row class and style
		$mbkm_siswa->resetAttributes();
		$mbkm_siswa->CssClass = "";
		if ($mbkm_siswa_list->isGridAdd()) {
			$mbkm_siswa_list->loadRowValues(); // Load default values
		} else {
			$mbkm_siswa_list->loadRowValues($mbkm_siswa_list->Recordset); // Load row values
		}
		$mbkm_siswa->RowType = ROWTYPE_VIEW; // Render view
		if ($mbkm_siswa_list->isGridEdit()) { // Grid edit
			if ($mbkm_siswa->EventCancelled)
				$mbkm_siswa_list->restoreCurrentRowFormValues($mbkm_siswa_list->RowIndex); // Restore form values
			if ($mbkm_siswa_list->RowAction == "insert")
				$mbkm_siswa->RowType = ROWTYPE_ADD; // Render add
			else
				$mbkm_siswa->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($mbkm_siswa_list->isGridEdit() && ($mbkm_siswa->RowType == ROWTYPE_EDIT || $mbkm_siswa->RowType == ROWTYPE_ADD) && $mbkm_siswa->EventCancelled) // Update failed
			$mbkm_siswa_list->restoreCurrentRowFormValues($mbkm_siswa_list->RowIndex); // Restore form values
		if ($mbkm_siswa->RowType == ROWTYPE_EDIT) // Edit row
			$mbkm_siswa_list->EditRowCount++;

		// Set up row id / data-rowindex
		$mbkm_siswa->RowAttrs->merge(["data-rowindex" => $mbkm_siswa_list->RowCount, "id" => "r" . $mbkm_siswa_list->RowCount . "_mbkm_siswa", "data-rowtype" => $mbkm_siswa->RowType]);

		// Render row
		$mbkm_siswa_list->renderRow();

		// Render list options
		$mbkm_siswa_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($mbkm_siswa_list->RowAction != "delete" && $mbkm_siswa_list->RowAction != "insertdelete" && !($mbkm_siswa_list->RowAction == "insert" && $mbkm_siswa->isConfirm() && $mbkm_siswa_list->emptyRow())) {
?>
	<tr <?php echo $mbkm_siswa->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mbkm_siswa_list->ListOptions->render("body", "left", $mbkm_siswa_list->RowCount);
?>
	<?php if ($mbkm_siswa_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $mbkm_siswa_list->Kode_Jp->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kode_Jp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Kode_Jp" data-value-separator="<?php echo $mbkm_siswa_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp"<?php echo $mbkm_siswa_list->Kode_Jp->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Kode_Jp->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Kode_Jp->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Jp" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Jp->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kode_Jp" class="form-group">
<span<?php echo $mbkm_siswa_list->Kode_Jp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->Kode_Jp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Jp" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Jp->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kode_Jp">
<span<?php echo $mbkm_siswa_list->Kode_Jp->viewAttributes() ?>><?php echo $mbkm_siswa_list->Kode_Jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Fak" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Fak->CurrentValue) ?>">
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Fak" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Fak->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT || $mbkm_siswa->CurrentMode == "edit") { ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Fak" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Fak->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Tahun_Akd" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Tahun_Akd->CurrentValue) ?>">
<input type="hidden" data-table="mbkm_siswa" data-field="x_Tahun_Akd" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Tahun_Akd->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT || $mbkm_siswa->CurrentMode == "edit") { ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Tahun_Akd" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Tahun_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Tahun_Akd->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Periode" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($mbkm_siswa_list->Periode->CurrentValue) ?>">
<input type="hidden" data-table="mbkm_siswa" data-field="x_Periode" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($mbkm_siswa_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT || $mbkm_siswa->CurrentMode == "edit") { ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Periode" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($mbkm_siswa_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Status_Akd" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Status_Akd->CurrentValue) ?>">
<input type="hidden" data-table="mbkm_siswa" data-field="x_Status_Akd" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Status_Akd->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT || $mbkm_siswa->CurrentMode == "edit") { ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Status_Akd" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($mbkm_siswa_list->Status_Akd->CurrentValue) ?>">
<?php } ?>
	<?php if ($mbkm_siswa_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $mbkm_siswa_list->Nim->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Nim" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Nim" data-value-separator="<?php echo $mbkm_siswa_list->Nim->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim"<?php echo $mbkm_siswa_list->Nim->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Nim->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Nim") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Nim->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Nim") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Nim" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($mbkm_siswa_list->Nim->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Nim" class="form-group">
<span<?php echo $mbkm_siswa_list->Nim->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->Nim->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Nim" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($mbkm_siswa_list->Nim->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Nim">
<span<?php echo $mbkm_siswa_list->Nim->viewAttributes() ?>><?php echo $mbkm_siswa_list->Nim->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->Kmbkm->Visible) { // Kmbkm ?>
		<td data-name="Kmbkm" <?php echo $mbkm_siswa_list->Kmbkm->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kmbkm" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Kmbkm" data-value-separator="<?php echo $mbkm_siswa_list->Kmbkm->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm"<?php echo $mbkm_siswa_list->Kmbkm->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Kmbkm->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Kmbkm") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Kmbkm->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Kmbkm") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kmbkm" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" value="<?php echo HtmlEncode($mbkm_siswa_list->Kmbkm->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kmbkm" class="form-group">
<span<?php echo $mbkm_siswa_list->Kmbkm->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->Kmbkm->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kmbkm" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" value="<?php echo HtmlEncode($mbkm_siswa_list->Kmbkm->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Kmbkm">
<span<?php echo $mbkm_siswa_list->Kmbkm->viewAttributes() ?>><?php echo $mbkm_siswa_list->Kmbkm->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $mbkm_siswa_list->NIDN->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($mbkm_siswa_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $mbkm_siswa_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($mbkm_siswa_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($mbkm_siswa_list->NIDN->ReadOnly || $mbkm_siswa_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $mbkm_siswa_list->NIDN->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $mbkm_siswa_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" value="<?php echo $mbkm_siswa_list->NIDN->CurrentValue ?>"<?php echo $mbkm_siswa_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_NIDN" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($mbkm_siswa_list->NIDN->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($mbkm_siswa_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $mbkm_siswa_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($mbkm_siswa_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($mbkm_siswa_list->NIDN->ReadOnly || $mbkm_siswa_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $mbkm_siswa_list->NIDN->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $mbkm_siswa_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" value="<?php echo $mbkm_siswa_list->NIDN->CurrentValue ?>"<?php echo $mbkm_siswa_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_NIDN">
<span<?php echo $mbkm_siswa_list->NIDN->viewAttributes() ?>><?php echo $mbkm_siswa_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->Title->Visible) { // Title ?>
		<td data-name="Title" <?php echo $mbkm_siswa_list->Title->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Title" class="form-group">
<input type="text" data-table="mbkm_siswa" data-field="x_Title" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" size="75" maxlength="150" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->Title->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->Title->EditValue ?>"<?php echo $mbkm_siswa_list->Title->editAttributes() ?>>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Title" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Title" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Title" value="<?php echo HtmlEncode($mbkm_siswa_list->Title->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Title" class="form-group">
<span<?php echo $mbkm_siswa_list->Title->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->Title->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Title" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" value="<?php echo HtmlEncode($mbkm_siswa_list->Title->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_Title">
<span<?php echo $mbkm_siswa_list->Title->viewAttributes() ?>><?php echo $mbkm_siswa_list->Title->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->dari->Visible) { // dari ?>
		<td data-name="dari" <?php echo $mbkm_siswa_list->dari->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_dari" class="form-group">
<input type="text" data-table="mbkm_siswa" data-field="x_dari" data-format="14" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" maxlength="8" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->dari->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->dari->EditValue ?>"<?php echo $mbkm_siswa_list->dari->editAttributes() ?>>
<?php if (!$mbkm_siswa_list->dari->ReadOnly && !$mbkm_siswa_list->dari->Disabled && !isset($mbkm_siswa_list->dari->EditAttrs["readonly"]) && !isset($mbkm_siswa_list->dari->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmbkm_siswalist", "datetimepicker"], function() {
	ew.createDateTimePicker("fmbkm_siswalist", "x<?php echo $mbkm_siswa_list->RowIndex ?>_dari", {"ignoreReadonly":true,"useCurrent":false,"format":14});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_dari" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_dari" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_dari" value="<?php echo HtmlEncode($mbkm_siswa_list->dari->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_dari" class="form-group">
<span<?php echo $mbkm_siswa_list->dari->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->dari->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_dari" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" value="<?php echo HtmlEncode($mbkm_siswa_list->dari->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_dari">
<span<?php echo $mbkm_siswa_list->dari->viewAttributes() ?>><?php echo $mbkm_siswa_list->dari->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->sampai->Visible) { // sampai ?>
		<td data-name="sampai" <?php echo $mbkm_siswa_list->sampai->cellAttributes() ?>>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_sampai" class="form-group">
<input type="text" data-table="mbkm_siswa" data-field="x_sampai" data-format="7" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" maxlength="8" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->sampai->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->sampai->EditValue ?>"<?php echo $mbkm_siswa_list->sampai->editAttributes() ?>>
<?php if (!$mbkm_siswa_list->sampai->ReadOnly && !$mbkm_siswa_list->sampai->Disabled && !isset($mbkm_siswa_list->sampai->EditAttrs["readonly"]) && !isset($mbkm_siswa_list->sampai->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmbkm_siswalist", "datetimepicker"], function() {
	ew.createDateTimePicker("fmbkm_siswalist", "x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_sampai" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" value="<?php echo HtmlEncode($mbkm_siswa_list->sampai->OldValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_sampai" class="form-group">
<span<?php echo $mbkm_siswa_list->sampai->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($mbkm_siswa_list->sampai->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_sampai" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" value="<?php echo HtmlEncode($mbkm_siswa_list->sampai->CurrentValue) ?>">
<?php } ?>
<?php if ($mbkm_siswa->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $mbkm_siswa_list->RowCount ?>_mbkm_siswa_sampai">
<span<?php echo $mbkm_siswa_list->sampai->viewAttributes() ?>><?php echo $mbkm_siswa_list->sampai->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mbkm_siswa_list->ListOptions->render("body", "right", $mbkm_siswa_list->RowCount);
?>
	</tr>
<?php if ($mbkm_siswa->RowType == ROWTYPE_ADD || $mbkm_siswa->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fmbkm_siswalist", "load"], function() {
	fmbkm_siswalist.updateLists(<?php echo $mbkm_siswa_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$mbkm_siswa_list->isGridAdd())
		if (!$mbkm_siswa_list->Recordset->EOF)
			$mbkm_siswa_list->Recordset->moveNext();
}
?>
<?php
	if ($mbkm_siswa_list->isGridAdd() || $mbkm_siswa_list->isGridEdit()) {
		$mbkm_siswa_list->RowIndex = '$rowindex$';
		$mbkm_siswa_list->loadRowValues();

		// Set row properties
		$mbkm_siswa->resetAttributes();
		$mbkm_siswa->RowAttrs->merge(["data-rowindex" => $mbkm_siswa_list->RowIndex, "id" => "r0_mbkm_siswa", "data-rowtype" => ROWTYPE_ADD]);
		$mbkm_siswa->RowAttrs->appendClass("ew-template");
		$mbkm_siswa->RowType = ROWTYPE_ADD;

		// Render row
		$mbkm_siswa_list->renderRow();

		// Render list options
		$mbkm_siswa_list->renderListOptions();
		$mbkm_siswa_list->StartRowCount = 0;
?>
	<tr <?php echo $mbkm_siswa->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mbkm_siswa_list->ListOptions->render("body", "left", $mbkm_siswa_list->RowIndex);
?>
	<?php if ($mbkm_siswa_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp">
<span id="el$rowindex$_mbkm_siswa_Kode_Jp" class="form-group mbkm_siswa_Kode_Jp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Kode_Jp" data-value-separator="<?php echo $mbkm_siswa_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp"<?php echo $mbkm_siswa_list->Kode_Jp->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Kode_Jp->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Kode_Jp->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kode_Jp" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($mbkm_siswa_list->Kode_Jp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim">
<span id="el$rowindex$_mbkm_siswa_Nim" class="form-group mbkm_siswa_Nim">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Nim" data-value-separator="<?php echo $mbkm_siswa_list->Nim->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Nim"<?php echo $mbkm_siswa_list->Nim->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Nim->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Nim") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Nim->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Nim") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Nim" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($mbkm_siswa_list->Nim->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->Kmbkm->Visible) { // Kmbkm ?>
		<td data-name="Kmbkm">
<span id="el$rowindex$_mbkm_siswa_Kmbkm" class="form-group mbkm_siswa_Kmbkm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_siswa" data-field="x_Kmbkm" data-value-separator="<?php echo $mbkm_siswa_list->Kmbkm->displayValueSeparatorAttribute() ?>" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm"<?php echo $mbkm_siswa_list->Kmbkm->editAttributes() ?>>
			<?php echo $mbkm_siswa_list->Kmbkm->selectOptionListHtml("x{$mbkm_siswa_list->RowIndex}_Kmbkm") ?>
		</select>
</div>
<?php echo $mbkm_siswa_list->Kmbkm->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_Kmbkm") ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Kmbkm" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Kmbkm" value="<?php echo HtmlEncode($mbkm_siswa_list->Kmbkm->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el$rowindex$_mbkm_siswa_NIDN" class="form-group mbkm_siswa_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($mbkm_siswa_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $mbkm_siswa_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($mbkm_siswa_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($mbkm_siswa_list->NIDN->ReadOnly || $mbkm_siswa_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $mbkm_siswa_list->NIDN->Lookup->getParamTag($mbkm_siswa_list, "p_x" . $mbkm_siswa_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="mbkm_siswa" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $mbkm_siswa_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" value="<?php echo $mbkm_siswa_list->NIDN->CurrentValue ?>"<?php echo $mbkm_siswa_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_NIDN" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($mbkm_siswa_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->Title->Visible) { // Title ?>
		<td data-name="Title">
<span id="el$rowindex$_mbkm_siswa_Title" class="form-group mbkm_siswa_Title">
<input type="text" data-table="mbkm_siswa" data-field="x_Title" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_Title" size="75" maxlength="150" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->Title->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->Title->EditValue ?>"<?php echo $mbkm_siswa_list->Title->editAttributes() ?>>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_Title" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_Title" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_Title" value="<?php echo HtmlEncode($mbkm_siswa_list->Title->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->dari->Visible) { // dari ?>
		<td data-name="dari">
<span id="el$rowindex$_mbkm_siswa_dari" class="form-group mbkm_siswa_dari">
<input type="text" data-table="mbkm_siswa" data-field="x_dari" data-format="14" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_dari" maxlength="8" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->dari->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->dari->EditValue ?>"<?php echo $mbkm_siswa_list->dari->editAttributes() ?>>
<?php if (!$mbkm_siswa_list->dari->ReadOnly && !$mbkm_siswa_list->dari->Disabled && !isset($mbkm_siswa_list->dari->EditAttrs["readonly"]) && !isset($mbkm_siswa_list->dari->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmbkm_siswalist", "datetimepicker"], function() {
	ew.createDateTimePicker("fmbkm_siswalist", "x<?php echo $mbkm_siswa_list->RowIndex ?>_dari", {"ignoreReadonly":true,"useCurrent":false,"format":14});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_dari" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_dari" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_dari" value="<?php echo HtmlEncode($mbkm_siswa_list->dari->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($mbkm_siswa_list->sampai->Visible) { // sampai ?>
		<td data-name="sampai">
<span id="el$rowindex$_mbkm_siswa_sampai" class="form-group mbkm_siswa_sampai">
<input type="text" data-table="mbkm_siswa" data-field="x_sampai" data-format="7" name="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" id="x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" maxlength="8" placeholder="<?php echo HtmlEncode($mbkm_siswa_list->sampai->getPlaceHolder()) ?>" value="<?php echo $mbkm_siswa_list->sampai->EditValue ?>"<?php echo $mbkm_siswa_list->sampai->editAttributes() ?>>
<?php if (!$mbkm_siswa_list->sampai->ReadOnly && !$mbkm_siswa_list->sampai->Disabled && !isset($mbkm_siswa_list->sampai->EditAttrs["readonly"]) && !isset($mbkm_siswa_list->sampai->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmbkm_siswalist", "datetimepicker"], function() {
	ew.createDateTimePicker("fmbkm_siswalist", "x<?php echo $mbkm_siswa_list->RowIndex ?>_sampai", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="mbkm_siswa" data-field="x_sampai" name="o<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" id="o<?php echo $mbkm_siswa_list->RowIndex ?>_sampai" value="<?php echo HtmlEncode($mbkm_siswa_list->sampai->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mbkm_siswa_list->ListOptions->render("body", "right", $mbkm_siswa_list->RowIndex);
?>
<script>
loadjs.ready(["fmbkm_siswalist", "load"], function() {
	fmbkm_siswalist.updateLists(<?php echo $mbkm_siswa_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($mbkm_siswa_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $mbkm_siswa_list->FormKeyCountName ?>" id="<?php echo $mbkm_siswa_list->FormKeyCountName ?>" value="<?php echo $mbkm_siswa_list->KeyCount ?>">
<?php echo $mbkm_siswa_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$mbkm_siswa->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mbkm_siswa_list->Recordset)
	$mbkm_siswa_list->Recordset->Close();
?>
<?php if (!$mbkm_siswa_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mbkm_siswa_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $mbkm_siswa_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mbkm_siswa_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mbkm_siswa_list->TotalRecords == 0 && !$mbkm_siswa->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mbkm_siswa_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mbkm_siswa_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$mbkm_siswa_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$mbkm_siswa_list->terminate();
?>