<?php
session_start();

// Fungsi untuk koneksi database MSSQL
function Conn() {
    $serverName = "localhost";
    $connectionInfo = array(
        "Database" => "SIAP",
        "Uid" => "Akademik",
        "PWD" => "134nj4r4n",
        "CharacterSet" => "UTF-8"
    );
    
    $conn = sqlsrv_connect($serverName, $connectionInfo);
    
    if ($conn === false) {
        die(print_r(sqlsrv_errors(), true));
    }
    return $conn;
}

// Fungsi untuk encoding HTML
function HtmlEncode($value) {
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$tokenValue = $_SESSION['csrf_token'];

// Proses utama
$id_jadwal = $_GET['id'] ?? '';
$conn = Conn();

// Handle POST request
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die("Invalid request");
    }

    $id_jadwal = $_POST['id_jadwal'];
    $imageData = $_POST['signature'] ?? '';
    
    if (!empty($imageData)) {
        $filename = md5($id_jadwal . time()) . ".png";
        $folderPath = "paraf/";
        
        if (!file_exists($folderPath)) {
            mkdir($folderPath, 0777, true);
        }
        
        $fullPath = $folderPath . $filename;
        $data = explode(',', $imageData);
        $decodedData = base64_decode($data[1]);
        file_put_contents($fullPath, $decodedData);

        // UPDATE menggunakan sqlsrv
        $sql = "UPDATE RKP_AbsenDosen SET parafbaak = ? WHERE id_jadwal = ?";
        $params = array($filename, $id_jadwal);
        $stmt = sqlsrv_prepare($conn, $sql, $params);
        
        if (sqlsrv_execute($stmt)) {
            $message = "<div class='alert alert-success alert-dismissible fade show' role='alert'>
                          <strong>Berhasil!</strong> Tanda tangan berhasil disimpan.
                          <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                        </div>";
        } else {
            $error = sqlsrv_errors();
            $message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
                          <strong>Error!</strong> Gagal menyimpan data: " . $error[0]['message'] . "
                          <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                        </div>";
        }
    } else {
        $message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
                      <strong>Error!</strong> Data tanda tangan tidak valid.
                      <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                    </div>";
    }
}

// Ambil data dari database
$id_jadwal_display = $id_jadwal;
$ttdfile = '';
if (!empty($id_jadwal)) {
    $sql = "SELECT id_jadwal, parafbaak FROM RKP_AbsenDosen WHERE id_jadwal = ?";
    $params = array($id_jadwal);
    $stmt = sqlsrv_query($conn, $sql, $params);
    
    if ($stmt === false) {
        die(print_r(sqlsrv_errors(), true));
    }

    $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
    if ($row) {
        $id_jadwal_display = $row['id_jadwal'];
        $ttdfile = $row['parafbaak'];
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Paraf Kehadiran - Akademik</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #1a2980 0%, #26d0ce 100%);
            min-height: 100vh;
            padding: 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow-x: hidden;
        }
        .card {
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 12px 25px rgba(0,0,0,0.2);
            transition: transform 0.3s;
            background: rgba(255, 255, 255, 0.95);
        }
        .card:hover {
            transform: translateY(-8px);
        }
        .card-header {
            font-weight: 700;
            letter-spacing: 0.8px;
            background: linear-gradient(120deg, #0d6efd 0%, #0b5ed7 100%);
        }
        .preview-container {
            border: 2px dashed #0d6efd;
            border-radius: 12px;
            padding: 20px;
            background-color: #f8f9fa;
            min-height: 250px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
        }
        .preview-container:hover {
            transform: scale(1.02);
            box-shadow: 0 5px 15px rgba(13, 110, 253, 0.2);
        }
        .action-buttons .btn {
            min-width: 150px;
            margin: 8px;
            padding: 12px 20px;
            font-weight: 600;
            border-radius: 50px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
            transition: all 0.3s;
        }
        .action-buttons .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0,0,0,0.2);
        }
        .info-card {
            background: linear-gradient(120deg, rgba(255,255,255,0.95) 0%, rgba(240,248,255,0.95) 100%);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            border: none;
        }
        .info-card i {
            font-size: 2rem;
            margin-right: 15px;
            color: #0d6efd;
            background: rgba(13, 110, 253, 0.1);
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .signature-instructions {
            background: linear-gradient(to right, #e6f7ff, #ffffff);
            border-left: 5px solid #0d6efd;
            padding: 20px;
            border-radius: 0 15px 15px 0;
            margin-bottom: 25px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        footer {
            color: white;
            text-align: center;
            padding: 25px 0;
            font-size: 1rem;
            margin-top: 40px;
            background: rgba(0,0,0,0.2);
            border-radius: 15px;
        }
        .system-title {
            text-align: center;
            color: white;
            margin-bottom: 40px;
            text-shadow: 0 3px 6px rgba(0,0,0,0.3);
        }
        .system-title h1 {
            font-weight: 800;
            font-size: 3rem;
            letter-spacing: 1.5px;
            margin-bottom: 15px;
        }
        .system-title p {
            font-size: 1.3rem;
            opacity: 0.95;
        }
        .signature-modal .modal-content {
            border-radius: 20px;
            overflow: hidden;
            border: none;
            box-shadow: 0 15px 50px rgba(0,0,0,0.3);
        }
        .signature-modal .modal-header {
            background: linear-gradient(120deg, #0d6efd 0%, #0b5ed7 100%);
            color: white;
            border-bottom: none;
        }
        .signature-modal .modal-body {
            padding: 30px;
        }
        .signature-modal canvas {
            border: 2px dashed #6c757d;
            background-color: #f8f9fa;
            cursor: crosshair;
            border-radius: 12px;
            width: 100%;
            height: 300px;
        }
        .signature-btn {
            background: linear-gradient(120deg, #0d6efd 0%, #0b5ed7 100%);
            color: white;
            font-weight: 600;
            padding: 15px 30px;
            border-radius: 50px;
            border: none;
            box-shadow: 0 6px 15px rgba(13, 110, 253, 0.4);
            transition: all 0.3s;
            font-size: 1.2rem;
        }
        .signature-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(13, 110, 253, 0.6);
        }
        .signature-btn i {
            margin-right: 10px;
        }
        .signature-preview {
            transition: all 0.3s;
            max-height: 250px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .signature-preview:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }
        .info-item {
            transition: transform 0.3s;
        }
        .info-item:hover {
            transform: translateX(10px);
        }
        .floating-icon {
            position: absolute;
            font-size: 5rem;
            opacity: 0.1;
            color: #0d6efd;
            z-index: -1;
        }
        .floating-icon-1 {
            top: 10%;
            left: 5%;
        }
        .floating-icon-2 {
            bottom: 15%;
            right: 5%;
            transform: rotate(45deg);
        }
        .floating-icon-3 {
            top: 30%;
            right: 15%;
            transform: rotate(-30deg);
        }
        .wave-divider {
            height: 50px;
            background: url('data:image/svg+xml;utf8,<svg viewBox="0 0 1200 120" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none"><path d="M321.39 56.44c58-10.79 114.16-30.13 172-41.86 82.39-16.72 168.19-17.73 250.45-.39C823.78 31 906.67 72 985.66 92.83c70.05 18.48 146.53 26.09 214.34 3V0H0v27.35a600.21 600.21 0 00321.39 29.09z" fill="rgba(255,255,255,0.2)"/></svg>');
            background-size: 1200px 100px;
            margin: 40px 0;
        }
        .modal-action-buttons .btn {
            border-radius: 50px;
            padding: 10px 25px;
            font-weight: 600;
            margin: 0 10px;
            min-width: 120px;
        }
    </style>
</head>
<body>
    <!-- Floating decorative icons -->
    <i class="fas fa-signature floating-icon floating-icon-1"></i>
    <i class="fas fa-pen floating-icon floating-icon-2"></i>
    <i class="fas fa-file-signature floating-icon floating-icon-3"></i>

    <div class="container">
        <div class="system-title">
            <h1><i class="fas fa-signature me-3"></i>SISTEM PARAF DIGITAL</h1>
            <p>Fakultas Ilmu Komputer - Universitas Akademik</p>
        </div>
        
        <?php if(!empty($message)) echo $message; ?>
        
        <div class="info-card">
            <div class="row">
                <div class="col-md-4 d-flex align-items-center mb-4 mb-md-0 info-item">
                    <i class="fas fa-info-circle"></i>
                    <div>
                        <h5 class="mb-0">ID Jadwal</h5>
                        <p class="mb-0 fw-bold"><?= HtmlEncode($id_jadwal_display) ?></p>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center mb-4 mb-md-0 info-item">
                    <i class="fas fa-calendar-alt"></i>
                    <div>
                        <h5 class="mb-0">Tanggal</h5>
                        <p class="mb-0 fw-bold"><?= date('d F Y') ?></p>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center info-item">
                    <i class="fas fa-user-tie"></i>
                    <div>
                        <h5 class="mb-0">Petugas BAAK</h5>
                        <p class="mb-0 fw-bold">Dr. Ahmad S.T., M.Kom.</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="signature-instructions">
            <h5><i class="fas fa-pencil-alt me-2"></i>Petunjuk Paraf:</h5>
            <p class="mb-0">Klik tombol "Buat Tanda Tangan" untuk membuka area tanda tangan. Gunakan mouse atau jari (pada perangkat touchscreen) untuk membuat tanda tangan. Pastikan tanda tangan jelas dan sesuai dengan tanda tangan resmi Anda.</p>
        </div>

        <div class="wave-divider"></div>

        <div class="card shadow-lg">
            <div class="card-header text-white py-3">
                <h4 class="mb-0"><i class="fas fa-file-signature me-2"></i>Paraf Kehadiran Perkuliahan</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Kolom Kiri: Form dan Tombol -->
                    <div class="col-lg-6 mb-5 mb-lg-0">
                        <form method="POST" id="signatureForm">
                            <input type="hidden" name="csrf_token" value="<?= $tokenValue ?>">
                            <input type="hidden" name="id_jadwal" value="<?= HtmlEncode($id_jadwal_display) ?>">
                            <input type="hidden" name="signature" id="signature">
                            
                            <div class="d-flex justify-content-center mb-4">
                                <button type="button" class="btn signature-btn" data-bs-toggle="modal" data-bs-target="#signatureModal">
                                    <i class="fas fa-pen me-2"></i>Buat Tanda Tangan
                                </button>
                            </div>
                            
                            <div class="mt-5 text-center">
                                <h5 class="mb-4">Tanda Tangan Saat Ini</h5>
                                <?php if (!empty($ttdfile)): ?>
                                    <img src="paraf/<?= HtmlEncode($ttdfile) ?>" 
                                         class="img-fluid signature-preview"
                                         alt="Tanda Tangan">
                                <?php else: ?>
                                    <div class="alert alert-secondary py-4">
                                        <i class="fas fa-signature fa-3x mb-3"></i>
                                        <p class="mb-0 fs-5">Belum ada tanda tangan</p>
                                        <small>Buat tanda tangan baru dengan tombol di atas</small>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="d-flex justify-content-center action-buttons mt-5">
                                <button type="submit" class="btn btn-success btn-lg px-5 py-3">
                                    <i class="fas fa-save me-2"></i>Simpan Paraf
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Kolom Kanan: Informasi dan Panduan -->
                    <div class="col-lg-6">
                        <div class="mb-5">
                            <h4 class="text-center mb-4"><i class="fas fa-lightbulb me-2"></i>Panduan Sistem Paraf</h4>
                            <div class="accordion" id="guideAccordion">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                                            <i class="fas fa-pen me-2"></i>Cara Membuat Tanda Tangan
                                        </button>
                                    </h2>
                                    <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#guideAccordion">
                                        <div class="accordion-body">
                                            <ol>
                                                <li>Klik tombol "Buat Tanda Tangan"</li>
                                                <li>Gambar tanda tangan Anda di area yang disediakan</li>
                                                <li>Gunakan tombol "Reset" jika ingin mengulang</li>
                                                <li>Klik "Simpan Tanda Tangan" setelah selesai</li>
                                            </ol>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                                            <i class="fas fa-check-circle me-2"></i>Persyaratan Tanda Tangan
                                        </button>
                                    </h2>
                                    <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#guideAccordion">
                                        <div class="accordion-body">
                                            <ul>
                                                <li>Tanda tangan harus jelas dan terbaca</li>
                                                <li>Harus sesuai dengan tanda tangan resmi</li>
                                                <li>Dibuat di area yang disediakan</li>
                                                <li>Tidak boleh menggunakan gambar atau stempel</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                                            <i class="fas fa-exclamation-triangle me-2"></i>Penting untuk Diperhatikan
                                        </button>
                                    </h2>
                                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#guideAccordion">
                                        <div class="accordion-body">
                                            <ul>
                                                <li>Tanda tangan ini bersifat resmi dan mengikat</li>
                                                <li>Pastikan data jadwal sudah benar</li>
                                                <li>Simpan tanda tangan hanya jika sudah yakin</li>
                                                <li>Hubungi BAAK jika terjadi kesalahan</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-center mt-5">
                            <div class="d-inline-block text-start">
                                <h5><i class="fas fa-qrcode me-2"></i>Scan untuk Panduan Mobile</h5>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=https://example.com/panduan-paraf" 
                                     class="img-thumbnail mt-2" 
                                     alt="QR Code Panduan">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <footer>
            <p class="mb-1">Sistem Informasi Akademik &copy; 2023 - Universitas Akademik</p>
            <p class="mb-0">Versi 2.2.0 | Terakhir diperbarui: <?= date('d F Y') ?></p>
        </footer>
    </div>

    <!-- Modal Tanda Tangan -->
    <div class="modal fade signature-modal" id="signatureModal" tabindex="-1" aria-labelledby="signatureModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="signatureModalLabel"><i class="fas fa-signature me-2"></i>Buat Tanda Tangan</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-4">
                        <p>Gambar tanda tangan Anda di area berikut:</p>
                        <canvas id="signature-pad" width="760" height="300"></canvas>
                    </div>
                    
                    <div class="text-center modal-action-buttons">
                        <button type="button" class="btn btn-danger" onclick="clearPad()">
                            <i class="fas fa-eraser me-2"></i>Reset
                        </button>
                        <button type="button" class="btn btn-success" id="saveSignature">
                            <i class="fas fa-save me-2"></i>Simpan Tanda Tangan
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const canvas = document.getElementById('signature-pad');
        const ctx = canvas.getContext('2d');
        let drawing = false;
        
        // Set canvas size
        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;
        
        // Set drawing style
        ctx.lineWidth = 3;
        ctx.lineJoin = 'round';
        ctx.lineCap = 'round';
        ctx.strokeStyle = '#0d6efd';
        
        // Function to get position
        function getPos(e) {
            const rect = canvas.getBoundingClientRect();
            return {
                x: e.clientX - rect.left,
                y: e.clientY - rect.top
            };
        }
        
        // Mouse events
        canvas.addEventListener('mousedown', (e) => {
            drawing = true;
            const pos = getPos(e);
            ctx.beginPath();
            ctx.moveTo(pos.x, pos.y);
        });
        
        canvas.addEventListener('mousemove', (e) => {
            if (!drawing) return;
            const pos = getPos(e);
            ctx.lineTo(pos.x, pos.y);
            ctx.stroke();
        });
        
        canvas.addEventListener('mouseup', () => drawing = false);
        canvas.addEventListener('mouseout', () => drawing = false);
        
        // Touch events
        canvas.addEventListener('touchstart', (e) => {
            e.preventDefault();
            drawing = true;
            const touch = e.touches[0];
            const pos = getPos(touch);
            ctx.beginPath();
            ctx.moveTo(pos.x, pos.y);
        });
        
        canvas.addEventListener('touchmove', (e) => {
            if (!drawing) return;
            e.preventDefault();
            const touch = e.touches[0];
            const pos = getPos(touch);
            ctx.lineTo(pos.x, pos.y);
            ctx.stroke();
        });
        
        canvas.addEventListener('touchend', () => drawing = false);
        
        // Clear canvas function
        function clearPad() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
        }
        
        // Save signature from modal
        document.getElementById('saveSignature').addEventListener('click', function() {
            const signatureInput = document.getElementById('signature');
            if (isCanvasBlank(canvas)) {
                alert('Harap membuat tanda tangan terlebih dahulu!');
            } else {
                signatureInput.value = canvas.toDataURL();
                
                // Close modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('signatureModal'));
                modal.hide();
                
                // Show success message
                alert('Tanda tangan berhasil dibuat!');
            }
        });
        
        // Check if canvas is blank
        function isCanvasBlank(canvas) {
            const context = canvas.getContext('2d');
            const pixelBuffer = new Uint32Array(
                context.getImageData(0, 0, canvas.width, canvas.height).data.buffer
            );
            return !pixelBuffer.some(color => color !== 0);
        }
        
        // Form submission
        document.getElementById('signatureForm').addEventListener('submit', function(e) {
            const signatureInput = document.getElementById('signature');
            if (isCanvasBlank(canvas) && signatureInput.value === '') {
                e.preventDefault();
                alert('Harap membuat tanda tangan terlebih dahulu!');
            }
        });
    });
    </script>
</body>
</html>