<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$id_jadwal = $_GET['id_jadwal'] ?? '';

// Ambil nama file tanda tangan (jika sudah ada)
$serverName = "localhost";
$connectionOptions = [
    "Database" => "SIAP",
    "Uid"      => "Akademik",
    "PWD"      => "134nj4r4n"
];
$conn = sqlsrv_connect($serverName, $connectionOptions);
if (!$conn) {
    die("Koneksi gagal: " . print_r(sqlsrv_errors(), true));
}

$query = "SELECT parafbaak FROM RKP_AbsenDosen WHERE id_jadwal = ?";
$stmt  = sqlsrv_query($conn, $query, [$id_jadwal]);
$row   = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
$namaFile = $row['parafbaak'] ?? '';

sqlsrv_close($conn);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Presensi Perkuliahan</title>
    <style>
        /* Modal overlay */
        .modal {
            display: none;
            position: fixed;
            z-index: 10;
            left: 0; top: 0;
            width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }
        /* Kotak modal */
        .modal-content {
            background-color: #fff;
            margin: 8% auto;
            padding: 20px;
            width: 500px;             /* lebarnya diatur agar cukup untuk dua kolom */
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        /* Flex container: kiri-kanan */
        .modal-content-flex {
            display: flex;
            gap: 20px;
        }
        /* Bagian kanvas (kiri) */
        .canvas-container {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        #signatureCanvas {
            border: 1px solid #333;
            border-radius: 4px;
            background-color: #fafafa;
        }
        /* Tombol di bawah kanvas */
        .button-group {
            margin-top: 10px;
            display: flex;
            gap: 10px;
        }
        .button-group button {
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            background-color: #007bff;
            color: #fff;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }
        .button-group button:hover {
            background-color: #0056b3;
        }
        /* Bagian informasi penting (kanan) */
        .info-box {
            background-color: #fefefe;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 12px;
            flex: 1;               /* agar mengambil sisa ruang */
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        .info-box h3 {
            margin: 0 0 8px 0;
            font-size: 16px;
            color: #333;
            border-bottom: 1px solid #eee;
            padding-bottom: 4px;
        }
        .info-box ul {
            list-style: disc inside;
            padding-left: 0;
            margin: 8px 0 0 0;
        }
        .info-box ul li {
            margin-bottom: 6px;
            font-size: 14px;
            color: #555;
            line-height: 1.4;
        }
    </style>
</head>
<body>

<?php
// Tampilkan tanda tangan yang sudah ada (jika file benar–benar tersimpan)
$pathFile = __DIR__ . "/ttd/$namaFile";
if ($namaFile && file_exists($pathFile)): ?>
    <div style="margin-bottom: 20px;">
        <strong>Tanda Tangan Anda:</strong><br>
        <img src="ttd/<?= htmlspecialchars($namaFile) ?>" width="150" alt="Tanda Tangan">
    </div>
<?php endif; ?>

<button onclick="bukaModal()" style="
    padding: 8px 16px;
    font-size: 14px;
    background-color: #28a745;
    color: #fff;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    transition: background-color 0.2s ease;
">Tanda Tangan</button>

<!-- Modal untuk tanda tangan -->
<div id="modalTtd" class="modal">
    <div class="modal-content">
        <div class="modal-content-flex">
            <!-- Bagian Kiri: Canvas + Tombol -->
            <div class="canvas-container">
                <canvas id="signatureCanvas" width="150" height="150"></canvas>
                <div class="button-group">
                    <button onclick="resetCanvas()">Reset</button>
                    <button onclick="simpanTtd()">Simpan</button>
                </div>
            </div>

            <!-- Bagian Kanan: Informasi Penting -->
            <div class="info-box">
                <h3>Informasi Penting:</h3>
                <ul>
                    <li>Tanda tangan ini bersifat resmi dan mengikat.</li>
                    <li>Pastikan tanda tangan jelas dan terbaca.</li>
                    <li>Klik <strong>&quot;Simpan&quot;</strong> untuk menyimpan secara permanen.</li>
                    <li>Hubungi <strong>BLAK</strong> jika terjadi kesalahan.</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    let canvas    = document.getElementById("signatureCanvas");
    let ctx       = canvas.getContext("2d");
    let isDrawing = false;

    canvas.addEventListener("mousedown", function(e) {
        isDrawing = true;
        ctx.beginPath();
        ctx.lineWidth = 2;
        ctx.moveTo(e.offsetX, e.offsetY);
    });
    canvas.addEventListener("mousemove", function(e) {
        if (isDrawing) {
            ctx.lineTo(e.offsetX, e.offsetY);
            ctx.strokeStyle = "#000";
            ctx.stroke();
        }
    });
    canvas.addEventListener("mouseup", function() {
        isDrawing = false;
    });
    canvas.addEventListener("mouseout", function() {
        isDrawing = false;
    });

    function bukaModal() {
        document.getElementById("modalTtd").style.display = "block";
    }
    function resetCanvas() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
    function simpanTtd() {
        let ttdData = canvas.toDataURL("image/png");

        // Kirim POST ke simpan_ttd.php
        let xhr = new XMLHttpRequest();
        xhr.open("POST", "simpan_ttd.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    alert("Tanda tangan disimpan.");
                    window.location.reload();
                } else {
                    alert("Gagal: " + xhr.responseText);
                }
            }
        };

        xhr.send(
            "ttd=" + encodeURIComponent(ttdData) +
            "&id_jadwal=" + encodeURIComponent(<?= json_encode($id_jadwal) ?>)
        );
    }

    // Klik di luar modal untuk menutup
    window.onclick = function(event) {
        if (event.target == document.getElementById("modalTtd")) {
            document.getElementById("modalTtd").style.display = "none";
        }
    }
</script>
</body>
</html>
