<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$ttd       = $_POST['ttd'] ?? '';
$id_jadwal = $_POST['id_jadwal'] ?? '';
$id_user = $_POST['id_user'] ?? '';


if (!$ttd || !$id_jadwal) {
    http_response_code(400);
    die("Data tidak lengkap.");
}

// Hilangkan prefix base64
$ttd = str_replace('data:image/png;base64,', '', $ttd);
$ttd = str_replace(' ', '+', $ttd);
$decodedImage = base64_decode($ttd);

if ($decodedImage === false) {
    http_response_code(400);
    die("Gagal decode base64.");
}

// Buat nama file
$namaFile   = $id_jadwal. '_' . $id_jadwal . '_' . time() . '.png';
$folderPath = __DIR__ . '/ttd/';
$filePath   = $folderPath . $namaFile;

// Pastikan folder ada dan bisa ditulis
if (!file_exists($folderPath)) {
    if (!mkdir($folderPath, 0777, true)) {
        http_response_code(500);
        die("Gagal membuat folder ttd.");
    }
}

// Tulis file
if (file_put_contents($filePath, $decodedImage) === false) {
    http_response_code(500);
    die("Gagal menulis file ke $filePath");
}

// Koneksi SQL Server
$serverName = "localhost";
$connectionOptions = [
    "Database" => "SIAP",
    "Uid"      => "Akademik",
    "PWD"      => "134nj4r4n"
];
$conn = sqlsrv_connect($serverName, $connectionOptions);
if (!$conn) {
    http_response_code(500);
    die("Koneksi gagal: " . print_r(sqlsrv_errors(), true));
}

// Update nama file ke DB
$jam = date("Y-m-d H:i:s");
$sql    = "UPDATE RKP_AbsenDosen SET parafbaak = ?, namabaak = ?, jambaak = ? WHERE id_jadwal = ?";
$params = [$namaFile, $id_user, $jam, $id_jadwal];

$stmt = sqlsrv_query($conn, $sql, $params);
if ($stmt === false) {
    http_response_code(500);
    die("Update DB gagal: " . print_r(sqlsrv_errors(), true));
}

sqlsrv_close($conn);
echo "Sukses";
