<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblBeasiswa_master_list = new tblBeasiswa_master_list();

// Run the page
$tblBeasiswa_master_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblBeasiswa_master_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblBeasiswa_master_list->isExport()) { ?>
<script>
var ftblBeasiswa_masterlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblBeasiswa_masterlist = currentForm = new ew.Form("ftblBeasiswa_masterlist", "list");
	ftblBeasiswa_masterlist.formKeyCountName = '<?php echo $tblBeasiswa_master_list->FormKeyCountName ?>';
	loadjs.done("ftblBeasiswa_masterlist");
});
var ftblBeasiswa_masterlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblBeasiswa_masterlistsrch = currentSearchForm = new ew.Form("ftblBeasiswa_masterlistsrch");

	// Validate function for search
	ftblBeasiswa_masterlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblBeasiswa_masterlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblBeasiswa_masterlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblBeasiswa_masterlistsrch.lists["x_Tahun_Akademik"] = <?php echo $tblBeasiswa_master_list->Tahun_Akademik->Lookup->toClientList($tblBeasiswa_master_list) ?>;
	ftblBeasiswa_masterlistsrch.lists["x_Tahun_Akademik"].options = <?php echo JsonEncode($tblBeasiswa_master_list->Tahun_Akademik->lookupOptions()) ?>;
	ftblBeasiswa_masterlistsrch.lists["x_Periode"] = <?php echo $tblBeasiswa_master_list->Periode->Lookup->toClientList($tblBeasiswa_master_list) ?>;
	ftblBeasiswa_masterlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblBeasiswa_master_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	ftblBeasiswa_masterlistsrch.filterList = <?php echo $tblBeasiswa_master_list->getFilterList() ?>;
	loadjs.done("ftblBeasiswa_masterlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblBeasiswa_master_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblBeasiswa_master_list->TotalRecords > 0 && $tblBeasiswa_master_list->ExportOptions->visible()) { ?>
<?php $tblBeasiswa_master_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->ImportOptions->visible()) { ?>
<?php $tblBeasiswa_master_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->SearchOptions->visible()) { ?>
<?php $tblBeasiswa_master_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->FilterOptions->visible()) { ?>
<?php $tblBeasiswa_master_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblBeasiswa_master_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblBeasiswa_master_list->isExport() && !$tblBeasiswa_master->CurrentAction) { ?>
<form name="ftblBeasiswa_masterlistsrch" id="ftblBeasiswa_masterlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblBeasiswa_masterlistsrch-search-panel" class="<?php echo $tblBeasiswa_master_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblBeasiswa_master">
	<div class="ew-extended-search">
<?php

// Render search row
$tblBeasiswa_master->RowType = ROWTYPE_SEARCH;
$tblBeasiswa_master->resetAttributes();
$tblBeasiswa_master_list->renderRow();
?>
<?php if ($tblBeasiswa_master_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php
		$tblBeasiswa_master_list->SearchColumnCount++;
		if (($tblBeasiswa_master_list->SearchColumnCount - 1) % $tblBeasiswa_master_list->SearchFieldsPerRow == 0) {
			$tblBeasiswa_master_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblBeasiswa_master_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Tahun_Akademik" class="ew-cell form-group">
		<label for="x_Tahun_Akademik" class="ew-search-caption ew-label"><?php echo $tblBeasiswa_master_list->Tahun_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Tahun_Akademik" id="z_Tahun_Akademik" value="LIKE">
</span>
		<span id="el_tblBeasiswa_master_Tahun_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblBeasiswa_master" data-field="x_Tahun_Akademik" data-value-separator="<?php echo $tblBeasiswa_master_list->Tahun_Akademik->displayValueSeparatorAttribute() ?>" id="x_Tahun_Akademik" name="x_Tahun_Akademik"<?php echo $tblBeasiswa_master_list->Tahun_Akademik->editAttributes() ?>>
			<?php echo $tblBeasiswa_master_list->Tahun_Akademik->selectOptionListHtml("x_Tahun_Akademik") ?>
		</select>
</div>
<?php echo $tblBeasiswa_master_list->Tahun_Akademik->Lookup->getParamTag($tblBeasiswa_master_list, "p_x_Tahun_Akademik") ?>
</span>
	</div>
	<?php if ($tblBeasiswa_master_list->SearchColumnCount % $tblBeasiswa_master_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->Periode->Visible) { // Periode ?>
	<?php
		$tblBeasiswa_master_list->SearchColumnCount++;
		if (($tblBeasiswa_master_list->SearchColumnCount - 1) % $tblBeasiswa_master_list->SearchFieldsPerRow == 0) {
			$tblBeasiswa_master_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblBeasiswa_master_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblBeasiswa_master_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblBeasiswa_master_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblBeasiswa_master" data-field="x_Periode" data-value-separator="<?php echo $tblBeasiswa_master_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblBeasiswa_master_list->Periode->editAttributes() ?>>
			<?php echo $tblBeasiswa_master_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblBeasiswa_master_list->SearchColumnCount % $tblBeasiswa_master_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblBeasiswa_master_list->SearchColumnCount % $tblBeasiswa_master_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblBeasiswa_master_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblBeasiswa_master_list->showPageHeader(); ?>
<?php
$tblBeasiswa_master_list->showMessage();
?>
<?php if ($tblBeasiswa_master_list->TotalRecords > 0 || $tblBeasiswa_master->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblBeasiswa_master_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblBeasiswa_master">
<form name="ftblBeasiswa_masterlist" id="ftblBeasiswa_masterlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblBeasiswa_master">
<div id="gmp_tblBeasiswa_master" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblBeasiswa_master_list->TotalRecords > 0 || $tblBeasiswa_master_list->isGridEdit()) { ?>
<table id="tbl_tblBeasiswa_masterlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblBeasiswa_master->RowType = ROWTYPE_HEADER;

// Render list options
$tblBeasiswa_master_list->renderListOptions();

// Render list options (header, left)
$tblBeasiswa_master_list->ListOptions->render("header", "left");
?>
<?php if ($tblBeasiswa_master_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Tahun_Akademik) == "") { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $tblBeasiswa_master_list->Tahun_Akademik->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_Tahun_Akademik" class="tblBeasiswa_master_Tahun_Akademik"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Tahun_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tahun_Akademik" class="<?php echo $tblBeasiswa_master_list->Tahun_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Tahun_Akademik) ?>', 1);"><div id="elh_tblBeasiswa_master_Tahun_Akademik" class="tblBeasiswa_master_Tahun_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Tahun_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->Tahun_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->Tahun_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->Periode->Visible) { // Periode ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblBeasiswa_master_list->Periode->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_Periode" class="tblBeasiswa_master_Periode"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblBeasiswa_master_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Periode) ?>', 1);"><div id="elh_tblBeasiswa_master_Periode" class="tblBeasiswa_master_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->NoSK->Visible) { // NoSK ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->NoSK) == "") { ?>
		<th data-name="NoSK" class="<?php echo $tblBeasiswa_master_list->NoSK->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_NoSK" class="tblBeasiswa_master_NoSK"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->NoSK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoSK" class="<?php echo $tblBeasiswa_master_list->NoSK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->NoSK) ?>', 1);"><div id="elh_tblBeasiswa_master_NoSK" class="tblBeasiswa_master_NoSK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->NoSK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->NoSK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->NoSK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->TanggalSK->Visible) { // TanggalSK ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->TanggalSK) == "") { ?>
		<th data-name="TanggalSK" class="<?php echo $tblBeasiswa_master_list->TanggalSK->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_TanggalSK" class="tblBeasiswa_master_TanggalSK"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->TanggalSK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TanggalSK" class="<?php echo $tblBeasiswa_master_list->TanggalSK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->TanggalSK) ?>', 1);"><div id="elh_tblBeasiswa_master_TanggalSK" class="tblBeasiswa_master_TanggalSK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->TanggalSK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->TanggalSK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->TanggalSK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->FileSK->Visible) { // FileSK ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->FileSK) == "") { ?>
		<th data-name="FileSK" class="<?php echo $tblBeasiswa_master_list->FileSK->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_FileSK" class="tblBeasiswa_master_FileSK"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->FileSK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileSK" class="<?php echo $tblBeasiswa_master_list->FileSK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->FileSK) ?>', 1);"><div id="elh_tblBeasiswa_master_FileSK" class="tblBeasiswa_master_FileSK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->FileSK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->FileSK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->FileSK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblBeasiswa_master_list->Keterangan->Visible) { // Keterangan ?>
	<?php if ($tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Keterangan) == "") { ?>
		<th data-name="Keterangan" class="<?php echo $tblBeasiswa_master_list->Keterangan->headerCellClass() ?>"><div id="elh_tblBeasiswa_master_Keterangan" class="tblBeasiswa_master_Keterangan"><div class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Keterangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Keterangan" class="<?php echo $tblBeasiswa_master_list->Keterangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblBeasiswa_master_list->SortUrl($tblBeasiswa_master_list->Keterangan) ?>', 1);"><div id="elh_tblBeasiswa_master_Keterangan" class="tblBeasiswa_master_Keterangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblBeasiswa_master_list->Keterangan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblBeasiswa_master_list->Keterangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblBeasiswa_master_list->Keterangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblBeasiswa_master_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblBeasiswa_master_list->ExportAll && $tblBeasiswa_master_list->isExport()) {
	$tblBeasiswa_master_list->StopRecord = $tblBeasiswa_master_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblBeasiswa_master_list->TotalRecords > $tblBeasiswa_master_list->StartRecord + $tblBeasiswa_master_list->DisplayRecords - 1)
		$tblBeasiswa_master_list->StopRecord = $tblBeasiswa_master_list->StartRecord + $tblBeasiswa_master_list->DisplayRecords - 1;
	else
		$tblBeasiswa_master_list->StopRecord = $tblBeasiswa_master_list->TotalRecords;
}
$tblBeasiswa_master_list->RecordCount = $tblBeasiswa_master_list->StartRecord - 1;
if ($tblBeasiswa_master_list->Recordset && !$tblBeasiswa_master_list->Recordset->EOF) {
	$tblBeasiswa_master_list->Recordset->moveFirst();
	$selectLimit = $tblBeasiswa_master_list->UseSelectLimit;
	if (!$selectLimit && $tblBeasiswa_master_list->StartRecord > 1)
		$tblBeasiswa_master_list->Recordset->move($tblBeasiswa_master_list->StartRecord - 1);
} elseif (!$tblBeasiswa_master->AllowAddDeleteRow && $tblBeasiswa_master_list->StopRecord == 0) {
	$tblBeasiswa_master_list->StopRecord = $tblBeasiswa_master->GridAddRowCount;
}

// Initialize aggregate
$tblBeasiswa_master->RowType = ROWTYPE_AGGREGATEINIT;
$tblBeasiswa_master->resetAttributes();
$tblBeasiswa_master_list->renderRow();
while ($tblBeasiswa_master_list->RecordCount < $tblBeasiswa_master_list->StopRecord) {
	$tblBeasiswa_master_list->RecordCount++;
	if ($tblBeasiswa_master_list->RecordCount >= $tblBeasiswa_master_list->StartRecord) {
		$tblBeasiswa_master_list->RowCount++;

		// Set up key count
		$tblBeasiswa_master_list->KeyCount = $tblBeasiswa_master_list->RowIndex;

		// Init row class and style
		$tblBeasiswa_master->resetAttributes();
		$tblBeasiswa_master->CssClass = "";
		if ($tblBeasiswa_master_list->isGridAdd()) {
		} else {
			$tblBeasiswa_master_list->loadRowValues($tblBeasiswa_master_list->Recordset); // Load row values
		}
		$tblBeasiswa_master->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tblBeasiswa_master->RowAttrs->merge(["data-rowindex" => $tblBeasiswa_master_list->RowCount, "id" => "r" . $tblBeasiswa_master_list->RowCount . "_tblBeasiswa_master", "data-rowtype" => $tblBeasiswa_master->RowType]);

		// Render row
		$tblBeasiswa_master_list->renderRow();

		// Render list options
		$tblBeasiswa_master_list->renderListOptions();
?>
	<tr <?php echo $tblBeasiswa_master->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblBeasiswa_master_list->ListOptions->render("body", "left", $tblBeasiswa_master_list->RowCount);
?>
	<?php if ($tblBeasiswa_master_list->Tahun_Akademik->Visible) { // Tahun_Akademik ?>
		<td data-name="Tahun_Akademik" <?php echo $tblBeasiswa_master_list->Tahun_Akademik->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_Tahun_Akademik">
<span<?php echo $tblBeasiswa_master_list->Tahun_Akademik->viewAttributes() ?>><?php echo $tblBeasiswa_master_list->Tahun_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblBeasiswa_master_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblBeasiswa_master_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_Periode">
<span<?php echo $tblBeasiswa_master_list->Periode->viewAttributes() ?>><?php echo $tblBeasiswa_master_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblBeasiswa_master_list->NoSK->Visible) { // NoSK ?>
		<td data-name="NoSK" <?php echo $tblBeasiswa_master_list->NoSK->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_NoSK">
<span<?php echo $tblBeasiswa_master_list->NoSK->viewAttributes() ?>><?php echo $tblBeasiswa_master_list->NoSK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblBeasiswa_master_list->TanggalSK->Visible) { // TanggalSK ?>
		<td data-name="TanggalSK" <?php echo $tblBeasiswa_master_list->TanggalSK->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_TanggalSK">
<span<?php echo $tblBeasiswa_master_list->TanggalSK->viewAttributes() ?>><?php echo $tblBeasiswa_master_list->TanggalSK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblBeasiswa_master_list->FileSK->Visible) { // FileSK ?>
		<td data-name="FileSK" <?php echo $tblBeasiswa_master_list->FileSK->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_FileSK">
<span<?php echo $tblBeasiswa_master_list->FileSK->viewAttributes() ?>><?php if (!EmptyString($tblBeasiswa_master_list->FileSK->getViewValue()) && $tblBeasiswa_master_list->FileSK->linkAttributes() != "") { ?>
<a<?php echo $tblBeasiswa_master_list->FileSK->linkAttributes() ?>><?php echo $tblBeasiswa_master_list->FileSK->getViewValue() ?></a>
<?php } else { ?>
<?php echo $tblBeasiswa_master_list->FileSK->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblBeasiswa_master_list->Keterangan->Visible) { // Keterangan ?>
		<td data-name="Keterangan" <?php echo $tblBeasiswa_master_list->Keterangan->cellAttributes() ?>>
<span id="el<?php echo $tblBeasiswa_master_list->RowCount ?>_tblBeasiswa_master_Keterangan">
<span<?php echo $tblBeasiswa_master_list->Keterangan->viewAttributes() ?>><?php echo $tblBeasiswa_master_list->Keterangan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblBeasiswa_master_list->ListOptions->render("body", "right", $tblBeasiswa_master_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$tblBeasiswa_master_list->isGridAdd())
		$tblBeasiswa_master_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$tblBeasiswa_master->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblBeasiswa_master_list->Recordset)
	$tblBeasiswa_master_list->Recordset->Close();
?>
<?php if (!$tblBeasiswa_master_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblBeasiswa_master_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblBeasiswa_master_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblBeasiswa_master_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblBeasiswa_master_list->TotalRecords == 0 && !$tblBeasiswa_master->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblBeasiswa_master_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblBeasiswa_master_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblBeasiswa_master_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblBeasiswa_master_list->terminate();
?>