<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblDosen_list = new tblDosen_list();

// Run the page
$tblDosen_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblDosen_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblDosen_list->isExport()) { ?>
<script>
var ftblDosenlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblDosenlist = currentForm = new ew.Form("ftblDosenlist", "list");
	ftblDosenlist.formKeyCountName = '<?php echo $tblDosen_list->FormKeyCountName ?>';

	// Validate form
	ftblDosenlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tblDosen_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblDosen_list->NIDN->caption(), $tblDosen_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblDosen_list->Nama->Required) { ?>
				elm = this.getElements("x" + infix + "_Nama");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblDosen_list->Nama->caption(), $tblDosen_list->Nama->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblDosen_list->Status->Required) { ?>
				elm = this.getElements("x" + infix + "_Status");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblDosen_list->Status->caption(), $tblDosen_list->Status->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblDosen_list->Kode_Jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblDosen_list->Kode_Jp->caption(), $tblDosen_list->Kode_Jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblDosen_list->ttd->Required) { ?>
				felm = this.getElements("x" + infix + "_ttd");
				elm = this.getElements("fn_x" + infix + "_ttd");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblDosen_list->ttd->caption(), $tblDosen_list->ttd->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftblDosenlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblDosenlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblDosenlist.lists["x_Status"] = <?php echo $tblDosen_list->Status->Lookup->toClientList($tblDosen_list) ?>;
	ftblDosenlist.lists["x_Status"].options = <?php echo JsonEncode($tblDosen_list->Status->options(FALSE, TRUE)) ?>;
	ftblDosenlist.lists["x_Kode_Jp"] = <?php echo $tblDosen_list->Kode_Jp->Lookup->toClientList($tblDosen_list) ?>;
	ftblDosenlist.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblDosen_list->Kode_Jp->lookupOptions()) ?>;
	loadjs.done("ftblDosenlist");
});
var ftblDosenlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblDosenlistsrch = currentSearchForm = new ew.Form("ftblDosenlistsrch");

	// Validate function for search
	ftblDosenlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblDosenlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblDosenlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblDosenlistsrch.lists["x_Kode_Jp"] = <?php echo $tblDosen_list->Kode_Jp->Lookup->toClientList($tblDosen_list) ?>;
	ftblDosenlistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblDosen_list->Kode_Jp->lookupOptions()) ?>;

	// Filters
	ftblDosenlistsrch.filterList = <?php echo $tblDosen_list->getFilterList() ?>;
	loadjs.done("ftblDosenlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblDosen_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblDosen_list->TotalRecords > 0 && $tblDosen_list->ExportOptions->visible()) { ?>
<?php $tblDosen_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblDosen_list->ImportOptions->visible()) { ?>
<?php $tblDosen_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblDosen_list->SearchOptions->visible()) { ?>
<?php $tblDosen_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblDosen_list->FilterOptions->visible()) { ?>
<?php $tblDosen_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblDosen_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblDosen_list->isExport() && !$tblDosen->CurrentAction) { ?>
<form name="ftblDosenlistsrch" id="ftblDosenlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblDosenlistsrch-search-panel" class="<?php echo $tblDosen_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblDosen">
	<div class="ew-extended-search">
<?php

// Render search row
$tblDosen->RowType = ROWTYPE_SEARCH;
$tblDosen->resetAttributes();
$tblDosen_list->renderRow();
?>
<?php if ($tblDosen_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$tblDosen_list->SearchColumnCount++;
		if (($tblDosen_list->SearchColumnCount - 1) % $tblDosen_list->SearchFieldsPerRow == 0) {
			$tblDosen_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblDosen_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $tblDosen_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_tblDosen_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblDosen" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblDosen_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $tblDosen_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblDosen_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblDosen_list->Kode_Jp->Lookup->getParamTag($tblDosen_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($tblDosen_list->SearchColumnCount % $tblDosen_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblDosen_list->SearchColumnCount % $tblDosen_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblDosen_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tblDosen_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tblDosen_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tblDosen_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tblDosen_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tblDosen_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tblDosen_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tblDosen_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblDosen_list->showPageHeader(); ?>
<?php
$tblDosen_list->showMessage();
?>
<?php if ($tblDosen_list->TotalRecords > 0 || $tblDosen->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblDosen_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblDosen">
<form name="ftblDosenlist" id="ftblDosenlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblDosen">
<div id="gmp_tblDosen" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblDosen_list->TotalRecords > 0 || $tblDosen_list->isGridEdit()) { ?>
<table id="tbl_tblDosenlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblDosen->RowType = ROWTYPE_HEADER;

// Render list options
$tblDosen_list->renderListOptions();

// Render list options (header, left)
$tblDosen_list->ListOptions->render("header", "left");
?>
<?php if ($tblDosen_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblDosen_list->SortUrl($tblDosen_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblDosen_list->NIDN->headerCellClass() ?>"><div id="elh_tblDosen_NIDN" class="tblDosen_NIDN"><div class="ew-table-header-caption"><?php echo $tblDosen_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblDosen_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblDosen_list->SortUrl($tblDosen_list->NIDN) ?>', 1);"><div id="elh_tblDosen_NIDN" class="tblDosen_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblDosen_list->NIDN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblDosen_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblDosen_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblDosen_list->Nama->Visible) { // Nama ?>
	<?php if ($tblDosen_list->SortUrl($tblDosen_list->Nama) == "") { ?>
		<th data-name="Nama" class="<?php echo $tblDosen_list->Nama->headerCellClass() ?>"><div id="elh_tblDosen_Nama" class="tblDosen_Nama"><div class="ew-table-header-caption"><?php echo $tblDosen_list->Nama->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama" class="<?php echo $tblDosen_list->Nama->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblDosen_list->SortUrl($tblDosen_list->Nama) ?>', 1);"><div id="elh_tblDosen_Nama" class="tblDosen_Nama">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblDosen_list->Nama->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblDosen_list->Nama->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblDosen_list->Nama->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblDosen_list->Status->Visible) { // Status ?>
	<?php if ($tblDosen_list->SortUrl($tblDosen_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $tblDosen_list->Status->headerCellClass() ?>"><div id="elh_tblDosen_Status" class="tblDosen_Status"><div class="ew-table-header-caption"><?php echo $tblDosen_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $tblDosen_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblDosen_list->SortUrl($tblDosen_list->Status) ?>', 1);"><div id="elh_tblDosen_Status" class="tblDosen_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblDosen_list->Status->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblDosen_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblDosen_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblDosen_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($tblDosen_list->SortUrl($tblDosen_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblDosen_list->Kode_Jp->headerCellClass() ?>"><div id="elh_tblDosen_Kode_Jp" class="tblDosen_Kode_Jp"><div class="ew-table-header-caption"><?php echo $tblDosen_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblDosen_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblDosen_list->SortUrl($tblDosen_list->Kode_Jp) ?>', 1);"><div id="elh_tblDosen_Kode_Jp" class="tblDosen_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblDosen_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblDosen_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblDosen_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblDosen_list->ttd->Visible) { // ttd ?>
	<?php if ($tblDosen_list->SortUrl($tblDosen_list->ttd) == "") { ?>
		<th data-name="ttd" class="<?php echo $tblDosen_list->ttd->headerCellClass() ?>"><div id="elh_tblDosen_ttd" class="tblDosen_ttd"><div class="ew-table-header-caption"><?php echo $tblDosen_list->ttd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ttd" class="<?php echo $tblDosen_list->ttd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblDosen_list->SortUrl($tblDosen_list->ttd) ?>', 1);"><div id="elh_tblDosen_ttd" class="tblDosen_ttd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblDosen_list->ttd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblDosen_list->ttd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblDosen_list->ttd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblDosen_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblDosen_list->ExportAll && $tblDosen_list->isExport()) {
	$tblDosen_list->StopRecord = $tblDosen_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblDosen_list->TotalRecords > $tblDosen_list->StartRecord + $tblDosen_list->DisplayRecords - 1)
		$tblDosen_list->StopRecord = $tblDosen_list->StartRecord + $tblDosen_list->DisplayRecords - 1;
	else
		$tblDosen_list->StopRecord = $tblDosen_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblDosen->isConfirm() || $tblDosen_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblDosen_list->FormKeyCountName) && ($tblDosen_list->isGridAdd() || $tblDosen_list->isGridEdit() || $tblDosen->isConfirm())) {
		$tblDosen_list->KeyCount = $CurrentForm->getValue($tblDosen_list->FormKeyCountName);
		$tblDosen_list->StopRecord = $tblDosen_list->StartRecord + $tblDosen_list->KeyCount - 1;
	}
}
$tblDosen_list->RecordCount = $tblDosen_list->StartRecord - 1;
if ($tblDosen_list->Recordset && !$tblDosen_list->Recordset->EOF) {
	$tblDosen_list->Recordset->moveFirst();
	$selectLimit = $tblDosen_list->UseSelectLimit;
	if (!$selectLimit && $tblDosen_list->StartRecord > 1)
		$tblDosen_list->Recordset->move($tblDosen_list->StartRecord - 1);
} elseif (!$tblDosen->AllowAddDeleteRow && $tblDosen_list->StopRecord == 0) {
	$tblDosen_list->StopRecord = $tblDosen->GridAddRowCount;
}

// Initialize aggregate
$tblDosen->RowType = ROWTYPE_AGGREGATEINIT;
$tblDosen->resetAttributes();
$tblDosen_list->renderRow();
$tblDosen_list->EditRowCount = 0;
if ($tblDosen_list->isEdit())
	$tblDosen_list->RowIndex = 1;
while ($tblDosen_list->RecordCount < $tblDosen_list->StopRecord) {
	$tblDosen_list->RecordCount++;
	if ($tblDosen_list->RecordCount >= $tblDosen_list->StartRecord) {
		$tblDosen_list->RowCount++;

		// Set up key count
		$tblDosen_list->KeyCount = $tblDosen_list->RowIndex;

		// Init row class and style
		$tblDosen->resetAttributes();
		$tblDosen->CssClass = "";
		if ($tblDosen_list->isGridAdd()) {
			$tblDosen_list->loadRowValues(); // Load default values
		} else {
			$tblDosen_list->loadRowValues($tblDosen_list->Recordset); // Load row values
		}
		$tblDosen->RowType = ROWTYPE_VIEW; // Render view
		if ($tblDosen_list->isEdit()) {
			if ($tblDosen_list->checkInlineEditKey() && $tblDosen_list->EditRowCount == 0) { // Inline edit
				$tblDosen->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($tblDosen_list->isEdit() && $tblDosen->RowType == ROWTYPE_EDIT && $tblDosen->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$tblDosen_list->restoreFormValues(); // Restore form values
		}
		if ($tblDosen->RowType == ROWTYPE_EDIT) // Edit row
			$tblDosen_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblDosen->RowAttrs->merge(["data-rowindex" => $tblDosen_list->RowCount, "id" => "r" . $tblDosen_list->RowCount . "_tblDosen", "data-rowtype" => $tblDosen->RowType]);

		// Render row
		$tblDosen_list->renderRow();

		// Render list options
		$tblDosen_list->renderListOptions();
?>
	<tr <?php echo $tblDosen->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblDosen_list->ListOptions->render("body", "left", $tblDosen_list->RowCount);
?>
	<?php if ($tblDosen_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblDosen_list->NIDN->cellAttributes() ?>>
<?php if ($tblDosen->RowType == ROWTYPE_EDIT) { // Edit record ?>
<input type="text" data-table="tblDosen" data-field="x_NIDN" name="x<?php echo $tblDosen_list->RowIndex ?>_NIDN" id="x<?php echo $tblDosen_list->RowIndex ?>_NIDN" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($tblDosen_list->NIDN->getPlaceHolder()) ?>" value="<?php echo $tblDosen_list->NIDN->EditValue ?>"<?php echo $tblDosen_list->NIDN->editAttributes() ?>>
<input type="hidden" data-table="tblDosen" data-field="x_NIDN" name="o<?php echo $tblDosen_list->RowIndex ?>_NIDN" id="o<?php echo $tblDosen_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblDosen_list->NIDN->OldValue != null ? $tblDosen_list->NIDN->OldValue : $tblDosen_list->NIDN->CurrentValue) ?>">
<?php } ?>
<?php if ($tblDosen->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_NIDN">
<span<?php echo $tblDosen_list->NIDN->viewAttributes() ?>><?php echo $tblDosen_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblDosen_list->Nama->Visible) { // Nama ?>
		<td data-name="Nama" <?php echo $tblDosen_list->Nama->cellAttributes() ?>>
<?php if ($tblDosen->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Nama" class="form-group">
<input type="text" data-table="tblDosen" data-field="x_Nama" name="x<?php echo $tblDosen_list->RowIndex ?>_Nama" id="x<?php echo $tblDosen_list->RowIndex ?>_Nama" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblDosen_list->Nama->getPlaceHolder()) ?>" value="<?php echo $tblDosen_list->Nama->EditValue ?>"<?php echo $tblDosen_list->Nama->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblDosen->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Nama">
<span<?php echo $tblDosen_list->Nama->viewAttributes() ?>><?php echo $tblDosen_list->Nama->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblDosen_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $tblDosen_list->Status->cellAttributes() ?>>
<?php if ($tblDosen->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Status" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblDosen" data-field="x_Status" data-value-separator="<?php echo $tblDosen_list->Status->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblDosen_list->RowIndex ?>_Status" name="x<?php echo $tblDosen_list->RowIndex ?>_Status"<?php echo $tblDosen_list->Status->editAttributes() ?>>
			<?php echo $tblDosen_list->Status->selectOptionListHtml("x{$tblDosen_list->RowIndex}_Status") ?>
		</select>
</div>
</span>
<?php } ?>
<?php if ($tblDosen->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Status">
<span<?php echo $tblDosen_list->Status->viewAttributes() ?>><?php echo $tblDosen_list->Status->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblDosen_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $tblDosen_list->Kode_Jp->cellAttributes() ?>>
<?php if ($tblDosen->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Kode_Jp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblDosen" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblDosen_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblDosen_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblDosen_list->RowIndex ?>_Kode_Jp"<?php echo $tblDosen_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblDosen_list->Kode_Jp->selectOptionListHtml("x{$tblDosen_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblDosen_list->Kode_Jp->Lookup->getParamTag($tblDosen_list, "p_x" . $tblDosen_list->RowIndex . "_Kode_Jp") ?>
</span>
<?php } ?>
<?php if ($tblDosen->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_Kode_Jp">
<span<?php echo $tblDosen_list->Kode_Jp->viewAttributes() ?>><?php echo $tblDosen_list->Kode_Jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblDosen_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd" <?php echo $tblDosen_list->ttd->cellAttributes() ?>>
<?php if ($tblDosen->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_ttd" class="form-group">
<div id="fd_x<?php echo $tblDosen_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblDosen_list->ttd->title() ?>" data-table="tblDosen" data-field="x_ttd" name="x<?php echo $tblDosen_list->RowIndex ?>_ttd" id="x<?php echo $tblDosen_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblDosen_list->ttd->editAttributes() ?><?php if ($tblDosen_list->ttd->ReadOnly || $tblDosen_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblDosen_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblDosen_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblDosen_list->RowIndex ?>_ttd" value="<?php echo $tblDosen_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblDosen_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblDosen_list->RowIndex ?>_ttd" value="<?php echo (Post("fa_x<?php echo $tblDosen_list->RowIndex ?>_ttd") == "0") ? "0" : "1" ?>">
<input type="hidden" name="fs_x<?php echo $tblDosen_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblDosen_list->RowIndex ?>_ttd" value="100">
<input type="hidden" name="fx_x<?php echo $tblDosen_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblDosen_list->RowIndex ?>_ttd" value="<?php echo $tblDosen_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblDosen_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblDosen_list->RowIndex ?>_ttd" value="<?php echo $tblDosen_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblDosen_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($tblDosen->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblDosen_list->RowCount ?>_tblDosen_ttd">
<span><?php echo GetFileViewTag($tblDosen_list->ttd, $tblDosen_list->ttd->getViewValue(), FALSE) ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblDosen_list->ListOptions->render("body", "right", $tblDosen_list->RowCount);
?>
	</tr>
<?php if ($tblDosen->RowType == ROWTYPE_ADD || $tblDosen->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblDosenlist", "load"], function() {
	ftblDosenlist.updateLists(<?php echo $tblDosen_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	if (!$tblDosen_list->isGridAdd())
		$tblDosen_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblDosen_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $tblDosen_list->FormKeyCountName ?>" id="<?php echo $tblDosen_list->FormKeyCountName ?>" value="<?php echo $tblDosen_list->KeyCount ?>">
<?php } ?>
<?php if (!$tblDosen->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblDosen_list->Recordset)
	$tblDosen_list->Recordset->Close();
?>
<?php if (!$tblDosen_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblDosen_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblDosen_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblDosen_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblDosen_list->TotalRecords == 0 && !$tblDosen->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblDosen_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblDosen_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblDosen_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblDosen_list->terminate();
?>