<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblMHSEkpt_list = new tblMHSEkpt_list();

// Run the page
$tblMHSEkpt_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblMHSEkpt_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblMHSEkpt_list->isExport()) { ?>
<script>
var ftblMHSEkptlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblMHSEkptlist = currentForm = new ew.Form("ftblMHSEkptlist", "list");
	ftblMHSEkptlist.formKeyCountName = '<?php echo $tblMHSEkpt_list->FormKeyCountName ?>';

	// Validate form
	ftblMHSEkptlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tblMHSEkpt_list->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->Nim->caption(), $tblMHSEkpt_list->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->Nama_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Nama_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->Nama_Mhs->caption(), $tblMHSEkpt_list->Nama_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->Tlp_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Tlp_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->Tlp_Mhs->caption(), $tblMHSEkpt_list->Tlp_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->Status_Akd->Required) { ?>
				elm = this.getElements("x" + infix + "_Status_Akd");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->Status_Akd->caption(), $tblMHSEkpt_list->Status_Akd->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->TaMasuk->Required) { ?>
				elm = this.getElements("x" + infix + "_TaMasuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->TaMasuk->caption(), $tblMHSEkpt_list->TaMasuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->PerMasuk->Required) { ?>
				elm = this.getElements("x" + infix + "_PerMasuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->PerMasuk->caption(), $tblMHSEkpt_list->PerMasuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHSEkpt_list->Status->Required) { ?>
				elm = this.getElements("x" + infix + "_Status");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHSEkpt_list->Status->caption(), $tblMHSEkpt_list->Status->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftblMHSEkptlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblMHSEkptlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblMHSEkptlist.lists["x_Status"] = <?php echo $tblMHSEkpt_list->Status->Lookup->toClientList($tblMHSEkpt_list) ?>;
	ftblMHSEkptlist.lists["x_Status"].options = <?php echo JsonEncode($tblMHSEkpt_list->Status->options(FALSE, TRUE)) ?>;
	loadjs.done("ftblMHSEkptlist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblMHSEkpt_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblMHSEkpt_list->TotalRecords > 0 && $tblMHSEkpt_list->ExportOptions->visible()) { ?>
<?php $tblMHSEkpt_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->ImportOptions->visible()) { ?>
<?php $tblMHSEkpt_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblMHSEkpt_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblMHSEkpt_list->isExport("print")) { ?>
<?php
if ($tblMHSEkpt_list->DbMasterFilter != "" && $tblMHSEkpt->getCurrentMasterTable() == "ekpt_mhsfeed") {
	if ($tblMHSEkpt_list->MasterRecordExists) {
		include_once "ekpt_mhsfeedmaster.php";
	}
}
?>
<?php } ?>
<?php
$tblMHSEkpt_list->renderOtherOptions();
?>
<?php $tblMHSEkpt_list->showPageHeader(); ?>
<?php
$tblMHSEkpt_list->showMessage();
?>
<?php if ($tblMHSEkpt_list->TotalRecords > 0 || $tblMHSEkpt->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblMHSEkpt_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblMHSEkpt">
<form name="ftblMHSEkptlist" id="ftblMHSEkptlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblMHSEkpt">
<?php if ($tblMHSEkpt->getCurrentMasterTable() == "ekpt_mhsfeed" && $tblMHSEkpt->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="ekpt_mhsfeed">
<input type="hidden" name="fk_NimIM" value="<?php echo HtmlEncode($tblMHSEkpt_list->Nim->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblMHSEkpt" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblMHSEkpt_list->TotalRecords > 0 || $tblMHSEkpt_list->isGridEdit()) { ?>
<table id="tbl_tblMHSEkptlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblMHSEkpt->RowType = ROWTYPE_HEADER;

// Render list options
$tblMHSEkpt_list->renderListOptions();

// Render list options (header, left)
$tblMHSEkpt_list->ListOptions->render("header", "left");
?>
<?php if ($tblMHSEkpt_list->Nim->Visible) { // Nim ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $tblMHSEkpt_list->Nim->headerCellClass() ?>"><div id="elh_tblMHSEkpt_Nim" class="tblMHSEkpt_Nim"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $tblMHSEkpt_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Nim) ?>', 1);"><div id="elh_tblMHSEkpt_Nim" class="tblMHSEkpt_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $tblMHSEkpt_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_tblMHSEkpt_Nama_Mhs" class="tblMHSEkpt_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $tblMHSEkpt_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Nama_Mhs) ?>', 1);"><div id="elh_tblMHSEkpt_Nama_Mhs" class="tblMHSEkpt_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Nama_Mhs->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Tlp_Mhs) == "") { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $tblMHSEkpt_list->Tlp_Mhs->headerCellClass() ?>"><div id="elh_tblMHSEkpt_Tlp_Mhs" class="tblMHSEkpt_Tlp_Mhs"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Tlp_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $tblMHSEkpt_list->Tlp_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Tlp_Mhs) ?>', 1);"><div id="elh_tblMHSEkpt_Tlp_Mhs" class="tblMHSEkpt_Tlp_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Tlp_Mhs->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->Tlp_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->Tlp_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $tblMHSEkpt_list->Status_Akd->headerCellClass() ?>"><div id="elh_tblMHSEkpt_Status_Akd" class="tblMHSEkpt_Status_Akd"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $tblMHSEkpt_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Status_Akd) ?>', 1);"><div id="elh_tblMHSEkpt_Status_Akd" class="tblMHSEkpt_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->TaMasuk) == "") { ?>
		<th data-name="TaMasuk" class="<?php echo $tblMHSEkpt_list->TaMasuk->headerCellClass() ?>"><div id="elh_tblMHSEkpt_TaMasuk" class="tblMHSEkpt_TaMasuk"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->TaMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaMasuk" class="<?php echo $tblMHSEkpt_list->TaMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->TaMasuk) ?>', 1);"><div id="elh_tblMHSEkpt_TaMasuk" class="tblMHSEkpt_TaMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->TaMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->TaMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->TaMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $tblMHSEkpt_list->PerMasuk->headerCellClass() ?>"><div id="elh_tblMHSEkpt_PerMasuk" class="tblMHSEkpt_PerMasuk"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $tblMHSEkpt_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->PerMasuk) ?>', 1);"><div id="elh_tblMHSEkpt_PerMasuk" class="tblMHSEkpt_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->PerMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHSEkpt_list->Status->Visible) { // Status ?>
	<?php if ($tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $tblMHSEkpt_list->Status->headerCellClass() ?>"><div id="elh_tblMHSEkpt_Status" class="tblMHSEkpt_Status"><div class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $tblMHSEkpt_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHSEkpt_list->SortUrl($tblMHSEkpt_list->Status) ?>', 1);"><div id="elh_tblMHSEkpt_Status" class="tblMHSEkpt_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHSEkpt_list->Status->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHSEkpt_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHSEkpt_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblMHSEkpt_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblMHSEkpt_list->ExportAll && $tblMHSEkpt_list->isExport()) {
	$tblMHSEkpt_list->StopRecord = $tblMHSEkpt_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblMHSEkpt_list->TotalRecords > $tblMHSEkpt_list->StartRecord + $tblMHSEkpt_list->DisplayRecords - 1)
		$tblMHSEkpt_list->StopRecord = $tblMHSEkpt_list->StartRecord + $tblMHSEkpt_list->DisplayRecords - 1;
	else
		$tblMHSEkpt_list->StopRecord = $tblMHSEkpt_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblMHSEkpt->isConfirm() || $tblMHSEkpt_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblMHSEkpt_list->FormKeyCountName) && ($tblMHSEkpt_list->isGridAdd() || $tblMHSEkpt_list->isGridEdit() || $tblMHSEkpt->isConfirm())) {
		$tblMHSEkpt_list->KeyCount = $CurrentForm->getValue($tblMHSEkpt_list->FormKeyCountName);
		$tblMHSEkpt_list->StopRecord = $tblMHSEkpt_list->StartRecord + $tblMHSEkpt_list->KeyCount - 1;
	}
}
$tblMHSEkpt_list->RecordCount = $tblMHSEkpt_list->StartRecord - 1;
if ($tblMHSEkpt_list->Recordset && !$tblMHSEkpt_list->Recordset->EOF) {
	$tblMHSEkpt_list->Recordset->moveFirst();
	$selectLimit = $tblMHSEkpt_list->UseSelectLimit;
	if (!$selectLimit && $tblMHSEkpt_list->StartRecord > 1)
		$tblMHSEkpt_list->Recordset->move($tblMHSEkpt_list->StartRecord - 1);
} elseif (!$tblMHSEkpt->AllowAddDeleteRow && $tblMHSEkpt_list->StopRecord == 0) {
	$tblMHSEkpt_list->StopRecord = $tblMHSEkpt->GridAddRowCount;
}

// Initialize aggregate
$tblMHSEkpt->RowType = ROWTYPE_AGGREGATEINIT;
$tblMHSEkpt->resetAttributes();
$tblMHSEkpt_list->renderRow();
$tblMHSEkpt_list->EditRowCount = 0;
if ($tblMHSEkpt_list->isEdit())
	$tblMHSEkpt_list->RowIndex = 1;
while ($tblMHSEkpt_list->RecordCount < $tblMHSEkpt_list->StopRecord) {
	$tblMHSEkpt_list->RecordCount++;
	if ($tblMHSEkpt_list->RecordCount >= $tblMHSEkpt_list->StartRecord) {
		$tblMHSEkpt_list->RowCount++;

		// Set up key count
		$tblMHSEkpt_list->KeyCount = $tblMHSEkpt_list->RowIndex;

		// Init row class and style
		$tblMHSEkpt->resetAttributes();
		$tblMHSEkpt->CssClass = "";
		if ($tblMHSEkpt_list->isGridAdd()) {
			$tblMHSEkpt_list->loadRowValues(); // Load default values
		} else {
			$tblMHSEkpt_list->loadRowValues($tblMHSEkpt_list->Recordset); // Load row values
		}
		$tblMHSEkpt->RowType = ROWTYPE_VIEW; // Render view
		if ($tblMHSEkpt_list->isEdit()) {
			if ($tblMHSEkpt_list->checkInlineEditKey() && $tblMHSEkpt_list->EditRowCount == 0) { // Inline edit
				$tblMHSEkpt->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($tblMHSEkpt_list->isEdit() && $tblMHSEkpt->RowType == ROWTYPE_EDIT && $tblMHSEkpt->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$tblMHSEkpt_list->restoreFormValues(); // Restore form values
		}
		if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) // Edit row
			$tblMHSEkpt_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblMHSEkpt->RowAttrs->merge(["data-rowindex" => $tblMHSEkpt_list->RowCount, "id" => "r" . $tblMHSEkpt_list->RowCount . "_tblMHSEkpt", "data-rowtype" => $tblMHSEkpt->RowType]);

		// Render row
		$tblMHSEkpt_list->renderRow();

		// Render list options
		$tblMHSEkpt_list->renderListOptions();
?>
	<tr <?php echo $tblMHSEkpt->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblMHSEkpt_list->ListOptions->render("body", "left", $tblMHSEkpt_list->RowCount);
?>
	<?php if ($tblMHSEkpt_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $tblMHSEkpt_list->Nim->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Nim" class="form-group">
<span<?php echo $tblMHSEkpt_list->Nim->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($tblMHSEkpt_list->Nim->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="tblMHSEkpt" data-field="x_Nim" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Nim" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblMHSEkpt_list->Nim->CurrentValue) ?>">
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Nim">
<span<?php echo $tblMHSEkpt_list->Nim->viewAttributes() ?>><?php echo $tblMHSEkpt_list->Nim->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $tblMHSEkpt_list->Nama_Mhs->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Nama_Mhs" class="form-group">
<input type="text" data-table="tblMHSEkpt" data-field="x_Nama_Mhs" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Nama_Mhs" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Nama_Mhs" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($tblMHSEkpt_list->Nama_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHSEkpt_list->Nama_Mhs->EditValue ?>"<?php echo $tblMHSEkpt_list->Nama_Mhs->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Nama_Mhs">
<span<?php echo $tblMHSEkpt_list->Nama_Mhs->viewAttributes() ?>><?php echo $tblMHSEkpt_list->Nama_Mhs->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
		<td data-name="Tlp_Mhs" <?php echo $tblMHSEkpt_list->Tlp_Mhs->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Tlp_Mhs" class="form-group">
<input type="text" data-table="tblMHSEkpt" data-field="x_Tlp_Mhs" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Tlp_Mhs" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Tlp_Mhs" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($tblMHSEkpt_list->Tlp_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHSEkpt_list->Tlp_Mhs->EditValue ?>"<?php echo $tblMHSEkpt_list->Tlp_Mhs->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Tlp_Mhs">
<span<?php echo $tblMHSEkpt_list->Tlp_Mhs->viewAttributes() ?>><?php echo $tblMHSEkpt_list->Tlp_Mhs->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $tblMHSEkpt_list->Status_Akd->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Status_Akd" class="form-group">
<input type="text" data-table="tblMHSEkpt" data-field="x_Status_Akd" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Status_Akd" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Status_Akd" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($tblMHSEkpt_list->Status_Akd->getPlaceHolder()) ?>" value="<?php echo $tblMHSEkpt_list->Status_Akd->EditValue ?>"<?php echo $tblMHSEkpt_list->Status_Akd->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Status_Akd">
<span<?php echo $tblMHSEkpt_list->Status_Akd->viewAttributes() ?>><?php echo $tblMHSEkpt_list->Status_Akd->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->TaMasuk->Visible) { // TaMasuk ?>
		<td data-name="TaMasuk" <?php echo $tblMHSEkpt_list->TaMasuk->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_TaMasuk" class="form-group">
<input type="text" data-table="tblMHSEkpt" data-field="x_TaMasuk" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_TaMasuk" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_TaMasuk" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($tblMHSEkpt_list->TaMasuk->getPlaceHolder()) ?>" value="<?php echo $tblMHSEkpt_list->TaMasuk->EditValue ?>"<?php echo $tblMHSEkpt_list->TaMasuk->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_TaMasuk">
<span<?php echo $tblMHSEkpt_list->TaMasuk->viewAttributes() ?>><?php echo $tblMHSEkpt_list->TaMasuk->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $tblMHSEkpt_list->PerMasuk->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_PerMasuk" class="form-group">
<input type="text" data-table="tblMHSEkpt" data-field="x_PerMasuk" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_PerMasuk" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_PerMasuk" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($tblMHSEkpt_list->PerMasuk->getPlaceHolder()) ?>" value="<?php echo $tblMHSEkpt_list->PerMasuk->EditValue ?>"<?php echo $tblMHSEkpt_list->PerMasuk->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_PerMasuk">
<span<?php echo $tblMHSEkpt_list->PerMasuk->viewAttributes() ?>><?php echo $tblMHSEkpt_list->PerMasuk->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblMHSEkpt_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $tblMHSEkpt_list->Status->cellAttributes() ?>>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Status" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHSEkpt" data-field="x_Status" data-value-separator="<?php echo $tblMHSEkpt_list->Status->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Status" name="x<?php echo $tblMHSEkpt_list->RowIndex ?>_Status"<?php echo $tblMHSEkpt_list->Status->editAttributes() ?>>
			<?php echo $tblMHSEkpt_list->Status->selectOptionListHtml("x{$tblMHSEkpt_list->RowIndex}_Status") ?>
		</select>
</div>
</span>
<?php } ?>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblMHSEkpt_list->RowCount ?>_tblMHSEkpt_Status">
<span<?php echo $tblMHSEkpt_list->Status->viewAttributes() ?>><?php echo $tblMHSEkpt_list->Status->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblMHSEkpt_list->ListOptions->render("body", "right", $tblMHSEkpt_list->RowCount);
?>
	</tr>
<?php if ($tblMHSEkpt->RowType == ROWTYPE_ADD || $tblMHSEkpt->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblMHSEkptlist", "load"], function() {
	ftblMHSEkptlist.updateLists(<?php echo $tblMHSEkpt_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	if (!$tblMHSEkpt_list->isGridAdd())
		$tblMHSEkpt_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblMHSEkpt_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $tblMHSEkpt_list->FormKeyCountName ?>" id="<?php echo $tblMHSEkpt_list->FormKeyCountName ?>" value="<?php echo $tblMHSEkpt_list->KeyCount ?>">
<?php } ?>
<?php if (!$tblMHSEkpt->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblMHSEkpt_list->Recordset)
	$tblMHSEkpt_list->Recordset->Close();
?>
<?php if (!$tblMHSEkpt_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblMHSEkpt_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblMHSEkpt_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblMHSEkpt_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblMHSEkpt_list->TotalRecords == 0 && !$tblMHSEkpt->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblMHSEkpt_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblMHSEkpt_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblMHSEkpt_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblMHSEkpt_list->terminate();
?>