<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblMHS_edit = new tblMHS_edit();

// Run the page
$tblMHS_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblMHS_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftblMHSedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	ftblMHSedit = currentForm = new ew.Form("ftblMHSedit", "edit");

	// Validate form
	ftblMHSedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tblMHS_edit->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Nim->caption(), $tblMHS_edit->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Nama_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Nama_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Nama_Mhs->caption(), $tblMHS_edit->Nama_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Kode_jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Kode_jp->caption(), $tblMHS_edit->Kode_jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Tmp_Lahir->Required) { ?>
				elm = this.getElements("x" + infix + "_Tmp_Lahir");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Tmp_Lahir->caption(), $tblMHS_edit->Tmp_Lahir->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Tgl_Lahir->Required) { ?>
				elm = this.getElements("x" + infix + "_Tgl_Lahir");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Tgl_Lahir->caption(), $tblMHS_edit->Tgl_Lahir->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tgl_Lahir");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->Tgl_Lahir->errorMessage()) ?>");
			<?php if ($tblMHS_edit->Jenis_Kel->Required) { ?>
				elm = this.getElements("x" + infix + "_Jenis_Kel");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Jenis_Kel->caption(), $tblMHS_edit->Jenis_Kel->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Gol_darah->Required) { ?>
				elm = this.getElements("x" + infix + "_Gol_darah");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Gol_darah->caption(), $tblMHS_edit->Gol_darah->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Agama_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Agama_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Agama_Mhs->caption(), $tblMHS_edit->Agama_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Alamat_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Alamat_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Alamat_Mhs->caption(), $tblMHS_edit->Alamat_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->rt->Required) { ?>
				elm = this.getElements("x" + infix + "_rt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->rt->caption(), $tblMHS_edit->rt->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->rw->Required) { ?>
				elm = this.getElements("x" + infix + "_rw");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->rw->caption(), $tblMHS_edit->rw->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Kelurahan->Required) { ?>
				elm = this.getElements("x" + infix + "_Kelurahan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Kelurahan->caption(), $tblMHS_edit->Kelurahan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Kecamatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Kecamatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Kecamatan->caption(), $tblMHS_edit->Kecamatan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Kota_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Kota_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Kota_Mhs->caption(), $tblMHS_edit->Kota_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Provinsi_mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Provinsi_mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Provinsi_mhs->caption(), $tblMHS_edit->Provinsi_mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Kodepos_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Kodepos_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Kodepos_Mhs->caption(), $tblMHS_edit->Kodepos_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Tlp_Mhs->Required) { ?>
				elm = this.getElements("x" + infix + "_Tlp_Mhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Tlp_Mhs->caption(), $tblMHS_edit->Tlp_Mhs->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->TlpRumah->Required) { ?>
				elm = this.getElements("x" + infix + "_TlpRumah");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->TlpRumah->caption(), $tblMHS_edit->TlpRumah->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->_Email->Required) { ?>
				elm = this.getElements("x" + infix + "__Email");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->_Email->caption(), $tblMHS_edit->_Email->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Status_Akd->Required) { ?>
				elm = this.getElements("x" + infix + "_Status_Akd");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Status_Akd->caption(), $tblMHS_edit->Status_Akd->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->tglmasuk->Required) { ?>
				elm = this.getElements("x" + infix + "_tglmasuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->tglmasuk->caption(), $tblMHS_edit->tglmasuk->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tglmasuk");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->tglmasuk->errorMessage()) ?>");
			<?php if ($tblMHS_edit->Status_Masuk->Required) { ?>
				elm = this.getElements("x" + infix + "_Status_Masuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Status_Masuk->caption(), $tblMHS_edit->Status_Masuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Sem_Masuk->Required) { ?>
				elm = this.getElements("x" + infix + "_Sem_Masuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Sem_Masuk->caption(), $tblMHS_edit->Sem_Masuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->TaMasuk->Required) { ?>
				elm = this.getElements("x" + infix + "_TaMasuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->TaMasuk->caption(), $tblMHS_edit->TaMasuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->PerMasuk->Required) { ?>
				elm = this.getElements("x" + infix + "_PerMasuk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->PerMasuk->caption(), $tblMHS_edit->PerMasuk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Thn_Selesai->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Selesai");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Thn_Selesai->caption(), $tblMHS_edit->Thn_Selesai->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Status->Required) { ?>
				elm = this.getElements("x" + infix + "_Status");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Status->caption(), $tblMHS_edit->Status->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->NIK->Required) { ?>
				elm = this.getElements("x" + infix + "_NIK");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->NIK->caption(), $tblMHS_edit->NIK->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->NamaIbu->Required) { ?>
				elm = this.getElements("x" + infix + "_NamaIbu");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->NamaIbu->caption(), $tblMHS_edit->NamaIbu->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->iddesa->Required) { ?>
				elm = this.getElements("x" + infix + "_iddesa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->iddesa->caption(), $tblMHS_edit->iddesa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_iddesa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->iddesa->errorMessage()) ?>");
			<?php if ($tblMHS_edit->MulaiKerja->Required) { ?>
				elm = this.getElements("x" + infix + "_MulaiKerja");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->MulaiKerja->caption(), $tblMHS_edit->MulaiKerja->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_MulaiKerja");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->MulaiKerja->errorMessage()) ?>");
			<?php if ($tblMHS_edit->IdKlsKerjasama->Required) { ?>
				elm = this.getElements("x" + infix + "_IdKlsKerjasama");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->IdKlsKerjasama->caption(), $tblMHS_edit->IdKlsKerjasama->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_IdKlsKerjasama");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->IdKlsKerjasama->errorMessage()) ?>");
			<?php if ($tblMHS_edit->IDBeasiswa->Required) { ?>
				elm = this.getElements("x" + infix + "_IDBeasiswa");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->IDBeasiswa->caption(), $tblMHS_edit->IDBeasiswa->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_IDBeasiswa");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->IDBeasiswa->errorMessage()) ?>");
			<?php if ($tblMHS_edit->tglKonversi->Required) { ?>
				elm = this.getElements("x" + infix + "_tglKonversi");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->tglKonversi->caption(), $tblMHS_edit->tglKonversi->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tglKonversi");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->tglKonversi->errorMessage()) ?>");
			<?php if ($tblMHS_edit->NoSuratKonversi->Required) { ?>
				elm = this.getElements("x" + infix + "_NoSuratKonversi");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->NoSuratKonversi->caption(), $tblMHS_edit->NoSuratKonversi->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblMHS_edit->Nopen->Required) { ?>
				elm = this.getElements("x" + infix + "_Nopen");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->Nopen->caption(), $tblMHS_edit->Nopen->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Nopen");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblMHS_edit->Nopen->errorMessage()) ?>");
			<?php if ($tblMHS_edit->id_feedmhs->Required) { ?>
				elm = this.getElements("x" + infix + "_id_feedmhs");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblMHS_edit->id_feedmhs->caption(), $tblMHS_edit->id_feedmhs->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftblMHSedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblMHSedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblMHSedit.lists["x_Jenis_Kel"] = <?php echo $tblMHS_edit->Jenis_Kel->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_Jenis_Kel"].options = <?php echo JsonEncode($tblMHS_edit->Jenis_Kel->options(FALSE, TRUE)) ?>;
	ftblMHSedit.lists["x_Status_Akd"] = <?php echo $tblMHS_edit->Status_Akd->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblMHS_edit->Status_Akd->lookupOptions()) ?>;
	ftblMHSedit.lists["x_Status_Masuk"] = <?php echo $tblMHS_edit->Status_Masuk->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_Status_Masuk"].options = <?php echo JsonEncode($tblMHS_edit->Status_Masuk->options(FALSE, TRUE)) ?>;
	ftblMHSedit.lists["x_TaMasuk"] = <?php echo $tblMHS_edit->TaMasuk->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_TaMasuk"].options = <?php echo JsonEncode($tblMHS_edit->TaMasuk->lookupOptions()) ?>;
	ftblMHSedit.lists["x_PerMasuk"] = <?php echo $tblMHS_edit->PerMasuk->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_PerMasuk"].options = <?php echo JsonEncode($tblMHS_edit->PerMasuk->options(FALSE, TRUE)) ?>;
	ftblMHSedit.lists["x_Status"] = <?php echo $tblMHS_edit->Status->Lookup->toClientList($tblMHS_edit) ?>;
	ftblMHSedit.lists["x_Status"].options = <?php echo JsonEncode($tblMHS_edit->Status->options(FALSE, TRUE)) ?>;
	loadjs.done("ftblMHSedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $tblMHS_edit->showPageHeader(); ?>
<?php
$tblMHS_edit->showMessage();
?>
<form name="ftblMHSedit" id="ftblMHSedit" class="<?php echo $tblMHS_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblMHS">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$tblMHS_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($tblMHS_edit->Nim->Visible) { // Nim ?>
	<div id="r_Nim" class="form-group row">
		<label id="elh_tblMHS_Nim" for="x_Nim" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Nim->caption() ?><?php echo $tblMHS_edit->Nim->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Nim->cellAttributes() ?>>
<span id="el_tblMHS_Nim">
<span<?php echo $tblMHS_edit->Nim->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($tblMHS_edit->Nim->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="tblMHS" data-field="x_Nim" name="x_Nim" id="x_Nim" value="<?php echo HtmlEncode($tblMHS_edit->Nim->CurrentValue) ?>">
<?php echo $tblMHS_edit->Nim->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<div id="r_Nama_Mhs" class="form-group row">
		<label id="elh_tblMHS_Nama_Mhs" for="x_Nama_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Nama_Mhs->caption() ?><?php echo $tblMHS_edit->Nama_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Nama_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Nama_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Nama_Mhs" name="x_Nama_Mhs" id="x_Nama_Mhs" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($tblMHS_edit->Nama_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Nama_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Nama_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Nama_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Kode_jp->Visible) { // Kode_jp ?>
	<div id="r_Kode_jp" class="form-group row">
		<label id="elh_tblMHS_Kode_jp" for="x_Kode_jp" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Kode_jp->caption() ?><?php echo $tblMHS_edit->Kode_jp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Kode_jp->cellAttributes() ?>>
<span id="el_tblMHS_Kode_jp">
<span<?php echo $tblMHS_edit->Kode_jp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($tblMHS_edit->Kode_jp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="tblMHS" data-field="x_Kode_jp" name="x_Kode_jp" id="x_Kode_jp" value="<?php echo HtmlEncode($tblMHS_edit->Kode_jp->CurrentValue) ?>">
<?php echo $tblMHS_edit->Kode_jp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
	<div id="r_Tmp_Lahir" class="form-group row">
		<label id="elh_tblMHS_Tmp_Lahir" for="x_Tmp_Lahir" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Tmp_Lahir->caption() ?><?php echo $tblMHS_edit->Tmp_Lahir->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Tmp_Lahir->cellAttributes() ?>>
<span id="el_tblMHS_Tmp_Lahir">
<input type="text" data-table="tblMHS" data-field="x_Tmp_Lahir" name="x_Tmp_Lahir" id="x_Tmp_Lahir" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblMHS_edit->Tmp_Lahir->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Tmp_Lahir->EditValue ?>"<?php echo $tblMHS_edit->Tmp_Lahir->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Tmp_Lahir->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
	<div id="r_Tgl_Lahir" class="form-group row">
		<label id="elh_tblMHS_Tgl_Lahir" for="x_Tgl_Lahir" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Tgl_Lahir->caption() ?><?php echo $tblMHS_edit->Tgl_Lahir->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Tgl_Lahir->cellAttributes() ?>>
<span id="el_tblMHS_Tgl_Lahir">
<input type="text" data-table="tblMHS" data-field="x_Tgl_Lahir" name="x_Tgl_Lahir" id="x_Tgl_Lahir" maxlength="8" placeholder="<?php echo HtmlEncode($tblMHS_edit->Tgl_Lahir->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Tgl_Lahir->EditValue ?>"<?php echo $tblMHS_edit->Tgl_Lahir->editAttributes() ?>>
<?php if (!$tblMHS_edit->Tgl_Lahir->ReadOnly && !$tblMHS_edit->Tgl_Lahir->Disabled && !isset($tblMHS_edit->Tgl_Lahir->EditAttrs["readonly"]) && !isset($tblMHS_edit->Tgl_Lahir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblMHSedit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblMHSedit", "x_Tgl_Lahir", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tblMHS_edit->Tgl_Lahir->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Jenis_Kel->Visible) { // Jenis_Kel ?>
	<div id="r_Jenis_Kel" class="form-group row">
		<label id="elh_tblMHS_Jenis_Kel" for="x_Jenis_Kel" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Jenis_Kel->caption() ?><?php echo $tblMHS_edit->Jenis_Kel->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Jenis_Kel->cellAttributes() ?>>
<span id="el_tblMHS_Jenis_Kel">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Jenis_Kel" data-value-separator="<?php echo $tblMHS_edit->Jenis_Kel->displayValueSeparatorAttribute() ?>" id="x_Jenis_Kel" name="x_Jenis_Kel"<?php echo $tblMHS_edit->Jenis_Kel->editAttributes() ?>>
			<?php echo $tblMHS_edit->Jenis_Kel->selectOptionListHtml("x_Jenis_Kel") ?>
		</select>
</div>
</span>
<?php echo $tblMHS_edit->Jenis_Kel->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Gol_darah->Visible) { // Gol_darah ?>
	<div id="r_Gol_darah" class="form-group row">
		<label id="elh_tblMHS_Gol_darah" for="x_Gol_darah" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Gol_darah->caption() ?><?php echo $tblMHS_edit->Gol_darah->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Gol_darah->cellAttributes() ?>>
<span id="el_tblMHS_Gol_darah">
<input type="text" data-table="tblMHS" data-field="x_Gol_darah" name="x_Gol_darah" id="x_Gol_darah" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($tblMHS_edit->Gol_darah->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Gol_darah->EditValue ?>"<?php echo $tblMHS_edit->Gol_darah->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Gol_darah->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Agama_Mhs->Visible) { // Agama_Mhs ?>
	<div id="r_Agama_Mhs" class="form-group row">
		<label id="elh_tblMHS_Agama_Mhs" for="x_Agama_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Agama_Mhs->caption() ?><?php echo $tblMHS_edit->Agama_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Agama_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Agama_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Agama_Mhs" name="x_Agama_Mhs" id="x_Agama_Mhs" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($tblMHS_edit->Agama_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Agama_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Agama_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Agama_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Alamat_Mhs->Visible) { // Alamat_Mhs ?>
	<div id="r_Alamat_Mhs" class="form-group row">
		<label id="elh_tblMHS_Alamat_Mhs" for="x_Alamat_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Alamat_Mhs->caption() ?><?php echo $tblMHS_edit->Alamat_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Alamat_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Alamat_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Alamat_Mhs" name="x_Alamat_Mhs" id="x_Alamat_Mhs" size="30" maxlength="70" placeholder="<?php echo HtmlEncode($tblMHS_edit->Alamat_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Alamat_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Alamat_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Alamat_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->rt->Visible) { // rt ?>
	<div id="r_rt" class="form-group row">
		<label id="elh_tblMHS_rt" for="x_rt" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->rt->caption() ?><?php echo $tblMHS_edit->rt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->rt->cellAttributes() ?>>
<span id="el_tblMHS_rt">
<input type="text" data-table="tblMHS" data-field="x_rt" name="x_rt" id="x_rt" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($tblMHS_edit->rt->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->rt->EditValue ?>"<?php echo $tblMHS_edit->rt->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->rt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->rw->Visible) { // rw ?>
	<div id="r_rw" class="form-group row">
		<label id="elh_tblMHS_rw" for="x_rw" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->rw->caption() ?><?php echo $tblMHS_edit->rw->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->rw->cellAttributes() ?>>
<span id="el_tblMHS_rw">
<input type="text" data-table="tblMHS" data-field="x_rw" name="x_rw" id="x_rw" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($tblMHS_edit->rw->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->rw->EditValue ?>"<?php echo $tblMHS_edit->rw->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->rw->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Kelurahan->Visible) { // Kelurahan ?>
	<div id="r_Kelurahan" class="form-group row">
		<label id="elh_tblMHS_Kelurahan" for="x_Kelurahan" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Kelurahan->caption() ?><?php echo $tblMHS_edit->Kelurahan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Kelurahan->cellAttributes() ?>>
<span id="el_tblMHS_Kelurahan">
<input type="text" data-table="tblMHS" data-field="x_Kelurahan" name="x_Kelurahan" id="x_Kelurahan" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($tblMHS_edit->Kelurahan->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Kelurahan->EditValue ?>"<?php echo $tblMHS_edit->Kelurahan->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Kelurahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Kecamatan->Visible) { // Kecamatan ?>
	<div id="r_Kecamatan" class="form-group row">
		<label id="elh_tblMHS_Kecamatan" for="x_Kecamatan" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Kecamatan->caption() ?><?php echo $tblMHS_edit->Kecamatan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Kecamatan->cellAttributes() ?>>
<span id="el_tblMHS_Kecamatan">
<input type="text" data-table="tblMHS" data-field="x_Kecamatan" name="x_Kecamatan" id="x_Kecamatan" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($tblMHS_edit->Kecamatan->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Kecamatan->EditValue ?>"<?php echo $tblMHS_edit->Kecamatan->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Kecamatan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Kota_Mhs->Visible) { // Kota_Mhs ?>
	<div id="r_Kota_Mhs" class="form-group row">
		<label id="elh_tblMHS_Kota_Mhs" for="x_Kota_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Kota_Mhs->caption() ?><?php echo $tblMHS_edit->Kota_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Kota_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Kota_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Kota_Mhs" name="x_Kota_Mhs" id="x_Kota_Mhs" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblMHS_edit->Kota_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Kota_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Kota_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Kota_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Provinsi_mhs->Visible) { // Provinsi_mhs ?>
	<div id="r_Provinsi_mhs" class="form-group row">
		<label id="elh_tblMHS_Provinsi_mhs" for="x_Provinsi_mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Provinsi_mhs->caption() ?><?php echo $tblMHS_edit->Provinsi_mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Provinsi_mhs->cellAttributes() ?>>
<span id="el_tblMHS_Provinsi_mhs">
<input type="text" data-table="tblMHS" data-field="x_Provinsi_mhs" name="x_Provinsi_mhs" id="x_Provinsi_mhs" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($tblMHS_edit->Provinsi_mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Provinsi_mhs->EditValue ?>"<?php echo $tblMHS_edit->Provinsi_mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Provinsi_mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Kodepos_Mhs->Visible) { // Kodepos_Mhs ?>
	<div id="r_Kodepos_Mhs" class="form-group row">
		<label id="elh_tblMHS_Kodepos_Mhs" for="x_Kodepos_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Kodepos_Mhs->caption() ?><?php echo $tblMHS_edit->Kodepos_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Kodepos_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Kodepos_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Kodepos_Mhs" name="x_Kodepos_Mhs" id="x_Kodepos_Mhs" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($tblMHS_edit->Kodepos_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Kodepos_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Kodepos_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Kodepos_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<div id="r_Tlp_Mhs" class="form-group row">
		<label id="elh_tblMHS_Tlp_Mhs" for="x_Tlp_Mhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Tlp_Mhs->caption() ?><?php echo $tblMHS_edit->Tlp_Mhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Tlp_Mhs->cellAttributes() ?>>
<span id="el_tblMHS_Tlp_Mhs">
<input type="text" data-table="tblMHS" data-field="x_Tlp_Mhs" name="x_Tlp_Mhs" id="x_Tlp_Mhs" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($tblMHS_edit->Tlp_Mhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Tlp_Mhs->EditValue ?>"<?php echo $tblMHS_edit->Tlp_Mhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Tlp_Mhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->TlpRumah->Visible) { // TlpRumah ?>
	<div id="r_TlpRumah" class="form-group row">
		<label id="elh_tblMHS_TlpRumah" for="x_TlpRumah" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->TlpRumah->caption() ?><?php echo $tblMHS_edit->TlpRumah->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->TlpRumah->cellAttributes() ?>>
<span id="el_tblMHS_TlpRumah">
<input type="text" data-table="tblMHS" data-field="x_TlpRumah" name="x_TlpRumah" id="x_TlpRumah" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($tblMHS_edit->TlpRumah->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->TlpRumah->EditValue ?>"<?php echo $tblMHS_edit->TlpRumah->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->TlpRumah->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->_Email->Visible) { // Email ?>
	<div id="r__Email" class="form-group row">
		<label id="elh_tblMHS__Email" for="x__Email" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->_Email->caption() ?><?php echo $tblMHS_edit->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->_Email->cellAttributes() ?>>
<span id="el_tblMHS__Email">
<input type="text" data-table="tblMHS" data-field="x__Email" name="x__Email" id="x__Email" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblMHS_edit->_Email->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->_Email->EditValue ?>"<?php echo $tblMHS_edit->_Email->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->_Email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Status_Akd->Visible) { // Status_Akd ?>
	<div id="r_Status_Akd" class="form-group row">
		<label id="elh_tblMHS_Status_Akd" for="x_Status_Akd" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Status_Akd->caption() ?><?php echo $tblMHS_edit->Status_Akd->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Status_Akd->cellAttributes() ?>>
<span id="el_tblMHS_Status_Akd">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblMHS_edit->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $tblMHS_edit->Status_Akd->editAttributes() ?>>
			<?php echo $tblMHS_edit->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $tblMHS_edit->Status_Akd->Lookup->getParamTag($tblMHS_edit, "p_x_Status_Akd") ?>
</span>
<?php echo $tblMHS_edit->Status_Akd->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->tglmasuk->Visible) { // tglmasuk ?>
	<div id="r_tglmasuk" class="form-group row">
		<label id="elh_tblMHS_tglmasuk" for="x_tglmasuk" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->tglmasuk->caption() ?><?php echo $tblMHS_edit->tglmasuk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->tglmasuk->cellAttributes() ?>>
<span id="el_tblMHS_tglmasuk">
<input type="text" data-table="tblMHS" data-field="x_tglmasuk" data-format="7" name="x_tglmasuk" id="x_tglmasuk" maxlength="8" placeholder="<?php echo HtmlEncode($tblMHS_edit->tglmasuk->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->tglmasuk->EditValue ?>"<?php echo $tblMHS_edit->tglmasuk->editAttributes() ?>>
<?php if (!$tblMHS_edit->tglmasuk->ReadOnly && !$tblMHS_edit->tglmasuk->Disabled && !isset($tblMHS_edit->tglmasuk->EditAttrs["readonly"]) && !isset($tblMHS_edit->tglmasuk->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblMHSedit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblMHSedit", "x_tglmasuk", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $tblMHS_edit->tglmasuk->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Status_Masuk->Visible) { // Status_Masuk ?>
	<div id="r_Status_Masuk" class="form-group row">
		<label id="elh_tblMHS_Status_Masuk" for="x_Status_Masuk" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Status_Masuk->caption() ?><?php echo $tblMHS_edit->Status_Masuk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Status_Masuk->cellAttributes() ?>>
<span id="el_tblMHS_Status_Masuk">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status_Masuk" data-value-separator="<?php echo $tblMHS_edit->Status_Masuk->displayValueSeparatorAttribute() ?>" id="x_Status_Masuk" name="x_Status_Masuk"<?php echo $tblMHS_edit->Status_Masuk->editAttributes() ?>>
			<?php echo $tblMHS_edit->Status_Masuk->selectOptionListHtml("x_Status_Masuk") ?>
		</select>
</div>
</span>
<?php echo $tblMHS_edit->Status_Masuk->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Sem_Masuk->Visible) { // Sem_Masuk ?>
	<div id="r_Sem_Masuk" class="form-group row">
		<label id="elh_tblMHS_Sem_Masuk" for="x_Sem_Masuk" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Sem_Masuk->caption() ?><?php echo $tblMHS_edit->Sem_Masuk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Sem_Masuk->cellAttributes() ?>>
<span id="el_tblMHS_Sem_Masuk">
<input type="text" data-table="tblMHS" data-field="x_Sem_Masuk" name="x_Sem_Masuk" id="x_Sem_Masuk" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($tblMHS_edit->Sem_Masuk->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Sem_Masuk->EditValue ?>"<?php echo $tblMHS_edit->Sem_Masuk->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Sem_Masuk->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->TaMasuk->Visible) { // TaMasuk ?>
	<div id="r_TaMasuk" class="form-group row">
		<label id="elh_tblMHS_TaMasuk" for="x_TaMasuk" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->TaMasuk->caption() ?><?php echo $tblMHS_edit->TaMasuk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->TaMasuk->cellAttributes() ?>>
<span id="el_tblMHS_TaMasuk">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_TaMasuk" data-value-separator="<?php echo $tblMHS_edit->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $tblMHS_edit->TaMasuk->editAttributes() ?>>
			<?php echo $tblMHS_edit->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $tblMHS_edit->TaMasuk->Lookup->getParamTag($tblMHS_edit, "p_x_TaMasuk") ?>
</span>
<?php echo $tblMHS_edit->TaMasuk->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->PerMasuk->Visible) { // PerMasuk ?>
	<div id="r_PerMasuk" class="form-group row">
		<label id="elh_tblMHS_PerMasuk" for="x_PerMasuk" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->PerMasuk->caption() ?><?php echo $tblMHS_edit->PerMasuk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->PerMasuk->cellAttributes() ?>>
<span id="el_tblMHS_PerMasuk">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_PerMasuk" data-value-separator="<?php echo $tblMHS_edit->PerMasuk->displayValueSeparatorAttribute() ?>" id="x_PerMasuk" name="x_PerMasuk"<?php echo $tblMHS_edit->PerMasuk->editAttributes() ?>>
			<?php echo $tblMHS_edit->PerMasuk->selectOptionListHtml("x_PerMasuk") ?>
		</select>
</div>
</span>
<?php echo $tblMHS_edit->PerMasuk->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Thn_Selesai->Visible) { // Thn_Selesai ?>
	<div id="r_Thn_Selesai" class="form-group row">
		<label id="elh_tblMHS_Thn_Selesai" for="x_Thn_Selesai" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Thn_Selesai->caption() ?><?php echo $tblMHS_edit->Thn_Selesai->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Thn_Selesai->cellAttributes() ?>>
<span id="el_tblMHS_Thn_Selesai">
<input type="text" data-table="tblMHS" data-field="x_Thn_Selesai" name="x_Thn_Selesai" id="x_Thn_Selesai" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblMHS_edit->Thn_Selesai->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Thn_Selesai->EditValue ?>"<?php echo $tblMHS_edit->Thn_Selesai->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Thn_Selesai->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Status->Visible) { // Status ?>
	<div id="r_Status" class="form-group row">
		<label id="elh_tblMHS_Status" for="x_Status" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Status->caption() ?><?php echo $tblMHS_edit->Status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Status->cellAttributes() ?>>
<span id="el_tblMHS_Status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status" data-value-separator="<?php echo $tblMHS_edit->Status->displayValueSeparatorAttribute() ?>" id="x_Status" name="x_Status"<?php echo $tblMHS_edit->Status->editAttributes() ?>>
			<?php echo $tblMHS_edit->Status->selectOptionListHtml("x_Status") ?>
		</select>
</div>
</span>
<?php echo $tblMHS_edit->Status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->NIK->Visible) { // NIK ?>
	<div id="r_NIK" class="form-group row">
		<label id="elh_tblMHS_NIK" for="x_NIK" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->NIK->caption() ?><?php echo $tblMHS_edit->NIK->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->NIK->cellAttributes() ?>>
<span id="el_tblMHS_NIK">
<input type="text" data-table="tblMHS" data-field="x_NIK" name="x_NIK" id="x_NIK" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($tblMHS_edit->NIK->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->NIK->EditValue ?>"<?php echo $tblMHS_edit->NIK->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->NIK->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->NamaIbu->Visible) { // NamaIbu ?>
	<div id="r_NamaIbu" class="form-group row">
		<label id="elh_tblMHS_NamaIbu" for="x_NamaIbu" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->NamaIbu->caption() ?><?php echo $tblMHS_edit->NamaIbu->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->NamaIbu->cellAttributes() ?>>
<span id="el_tblMHS_NamaIbu">
<input type="text" data-table="tblMHS" data-field="x_NamaIbu" name="x_NamaIbu" id="x_NamaIbu" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblMHS_edit->NamaIbu->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->NamaIbu->EditValue ?>"<?php echo $tblMHS_edit->NamaIbu->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->NamaIbu->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->iddesa->Visible) { // iddesa ?>
	<div id="r_iddesa" class="form-group row">
		<label id="elh_tblMHS_iddesa" for="x_iddesa" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->iddesa->caption() ?><?php echo $tblMHS_edit->iddesa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->iddesa->cellAttributes() ?>>
<span id="el_tblMHS_iddesa">
<input type="text" data-table="tblMHS" data-field="x_iddesa" name="x_iddesa" id="x_iddesa" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblMHS_edit->iddesa->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->iddesa->EditValue ?>"<?php echo $tblMHS_edit->iddesa->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->iddesa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->MulaiKerja->Visible) { // MulaiKerja ?>
	<div id="r_MulaiKerja" class="form-group row">
		<label id="elh_tblMHS_MulaiKerja" for="x_MulaiKerja" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->MulaiKerja->caption() ?><?php echo $tblMHS_edit->MulaiKerja->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->MulaiKerja->cellAttributes() ?>>
<span id="el_tblMHS_MulaiKerja">
<input type="text" data-table="tblMHS" data-field="x_MulaiKerja" name="x_MulaiKerja" id="x_MulaiKerja" maxlength="8" placeholder="<?php echo HtmlEncode($tblMHS_edit->MulaiKerja->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->MulaiKerja->EditValue ?>"<?php echo $tblMHS_edit->MulaiKerja->editAttributes() ?>>
<?php if (!$tblMHS_edit->MulaiKerja->ReadOnly && !$tblMHS_edit->MulaiKerja->Disabled && !isset($tblMHS_edit->MulaiKerja->EditAttrs["readonly"]) && !isset($tblMHS_edit->MulaiKerja->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblMHSedit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblMHSedit", "x_MulaiKerja", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tblMHS_edit->MulaiKerja->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->IdKlsKerjasama->Visible) { // IdKlsKerjasama ?>
	<div id="r_IdKlsKerjasama" class="form-group row">
		<label id="elh_tblMHS_IdKlsKerjasama" for="x_IdKlsKerjasama" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->IdKlsKerjasama->caption() ?><?php echo $tblMHS_edit->IdKlsKerjasama->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->IdKlsKerjasama->cellAttributes() ?>>
<span id="el_tblMHS_IdKlsKerjasama">
<input type="text" data-table="tblMHS" data-field="x_IdKlsKerjasama" name="x_IdKlsKerjasama" id="x_IdKlsKerjasama" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblMHS_edit->IdKlsKerjasama->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->IdKlsKerjasama->EditValue ?>"<?php echo $tblMHS_edit->IdKlsKerjasama->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->IdKlsKerjasama->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->IDBeasiswa->Visible) { // IDBeasiswa ?>
	<div id="r_IDBeasiswa" class="form-group row">
		<label id="elh_tblMHS_IDBeasiswa" for="x_IDBeasiswa" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->IDBeasiswa->caption() ?><?php echo $tblMHS_edit->IDBeasiswa->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->IDBeasiswa->cellAttributes() ?>>
<span id="el_tblMHS_IDBeasiswa">
<input type="text" data-table="tblMHS" data-field="x_IDBeasiswa" name="x_IDBeasiswa" id="x_IDBeasiswa" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblMHS_edit->IDBeasiswa->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->IDBeasiswa->EditValue ?>"<?php echo $tblMHS_edit->IDBeasiswa->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->IDBeasiswa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->tglKonversi->Visible) { // tglKonversi ?>
	<div id="r_tglKonversi" class="form-group row">
		<label id="elh_tblMHS_tglKonversi" for="x_tglKonversi" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->tglKonversi->caption() ?><?php echo $tblMHS_edit->tglKonversi->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->tglKonversi->cellAttributes() ?>>
<span id="el_tblMHS_tglKonversi">
<input type="text" data-table="tblMHS" data-field="x_tglKonversi" name="x_tglKonversi" id="x_tglKonversi" maxlength="8" placeholder="<?php echo HtmlEncode($tblMHS_edit->tglKonversi->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->tglKonversi->EditValue ?>"<?php echo $tblMHS_edit->tglKonversi->editAttributes() ?>>
<?php if (!$tblMHS_edit->tglKonversi->ReadOnly && !$tblMHS_edit->tglKonversi->Disabled && !isset($tblMHS_edit->tglKonversi->EditAttrs["readonly"]) && !isset($tblMHS_edit->tglKonversi->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblMHSedit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblMHSedit", "x_tglKonversi", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tblMHS_edit->tglKonversi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->NoSuratKonversi->Visible) { // NoSuratKonversi ?>
	<div id="r_NoSuratKonversi" class="form-group row">
		<label id="elh_tblMHS_NoSuratKonversi" for="x_NoSuratKonversi" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->NoSuratKonversi->caption() ?><?php echo $tblMHS_edit->NoSuratKonversi->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->NoSuratKonversi->cellAttributes() ?>>
<span id="el_tblMHS_NoSuratKonversi">
<input type="text" data-table="tblMHS" data-field="x_NoSuratKonversi" name="x_NoSuratKonversi" id="x_NoSuratKonversi" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblMHS_edit->NoSuratKonversi->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->NoSuratKonversi->EditValue ?>"<?php echo $tblMHS_edit->NoSuratKonversi->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->NoSuratKonversi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->Nopen->Visible) { // Nopen ?>
	<div id="r_Nopen" class="form-group row">
		<label id="elh_tblMHS_Nopen" for="x_Nopen" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->Nopen->caption() ?><?php echo $tblMHS_edit->Nopen->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->Nopen->cellAttributes() ?>>
<span id="el_tblMHS_Nopen">
<input type="text" data-table="tblMHS" data-field="x_Nopen" name="x_Nopen" id="x_Nopen" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($tblMHS_edit->Nopen->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->Nopen->EditValue ?>"<?php echo $tblMHS_edit->Nopen->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->Nopen->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblMHS_edit->id_feedmhs->Visible) { // id_feedmhs ?>
	<div id="r_id_feedmhs" class="form-group row">
		<label id="elh_tblMHS_id_feedmhs" for="x_id_feedmhs" class="<?php echo $tblMHS_edit->LeftColumnClass ?>"><?php echo $tblMHS_edit->id_feedmhs->caption() ?><?php echo $tblMHS_edit->id_feedmhs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblMHS_edit->RightColumnClass ?>"><div <?php echo $tblMHS_edit->id_feedmhs->cellAttributes() ?>>
<span id="el_tblMHS_id_feedmhs">
<input type="text" data-table="tblMHS" data-field="x_id_feedmhs" name="x_id_feedmhs" id="x_id_feedmhs" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblMHS_edit->id_feedmhs->getPlaceHolder()) ?>" value="<?php echo $tblMHS_edit->id_feedmhs->EditValue ?>"<?php echo $tblMHS_edit->id_feedmhs->editAttributes() ?>>
</span>
<?php echo $tblMHS_edit->id_feedmhs->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("Wli_DNS", explode(",", $tblMHS->getCurrentDetailTable())) && $Wli_DNS->DetailEdit) {
?>
<?php if ($tblMHS->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("Wli_DNS", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "Wli_DNSgrid.php" ?>
<?php } ?>
<?php
	if (in_array("Wali_IPS", explode(",", $tblMHS->getCurrentDetailTable())) && $Wali_IPS->DetailEdit) {
?>
<?php if ($tblMHS->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("Wali_IPS", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "Wali_IPSgrid.php" ?>
<?php } ?>
<?php if (!$tblMHS_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tblMHS_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tblMHS_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tblMHS_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$tblMHS_edit->terminate();
?>