<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblMHS_list = new tblMHS_list();

// Run the page
$tblMHS_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblMHS_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblMHS_list->isExport()) { ?>
<script>
var ftblMHSlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblMHSlist = currentForm = new ew.Form("ftblMHSlist", "list");
	ftblMHSlist.formKeyCountName = '<?php echo $tblMHS_list->FormKeyCountName ?>';
	loadjs.done("ftblMHSlist");
});
var ftblMHSlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblMHSlistsrch = currentSearchForm = new ew.Form("ftblMHSlistsrch");

	// Validate function for search
	ftblMHSlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblMHSlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblMHSlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblMHSlistsrch.lists["x_Kode_jp"] = <?php echo $tblMHS_list->Kode_jp->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_Kode_jp"].options = <?php echo JsonEncode($tblMHS_list->Kode_jp->lookupOptions()) ?>;
	ftblMHSlistsrch.lists["x_Status_Akd"] = <?php echo $tblMHS_list->Status_Akd->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblMHS_list->Status_Akd->lookupOptions()) ?>;
	ftblMHSlistsrch.lists["x_Status_Masuk"] = <?php echo $tblMHS_list->Status_Masuk->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_Status_Masuk"].options = <?php echo JsonEncode($tblMHS_list->Status_Masuk->options(FALSE, TRUE)) ?>;
	ftblMHSlistsrch.lists["x_TaMasuk"] = <?php echo $tblMHS_list->TaMasuk->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_TaMasuk"].options = <?php echo JsonEncode($tblMHS_list->TaMasuk->lookupOptions()) ?>;
	ftblMHSlistsrch.lists["x_PerMasuk"] = <?php echo $tblMHS_list->PerMasuk->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_PerMasuk"].options = <?php echo JsonEncode($tblMHS_list->PerMasuk->options(FALSE, TRUE)) ?>;
	ftblMHSlistsrch.lists["x_Status"] = <?php echo $tblMHS_list->Status->Lookup->toClientList($tblMHS_list) ?>;
	ftblMHSlistsrch.lists["x_Status"].options = <?php echo JsonEncode($tblMHS_list->Status->options(FALSE, TRUE)) ?>;

	// Filters
	ftblMHSlistsrch.filterList = <?php echo $tblMHS_list->getFilterList() ?>;
	loadjs.done("ftblMHSlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblMHS_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblMHS_list->TotalRecords > 0 && $tblMHS_list->ExportOptions->visible()) { ?>
<?php $tblMHS_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblMHS_list->ImportOptions->visible()) { ?>
<?php $tblMHS_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblMHS_list->SearchOptions->visible()) { ?>
<?php $tblMHS_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblMHS_list->FilterOptions->visible()) { ?>
<?php $tblMHS_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblMHS_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblMHS_list->isExport() && !$tblMHS->CurrentAction) { ?>
<form name="ftblMHSlistsrch" id="ftblMHSlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblMHSlistsrch-search-panel" class="<?php echo $tblMHS_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblMHS">
	<div class="ew-extended-search">
<?php

// Render search row
$tblMHS->RowType = ROWTYPE_SEARCH;
$tblMHS->resetAttributes();
$tblMHS_list->renderRow();
?>
<?php if ($tblMHS_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_jp" class="ew-cell form-group">
		<label for="x_Kode_jp" class="ew-search-caption ew-label"><?php echo $tblMHS_list->Kode_jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_jp" id="z_Kode_jp" value="LIKE">
</span>
		<span id="el_tblMHS_Kode_jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Kode_jp" data-value-separator="<?php echo $tblMHS_list->Kode_jp->displayValueSeparatorAttribute() ?>" id="x_Kode_jp" name="x_Kode_jp"<?php echo $tblMHS_list->Kode_jp->editAttributes() ?>>
			<?php echo $tblMHS_list->Kode_jp->selectOptionListHtml("x_Kode_jp") ?>
		</select>
</div>
<?php echo $tblMHS_list->Kode_jp->Lookup->getParamTag($tblMHS_list, "p_x_Kode_jp") ?>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $tblMHS_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_tblMHS_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblMHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $tblMHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblMHS_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $tblMHS_list->Status_Akd->Lookup->getParamTag($tblMHS_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Masuk" class="ew-cell form-group">
		<label for="x_Status_Masuk" class="ew-search-caption ew-label"><?php echo $tblMHS_list->Status_Masuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Masuk" id="z_Status_Masuk" value="LIKE">
</span>
		<span id="el_tblMHS_Status_Masuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status_Masuk" data-value-separator="<?php echo $tblMHS_list->Status_Masuk->displayValueSeparatorAttribute() ?>" id="x_Status_Masuk" name="x_Status_Masuk"<?php echo $tblMHS_list->Status_Masuk->editAttributes() ?>>
			<?php echo $tblMHS_list->Status_Masuk->selectOptionListHtml("x_Status_Masuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_TaMasuk" class="ew-cell form-group">
		<label for="x_TaMasuk" class="ew-search-caption ew-label"><?php echo $tblMHS_list->TaMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaMasuk" id="z_TaMasuk" value="LIKE">
</span>
		<span id="el_tblMHS_TaMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_TaMasuk" data-value-separator="<?php echo $tblMHS_list->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $tblMHS_list->TaMasuk->editAttributes() ?>>
			<?php echo $tblMHS_list->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $tblMHS_list->TaMasuk->Lookup->getParamTag($tblMHS_list, "p_x_TaMasuk") ?>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_PerMasuk" class="ew-cell form-group">
		<label for="x_PerMasuk" class="ew-search-caption ew-label"><?php echo $tblMHS_list->PerMasuk->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasuk" id="z_PerMasuk" value="LIKE">
</span>
		<span id="el_tblMHS_PerMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_PerMasuk" data-value-separator="<?php echo $tblMHS_list->PerMasuk->displayValueSeparatorAttribute() ?>" id="x_PerMasuk" name="x_PerMasuk"<?php echo $tblMHS_list->PerMasuk->editAttributes() ?>>
			<?php echo $tblMHS_list->PerMasuk->selectOptionListHtml("x_PerMasuk") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status->Visible) { // Status ?>
	<?php
		$tblMHS_list->SearchColumnCount++;
		if (($tblMHS_list->SearchColumnCount - 1) % $tblMHS_list->SearchFieldsPerRow == 0) {
			$tblMHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status" class="ew-cell form-group">
		<label for="x_Status" class="ew-search-caption ew-label"><?php echo $tblMHS_list->Status->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status" id="z_Status" value="LIKE">
</span>
		<span id="el_tblMHS_Status" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMHS" data-field="x_Status" data-value-separator="<?php echo $tblMHS_list->Status->displayValueSeparatorAttribute() ?>" id="x_Status" name="x_Status"<?php echo $tblMHS_list->Status->editAttributes() ?>>
			<?php echo $tblMHS_list->Status->selectOptionListHtml("x_Status") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblMHS_list->SearchColumnCount % $tblMHS_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblMHS_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tblMHS_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tblMHS_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tblMHS_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tblMHS_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tblMHS_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tblMHS_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tblMHS_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblMHS_list->showPageHeader(); ?>
<?php
$tblMHS_list->showMessage();
?>
<?php if ($tblMHS_list->TotalRecords > 0 || $tblMHS->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblMHS_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblMHS">
<form name="ftblMHSlist" id="ftblMHSlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblMHS">
<div id="gmp_tblMHS" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblMHS_list->TotalRecords > 0 || $tblMHS_list->isGridEdit()) { ?>
<table id="tbl_tblMHSlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblMHS->RowType = ROWTYPE_HEADER;

// Render list options
$tblMHS_list->renderListOptions();

// Render list options (header, left)
$tblMHS_list->ListOptions->render("header", "left");
?>
<?php if ($tblMHS_list->Nim->Visible) { // Nim ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $tblMHS_list->Nim->headerCellClass() ?>"><div id="elh_tblMHS_Nim" class="tblMHS_Nim"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $tblMHS_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Nim) ?>', 1);"><div id="elh_tblMHS_Nim" class="tblMHS_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Nim->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Nama_Mhs) == "") { ?>
		<th data-name="Nama_Mhs" class="<?php echo $tblMHS_list->Nama_Mhs->headerCellClass() ?>"><div id="elh_tblMHS_Nama_Mhs" class="tblMHS_Nama_Mhs"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Nama_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mhs" class="<?php echo $tblMHS_list->Nama_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Nama_Mhs) ?>', 1);"><div id="elh_tblMHS_Nama_Mhs" class="tblMHS_Nama_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Nama_Mhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Nama_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Nama_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Kode_jp->Visible) { // Kode_jp ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Kode_jp) == "") { ?>
		<th data-name="Kode_jp" class="<?php echo $tblMHS_list->Kode_jp->headerCellClass() ?>"><div id="elh_tblMHS_Kode_jp" class="tblMHS_Kode_jp"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_jp" class="<?php echo $tblMHS_list->Kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Kode_jp) ?>', 1);"><div id="elh_tblMHS_Kode_jp" class="tblMHS_Kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Kode_jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Jenis_Kel->Visible) { // Jenis_Kel ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Jenis_Kel) == "") { ?>
		<th data-name="Jenis_Kel" class="<?php echo $tblMHS_list->Jenis_Kel->headerCellClass() ?>"><div id="elh_tblMHS_Jenis_Kel" class="tblMHS_Jenis_Kel"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Jenis_Kel->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jenis_Kel" class="<?php echo $tblMHS_list->Jenis_Kel->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Jenis_Kel) ?>', 1);"><div id="elh_tblMHS_Jenis_Kel" class="tblMHS_Jenis_Kel">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Jenis_Kel->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Jenis_Kel->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Jenis_Kel->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Tlp_Mhs) == "") { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $tblMHS_list->Tlp_Mhs->headerCellClass() ?>"><div id="elh_tblMHS_Tlp_Mhs" class="tblMHS_Tlp_Mhs"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Tlp_Mhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tlp_Mhs" class="<?php echo $tblMHS_list->Tlp_Mhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Tlp_Mhs) ?>', 1);"><div id="elh_tblMHS_Tlp_Mhs" class="tblMHS_Tlp_Mhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Tlp_Mhs->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Tlp_Mhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Tlp_Mhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $tblMHS_list->Status_Akd->headerCellClass() ?>"><div id="elh_tblMHS_Status_Akd" class="tblMHS_Status_Akd"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $tblMHS_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Status_Akd) ?>', 1);"><div id="elh_tblMHS_Status_Akd" class="tblMHS_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Status_Masuk) == "") { ?>
		<th data-name="Status_Masuk" class="<?php echo $tblMHS_list->Status_Masuk->headerCellClass() ?>"><div id="elh_tblMHS_Status_Masuk" class="tblMHS_Status_Masuk"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Status_Masuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Masuk" class="<?php echo $tblMHS_list->Status_Masuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Status_Masuk) ?>', 1);"><div id="elh_tblMHS_Status_Masuk" class="tblMHS_Status_Masuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Status_Masuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Status_Masuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Status_Masuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->TaMasuk->Visible) { // TaMasuk ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->TaMasuk) == "") { ?>
		<th data-name="TaMasuk" class="<?php echo $tblMHS_list->TaMasuk->headerCellClass() ?>"><div id="elh_tblMHS_TaMasuk" class="tblMHS_TaMasuk"><div class="ew-table-header-caption"><?php echo $tblMHS_list->TaMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaMasuk" class="<?php echo $tblMHS_list->TaMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->TaMasuk) ?>', 1);"><div id="elh_tblMHS_TaMasuk" class="tblMHS_TaMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->TaMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->TaMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->TaMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $tblMHS_list->PerMasuk->headerCellClass() ?>"><div id="elh_tblMHS_PerMasuk" class="tblMHS_PerMasuk"><div class="ew-table-header-caption"><?php echo $tblMHS_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $tblMHS_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->PerMasuk) ?>', 1);"><div id="elh_tblMHS_PerMasuk" class="tblMHS_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->PerMasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Status->Visible) { // Status ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $tblMHS_list->Status->headerCellClass() ?>"><div id="elh_tblMHS_Status" class="tblMHS_Status"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $tblMHS_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Status) ?>', 1);"><div id="elh_tblMHS_Status" class="tblMHS_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Status->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->Nopen->Visible) { // Nopen ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->Nopen) == "") { ?>
		<th data-name="Nopen" class="<?php echo $tblMHS_list->Nopen->headerCellClass() ?>"><div id="elh_tblMHS_Nopen" class="tblMHS_Nopen"><div class="ew-table-header-caption"><?php echo $tblMHS_list->Nopen->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nopen" class="<?php echo $tblMHS_list->Nopen->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->Nopen) ?>', 1);"><div id="elh_tblMHS_Nopen" class="tblMHS_Nopen">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->Nopen->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->Nopen->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->Nopen->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMHS_list->id_feedmhs->Visible) { // id_feedmhs ?>
	<?php if ($tblMHS_list->SortUrl($tblMHS_list->id_feedmhs) == "") { ?>
		<th data-name="id_feedmhs" class="<?php echo $tblMHS_list->id_feedmhs->headerCellClass() ?>"><div id="elh_tblMHS_id_feedmhs" class="tblMHS_id_feedmhs"><div class="ew-table-header-caption"><?php echo $tblMHS_list->id_feedmhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_feedmhs" class="<?php echo $tblMHS_list->id_feedmhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMHS_list->SortUrl($tblMHS_list->id_feedmhs) ?>', 1);"><div id="elh_tblMHS_id_feedmhs" class="tblMHS_id_feedmhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMHS_list->id_feedmhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMHS_list->id_feedmhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMHS_list->id_feedmhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblMHS_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblMHS_list->ExportAll && $tblMHS_list->isExport()) {
	$tblMHS_list->StopRecord = $tblMHS_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblMHS_list->TotalRecords > $tblMHS_list->StartRecord + $tblMHS_list->DisplayRecords - 1)
		$tblMHS_list->StopRecord = $tblMHS_list->StartRecord + $tblMHS_list->DisplayRecords - 1;
	else
		$tblMHS_list->StopRecord = $tblMHS_list->TotalRecords;
}
$tblMHS_list->RecordCount = $tblMHS_list->StartRecord - 1;
if ($tblMHS_list->Recordset && !$tblMHS_list->Recordset->EOF) {
	$tblMHS_list->Recordset->moveFirst();
	$selectLimit = $tblMHS_list->UseSelectLimit;
	if (!$selectLimit && $tblMHS_list->StartRecord > 1)
		$tblMHS_list->Recordset->move($tblMHS_list->StartRecord - 1);
} elseif (!$tblMHS->AllowAddDeleteRow && $tblMHS_list->StopRecord == 0) {
	$tblMHS_list->StopRecord = $tblMHS->GridAddRowCount;
}

// Initialize aggregate
$tblMHS->RowType = ROWTYPE_AGGREGATEINIT;
$tblMHS->resetAttributes();
$tblMHS_list->renderRow();
while ($tblMHS_list->RecordCount < $tblMHS_list->StopRecord) {
	$tblMHS_list->RecordCount++;
	if ($tblMHS_list->RecordCount >= $tblMHS_list->StartRecord) {
		$tblMHS_list->RowCount++;

		// Set up key count
		$tblMHS_list->KeyCount = $tblMHS_list->RowIndex;

		// Init row class and style
		$tblMHS->resetAttributes();
		$tblMHS->CssClass = "";
		if ($tblMHS_list->isGridAdd()) {
		} else {
			$tblMHS_list->loadRowValues($tblMHS_list->Recordset); // Load row values
		}
		$tblMHS->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tblMHS->RowAttrs->merge(["data-rowindex" => $tblMHS_list->RowCount, "id" => "r" . $tblMHS_list->RowCount . "_tblMHS", "data-rowtype" => $tblMHS->RowType]);

		// Render row
		$tblMHS_list->renderRow();

		// Render list options
		$tblMHS_list->renderListOptions();
?>
	<tr <?php echo $tblMHS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblMHS_list->ListOptions->render("body", "left", $tblMHS_list->RowCount);
?>
	<?php if ($tblMHS_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $tblMHS_list->Nim->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Nim">
<span<?php echo $tblMHS_list->Nim->viewAttributes() ?>><?php echo $tblMHS_list->Nim->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Nama_Mhs->Visible) { // Nama_Mhs ?>
		<td data-name="Nama_Mhs" <?php echo $tblMHS_list->Nama_Mhs->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Nama_Mhs">
<span<?php echo $tblMHS_list->Nama_Mhs->viewAttributes() ?>><?php echo $tblMHS_list->Nama_Mhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Kode_jp->Visible) { // Kode_jp ?>
		<td data-name="Kode_jp" <?php echo $tblMHS_list->Kode_jp->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Kode_jp">
<span<?php echo $tblMHS_list->Kode_jp->viewAttributes() ?>><?php echo $tblMHS_list->Kode_jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Jenis_Kel->Visible) { // Jenis_Kel ?>
		<td data-name="Jenis_Kel" <?php echo $tblMHS_list->Jenis_Kel->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Jenis_Kel">
<span<?php echo $tblMHS_list->Jenis_Kel->viewAttributes() ?>><?php echo $tblMHS_list->Jenis_Kel->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Tlp_Mhs->Visible) { // Tlp_Mhs ?>
		<td data-name="Tlp_Mhs" <?php echo $tblMHS_list->Tlp_Mhs->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Tlp_Mhs">
<span<?php echo $tblMHS_list->Tlp_Mhs->viewAttributes() ?>><?php if (!EmptyString($tblMHS_list->Tlp_Mhs->getViewValue()) && $tblMHS_list->Tlp_Mhs->linkAttributes() != "") { ?>
<a<?php echo $tblMHS_list->Tlp_Mhs->linkAttributes() ?>><?php echo $tblMHS_list->Tlp_Mhs->getViewValue() ?></a>
<?php } else { ?>
<?php echo $tblMHS_list->Tlp_Mhs->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $tblMHS_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Status_Akd">
<span<?php echo $tblMHS_list->Status_Akd->viewAttributes() ?>><?php echo $tblMHS_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Status_Masuk->Visible) { // Status_Masuk ?>
		<td data-name="Status_Masuk" <?php echo $tblMHS_list->Status_Masuk->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Status_Masuk">
<span<?php echo $tblMHS_list->Status_Masuk->viewAttributes() ?>><?php echo $tblMHS_list->Status_Masuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->TaMasuk->Visible) { // TaMasuk ?>
		<td data-name="TaMasuk" <?php echo $tblMHS_list->TaMasuk->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_TaMasuk">
<span<?php echo $tblMHS_list->TaMasuk->viewAttributes() ?>><?php echo $tblMHS_list->TaMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $tblMHS_list->PerMasuk->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_PerMasuk">
<span<?php echo $tblMHS_list->PerMasuk->viewAttributes() ?>><?php echo $tblMHS_list->PerMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $tblMHS_list->Status->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Status">
<span<?php echo $tblMHS_list->Status->viewAttributes() ?>><?php echo $tblMHS_list->Status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->Nopen->Visible) { // Nopen ?>
		<td data-name="Nopen" <?php echo $tblMHS_list->Nopen->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_Nopen">
<span<?php echo $tblMHS_list->Nopen->viewAttributes() ?>><?php echo $tblMHS_list->Nopen->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMHS_list->id_feedmhs->Visible) { // id_feedmhs ?>
		<td data-name="id_feedmhs" <?php echo $tblMHS_list->id_feedmhs->cellAttributes() ?>>
<span id="el<?php echo $tblMHS_list->RowCount ?>_tblMHS_id_feedmhs">
<span<?php echo $tblMHS_list->id_feedmhs->viewAttributes() ?>><?php echo $tblMHS_list->id_feedmhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblMHS_list->ListOptions->render("body", "right", $tblMHS_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$tblMHS_list->isGridAdd())
		$tblMHS_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$tblMHS->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblMHS_list->Recordset)
	$tblMHS_list->Recordset->Close();
?>
<?php if (!$tblMHS_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblMHS_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblMHS_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblMHS_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblMHS_list->TotalRecords == 0 && !$tblMHS->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblMHS_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblMHS_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblMHS_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblMHS_list->terminate();
?>