<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblMK_list = new tblMK_list();

// Run the page
$tblMK_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblMK_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblMK_list->isExport()) { ?>
<script>
var ftblMKlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblMKlist = currentForm = new ew.Form("ftblMKlist", "list");
	ftblMKlist.formKeyCountName = '<?php echo $tblMK_list->FormKeyCountName ?>';
	loadjs.done("ftblMKlist");
});
var ftblMKlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblMKlistsrch = currentSearchForm = new ew.Form("ftblMKlistsrch");

	// Validate function for search
	ftblMKlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblMKlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblMKlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblMKlistsrch.lists["x_Kel"] = <?php echo $tblMK_list->Kel->Lookup->toClientList($tblMK_list) ?>;
	ftblMKlistsrch.lists["x_Kel"].options = <?php echo JsonEncode($tblMK_list->Kel->lookupOptions()) ?>;

	// Filters
	ftblMKlistsrch.filterList = <?php echo $tblMK_list->getFilterList() ?>;
	loadjs.done("ftblMKlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblMK_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblMK_list->TotalRecords > 0 && $tblMK_list->ExportOptions->visible()) { ?>
<?php $tblMK_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblMK_list->ImportOptions->visible()) { ?>
<?php $tblMK_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblMK_list->SearchOptions->visible()) { ?>
<?php $tblMK_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblMK_list->FilterOptions->visible()) { ?>
<?php $tblMK_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblMK_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblMK_list->isExport("print")) { ?>
<?php
if ($tblMK_list->DbMasterFilter != "" && $tblMK->getCurrentMasterTable() == "QFak") {
	if ($tblMK_list->MasterRecordExists) {
		include_once "QFakmaster.php";
	}
}
?>
<?php } ?>
<?php
$tblMK_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblMK_list->isExport() && !$tblMK->CurrentAction) { ?>
<form name="ftblMKlistsrch" id="ftblMKlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblMKlistsrch-search-panel" class="<?php echo $tblMK_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblMK">
	<div class="ew-extended-search">
<?php

// Render search row
$tblMK->RowType = ROWTYPE_SEARCH;
$tblMK->resetAttributes();
$tblMK_list->renderRow();
?>
<?php if ($tblMK_list->Kel->Visible) { // Kel ?>
	<?php
		$tblMK_list->SearchColumnCount++;
		if (($tblMK_list->SearchColumnCount - 1) % $tblMK_list->SearchFieldsPerRow == 0) {
			$tblMK_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblMK_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kel" class="ew-cell form-group">
		<label for="x_Kel" class="ew-search-caption ew-label"><?php echo $tblMK_list->Kel->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kel" id="z_Kel" value="LIKE">
</span>
		<span id="el_tblMK_Kel" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblMK" data-field="x_Kel" data-value-separator="<?php echo $tblMK_list->Kel->displayValueSeparatorAttribute() ?>" id="x_Kel" name="x_Kel"<?php echo $tblMK_list->Kel->editAttributes() ?>>
			<?php echo $tblMK_list->Kel->selectOptionListHtml("x_Kel") ?>
		</select>
</div>
<?php echo $tblMK_list->Kel->Lookup->getParamTag($tblMK_list, "p_x_Kel") ?>
</span>
	</div>
	<?php if ($tblMK_list->SearchColumnCount % $tblMK_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblMK_list->SearchColumnCount % $tblMK_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblMK_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tblMK_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tblMK_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tblMK_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tblMK_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tblMK_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tblMK_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tblMK_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblMK_list->showPageHeader(); ?>
<?php
$tblMK_list->showMessage();
?>
<?php if ($tblMK_list->TotalRecords > 0 || $tblMK->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblMK_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblMK">
<form name="ftblMKlist" id="ftblMKlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblMK">
<?php if ($tblMK->getCurrentMasterTable() == "QFak" && $tblMK->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="QFak">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($tblMK_list->Kode_Fak->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblMK" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblMK_list->TotalRecords > 0 || $tblMK_list->isGridEdit()) { ?>
<table id="tbl_tblMKlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblMK->RowType = ROWTYPE_HEADER;

// Render list options
$tblMK_list->renderListOptions();

// Render list options (header, left)
$tblMK_list->ListOptions->render("header", "left");
?>
<?php if ($tblMK_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $tblMK_list->Kode_MK->headerCellClass() ?>"><div id="elh_tblMK_Kode_MK" class="tblMK_Kode_MK"><div class="ew-table-header-caption"><?php echo $tblMK_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $tblMK_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Kode_MK) ?>', 1);"><div id="elh_tblMK_Kode_MK" class="tblMK_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Kode_MK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Nama_Mk_Ind) == "") { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $tblMK_list->Nama_Mk_Ind->headerCellClass() ?>"><div id="elh_tblMK_Nama_Mk_Ind" class="tblMK_Nama_Mk_Ind"><div class="ew-table-header-caption"><?php echo $tblMK_list->Nama_Mk_Ind->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $tblMK_list->Nama_Mk_Ind->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Nama_Mk_Ind) ?>', 1);"><div id="elh_tblMK_Nama_Mk_Ind" class="tblMK_Nama_Mk_Ind">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Nama_Mk_Ind->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Nama_Mk_Ind->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Nama_Mk_Ind->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->Nama_Mk_Ing->Visible) { // Nama_Mk_Ing ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Nama_Mk_Ing) == "") { ?>
		<th data-name="Nama_Mk_Ing" class="<?php echo $tblMK_list->Nama_Mk_Ing->headerCellClass() ?>"><div id="elh_tblMK_Nama_Mk_Ing" class="tblMK_Nama_Mk_Ing"><div class="ew-table-header-caption"><?php echo $tblMK_list->Nama_Mk_Ing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ing" class="<?php echo $tblMK_list->Nama_Mk_Ing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Nama_Mk_Ing) ?>', 1);"><div id="elh_tblMK_Nama_Mk_Ing" class="tblMK_Nama_Mk_Ing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Nama_Mk_Ing->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Nama_Mk_Ing->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Nama_Mk_Ing->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->Singkatan->Visible) { // Singkatan ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Singkatan) == "") { ?>
		<th data-name="Singkatan" class="<?php echo $tblMK_list->Singkatan->headerCellClass() ?>"><div id="elh_tblMK_Singkatan" class="tblMK_Singkatan"><div class="ew-table-header-caption"><?php echo $tblMK_list->Singkatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Singkatan" class="<?php echo $tblMK_list->Singkatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Singkatan) ?>', 1);"><div id="elh_tblMK_Singkatan" class="tblMK_Singkatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Singkatan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Singkatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Singkatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->SKS->Visible) { // SKS ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $tblMK_list->SKS->headerCellClass() ?>"><div id="elh_tblMK_SKS" class="tblMK_SKS"><div class="ew-table-header-caption"><?php echo $tblMK_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $tblMK_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->SKS) ?>', 1);"><div id="elh_tblMK_SKS" class="tblMK_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->sksteory->Visible) { // sksteory ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->sksteory) == "") { ?>
		<th data-name="sksteory" class="<?php echo $tblMK_list->sksteory->headerCellClass() ?>"><div id="elh_tblMK_sksteory" class="tblMK_sksteory"><div class="ew-table-header-caption"><?php echo $tblMK_list->sksteory->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sksteory" class="<?php echo $tblMK_list->sksteory->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->sksteory) ?>', 1);"><div id="elh_tblMK_sksteory" class="tblMK_sksteory">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->sksteory->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->sksteory->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->sksteory->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->sksprak->Visible) { // sksprak ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->sksprak) == "") { ?>
		<th data-name="sksprak" class="<?php echo $tblMK_list->sksprak->headerCellClass() ?>"><div id="elh_tblMK_sksprak" class="tblMK_sksprak"><div class="ew-table-header-caption"><?php echo $tblMK_list->sksprak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sksprak" class="<?php echo $tblMK_list->sksprak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->sksprak) ?>', 1);"><div id="elh_tblMK_sksprak" class="tblMK_sksprak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->sksprak->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->sksprak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->sksprak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->Kel->Visible) { // Kel ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Kel) == "") { ?>
		<th data-name="Kel" class="<?php echo $tblMK_list->Kel->headerCellClass() ?>"><div id="elh_tblMK_Kel" class="tblMK_Kel"><div class="ew-table-header-caption"><?php echo $tblMK_list->Kel->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kel" class="<?php echo $tblMK_list->Kel->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Kel) ?>', 1);"><div id="elh_tblMK_Kel" class="tblMK_Kel">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Kel->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Kel->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Kel->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblMK_list->Ket->Visible) { // Ket ?>
	<?php if ($tblMK_list->SortUrl($tblMK_list->Ket) == "") { ?>
		<th data-name="Ket" class="<?php echo $tblMK_list->Ket->headerCellClass() ?>"><div id="elh_tblMK_Ket" class="tblMK_Ket"><div class="ew-table-header-caption"><?php echo $tblMK_list->Ket->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ket" class="<?php echo $tblMK_list->Ket->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblMK_list->SortUrl($tblMK_list->Ket) ?>', 1);"><div id="elh_tblMK_Ket" class="tblMK_Ket">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblMK_list->Ket->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblMK_list->Ket->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblMK_list->Ket->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblMK_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblMK_list->ExportAll && $tblMK_list->isExport()) {
	$tblMK_list->StopRecord = $tblMK_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblMK_list->TotalRecords > $tblMK_list->StartRecord + $tblMK_list->DisplayRecords - 1)
		$tblMK_list->StopRecord = $tblMK_list->StartRecord + $tblMK_list->DisplayRecords - 1;
	else
		$tblMK_list->StopRecord = $tblMK_list->TotalRecords;
}
$tblMK_list->RecordCount = $tblMK_list->StartRecord - 1;
if ($tblMK_list->Recordset && !$tblMK_list->Recordset->EOF) {
	$tblMK_list->Recordset->moveFirst();
	$selectLimit = $tblMK_list->UseSelectLimit;
	if (!$selectLimit && $tblMK_list->StartRecord > 1)
		$tblMK_list->Recordset->move($tblMK_list->StartRecord - 1);
} elseif (!$tblMK->AllowAddDeleteRow && $tblMK_list->StopRecord == 0) {
	$tblMK_list->StopRecord = $tblMK->GridAddRowCount;
}

// Initialize aggregate
$tblMK->RowType = ROWTYPE_AGGREGATEINIT;
$tblMK->resetAttributes();
$tblMK_list->renderRow();
while ($tblMK_list->RecordCount < $tblMK_list->StopRecord) {
	$tblMK_list->RecordCount++;
	if ($tblMK_list->RecordCount >= $tblMK_list->StartRecord) {
		$tblMK_list->RowCount++;

		// Set up key count
		$tblMK_list->KeyCount = $tblMK_list->RowIndex;

		// Init row class and style
		$tblMK->resetAttributes();
		$tblMK->CssClass = "";
		if ($tblMK_list->isGridAdd()) {
		} else {
			$tblMK_list->loadRowValues($tblMK_list->Recordset); // Load row values
		}
		$tblMK->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tblMK->RowAttrs->merge(["data-rowindex" => $tblMK_list->RowCount, "id" => "r" . $tblMK_list->RowCount . "_tblMK", "data-rowtype" => $tblMK->RowType]);

		// Render row
		$tblMK_list->renderRow();

		// Render list options
		$tblMK_list->renderListOptions();
?>
	<tr <?php echo $tblMK->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblMK_list->ListOptions->render("body", "left", $tblMK_list->RowCount);
?>
	<?php if ($tblMK_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $tblMK_list->Kode_MK->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Kode_MK">
<span<?php echo $tblMK_list->Kode_MK->viewAttributes() ?>><?php echo $tblMK_list->Kode_MK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
		<td data-name="Nama_Mk_Ind" <?php echo $tblMK_list->Nama_Mk_Ind->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Nama_Mk_Ind">
<span<?php echo $tblMK_list->Nama_Mk_Ind->viewAttributes() ?>><?php echo $tblMK_list->Nama_Mk_Ind->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->Nama_Mk_Ing->Visible) { // Nama_Mk_Ing ?>
		<td data-name="Nama_Mk_Ing" <?php echo $tblMK_list->Nama_Mk_Ing->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Nama_Mk_Ing">
<span<?php echo $tblMK_list->Nama_Mk_Ing->viewAttributes() ?>><?php echo $tblMK_list->Nama_Mk_Ing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->Singkatan->Visible) { // Singkatan ?>
		<td data-name="Singkatan" <?php echo $tblMK_list->Singkatan->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Singkatan">
<span<?php echo $tblMK_list->Singkatan->viewAttributes() ?>><?php echo $tblMK_list->Singkatan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $tblMK_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_SKS">
<span<?php echo $tblMK_list->SKS->viewAttributes() ?>><?php echo $tblMK_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->sksteory->Visible) { // sksteory ?>
		<td data-name="sksteory" <?php echo $tblMK_list->sksteory->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_sksteory">
<span<?php echo $tblMK_list->sksteory->viewAttributes() ?>><?php echo $tblMK_list->sksteory->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->sksprak->Visible) { // sksprak ?>
		<td data-name="sksprak" <?php echo $tblMK_list->sksprak->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_sksprak">
<span<?php echo $tblMK_list->sksprak->viewAttributes() ?>><?php echo $tblMK_list->sksprak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->Kel->Visible) { // Kel ?>
		<td data-name="Kel" <?php echo $tblMK_list->Kel->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Kel">
<span<?php echo $tblMK_list->Kel->viewAttributes() ?>><?php echo $tblMK_list->Kel->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblMK_list->Ket->Visible) { // Ket ?>
		<td data-name="Ket" <?php echo $tblMK_list->Ket->cellAttributes() ?>>
<span id="el<?php echo $tblMK_list->RowCount ?>_tblMK_Ket">
<span<?php echo $tblMK_list->Ket->viewAttributes() ?>><?php echo $tblMK_list->Ket->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblMK_list->ListOptions->render("body", "right", $tblMK_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$tblMK_list->isGridAdd())
		$tblMK_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$tblMK->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblMK_list->Recordset)
	$tblMK_list->Recordset->Close();
?>
<?php if (!$tblMK_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblMK_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblMK_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblMK_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblMK_list->TotalRecords == 0 && !$tblMK->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblMK_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblMK_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblMK_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblMK_list->terminate();
?>