<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblNilaiPerMhs_list = new tblNilaiPerMhs_list();

// Run the page
$tblNilaiPerMhs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblNilaiPerMhs_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblNilaiPerMhs_list->isExport()) { ?>
<script>
var ftblNilaiPerMhslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblNilaiPerMhslist = currentForm = new ew.Form("ftblNilaiPerMhslist", "list");
	ftblNilaiPerMhslist.formKeyCountName = '<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>';

	// Validate form
	ftblNilaiPerMhslist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblNilaiPerMhs_list->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Thn_Akademik->caption(), $tblNilaiPerMhs_list->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblNilaiPerMhs_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Periode->caption(), $tblNilaiPerMhs_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblNilaiPerMhs_list->Kode_MK->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_MK");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Kode_MK->caption(), $tblNilaiPerMhs_list->Kode_MK->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblNilaiPerMhs_list->Kehadiran->Required) { ?>
				elm = this.getElements("x" + infix + "_Kehadiran");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Kehadiran->caption(), $tblNilaiPerMhs_list->Kehadiran->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Kehadiran");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->Kehadiran->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->Tugas->Required) { ?>
				elm = this.getElements("x" + infix + "_Tugas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Tugas->caption(), $tblNilaiPerMhs_list->Tugas->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tugas");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->Tugas->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->UTS->Required) { ?>
				elm = this.getElements("x" + infix + "_UTS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->UTS->caption(), $tblNilaiPerMhs_list->UTS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_UTS");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->UTS->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->UAS->Required) { ?>
				elm = this.getElements("x" + infix + "_UAS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->UAS->caption(), $tblNilaiPerMhs_list->UAS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_UAS");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->UAS->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->Jumlah->Required) { ?>
				elm = this.getElements("x" + infix + "_Jumlah");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Jumlah->caption(), $tblNilaiPerMhs_list->Jumlah->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Jumlah");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->Jumlah->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->Nilai->Required) { ?>
				elm = this.getElements("x" + infix + "_Nilai");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Nilai->caption(), $tblNilaiPerMhs_list->Nilai->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblNilaiPerMhs_list->Angka->Required) { ?>
				elm = this.getElements("x" + infix + "_Angka");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->Angka->caption(), $tblNilaiPerMhs_list->Angka->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Angka");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilaiPerMhs_list->Angka->errorMessage()) ?>");
			<?php if ($tblNilaiPerMhs_list->stat_feeder->Required) { ?>
				elm = this.getElements("x" + infix + "_stat_feeder");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilaiPerMhs_list->stat_feeder->caption(), $tblNilaiPerMhs_list->stat_feeder->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblNilaiPerMhslist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Thn_Akademik", false)) return false;
		if (ew.valueChanged(fobj, infix, "Periode", false)) return false;
		if (ew.valueChanged(fobj, infix, "Kode_MK", false)) return false;
		if (ew.valueChanged(fobj, infix, "Kehadiran", false)) return false;
		if (ew.valueChanged(fobj, infix, "Tugas", false)) return false;
		if (ew.valueChanged(fobj, infix, "UTS", false)) return false;
		if (ew.valueChanged(fobj, infix, "UAS", false)) return false;
		if (ew.valueChanged(fobj, infix, "Jumlah", false)) return false;
		if (ew.valueChanged(fobj, infix, "Nilai", false)) return false;
		if (ew.valueChanged(fobj, infix, "Angka", false)) return false;
		if (ew.valueChanged(fobj, infix, "stat_feeder", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblNilaiPerMhslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblNilaiPerMhslist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblNilaiPerMhslist.lists["x_Thn_Akademik"] = <?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->toClientList($tblNilaiPerMhs_list) ?>;
	ftblNilaiPerMhslist.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblNilaiPerMhs_list->Thn_Akademik->lookupOptions()) ?>;
	ftblNilaiPerMhslist.lists["x_Periode"] = <?php echo $tblNilaiPerMhs_list->Periode->Lookup->toClientList($tblNilaiPerMhs_list) ?>;
	ftblNilaiPerMhslist.lists["x_Periode"].options = <?php echo JsonEncode($tblNilaiPerMhs_list->Periode->options(FALSE, TRUE)) ?>;
	ftblNilaiPerMhslist.lists["x_Kode_MK"] = <?php echo $tblNilaiPerMhs_list->Kode_MK->Lookup->toClientList($tblNilaiPerMhs_list) ?>;
	ftblNilaiPerMhslist.lists["x_Kode_MK"].options = <?php echo JsonEncode($tblNilaiPerMhs_list->Kode_MK->lookupOptions()) ?>;
	ftblNilaiPerMhslist.autoSuggests["x_Kode_MK"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("ftblNilaiPerMhslist");
});
var ftblNilaiPerMhslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblNilaiPerMhslistsrch = currentSearchForm = new ew.Form("ftblNilaiPerMhslistsrch");

	// Validate function for search
	ftblNilaiPerMhslistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblNilaiPerMhslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblNilaiPerMhslistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblNilaiPerMhslistsrch.lists["x_Thn_Akademik"] = <?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->toClientList($tblNilaiPerMhs_list) ?>;
	ftblNilaiPerMhslistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblNilaiPerMhs_list->Thn_Akademik->lookupOptions()) ?>;
	ftblNilaiPerMhslistsrch.lists["x_Periode"] = <?php echo $tblNilaiPerMhs_list->Periode->Lookup->toClientList($tblNilaiPerMhs_list) ?>;
	ftblNilaiPerMhslistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblNilaiPerMhs_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	ftblNilaiPerMhslistsrch.filterList = <?php echo $tblNilaiPerMhs_list->getFilterList() ?>;
	loadjs.done("ftblNilaiPerMhslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblNilaiPerMhs_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblNilaiPerMhs_list->TotalRecords > 0 && $tblNilaiPerMhs_list->ExportOptions->visible()) { ?>
<?php $tblNilaiPerMhs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->ImportOptions->visible()) { ?>
<?php $tblNilaiPerMhs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->SearchOptions->visible()) { ?>
<?php $tblNilaiPerMhs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->FilterOptions->visible()) { ?>
<?php $tblNilaiPerMhs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblNilaiPerMhs_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblNilaiPerMhs_list->isExport("print")) { ?>
<?php
if ($tblNilaiPerMhs_list->DbMasterFilter != "" && $tblNilaiPerMhs->getCurrentMasterTable() == "V_LMHS") {
	if ($tblNilaiPerMhs_list->MasterRecordExists) {
		include_once "V_LMHSmaster.php";
	}
}
?>
<?php
if ($tblNilaiPerMhs_list->DbMasterFilter != "" && $tblNilaiPerMhs->getCurrentMasterTable() == "IM_Mhs") {
	if ($tblNilaiPerMhs_list->MasterRecordExists) {
		include_once "IM_Mhsmaster.php";
	}
}
?>
<?php } ?>
<?php
$tblNilaiPerMhs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblNilaiPerMhs_list->isExport() && !$tblNilaiPerMhs->CurrentAction) { ?>
<form name="ftblNilaiPerMhslistsrch" id="ftblNilaiPerMhslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblNilaiPerMhslistsrch-search-panel" class="<?php echo $tblNilaiPerMhs_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblNilaiPerMhs">
	<div class="ew-extended-search">
<?php

// Render search row
$tblNilaiPerMhs->RowType = ROWTYPE_SEARCH;
$tblNilaiPerMhs->resetAttributes();
$tblNilaiPerMhs_list->renderRow();
?>
<?php if ($tblNilaiPerMhs_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$tblNilaiPerMhs_list->SearchColumnCount++;
		if (($tblNilaiPerMhs_list->SearchColumnCount - 1) % $tblNilaiPerMhs_list->SearchFieldsPerRow == 0) {
			$tblNilaiPerMhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblNilaiPerMhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $tblNilaiPerMhs_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_tblNilaiPerMhs_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblNilaiPerMhs_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($tblNilaiPerMhs_list->SearchColumnCount % $tblNilaiPerMhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Periode->Visible) { // Periode ?>
	<?php
		$tblNilaiPerMhs_list->SearchColumnCount++;
		if (($tblNilaiPerMhs_list->SearchColumnCount - 1) % $tblNilaiPerMhs_list->SearchFieldsPerRow == 0) {
			$tblNilaiPerMhs_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblNilaiPerMhs_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblNilaiPerMhs_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblNilaiPerMhs_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Periode" data-value-separator="<?php echo $tblNilaiPerMhs_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblNilaiPerMhs_list->Periode->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblNilaiPerMhs_list->SearchColumnCount % $tblNilaiPerMhs_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblNilaiPerMhs_list->SearchColumnCount % $tblNilaiPerMhs_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblNilaiPerMhs_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tblNilaiPerMhs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tblNilaiPerMhs_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tblNilaiPerMhs_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tblNilaiPerMhs_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tblNilaiPerMhs_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblNilaiPerMhs_list->showPageHeader(); ?>
<?php
$tblNilaiPerMhs_list->showMessage();
?>
<?php if ($tblNilaiPerMhs_list->TotalRecords > 0 || $tblNilaiPerMhs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblNilaiPerMhs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblNilaiPerMhs">
<form name="ftblNilaiPerMhslist" id="ftblNilaiPerMhslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblNilaiPerMhs">
<?php if ($tblNilaiPerMhs->getCurrentMasterTable() == "V_LMHS" && $tblNilaiPerMhs->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="V_LMHS">
<input type="hidden" name="fk_Nim" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nim->getSessionValue()) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->getCurrentMasterTable() == "IM_Mhs" && $tblNilaiPerMhs->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="IM_Mhs">
<input type="hidden" name="fk_Nim" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nim->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblNilaiPerMhs" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblNilaiPerMhs_list->TotalRecords > 0 || $tblNilaiPerMhs_list->isGridEdit()) { ?>
<table id="tbl_tblNilaiPerMhslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblNilaiPerMhs->RowType = ROWTYPE_HEADER;

// Render list options
$tblNilaiPerMhs_list->renderListOptions();

// Render list options (header, left)
$tblNilaiPerMhs_list->ListOptions->render("header", "left");
?>
<?php if ($tblNilaiPerMhs_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Thn_Akademik" class="tblNilaiPerMhs_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Thn_Akademik) ?>', 1);"><div id="elh_tblNilaiPerMhs_Thn_Akademik" class="tblNilaiPerMhs_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Periode->Visible) { // Periode ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblNilaiPerMhs_list->Periode->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Periode" class="tblNilaiPerMhs_Periode"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblNilaiPerMhs_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Periode) ?>', 1);"><div id="elh_tblNilaiPerMhs_Periode" class="tblNilaiPerMhs_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $tblNilaiPerMhs_list->Kode_MK->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Kode_MK" class="tblNilaiPerMhs_Kode_MK"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $tblNilaiPerMhs_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Kode_MK) ?>', 1);"><div id="elh_tblNilaiPerMhs_Kode_MK" class="tblNilaiPerMhs_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Kode_MK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Kehadiran->Visible) { // Kehadiran ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Kehadiran) == "") { ?>
		<th data-name="Kehadiran" class="<?php echo $tblNilaiPerMhs_list->Kehadiran->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Kehadiran" class="tblNilaiPerMhs_Kehadiran"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Kehadiran->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kehadiran" class="<?php echo $tblNilaiPerMhs_list->Kehadiran->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Kehadiran) ?>', 1);"><div id="elh_tblNilaiPerMhs_Kehadiran" class="tblNilaiPerMhs_Kehadiran">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Kehadiran->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Kehadiran->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Kehadiran->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Tugas->Visible) { // Tugas ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Tugas) == "") { ?>
		<th data-name="Tugas" class="<?php echo $tblNilaiPerMhs_list->Tugas->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Tugas" class="tblNilaiPerMhs_Tugas"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Tugas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tugas" class="<?php echo $tblNilaiPerMhs_list->Tugas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Tugas) ?>', 1);"><div id="elh_tblNilaiPerMhs_Tugas" class="tblNilaiPerMhs_Tugas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Tugas->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Tugas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Tugas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->UTS->Visible) { // UTS ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->UTS) == "") { ?>
		<th data-name="UTS" class="<?php echo $tblNilaiPerMhs_list->UTS->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_UTS" class="tblNilaiPerMhs_UTS"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->UTS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UTS" class="<?php echo $tblNilaiPerMhs_list->UTS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->UTS) ?>', 1);"><div id="elh_tblNilaiPerMhs_UTS" class="tblNilaiPerMhs_UTS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->UTS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->UTS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->UTS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->UAS->Visible) { // UAS ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->UAS) == "") { ?>
		<th data-name="UAS" class="<?php echo $tblNilaiPerMhs_list->UAS->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_UAS" class="tblNilaiPerMhs_UAS"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->UAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UAS" class="<?php echo $tblNilaiPerMhs_list->UAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->UAS) ?>', 1);"><div id="elh_tblNilaiPerMhs_UAS" class="tblNilaiPerMhs_UAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->UAS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->UAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->UAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Jumlah->Visible) { // Jumlah ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Jumlah) == "") { ?>
		<th data-name="Jumlah" class="<?php echo $tblNilaiPerMhs_list->Jumlah->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Jumlah" class="tblNilaiPerMhs_Jumlah"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Jumlah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jumlah" class="<?php echo $tblNilaiPerMhs_list->Jumlah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Jumlah) ?>', 1);"><div id="elh_tblNilaiPerMhs_Jumlah" class="tblNilaiPerMhs_Jumlah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Jumlah->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Jumlah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Jumlah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Nilai->Visible) { // Nilai ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Nilai) == "") { ?>
		<th data-name="Nilai" class="<?php echo $tblNilaiPerMhs_list->Nilai->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Nilai" class="tblNilaiPerMhs_Nilai"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Nilai->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nilai" class="<?php echo $tblNilaiPerMhs_list->Nilai->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Nilai) ?>', 1);"><div id="elh_tblNilaiPerMhs_Nilai" class="tblNilaiPerMhs_Nilai">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Nilai->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Nilai->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Nilai->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->Angka->Visible) { // Angka ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Angka) == "") { ?>
		<th data-name="Angka" class="<?php echo $tblNilaiPerMhs_list->Angka->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_Angka" class="tblNilaiPerMhs_Angka"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Angka->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Angka" class="<?php echo $tblNilaiPerMhs_list->Angka->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->Angka) ?>', 1);"><div id="elh_tblNilaiPerMhs_Angka" class="tblNilaiPerMhs_Angka">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->Angka->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->Angka->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->Angka->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->stat_feeder->Visible) { // stat_feeder ?>
	<?php if ($tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->stat_feeder) == "") { ?>
		<th data-name="stat_feeder" class="<?php echo $tblNilaiPerMhs_list->stat_feeder->headerCellClass() ?>"><div id="elh_tblNilaiPerMhs_stat_feeder" class="tblNilaiPerMhs_stat_feeder"><div class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->stat_feeder->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stat_feeder" class="<?php echo $tblNilaiPerMhs_list->stat_feeder->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilaiPerMhs_list->SortUrl($tblNilaiPerMhs_list->stat_feeder) ?>', 1);"><div id="elh_tblNilaiPerMhs_stat_feeder" class="tblNilaiPerMhs_stat_feeder">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilaiPerMhs_list->stat_feeder->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblNilaiPerMhs_list->stat_feeder->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilaiPerMhs_list->stat_feeder->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblNilaiPerMhs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblNilaiPerMhs_list->ExportAll && $tblNilaiPerMhs_list->isExport()) {
	$tblNilaiPerMhs_list->StopRecord = $tblNilaiPerMhs_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblNilaiPerMhs_list->TotalRecords > $tblNilaiPerMhs_list->StartRecord + $tblNilaiPerMhs_list->DisplayRecords - 1)
		$tblNilaiPerMhs_list->StopRecord = $tblNilaiPerMhs_list->StartRecord + $tblNilaiPerMhs_list->DisplayRecords - 1;
	else
		$tblNilaiPerMhs_list->StopRecord = $tblNilaiPerMhs_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblNilaiPerMhs->isConfirm() || $tblNilaiPerMhs_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblNilaiPerMhs_list->FormKeyCountName) && ($tblNilaiPerMhs_list->isGridAdd() || $tblNilaiPerMhs_list->isGridEdit() || $tblNilaiPerMhs->isConfirm())) {
		$tblNilaiPerMhs_list->KeyCount = $CurrentForm->getValue($tblNilaiPerMhs_list->FormKeyCountName);
		$tblNilaiPerMhs_list->StopRecord = $tblNilaiPerMhs_list->StartRecord + $tblNilaiPerMhs_list->KeyCount - 1;
	}
}
$tblNilaiPerMhs_list->RecordCount = $tblNilaiPerMhs_list->StartRecord - 1;
if ($tblNilaiPerMhs_list->Recordset && !$tblNilaiPerMhs_list->Recordset->EOF) {
	$tblNilaiPerMhs_list->Recordset->moveFirst();
	$selectLimit = $tblNilaiPerMhs_list->UseSelectLimit;
	if (!$selectLimit && $tblNilaiPerMhs_list->StartRecord > 1)
		$tblNilaiPerMhs_list->Recordset->move($tblNilaiPerMhs_list->StartRecord - 1);
} elseif (!$tblNilaiPerMhs->AllowAddDeleteRow && $tblNilaiPerMhs_list->StopRecord == 0) {
	$tblNilaiPerMhs_list->StopRecord = $tblNilaiPerMhs->GridAddRowCount;
}

// Initialize aggregate
$tblNilaiPerMhs->RowType = ROWTYPE_AGGREGATEINIT;
$tblNilaiPerMhs->resetAttributes();
$tblNilaiPerMhs_list->renderRow();
$tblNilaiPerMhs_list->EditRowCount = 0;
if ($tblNilaiPerMhs_list->isEdit())
	$tblNilaiPerMhs_list->RowIndex = 1;
if ($tblNilaiPerMhs_list->isGridAdd())
	$tblNilaiPerMhs_list->RowIndex = 0;
if ($tblNilaiPerMhs_list->isGridEdit())
	$tblNilaiPerMhs_list->RowIndex = 0;
while ($tblNilaiPerMhs_list->RecordCount < $tblNilaiPerMhs_list->StopRecord) {
	$tblNilaiPerMhs_list->RecordCount++;
	if ($tblNilaiPerMhs_list->RecordCount >= $tblNilaiPerMhs_list->StartRecord) {
		$tblNilaiPerMhs_list->RowCount++;
		if ($tblNilaiPerMhs_list->isGridAdd() || $tblNilaiPerMhs_list->isGridEdit() || $tblNilaiPerMhs->isConfirm()) {
			$tblNilaiPerMhs_list->RowIndex++;
			$CurrentForm->Index = $tblNilaiPerMhs_list->RowIndex;
			if ($CurrentForm->hasValue($tblNilaiPerMhs_list->FormActionName) && ($tblNilaiPerMhs->isConfirm() || $tblNilaiPerMhs_list->EventCancelled))
				$tblNilaiPerMhs_list->RowAction = strval($CurrentForm->getValue($tblNilaiPerMhs_list->FormActionName));
			elseif ($tblNilaiPerMhs_list->isGridAdd())
				$tblNilaiPerMhs_list->RowAction = "insert";
			else
				$tblNilaiPerMhs_list->RowAction = "";
		}

		// Set up key count
		$tblNilaiPerMhs_list->KeyCount = $tblNilaiPerMhs_list->RowIndex;

		// Init row class and style
		$tblNilaiPerMhs->resetAttributes();
		$tblNilaiPerMhs->CssClass = "";
		if ($tblNilaiPerMhs_list->isGridAdd()) {
			$tblNilaiPerMhs_list->loadRowValues(); // Load default values
		} else {
			$tblNilaiPerMhs_list->loadRowValues($tblNilaiPerMhs_list->Recordset); // Load row values
		}
		$tblNilaiPerMhs->RowType = ROWTYPE_VIEW; // Render view
		if ($tblNilaiPerMhs_list->isGridAdd()) // Grid add
			$tblNilaiPerMhs->RowType = ROWTYPE_ADD; // Render add
		if ($tblNilaiPerMhs_list->isGridAdd() && $tblNilaiPerMhs->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblNilaiPerMhs_list->restoreCurrentRowFormValues($tblNilaiPerMhs_list->RowIndex); // Restore form values
		if ($tblNilaiPerMhs_list->isEdit()) {
			if ($tblNilaiPerMhs_list->checkInlineEditKey() && $tblNilaiPerMhs_list->EditRowCount == 0) { // Inline edit
				$tblNilaiPerMhs->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($tblNilaiPerMhs_list->isGridEdit()) { // Grid edit
			if ($tblNilaiPerMhs->EventCancelled)
				$tblNilaiPerMhs_list->restoreCurrentRowFormValues($tblNilaiPerMhs_list->RowIndex); // Restore form values
			if ($tblNilaiPerMhs_list->RowAction == "insert")
				$tblNilaiPerMhs->RowType = ROWTYPE_ADD; // Render add
			else
				$tblNilaiPerMhs->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblNilaiPerMhs_list->isEdit() && $tblNilaiPerMhs->RowType == ROWTYPE_EDIT && $tblNilaiPerMhs->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$tblNilaiPerMhs_list->restoreFormValues(); // Restore form values
		}
		if ($tblNilaiPerMhs_list->isGridEdit() && ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT || $tblNilaiPerMhs->RowType == ROWTYPE_ADD) && $tblNilaiPerMhs->EventCancelled) // Update failed
			$tblNilaiPerMhs_list->restoreCurrentRowFormValues($tblNilaiPerMhs_list->RowIndex); // Restore form values
		if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) // Edit row
			$tblNilaiPerMhs_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblNilaiPerMhs->RowAttrs->merge(["data-rowindex" => $tblNilaiPerMhs_list->RowCount, "id" => "r" . $tblNilaiPerMhs_list->RowCount . "_tblNilaiPerMhs", "data-rowtype" => $tblNilaiPerMhs->RowType]);

		// Render row
		$tblNilaiPerMhs_list->renderRow();

		// Render list options
		$tblNilaiPerMhs_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblNilaiPerMhs_list->RowAction != "delete" && $tblNilaiPerMhs_list->RowAction != "insertdelete" && !($tblNilaiPerMhs_list->RowAction == "insert" && $tblNilaiPerMhs->isConfirm() && $tblNilaiPerMhs_list->emptyRow())) {
?>
	<tr <?php echo $tblNilaiPerMhs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilaiPerMhs_list->ListOptions->render("body", "left", $tblNilaiPerMhs_list->RowCount);
?>
	<?php if ($tblNilaiPerMhs_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblNilaiPerMhs_list->Thn_Akademik->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Thn_Akademik" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik"<?php echo $tblNilaiPerMhs_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Thn_Akademik->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik"<?php echo $tblNilaiPerMhs_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Thn_Akademik->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Thn_Akademik") ?>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Thn_Akademik->OldValue != null ? $tblNilaiPerMhs_list->Thn_Akademik->OldValue : $tblNilaiPerMhs_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Thn_Akademik">
<span<?php echo $tblNilaiPerMhs_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Thn_Akademik->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Nim" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nim->CurrentValue) ?>">
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Nim" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nim->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT || $tblNilaiPerMhs->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Nim" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nim->CurrentValue) ?>">
<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblNilaiPerMhs_list->Periode->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Periode" data-value-separator="<?php echo $tblNilaiPerMhs_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode"<?php echo $tblNilaiPerMhs_list->Periode->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Periode->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Periode" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Periode" data-value-separator="<?php echo $tblNilaiPerMhs_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode"<?php echo $tblNilaiPerMhs_list->Periode->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Periode->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Periode" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Periode->OldValue != null ? $tblNilaiPerMhs_list->Periode->OldValue : $tblNilaiPerMhs_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Periode">
<span<?php echo $tblNilaiPerMhs_list->Periode->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $tblNilaiPerMhs_list->Kode_MK->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Kode_MK" class="form-group">
<?php
$onchange = $tblNilaiPerMhs_list->Kode_MK->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblNilaiPerMhs_list->Kode_MK->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK">
	<input type="text" class="form-control" name="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo RemoveHtml($tblNilaiPerMhs_list->Kode_MK->EditValue) ?>" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>"<?php echo $tblNilaiPerMhs_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" data-value-separator="<?php echo $tblNilaiPerMhs_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblNilaiPerMhslist"], function() {
	ftblNilaiPerMhslist.createAutoSuggest({"id":"x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK","forceSelect":false});
});
</script>
<?php echo $tblNilaiPerMhs_list->Kode_MK->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Kode_MK") ?>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php
$onchange = $tblNilaiPerMhs_list->Kode_MK->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblNilaiPerMhs_list->Kode_MK->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK">
	<input type="text" class="form-control" name="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo RemoveHtml($tblNilaiPerMhs_list->Kode_MK->EditValue) ?>" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>"<?php echo $tblNilaiPerMhs_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" data-value-separator="<?php echo $tblNilaiPerMhs_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblNilaiPerMhslist"], function() {
	ftblNilaiPerMhslist.createAutoSuggest({"id":"x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK","forceSelect":false});
});
</script>
<?php echo $tblNilaiPerMhs_list->Kode_MK->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Kode_MK") ?>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->OldValue != null ? $tblNilaiPerMhs_list->Kode_MK->OldValue : $tblNilaiPerMhs_list->Kode_MK->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Kode_MK">
<span<?php echo $tblNilaiPerMhs_list->Kode_MK->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Kode_MK->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Kehadiran->Visible) { // Kehadiran ?>
		<td data-name="Kehadiran" <?php echo $tblNilaiPerMhs_list->Kehadiran->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Kehadiran" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Kehadiran" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Kehadiran->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Kehadiran->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kehadiran" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kehadiran->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Kehadiran" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Kehadiran" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Kehadiran->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Kehadiran->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Kehadiran">
<span<?php echo $tblNilaiPerMhs_list->Kehadiran->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Kehadiran->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Tugas->Visible) { // Tugas ?>
		<td data-name="Tugas" <?php echo $tblNilaiPerMhs_list->Tugas->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Tugas" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Tugas" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Tugas->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Tugas->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Tugas->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Tugas" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Tugas->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Tugas" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Tugas" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Tugas->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Tugas->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Tugas->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Tugas">
<span<?php echo $tblNilaiPerMhs_list->Tugas->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Tugas->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS" <?php echo $tblNilaiPerMhs_list->UTS->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UTS" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UTS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UTS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UTS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UTS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_UTS" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->UTS->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UTS" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UTS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UTS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UTS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UTS->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UTS">
<span<?php echo $tblNilaiPerMhs_list->UTS->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->UTS->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS" <?php echo $tblNilaiPerMhs_list->UAS->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UAS" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UAS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UAS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UAS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UAS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_UAS" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->UAS->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UAS" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UAS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UAS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UAS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UAS->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_UAS">
<span<?php echo $tblNilaiPerMhs_list->UAS->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->UAS->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Jumlah->Visible) { // Jumlah ?>
		<td data-name="Jumlah" <?php echo $tblNilaiPerMhs_list->Jumlah->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Jumlah" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Jumlah" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Jumlah->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Jumlah->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Jumlah->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Jumlah" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Jumlah->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Jumlah" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Jumlah" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Jumlah->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Jumlah->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Jumlah->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Jumlah">
<span<?php echo $tblNilaiPerMhs_list->Jumlah->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Jumlah->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Nilai->Visible) { // Nilai ?>
		<td data-name="Nilai" <?php echo $tblNilaiPerMhs_list->Nilai->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Nilai" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Nilai" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" size="2" maxlength="2" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nilai->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Nilai->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Nilai->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Nilai" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nilai->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Nilai" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Nilai" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" size="2" maxlength="2" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nilai->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Nilai->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Nilai->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Nilai">
<span<?php echo $tblNilaiPerMhs_list->Nilai->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Nilai->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Angka->Visible) { // Angka ?>
		<td data-name="Angka" <?php echo $tblNilaiPerMhs_list->Angka->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Angka" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Angka" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Angka->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Angka->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Angka->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Angka" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Angka->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Angka" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Angka" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Angka->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Angka->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Angka->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_Angka">
<span<?php echo $tblNilaiPerMhs_list->Angka->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->Angka->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->stat_feeder->Visible) { // stat_feeder ?>
		<td data-name="stat_feeder" <?php echo $tblNilaiPerMhs_list->stat_feeder->cellAttributes() ?>>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_stat_feeder" class="form-group">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_stat_feeder" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->stat_feeder->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->stat_feeder->EditValue ?>"<?php echo $tblNilaiPerMhs_list->stat_feeder->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_stat_feeder" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->stat_feeder->OldValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_stat_feeder" class="form-group">
<span<?php echo $tblNilaiPerMhs_list->stat_feeder->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($tblNilaiPerMhs_list->stat_feeder->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_stat_feeder" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->stat_feeder->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilaiPerMhs_list->RowCount ?>_tblNilaiPerMhs_stat_feeder">
<span<?php echo $tblNilaiPerMhs_list->stat_feeder->viewAttributes() ?>><?php echo $tblNilaiPerMhs_list->stat_feeder->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblNilaiPerMhs_list->ListOptions->render("body", "right", $tblNilaiPerMhs_list->RowCount);
?>
	</tr>
<?php if ($tblNilaiPerMhs->RowType == ROWTYPE_ADD || $tblNilaiPerMhs->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblNilaiPerMhslist", "load"], function() {
	ftblNilaiPerMhslist.updateLists(<?php echo $tblNilaiPerMhs_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblNilaiPerMhs_list->isGridAdd())
		if (!$tblNilaiPerMhs_list->Recordset->EOF)
			$tblNilaiPerMhs_list->Recordset->moveNext();
}
?>
<?php
	if ($tblNilaiPerMhs_list->isGridAdd() || $tblNilaiPerMhs_list->isGridEdit()) {
		$tblNilaiPerMhs_list->RowIndex = '$rowindex$';
		$tblNilaiPerMhs_list->loadRowValues();

		// Set row properties
		$tblNilaiPerMhs->resetAttributes();
		$tblNilaiPerMhs->RowAttrs->merge(["data-rowindex" => $tblNilaiPerMhs_list->RowIndex, "id" => "r0_tblNilaiPerMhs", "data-rowtype" => ROWTYPE_ADD]);
		$tblNilaiPerMhs->RowAttrs->appendClass("ew-template");
		$tblNilaiPerMhs->RowType = ROWTYPE_ADD;

		// Render row
		$tblNilaiPerMhs_list->renderRow();

		// Render list options
		$tblNilaiPerMhs_list->renderListOptions();
		$tblNilaiPerMhs_list->StartRowCount = 0;
?>
	<tr <?php echo $tblNilaiPerMhs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilaiPerMhs_list->ListOptions->render("body", "left", $tblNilaiPerMhs_list->RowIndex);
?>
	<?php if ($tblNilaiPerMhs_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik">
<span id="el$rowindex$_tblNilaiPerMhs_Thn_Akademik" class="form-group tblNilaiPerMhs_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblNilaiPerMhs_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik"<?php echo $tblNilaiPerMhs_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Thn_Akademik->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblNilaiPerMhs_list->Thn_Akademik->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Thn_Akademik" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Thn_Akademik->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode">
<span id="el$rowindex$_tblNilaiPerMhs_Periode" class="form-group tblNilaiPerMhs_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblNilaiPerMhs" data-field="x_Periode" data-value-separator="<?php echo $tblNilaiPerMhs_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode"<?php echo $tblNilaiPerMhs_list->Periode->editAttributes() ?>>
			<?php echo $tblNilaiPerMhs_list->Periode->selectOptionListHtml("x{$tblNilaiPerMhs_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Periode" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Periode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK">
<span id="el$rowindex$_tblNilaiPerMhs_Kode_MK" class="form-group tblNilaiPerMhs_Kode_MK">
<?php
$onchange = $tblNilaiPerMhs_list->Kode_MK->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblNilaiPerMhs_list->Kode_MK->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK">
	<input type="text" class="form-control" name="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="sv_x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo RemoveHtml($tblNilaiPerMhs_list->Kode_MK->EditValue) ?>" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->getPlaceHolder()) ?>"<?php echo $tblNilaiPerMhs_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" data-value-separator="<?php echo $tblNilaiPerMhs_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblNilaiPerMhslist"], function() {
	ftblNilaiPerMhslist.createAutoSuggest({"id":"x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK","forceSelect":false});
});
</script>
<?php echo $tblNilaiPerMhs_list->Kode_MK->Lookup->getParamTag($tblNilaiPerMhs_list, "p_x" . $tblNilaiPerMhs_list->RowIndex . "_Kode_MK") ?>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kode_MK" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kode_MK->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Kehadiran->Visible) { // Kehadiran ?>
		<td data-name="Kehadiran">
<span id="el$rowindex$_tblNilaiPerMhs_Kehadiran" class="form-group tblNilaiPerMhs_Kehadiran">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Kehadiran" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kehadiran->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Kehadiran->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Kehadiran->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Kehadiran" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Kehadiran" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Kehadiran->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Tugas->Visible) { // Tugas ?>
		<td data-name="Tugas">
<span id="el$rowindex$_tblNilaiPerMhs_Tugas" class="form-group tblNilaiPerMhs_Tugas">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Tugas" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Tugas->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Tugas->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Tugas->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Tugas" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Tugas" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Tugas->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS">
<span id="el$rowindex$_tblNilaiPerMhs_UTS" class="form-group tblNilaiPerMhs_UTS">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UTS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UTS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UTS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UTS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_UTS" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UTS" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->UTS->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS">
<span id="el$rowindex$_tblNilaiPerMhs_UAS" class="form-group tblNilaiPerMhs_UAS">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_UAS" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->UAS->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->UAS->EditValue ?>"<?php echo $tblNilaiPerMhs_list->UAS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_UAS" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_UAS" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->UAS->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Jumlah->Visible) { // Jumlah ?>
		<td data-name="Jumlah">
<span id="el$rowindex$_tblNilaiPerMhs_Jumlah" class="form-group tblNilaiPerMhs_Jumlah">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Jumlah" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Jumlah->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Jumlah->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Jumlah->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Jumlah" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Jumlah" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Jumlah->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Nilai->Visible) { // Nilai ?>
		<td data-name="Nilai">
<span id="el$rowindex$_tblNilaiPerMhs_Nilai" class="form-group tblNilaiPerMhs_Nilai">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Nilai" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" size="2" maxlength="2" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nilai->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Nilai->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Nilai->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Nilai" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Nilai" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Nilai->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->Angka->Visible) { // Angka ?>
		<td data-name="Angka">
<span id="el$rowindex$_tblNilaiPerMhs_Angka" class="form-group tblNilaiPerMhs_Angka">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_Angka" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" size="2" maxlength="8" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->Angka->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->Angka->EditValue ?>"<?php echo $tblNilaiPerMhs_list->Angka->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_Angka" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_Angka" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->Angka->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilaiPerMhs_list->stat_feeder->Visible) { // stat_feeder ?>
		<td data-name="stat_feeder">
<span id="el$rowindex$_tblNilaiPerMhs_stat_feeder" class="form-group tblNilaiPerMhs_stat_feeder">
<input type="text" data-table="tblNilaiPerMhs" data-field="x_stat_feeder" name="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" id="x<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($tblNilaiPerMhs_list->stat_feeder->getPlaceHolder()) ?>" value="<?php echo $tblNilaiPerMhs_list->stat_feeder->EditValue ?>"<?php echo $tblNilaiPerMhs_list->stat_feeder->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilaiPerMhs" data-field="x_stat_feeder" name="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" id="o<?php echo $tblNilaiPerMhs_list->RowIndex ?>_stat_feeder" value="<?php echo HtmlEncode($tblNilaiPerMhs_list->stat_feeder->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblNilaiPerMhs_list->ListOptions->render("body", "right", $tblNilaiPerMhs_list->RowIndex);
?>
<script>
loadjs.ready(["ftblNilaiPerMhslist", "load"], function() {
	ftblNilaiPerMhslist.updateLists(<?php echo $tblNilaiPerMhs_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblNilaiPerMhs_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" id="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" value="<?php echo $tblNilaiPerMhs_list->KeyCount ?>">
<?php echo $tblNilaiPerMhs_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblNilaiPerMhs_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" id="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" value="<?php echo $tblNilaiPerMhs_list->KeyCount ?>">
<?php } ?>
<?php if ($tblNilaiPerMhs_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" id="<?php echo $tblNilaiPerMhs_list->FormKeyCountName ?>" value="<?php echo $tblNilaiPerMhs_list->KeyCount ?>">
<?php echo $tblNilaiPerMhs_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblNilaiPerMhs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblNilaiPerMhs_list->Recordset)
	$tblNilaiPerMhs_list->Recordset->Close();
?>
<?php if (!$tblNilaiPerMhs_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblNilaiPerMhs_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblNilaiPerMhs_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblNilaiPerMhs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblNilaiPerMhs_list->TotalRecords == 0 && !$tblNilaiPerMhs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblNilaiPerMhs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblNilaiPerMhs_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblNilaiPerMhs_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblNilaiPerMhs_list->terminate();
?>