<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblNilai_add = new tblNilai_add();

// Run the page
$tblNilai_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblNilai_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftblNilaiadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	ftblNilaiadd = currentForm = new ew.Form("ftblNilaiadd", "add");

	// Validate form
	ftblNilaiadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tblNilai_add->Kode_MK->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_MK");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilai_add->Kode_MK->caption(), $tblNilai_add->Kode_MK->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftblNilaiadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblNilaiadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("ftblNilaiadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $tblNilai_add->showPageHeader(); ?>
<?php
$tblNilai_add->showMessage();
?>
<form name="ftblNilaiadd" id="ftblNilaiadd" class="<?php echo $tblNilai_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblNilai">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$tblNilai_add->IsModal ?>">
<?php if ($tblNilai->getCurrentMasterTable() == "Perwalian") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="Perwalian">
<input type="hidden" name="fk_Nim" value="<?php echo HtmlEncode($tblNilai_add->Nim->getSessionValue()) ?>">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($tblNilai_add->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($tblNilai_add->Periode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($tblNilai_add->Kode_MK->Visible) { // Kode_MK ?>
	<div id="r_Kode_MK" class="form-group row">
		<label id="elh_tblNilai_Kode_MK" for="x_Kode_MK" class="<?php echo $tblNilai_add->LeftColumnClass ?>"><?php echo $tblNilai_add->Kode_MK->caption() ?><?php echo $tblNilai_add->Kode_MK->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblNilai_add->RightColumnClass ?>"><div <?php echo $tblNilai_add->Kode_MK->cellAttributes() ?>>
<span id="el_tblNilai_Kode_MK">
<input type="text" data-table="tblNilai" data-field="x_Kode_MK" name="x_Kode_MK" id="x_Kode_MK" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($tblNilai_add->Kode_MK->getPlaceHolder()) ?>" value="<?php echo $tblNilai_add->Kode_MK->EditValue ?>"<?php echo $tblNilai_add->Kode_MK->editAttributes() ?>>
</span>
<?php echo $tblNilai_add->Kode_MK->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<?php if (strval($tblNilai_add->Nim->getSessionValue()) != "") { ?>
	<input type="hidden" name="x_Nim" id="x_Nim" value="<?php echo HtmlEncode(strval($tblNilai_add->Nim->getSessionValue())) ?>">
	<?php } ?>
	<?php if (strval($tblNilai_add->Thn_Akademik->getSessionValue()) != "") { ?>
	<input type="hidden" name="x_Thn_Akademik" id="x_Thn_Akademik" value="<?php echo HtmlEncode(strval($tblNilai_add->Thn_Akademik->getSessionValue())) ?>">
	<?php } ?>
	<?php if (strval($tblNilai_add->Periode->getSessionValue()) != "") { ?>
	<input type="hidden" name="x_Periode" id="x_Periode" value="<?php echo HtmlEncode(strval($tblNilai_add->Periode->getSessionValue())) ?>">
	<?php } ?>
<?php if (!$tblNilai_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tblNilai_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tblNilai_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tblNilai_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$tblNilai_add->terminate();
?>