<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblNilai_list = new tblNilai_list();

// Run the page
$tblNilai_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblNilai_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblNilai_list->isExport()) { ?>
<script>
var ftblNilailist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblNilailist = currentForm = new ew.Form("ftblNilailist", "list");
	ftblNilailist.formKeyCountName = '<?php echo $tblNilai_list->FormKeyCountName ?>';

	// Validate form
	ftblNilailist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblNilai_list->Kode_MK->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_MK");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilai_list->Kode_MK->caption(), $tblNilai_list->Kode_MK->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblNilai_list->SKS->Required) { ?>
				elm = this.getElements("x" + infix + "_SKS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilai_list->SKS->caption(), $tblNilai_list->SKS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SKS");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblNilai_list->SKS->errorMessage()) ?>");
			<?php if ($tblNilai_list->kls->Required) { ?>
				elm = this.getElements("x" + infix + "_kls");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblNilai_list->kls->caption(), $tblNilai_list->kls->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblNilailist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Kode_MK", false)) return false;
		if (ew.valueChanged(fobj, infix, "SKS", false)) return false;
		if (ew.valueChanged(fobj, infix, "kls", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblNilailist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblNilailist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblNilailist.lists["x_Kode_MK"] = <?php echo $tblNilai_list->Kode_MK->Lookup->toClientList($tblNilai_list) ?>;
	ftblNilailist.lists["x_Kode_MK"].options = <?php echo JsonEncode($tblNilai_list->Kode_MK->lookupOptions()) ?>;
	loadjs.done("ftblNilailist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblNilai_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblNilai_list->TotalRecords > 0 && $tblNilai_list->ExportOptions->visible()) { ?>
<?php $tblNilai_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblNilai_list->ImportOptions->visible()) { ?>
<?php $tblNilai_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblNilai_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblNilai_list->isExport("print")) { ?>
<?php
if ($tblNilai_list->DbMasterFilter != "" && $tblNilai->getCurrentMasterTable() == "Perwalian") {
	if ($tblNilai_list->MasterRecordExists) {
		include_once "Perwalianmaster.php";
	}
}
?>
<?php } ?>
<?php
$tblNilai_list->renderOtherOptions();
?>
<?php $tblNilai_list->showPageHeader(); ?>
<?php
$tblNilai_list->showMessage();
?>
<?php if ($tblNilai_list->TotalRecords > 0 || $tblNilai->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblNilai_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblNilai">
<form name="ftblNilailist" id="ftblNilailist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblNilai">
<?php if ($tblNilai->getCurrentMasterTable() == "Perwalian" && $tblNilai->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="Perwalian">
<input type="hidden" name="fk_Nim" value="<?php echo HtmlEncode($tblNilai_list->Nim->getSessionValue()) ?>">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($tblNilai_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($tblNilai_list->Periode->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblNilai" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblNilai_list->TotalRecords > 0 || $tblNilai_list->isAdd() || $tblNilai_list->isCopy() || $tblNilai_list->isGridEdit()) { ?>
<table id="tbl_tblNilailist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblNilai->RowType = ROWTYPE_HEADER;

// Render list options
$tblNilai_list->renderListOptions();

// Render list options (header, left)
$tblNilai_list->ListOptions->render("header", "left");
?>
<?php if ($tblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($tblNilai_list->SortUrl($tblNilai_list->Kode_MK) == "") { ?>
		<th data-name="Kode_MK" class="<?php echo $tblNilai_list->Kode_MK->headerCellClass() ?>"><div id="elh_tblNilai_Kode_MK" class="tblNilai_Kode_MK"><div class="ew-table-header-caption"><?php echo $tblNilai_list->Kode_MK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_MK" class="<?php echo $tblNilai_list->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilai_list->SortUrl($tblNilai_list->Kode_MK) ?>', 1);"><div id="elh_tblNilai_Kode_MK" class="tblNilai_Kode_MK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_list->Kode_MK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_list->Kode_MK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_list->Kode_MK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilai_list->SKS->Visible) { // SKS ?>
	<?php if ($tblNilai_list->SortUrl($tblNilai_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $tblNilai_list->SKS->headerCellClass() ?>"><div id="elh_tblNilai_SKS" class="tblNilai_SKS"><div class="ew-table-header-caption"><?php echo $tblNilai_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $tblNilai_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilai_list->SortUrl($tblNilai_list->SKS) ?>', 1);"><div id="elh_tblNilai_SKS" class="tblNilai_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilai_list->kls->Visible) { // kls ?>
	<?php if ($tblNilai_list->SortUrl($tblNilai_list->kls) == "") { ?>
		<th data-name="kls" class="<?php echo $tblNilai_list->kls->headerCellClass() ?>"><div id="elh_tblNilai_kls" class="tblNilai_kls"><div class="ew-table-header-caption"><?php echo $tblNilai_list->kls->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kls" class="<?php echo $tblNilai_list->kls->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblNilai_list->SortUrl($tblNilai_list->kls) ?>', 1);"><div id="elh_tblNilai_kls" class="tblNilai_kls">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_list->kls->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_list->kls->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_list->kls->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblNilai_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
	if ($tblNilai_list->isAdd() || $tblNilai_list->isCopy()) {
		$tblNilai_list->RowIndex = 0;
		$tblNilai_list->KeyCount = $tblNilai_list->RowIndex;
		if ($tblNilai_list->isAdd())
			$tblNilai_list->loadRowValues();
		if ($tblNilai->EventCancelled) // Insert failed
			$tblNilai_list->restoreFormValues(); // Restore form values

		// Set row properties
		$tblNilai->resetAttributes();
		$tblNilai->RowAttrs->merge(["data-rowindex" => 0, "id" => "r0_tblNilai", "data-rowtype" => ROWTYPE_ADD]);
		$tblNilai->RowType = ROWTYPE_ADD;

		// Render row
		$tblNilai_list->renderRow();

		// Render list options
		$tblNilai_list->renderListOptions();
		$tblNilai_list->StartRowCount = 0;
?>
	<tr <?php echo $tblNilai->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilai_list->ListOptions->render("body", "left", $tblNilai_list->RowCount);
?>
	<?php if ($tblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK">
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_Kode_MK" class="form-group tblNilai_Kode_MK">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK"><?php echo EmptyValue(strval($tblNilai_list->Kode_MK->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblNilai_list->Kode_MK->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblNilai_list->Kode_MK->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblNilai_list->Kode_MK->ReadOnly || $tblNilai_list->Kode_MK->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblNilai_list->Kode_MK->Lookup->getParamTag($tblNilai_list, "p_x" . $tblNilai_list->RowIndex . "_Kode_MK") ?>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblNilai_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo $tblNilai_list->Kode_MK->CurrentValue ?>"<?php echo $tblNilai_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" name="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilai_list->Kode_MK->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilai_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS">
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_SKS" class="form-group tblNilai_SKS">
<input type="text" data-table="tblNilai" data-field="x_SKS" name="x<?php echo $tblNilai_list->RowIndex ?>_SKS" id="x<?php echo $tblNilai_list->RowIndex ?>_SKS" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->SKS->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->SKS->EditValue ?>"<?php echo $tblNilai_list->SKS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_SKS" name="o<?php echo $tblNilai_list->RowIndex ?>_SKS" id="o<?php echo $tblNilai_list->RowIndex ?>_SKS" value="<?php echo HtmlEncode($tblNilai_list->SKS->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilai_list->kls->Visible) { // kls ?>
		<td data-name="kls">
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_kls" class="form-group tblNilai_kls">
<input type="text" data-table="tblNilai" data-field="x_kls" name="x<?php echo $tblNilai_list->RowIndex ?>_kls" id="x<?php echo $tblNilai_list->RowIndex ?>_kls" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->kls->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->kls->EditValue ?>"<?php echo $tblNilai_list->kls->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_kls" name="o<?php echo $tblNilai_list->RowIndex ?>_kls" id="o<?php echo $tblNilai_list->RowIndex ?>_kls" value="<?php echo HtmlEncode($tblNilai_list->kls->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblNilai_list->ListOptions->render("body", "right", $tblNilai_list->RowCount);
?>
<script>
loadjs.ready(["ftblNilailist", "load"], function() {
	ftblNilailist.updateLists(<?php echo $tblNilai_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
<?php
if ($tblNilai_list->ExportAll && $tblNilai_list->isExport()) {
	$tblNilai_list->StopRecord = $tblNilai_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblNilai_list->TotalRecords > $tblNilai_list->StartRecord + $tblNilai_list->DisplayRecords - 1)
		$tblNilai_list->StopRecord = $tblNilai_list->StartRecord + $tblNilai_list->DisplayRecords - 1;
	else
		$tblNilai_list->StopRecord = $tblNilai_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblNilai->isConfirm() || $tblNilai_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblNilai_list->FormKeyCountName) && ($tblNilai_list->isGridAdd() || $tblNilai_list->isGridEdit() || $tblNilai->isConfirm())) {
		$tblNilai_list->KeyCount = $CurrentForm->getValue($tblNilai_list->FormKeyCountName);
		$tblNilai_list->StopRecord = $tblNilai_list->StartRecord + $tblNilai_list->KeyCount - 1;
	}
}
$tblNilai_list->RecordCount = $tblNilai_list->StartRecord - 1;
if ($tblNilai_list->Recordset && !$tblNilai_list->Recordset->EOF) {
	$tblNilai_list->Recordset->moveFirst();
	$selectLimit = $tblNilai_list->UseSelectLimit;
	if (!$selectLimit && $tblNilai_list->StartRecord > 1)
		$tblNilai_list->Recordset->move($tblNilai_list->StartRecord - 1);
} elseif (!$tblNilai->AllowAddDeleteRow && $tblNilai_list->StopRecord == 0) {
	$tblNilai_list->StopRecord = $tblNilai->GridAddRowCount;
}

// Initialize aggregate
$tblNilai->RowType = ROWTYPE_AGGREGATEINIT;
$tblNilai->resetAttributes();
$tblNilai_list->renderRow();
$tblNilai_list->EditRowCount = 0;
if ($tblNilai_list->isEdit())
	$tblNilai_list->RowIndex = 1;
if ($tblNilai_list->isGridAdd())
	$tblNilai_list->RowIndex = 0;
while ($tblNilai_list->RecordCount < $tblNilai_list->StopRecord) {
	$tblNilai_list->RecordCount++;
	if ($tblNilai_list->RecordCount >= $tblNilai_list->StartRecord) {
		$tblNilai_list->RowCount++;
		if ($tblNilai_list->isGridAdd() || $tblNilai_list->isGridEdit() || $tblNilai->isConfirm()) {
			$tblNilai_list->RowIndex++;
			$CurrentForm->Index = $tblNilai_list->RowIndex;
			if ($CurrentForm->hasValue($tblNilai_list->FormActionName) && ($tblNilai->isConfirm() || $tblNilai_list->EventCancelled))
				$tblNilai_list->RowAction = strval($CurrentForm->getValue($tblNilai_list->FormActionName));
			elseif ($tblNilai_list->isGridAdd())
				$tblNilai_list->RowAction = "insert";
			else
				$tblNilai_list->RowAction = "";
		}

		// Set up key count
		$tblNilai_list->KeyCount = $tblNilai_list->RowIndex;

		// Init row class and style
		$tblNilai->resetAttributes();
		$tblNilai->CssClass = "";
		if ($tblNilai_list->isGridAdd()) {
			$tblNilai_list->loadRowValues(); // Load default values
		} else {
			$tblNilai_list->loadRowValues($tblNilai_list->Recordset); // Load row values
		}
		$tblNilai->RowType = ROWTYPE_VIEW; // Render view
		if ($tblNilai_list->isGridAdd()) // Grid add
			$tblNilai->RowType = ROWTYPE_ADD; // Render add
		if ($tblNilai_list->isGridAdd() && $tblNilai->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblNilai_list->restoreCurrentRowFormValues($tblNilai_list->RowIndex); // Restore form values
		if ($tblNilai_list->isEdit()) {
			if ($tblNilai_list->checkInlineEditKey() && $tblNilai_list->EditRowCount == 0) { // Inline edit
				$tblNilai->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($tblNilai_list->isEdit() && $tblNilai->RowType == ROWTYPE_EDIT && $tblNilai->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$tblNilai_list->restoreFormValues(); // Restore form values
		}
		if ($tblNilai->RowType == ROWTYPE_EDIT) // Edit row
			$tblNilai_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblNilai->RowAttrs->merge(["data-rowindex" => $tblNilai_list->RowCount, "id" => "r" . $tblNilai_list->RowCount . "_tblNilai", "data-rowtype" => $tblNilai->RowType]);

		// Render row
		$tblNilai_list->renderRow();

		// Render list options
		$tblNilai_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblNilai_list->RowAction != "delete" && $tblNilai_list->RowAction != "insertdelete" && !($tblNilai_list->RowAction == "insert" && $tblNilai->isConfirm() && $tblNilai_list->emptyRow())) {
?>
	<tr <?php echo $tblNilai->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilai_list->ListOptions->render("body", "left", $tblNilai_list->RowCount);
?>
	<?php if ($tblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" <?php echo $tblNilai_list->Kode_MK->cellAttributes() ?>>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_Kode_MK" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK"><?php echo EmptyValue(strval($tblNilai_list->Kode_MK->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblNilai_list->Kode_MK->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblNilai_list->Kode_MK->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblNilai_list->Kode_MK->ReadOnly || $tblNilai_list->Kode_MK->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblNilai_list->Kode_MK->Lookup->getParamTag($tblNilai_list, "p_x" . $tblNilai_list->RowIndex . "_Kode_MK") ?>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblNilai_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo $tblNilai_list->Kode_MK->CurrentValue ?>"<?php echo $tblNilai_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" name="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilai_list->Kode_MK->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK"><?php echo EmptyValue(strval($tblNilai_list->Kode_MK->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblNilai_list->Kode_MK->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblNilai_list->Kode_MK->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblNilai_list->Kode_MK->ReadOnly || $tblNilai_list->Kode_MK->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblNilai_list->Kode_MK->Lookup->getParamTag($tblNilai_list, "p_x" . $tblNilai_list->RowIndex . "_Kode_MK") ?>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblNilai_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo $tblNilai_list->Kode_MK->CurrentValue ?>"<?php echo $tblNilai_list->Kode_MK->editAttributes() ?>>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" name="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilai_list->Kode_MK->OldValue != null ? $tblNilai_list->Kode_MK->OldValue : $tblNilai_list->Kode_MK->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_Kode_MK">
<span<?php echo $tblNilai_list->Kode_MK->viewAttributes() ?>><?php echo $tblNilai_list->Kode_MK->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblNilai" data-field="x_Nim" name="x<?php echo $tblNilai_list->RowIndex ?>_Nim" id="x<?php echo $tblNilai_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilai_list->Nim->CurrentValue) ?>">
<input type="hidden" data-table="tblNilai" data-field="x_Nim" name="o<?php echo $tblNilai_list->RowIndex ?>_Nim" id="o<?php echo $tblNilai_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilai_list->Nim->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT || $tblNilai->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblNilai" data-field="x_Nim" name="x<?php echo $tblNilai_list->RowIndex ?>_Nim" id="x<?php echo $tblNilai_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblNilai_list->Nim->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblNilai" data-field="x_Thn_Akademik" name="x<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" id="x<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilai_list->Thn_Akademik->CurrentValue) ?>">
<input type="hidden" data-table="tblNilai" data-field="x_Thn_Akademik" name="o<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilai_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT || $tblNilai->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblNilai" data-field="x_Thn_Akademik" name="x<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" id="x<?php echo $tblNilai_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblNilai_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblNilai" data-field="x_Periode" name="x<?php echo $tblNilai_list->RowIndex ?>_Periode" id="x<?php echo $tblNilai_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilai_list->Periode->CurrentValue) ?>">
<input type="hidden" data-table="tblNilai" data-field="x_Periode" name="o<?php echo $tblNilai_list->RowIndex ?>_Periode" id="o<?php echo $tblNilai_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilai_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT || $tblNilai->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblNilai" data-field="x_Periode" name="x<?php echo $tblNilai_list->RowIndex ?>_Periode" id="x<?php echo $tblNilai_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblNilai_list->Periode->CurrentValue) ?>">
<?php } ?>
	<?php if ($tblNilai_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $tblNilai_list->SKS->cellAttributes() ?>>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_SKS" class="form-group">
<input type="text" data-table="tblNilai" data-field="x_SKS" name="x<?php echo $tblNilai_list->RowIndex ?>_SKS" id="x<?php echo $tblNilai_list->RowIndex ?>_SKS" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->SKS->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->SKS->EditValue ?>"<?php echo $tblNilai_list->SKS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_SKS" name="o<?php echo $tblNilai_list->RowIndex ?>_SKS" id="o<?php echo $tblNilai_list->RowIndex ?>_SKS" value="<?php echo HtmlEncode($tblNilai_list->SKS->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_SKS" class="form-group">
<input type="text" data-table="tblNilai" data-field="x_SKS" name="x<?php echo $tblNilai_list->RowIndex ?>_SKS" id="x<?php echo $tblNilai_list->RowIndex ?>_SKS" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->SKS->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->SKS->EditValue ?>"<?php echo $tblNilai_list->SKS->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_SKS">
<span<?php echo $tblNilai_list->SKS->viewAttributes() ?>><?php echo $tblNilai_list->SKS->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblNilai_list->kls->Visible) { // kls ?>
		<td data-name="kls" <?php echo $tblNilai_list->kls->cellAttributes() ?>>
<?php if ($tblNilai->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_kls" class="form-group">
<input type="text" data-table="tblNilai" data-field="x_kls" name="x<?php echo $tblNilai_list->RowIndex ?>_kls" id="x<?php echo $tblNilai_list->RowIndex ?>_kls" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->kls->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->kls->EditValue ?>"<?php echo $tblNilai_list->kls->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_kls" name="o<?php echo $tblNilai_list->RowIndex ?>_kls" id="o<?php echo $tblNilai_list->RowIndex ?>_kls" value="<?php echo HtmlEncode($tblNilai_list->kls->OldValue) ?>">
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_kls" class="form-group">
<input type="text" data-table="tblNilai" data-field="x_kls" name="x<?php echo $tblNilai_list->RowIndex ?>_kls" id="x<?php echo $tblNilai_list->RowIndex ?>_kls" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->kls->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->kls->EditValue ?>"<?php echo $tblNilai_list->kls->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblNilai->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblNilai_list->RowCount ?>_tblNilai_kls">
<span<?php echo $tblNilai_list->kls->viewAttributes() ?>><?php echo $tblNilai_list->kls->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblNilai_list->ListOptions->render("body", "right", $tblNilai_list->RowCount);
?>
	</tr>
<?php if ($tblNilai->RowType == ROWTYPE_ADD || $tblNilai->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblNilailist", "load"], function() {
	ftblNilailist.updateLists(<?php echo $tblNilai_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblNilai_list->isGridAdd())
		if (!$tblNilai_list->Recordset->EOF)
			$tblNilai_list->Recordset->moveNext();
}
?>
<?php
	if ($tblNilai_list->isGridAdd() || $tblNilai_list->isGridEdit()) {
		$tblNilai_list->RowIndex = '$rowindex$';
		$tblNilai_list->loadRowValues();

		// Set row properties
		$tblNilai->resetAttributes();
		$tblNilai->RowAttrs->merge(["data-rowindex" => $tblNilai_list->RowIndex, "id" => "r0_tblNilai", "data-rowtype" => ROWTYPE_ADD]);
		$tblNilai->RowAttrs->appendClass("ew-template");
		$tblNilai->RowType = ROWTYPE_ADD;

		// Render row
		$tblNilai_list->renderRow();

		// Render list options
		$tblNilai_list->renderListOptions();
		$tblNilai_list->StartRowCount = 0;
?>
	<tr <?php echo $tblNilai->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilai_list->ListOptions->render("body", "left", $tblNilai_list->RowIndex);
?>
	<?php if ($tblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK">
<span id="el$rowindex$_tblNilai_Kode_MK" class="form-group tblNilai_Kode_MK">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK"><?php echo EmptyValue(strval($tblNilai_list->Kode_MK->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblNilai_list->Kode_MK->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblNilai_list->Kode_MK->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblNilai_list->Kode_MK->ReadOnly || $tblNilai_list->Kode_MK->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblNilai_list->Kode_MK->Lookup->getParamTag($tblNilai_list, "p_x" . $tblNilai_list->RowIndex . "_Kode_MK") ?>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblNilai_list->Kode_MK->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo $tblNilai_list->Kode_MK->CurrentValue ?>"<?php echo $tblNilai_list->Kode_MK->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_Kode_MK" name="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblNilai_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblNilai_list->Kode_MK->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilai_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS">
<span id="el$rowindex$_tblNilai_SKS" class="form-group tblNilai_SKS">
<input type="text" data-table="tblNilai" data-field="x_SKS" name="x<?php echo $tblNilai_list->RowIndex ?>_SKS" id="x<?php echo $tblNilai_list->RowIndex ?>_SKS" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->SKS->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->SKS->EditValue ?>"<?php echo $tblNilai_list->SKS->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_SKS" name="o<?php echo $tblNilai_list->RowIndex ?>_SKS" id="o<?php echo $tblNilai_list->RowIndex ?>_SKS" value="<?php echo HtmlEncode($tblNilai_list->SKS->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblNilai_list->kls->Visible) { // kls ?>
		<td data-name="kls">
<span id="el$rowindex$_tblNilai_kls" class="form-group tblNilai_kls">
<input type="text" data-table="tblNilai" data-field="x_kls" name="x<?php echo $tblNilai_list->RowIndex ?>_kls" id="x<?php echo $tblNilai_list->RowIndex ?>_kls" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblNilai_list->kls->getPlaceHolder()) ?>" value="<?php echo $tblNilai_list->kls->EditValue ?>"<?php echo $tblNilai_list->kls->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblNilai" data-field="x_kls" name="o<?php echo $tblNilai_list->RowIndex ?>_kls" id="o<?php echo $tblNilai_list->RowIndex ?>_kls" value="<?php echo HtmlEncode($tblNilai_list->kls->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblNilai_list->ListOptions->render("body", "right", $tblNilai_list->RowIndex);
?>
<script>
loadjs.ready(["ftblNilailist", "load"], function() {
	ftblNilailist.updateLists(<?php echo $tblNilai_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
<?php

// Render aggregate row
$tblNilai->RowType = ROWTYPE_AGGREGATE;
$tblNilai->resetAttributes();
$tblNilai_list->renderRow();
?>
<?php if ($tblNilai_list->TotalRecords > 0 && !$tblNilai_list->isGridAdd() && !$tblNilai_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$tblNilai_list->renderListOptions();

// Render list options (footer, left)
$tblNilai_list->ListOptions->render("footer", "left");
?>
	<?php if ($tblNilai_list->Kode_MK->Visible) { // Kode_MK ?>
		<td data-name="Kode_MK" class="<?php echo $tblNilai_list->Kode_MK->footerCellClass() ?>"><span id="elf_tblNilai_Kode_MK" class="tblNilai_Kode_MK">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($tblNilai_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" class="<?php echo $tblNilai_list->SKS->footerCellClass() ?>"><span id="elf_tblNilai_SKS" class="tblNilai_SKS">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $tblNilai_list->SKS->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($tblNilai_list->kls->Visible) { // kls ?>
		<td data-name="kls" class="<?php echo $tblNilai_list->kls->footerCellClass() ?>"><span id="elf_tblNilai_kls" class="tblNilai_kls">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$tblNilai_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblNilai_list->isAdd() || $tblNilai_list->isCopy()) { ?>
<input type="hidden" name="<?php echo $tblNilai_list->FormKeyCountName ?>" id="<?php echo $tblNilai_list->FormKeyCountName ?>" value="<?php echo $tblNilai_list->KeyCount ?>">
<?php } ?>
<?php if ($tblNilai_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblNilai_list->FormKeyCountName ?>" id="<?php echo $tblNilai_list->FormKeyCountName ?>" value="<?php echo $tblNilai_list->KeyCount ?>">
<?php echo $tblNilai_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblNilai_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $tblNilai_list->FormKeyCountName ?>" id="<?php echo $tblNilai_list->FormKeyCountName ?>" value="<?php echo $tblNilai_list->KeyCount ?>">
<?php } ?>
<?php if (!$tblNilai->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblNilai_list->Recordset)
	$tblNilai_list->Recordset->Close();
?>
<?php if (!$tblNilai_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblNilai_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblNilai_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblNilai_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblNilai_list->TotalRecords == 0 && !$tblNilai->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblNilai_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblNilai_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblNilai_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblNilai_list->terminate();
?>