<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$tblNilai_preview = new tblNilai_preview();

// Run the page
$tblNilai_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblNilai_preview->Page_Render();
?>
<?php $tblNilai_preview->showPageHeader(); ?>
<?php if ($tblNilai_preview->TotalRecords > 0) { ?>
<div class="card ew-grid tblNilai"><!-- .card -->
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel ew-preview-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$tblNilai_preview->renderListOptions();

// Render list options (header, left)
$tblNilai_preview->ListOptions->render("header", "left");
?>
<?php if ($tblNilai_preview->Kode_MK->Visible) { // Kode_MK ?>
	<?php if ($tblNilai->SortUrl($tblNilai_preview->Kode_MK) == "") { ?>
		<th class="<?php echo $tblNilai_preview->Kode_MK->headerCellClass() ?>"><?php echo $tblNilai_preview->Kode_MK->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $tblNilai_preview->Kode_MK->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($tblNilai_preview->Kode_MK->Name) ?>" data-sort-order="<?php echo $tblNilai_preview->SortField == $tblNilai_preview->Kode_MK->Name && $tblNilai_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_preview->Kode_MK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_preview->SortField == $tblNilai_preview->Kode_MK->Name) { ?><?php if ($tblNilai_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilai_preview->SKS->Visible) { // SKS ?>
	<?php if ($tblNilai->SortUrl($tblNilai_preview->SKS) == "") { ?>
		<th class="<?php echo $tblNilai_preview->SKS->headerCellClass() ?>"><?php echo $tblNilai_preview->SKS->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $tblNilai_preview->SKS->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($tblNilai_preview->SKS->Name) ?>" data-sort-order="<?php echo $tblNilai_preview->SortField == $tblNilai_preview->SKS->Name && $tblNilai_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_preview->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_preview->SortField == $tblNilai_preview->SKS->Name) { ?><?php if ($tblNilai_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblNilai_preview->kls->Visible) { // kls ?>
	<?php if ($tblNilai->SortUrl($tblNilai_preview->kls) == "") { ?>
		<th class="<?php echo $tblNilai_preview->kls->headerCellClass() ?>"><?php echo $tblNilai_preview->kls->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $tblNilai_preview->kls->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($tblNilai_preview->kls->Name) ?>" data-sort-order="<?php echo $tblNilai_preview->SortField == $tblNilai_preview->kls->Name && $tblNilai_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblNilai_preview->kls->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblNilai_preview->SortField == $tblNilai_preview->kls->Name) { ?><?php if ($tblNilai_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblNilai_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblNilai_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$tblNilai_preview->RecCount = 0;
$tblNilai_preview->RowCount = 0;
while ($tblNilai_preview->Recordset && !$tblNilai_preview->Recordset->EOF) {

	// Init row class and style
	$tblNilai_preview->RecCount++;
	$tblNilai_preview->RowCount++;
	$tblNilai_preview->CssStyle = "";
	$tblNilai_preview->loadListRowValues($tblNilai_preview->Recordset);
	$tblNilai_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$tblNilai->RowType = ROWTYPE_PREVIEW; // Preview record
	$tblNilai_preview->resetAttributes();
	$tblNilai_preview->renderListRow();

	// Render list options
	$tblNilai_preview->renderListOptions();
?>
	<tr <?php echo $tblNilai->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblNilai_preview->ListOptions->render("body", "left", $tblNilai_preview->RowCount);
?>
<?php if ($tblNilai_preview->Kode_MK->Visible) { // Kode_MK ?>
		<!-- Kode_MK -->
		<td<?php echo $tblNilai_preview->Kode_MK->cellAttributes() ?>>
<span<?php echo $tblNilai_preview->Kode_MK->viewAttributes() ?>><?php echo $tblNilai_preview->Kode_MK->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($tblNilai_preview->SKS->Visible) { // SKS ?>
		<!-- SKS -->
		<td<?php echo $tblNilai_preview->SKS->cellAttributes() ?>>
<span<?php echo $tblNilai_preview->SKS->viewAttributes() ?>><?php echo $tblNilai_preview->SKS->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($tblNilai_preview->kls->Visible) { // kls ?>
		<!-- kls -->
		<td<?php echo $tblNilai_preview->kls->cellAttributes() ?>>
<span<?php echo $tblNilai_preview->kls->viewAttributes() ?>><?php echo $tblNilai_preview->kls->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$tblNilai_preview->ListOptions->render("body", "right", $tblNilai_preview->RowCount);
?>
	</tr>
<?php
	$tblNilai_preview->Recordset->MoveNext();
} // while
?>
	</tbody>
<?php

	// Render aggregate row
	$tblNilai->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$tblNilai_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$tblNilai_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$tblNilai_preview->ListOptions->render("footer", "left");
?>
<?php if ($tblNilai_preview->Kode_MK->Visible) { // Kode_MK ?>
		<!-- Kode_MK -->
		<td class="<?php echo $tblNilai_preview->Kode_MK->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($tblNilai_preview->SKS->Visible) { // SKS ?>
		<!-- SKS -->
		<td class="<?php echo $tblNilai_preview->SKS->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $tblNilai_preview->SKS->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($tblNilai_preview->kls->Visible) { // kls ?>
		<!-- kls -->
		<td class="<?php echo $tblNilai_preview->kls->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$tblNilai_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php echo $tblNilai_preview->Pager->render() ?>
<?php } else { // No record ?>
<div class="card no-border">
<div class="ew-detail-count"><?php echo $Language->phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($tblNilai_preview->OtherOptions as $option)
		$option->render("body");
?>
</div>
<?php if ($tblNilai_preview->TotalRecords > 0) { ?>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
<?php } ?>
</div><!-- /.card -->
<?php
$tblNilai_preview->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php
if ($tblNilai_preview->Recordset)
	$tblNilai_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$tblNilai_preview->terminate();
?>