<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblPengesahanKEU_list = new tblPengesahanKEU_list();

// Run the page
$tblPengesahanKEU_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblPengesahanKEU_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblPengesahanKEU_list->isExport()) { ?>
<script>
var ftblPengesahanKEUlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblPengesahanKEUlist = currentForm = new ew.Form("ftblPengesahanKEUlist", "list");
	ftblPengesahanKEUlist.formKeyCountName = '<?php echo $tblPengesahanKEU_list->FormKeyCountName ?>';

	// Validate form
	ftblPengesahanKEUlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblPengesahanKEU_list->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->Thn_Akademik->caption(), $tblPengesahanKEU_list->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKEU_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->Periode->caption(), $tblPengesahanKEU_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKEU_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->NIDN->caption(), $tblPengesahanKEU_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKEU_list->Jabatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Jabatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->Jabatan->caption(), $tblPengesahanKEU_list->Jabatan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKEU_list->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->Tanggal->caption(), $tblPengesahanKEU_list->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkUSDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblPengesahanKEU_list->Tanggal->errorMessage()) ?>");
			<?php if ($tblPengesahanKEU_list->ttd->Required) { ?>
				felm = this.getElements("x" + infix + "_ttd");
				elm = this.getElements("fn_x" + infix + "_ttd");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKEU_list->ttd->caption(), $tblPengesahanKEU_list->ttd->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblPengesahanKEUlist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Thn_Akademik", false)) return false;
		if (ew.valueChanged(fobj, infix, "Periode", false)) return false;
		if (ew.valueChanged(fobj, infix, "NIDN", false)) return false;
		if (ew.valueChanged(fobj, infix, "Jabatan", false)) return false;
		if (ew.valueChanged(fobj, infix, "Tanggal", false)) return false;
		if (ew.valueChanged(fobj, infix, "ttd", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKEUlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKEUlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKEUlist.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKEU_list) ?>;
	ftblPengesahanKEUlist.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKEU_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKEUlist.lists["x_Periode"] = <?php echo $tblPengesahanKEU_list->Periode->Lookup->toClientList($tblPengesahanKEU_list) ?>;
	ftblPengesahanKEUlist.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKEU_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanKEUlist.lists["x_NIDN"] = <?php echo $tblPengesahanKEU_list->NIDN->Lookup->toClientList($tblPengesahanKEU_list) ?>;
	ftblPengesahanKEUlist.lists["x_NIDN"].options = <?php echo JsonEncode($tblPengesahanKEU_list->NIDN->lookupOptions()) ?>;
	loadjs.done("ftblPengesahanKEUlist");
});
var ftblPengesahanKEUlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblPengesahanKEUlistsrch = currentSearchForm = new ew.Form("ftblPengesahanKEUlistsrch");

	// Validate function for search
	ftblPengesahanKEUlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKEUlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKEUlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKEUlistsrch.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKEU_list) ?>;
	ftblPengesahanKEUlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKEU_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKEUlistsrch.lists["x_Periode"] = <?php echo $tblPengesahanKEU_list->Periode->Lookup->toClientList($tblPengesahanKEU_list) ?>;
	ftblPengesahanKEUlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKEU_list->Periode->options(FALSE, TRUE)) ?>;

	// Filters
	ftblPengesahanKEUlistsrch.filterList = <?php echo $tblPengesahanKEU_list->getFilterList() ?>;
	loadjs.done("ftblPengesahanKEUlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblPengesahanKEU_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblPengesahanKEU_list->TotalRecords > 0 && $tblPengesahanKEU_list->ExportOptions->visible()) { ?>
<?php $tblPengesahanKEU_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->ImportOptions->visible()) { ?>
<?php $tblPengesahanKEU_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->SearchOptions->visible()) { ?>
<?php $tblPengesahanKEU_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->FilterOptions->visible()) { ?>
<?php $tblPengesahanKEU_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblPengesahanKEU_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblPengesahanKEU_list->isExport() && !$tblPengesahanKEU->CurrentAction) { ?>
<form name="ftblPengesahanKEUlistsrch" id="ftblPengesahanKEUlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblPengesahanKEUlistsrch-search-panel" class="<?php echo $tblPengesahanKEU_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblPengesahanKEU">
	<div class="ew-extended-search">
<?php

// Render search row
$tblPengesahanKEU->RowType = ROWTYPE_SEARCH;
$tblPengesahanKEU->resetAttributes();
$tblPengesahanKEU_list->renderRow();
?>
<?php if ($tblPengesahanKEU_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$tblPengesahanKEU_list->SearchColumnCount++;
		if (($tblPengesahanKEU_list->SearchColumnCount - 1) % $tblPengesahanKEU_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKEU_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKEU_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $tblPengesahanKEU_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_tblPengesahanKEU_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKEU_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblPengesahanKEU_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKEU_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($tblPengesahanKEU_list->SearchColumnCount % $tblPengesahanKEU_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->Periode->Visible) { // Periode ?>
	<?php
		$tblPengesahanKEU_list->SearchColumnCount++;
		if (($tblPengesahanKEU_list->SearchColumnCount - 1) % $tblPengesahanKEU_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKEU_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKEU_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblPengesahanKEU_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblPengesahanKEU_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKEU_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblPengesahanKEU_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblPengesahanKEU_list->SearchColumnCount % $tblPengesahanKEU_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblPengesahanKEU_list->SearchColumnCount % $tblPengesahanKEU_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblPengesahanKEU_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblPengesahanKEU_list->showPageHeader(); ?>
<?php
$tblPengesahanKEU_list->showMessage();
?>
<?php if ($tblPengesahanKEU_list->TotalRecords > 0 || $tblPengesahanKEU->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblPengesahanKEU_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblPengesahanKEU">
<form name="ftblPengesahanKEUlist" id="ftblPengesahanKEUlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblPengesahanKEU">
<div id="gmp_tblPengesahanKEU" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblPengesahanKEU_list->TotalRecords > 0 || $tblPengesahanKEU_list->isGridEdit()) { ?>
<table id="tbl_tblPengesahanKEUlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblPengesahanKEU->RowType = ROWTYPE_HEADER;

// Render list options
$tblPengesahanKEU_list->renderListOptions();

// Render list options (header, left)
$tblPengesahanKEU_list->ListOptions->render("header", "left");
?>
<?php if ($tblPengesahanKEU_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKEU_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_Thn_Akademik" class="tblPengesahanKEU_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKEU_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Thn_Akademik) ?>', 1);"><div id="elh_tblPengesahanKEU_Thn_Akademik" class="tblPengesahanKEU_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->Periode->Visible) { // Periode ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKEU_list->Periode->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_Periode" class="tblPengesahanKEU_Periode"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKEU_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Periode) ?>', 1);"><div id="elh_tblPengesahanKEU_Periode" class="tblPengesahanKEU_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKEU_list->NIDN->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_NIDN" class="tblPengesahanKEU_NIDN"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKEU_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->NIDN) ?>', 1);"><div id="elh_tblPengesahanKEU_NIDN" class="tblPengesahanKEU_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->Jabatan->Visible) { // Jabatan ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Jabatan) == "") { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKEU_list->Jabatan->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_Jabatan" class="tblPengesahanKEU_Jabatan"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Jabatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKEU_list->Jabatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Jabatan) ?>', 1);"><div id="elh_tblPengesahanKEU_Jabatan" class="tblPengesahanKEU_Jabatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Jabatan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->Jabatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->Jabatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKEU_list->Tanggal->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_Tanggal" class="tblPengesahanKEU_Tanggal"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKEU_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->Tanggal) ?>', 1);"><div id="elh_tblPengesahanKEU_Tanggal" class="tblPengesahanKEU_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->ttd->Visible) { // ttd ?>
	<?php if ($tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->ttd) == "") { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKEU_list->ttd->headerCellClass() ?>"><div id="elh_tblPengesahanKEU_ttd" class="tblPengesahanKEU_ttd"><div class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->ttd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKEU_list->ttd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKEU_list->SortUrl($tblPengesahanKEU_list->ttd) ?>', 1);"><div id="elh_tblPengesahanKEU_ttd" class="tblPengesahanKEU_ttd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKEU_list->ttd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKEU_list->ttd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKEU_list->ttd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblPengesahanKEU_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblPengesahanKEU_list->ExportAll && $tblPengesahanKEU_list->isExport()) {
	$tblPengesahanKEU_list->StopRecord = $tblPengesahanKEU_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblPengesahanKEU_list->TotalRecords > $tblPengesahanKEU_list->StartRecord + $tblPengesahanKEU_list->DisplayRecords - 1)
		$tblPengesahanKEU_list->StopRecord = $tblPengesahanKEU_list->StartRecord + $tblPengesahanKEU_list->DisplayRecords - 1;
	else
		$tblPengesahanKEU_list->StopRecord = $tblPengesahanKEU_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblPengesahanKEU->isConfirm() || $tblPengesahanKEU_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblPengesahanKEU_list->FormKeyCountName) && ($tblPengesahanKEU_list->isGridAdd() || $tblPengesahanKEU_list->isGridEdit() || $tblPengesahanKEU->isConfirm())) {
		$tblPengesahanKEU_list->KeyCount = $CurrentForm->getValue($tblPengesahanKEU_list->FormKeyCountName);
		$tblPengesahanKEU_list->StopRecord = $tblPengesahanKEU_list->StartRecord + $tblPengesahanKEU_list->KeyCount - 1;
	}
}
$tblPengesahanKEU_list->RecordCount = $tblPengesahanKEU_list->StartRecord - 1;
if ($tblPengesahanKEU_list->Recordset && !$tblPengesahanKEU_list->Recordset->EOF) {
	$tblPengesahanKEU_list->Recordset->moveFirst();
	$selectLimit = $tblPengesahanKEU_list->UseSelectLimit;
	if (!$selectLimit && $tblPengesahanKEU_list->StartRecord > 1)
		$tblPengesahanKEU_list->Recordset->move($tblPengesahanKEU_list->StartRecord - 1);
} elseif (!$tblPengesahanKEU->AllowAddDeleteRow && $tblPengesahanKEU_list->StopRecord == 0) {
	$tblPengesahanKEU_list->StopRecord = $tblPengesahanKEU->GridAddRowCount;
}

// Initialize aggregate
$tblPengesahanKEU->RowType = ROWTYPE_AGGREGATEINIT;
$tblPengesahanKEU->resetAttributes();
$tblPengesahanKEU_list->renderRow();
if ($tblPengesahanKEU_list->isGridAdd())
	$tblPengesahanKEU_list->RowIndex = 0;
if ($tblPengesahanKEU_list->isGridEdit())
	$tblPengesahanKEU_list->RowIndex = 0;
while ($tblPengesahanKEU_list->RecordCount < $tblPengesahanKEU_list->StopRecord) {
	$tblPengesahanKEU_list->RecordCount++;
	if ($tblPengesahanKEU_list->RecordCount >= $tblPengesahanKEU_list->StartRecord) {
		$tblPengesahanKEU_list->RowCount++;
		if ($tblPengesahanKEU_list->isGridAdd() || $tblPengesahanKEU_list->isGridEdit() || $tblPengesahanKEU->isConfirm()) {
			$tblPengesahanKEU_list->RowIndex++;
			$CurrentForm->Index = $tblPengesahanKEU_list->RowIndex;
			if ($CurrentForm->hasValue($tblPengesahanKEU_list->FormActionName) && ($tblPengesahanKEU->isConfirm() || $tblPengesahanKEU_list->EventCancelled))
				$tblPengesahanKEU_list->RowAction = strval($CurrentForm->getValue($tblPengesahanKEU_list->FormActionName));
			elseif ($tblPengesahanKEU_list->isGridAdd())
				$tblPengesahanKEU_list->RowAction = "insert";
			else
				$tblPengesahanKEU_list->RowAction = "";
		}

		// Set up key count
		$tblPengesahanKEU_list->KeyCount = $tblPengesahanKEU_list->RowIndex;

		// Init row class and style
		$tblPengesahanKEU->resetAttributes();
		$tblPengesahanKEU->CssClass = "";
		if ($tblPengesahanKEU_list->isGridAdd()) {
			$tblPengesahanKEU_list->loadRowValues(); // Load default values
		} else {
			$tblPengesahanKEU_list->loadRowValues($tblPengesahanKEU_list->Recordset); // Load row values
		}
		$tblPengesahanKEU->RowType = ROWTYPE_VIEW; // Render view
		if ($tblPengesahanKEU_list->isGridAdd()) // Grid add
			$tblPengesahanKEU->RowType = ROWTYPE_ADD; // Render add
		if ($tblPengesahanKEU_list->isGridAdd() && $tblPengesahanKEU->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblPengesahanKEU_list->restoreCurrentRowFormValues($tblPengesahanKEU_list->RowIndex); // Restore form values
		if ($tblPengesahanKEU_list->isGridEdit()) { // Grid edit
			if ($tblPengesahanKEU->EventCancelled)
				$tblPengesahanKEU_list->restoreCurrentRowFormValues($tblPengesahanKEU_list->RowIndex); // Restore form values
			if ($tblPengesahanKEU_list->RowAction == "insert")
				$tblPengesahanKEU->RowType = ROWTYPE_ADD; // Render add
			else
				$tblPengesahanKEU->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblPengesahanKEU_list->isGridEdit() && ($tblPengesahanKEU->RowType == ROWTYPE_EDIT || $tblPengesahanKEU->RowType == ROWTYPE_ADD) && $tblPengesahanKEU->EventCancelled) // Update failed
			$tblPengesahanKEU_list->restoreCurrentRowFormValues($tblPengesahanKEU_list->RowIndex); // Restore form values
		if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) // Edit row
			$tblPengesahanKEU_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblPengesahanKEU->RowAttrs->merge(["data-rowindex" => $tblPengesahanKEU_list->RowCount, "id" => "r" . $tblPengesahanKEU_list->RowCount . "_tblPengesahanKEU", "data-rowtype" => $tblPengesahanKEU->RowType]);

		// Render row
		$tblPengesahanKEU_list->renderRow();

		// Render list options
		$tblPengesahanKEU_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblPengesahanKEU_list->RowAction != "delete" && $tblPengesahanKEU_list->RowAction != "insertdelete" && !($tblPengesahanKEU_list->RowAction == "insert" && $tblPengesahanKEU->isConfirm() && $tblPengesahanKEU_list->emptyRow())) {
?>
	<tr <?php echo $tblPengesahanKEU->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKEU_list->ListOptions->render("body", "left", $tblPengesahanKEU_list->RowCount);
?>
	<?php if ($tblPengesahanKEU_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblPengesahanKEU_list->Thn_Akademik->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Thn_Akademik" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKEU_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKEU_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKEU_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKEU_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_Thn_Akademik") ?>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Thn_Akademik->OldValue != null ? $tblPengesahanKEU_list->Thn_Akademik->OldValue : $tblPengesahanKEU_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Thn_Akademik">
<span<?php echo $tblPengesahanKEU_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblPengesahanKEU_list->Thn_Akademik->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblPengesahanKEU_list->Periode->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKEU_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKEU_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Periode->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Periode" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKEU_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKEU_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Periode->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Periode" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Periode->OldValue != null ? $tblPengesahanKEU_list->Periode->OldValue : $tblPengesahanKEU_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Periode">
<span<?php echo $tblPengesahanKEU_list->Periode->viewAttributes() ?>><?php echo $tblPengesahanKEU_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblPengesahanKEU_list->NIDN->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKEU_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKEU_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKEU_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKEU_list->NIDN->ReadOnly || $tblPengesahanKEU_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKEU_list->NIDN->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKEU_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKEU_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKEU_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_NIDN" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKEU_list->NIDN->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKEU_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKEU_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKEU_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKEU_list->NIDN->ReadOnly || $tblPengesahanKEU_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKEU_list->NIDN->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKEU_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKEU_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKEU_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_NIDN">
<span<?php echo $tblPengesahanKEU_list->NIDN->viewAttributes() ?>><?php echo $tblPengesahanKEU_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan" <?php echo $tblPengesahanKEU_list->Jabatan->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKEU_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Jabatan->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKEU_list->Jabatan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Jabatan">
<span<?php echo $tblPengesahanKEU_list->Jabatan->viewAttributes() ?>><?php echo $tblPengesahanKEU_list->Jabatan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $tblPengesahanKEU_list->Tanggal->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Tanggal" data-format="6" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKEU_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKEU_list->Tanggal->ReadOnly && !$tblPengesahanKEU_list->Tanggal->Disabled && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKEUlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKEUlist", "x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":6});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Tanggal->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Tanggal" data-format="6" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKEU_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKEU_list->Tanggal->ReadOnly && !$tblPengesahanKEU_list->Tanggal->Disabled && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKEUlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKEUlist", "x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":6});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_Tanggal">
<span<?php echo $tblPengesahanKEU_list->Tanggal->viewAttributes() ?>><?php echo $tblPengesahanKEU_list->Tanggal->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd" <?php echo $tblPengesahanKEU_list->ttd->cellAttributes() ?>>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKEU_list->ttd->title() ?>" data-table="tblPengesahanKEU" data-field="x_ttd" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKEU_list->ttd->editAttributes() ?><?php if ($tblPengesahanKEU_list->ttd->ReadOnly || $tblPengesahanKEU_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_ttd" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKEU_list->ttd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKEU_list->ttd->title() ?>" data-table="tblPengesahanKEU" data-field="x_ttd" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKEU_list->ttd->editAttributes() ?><?php if ($tblPengesahanKEU_list->ttd->ReadOnly || $tblPengesahanKEU_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo (Post("fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd") == "0") ? "0" : "1" ?>">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKEU_list->RowCount ?>_tblPengesahanKEU_ttd">
<span><?php echo GetFileViewTag($tblPengesahanKEU_list->ttd, $tblPengesahanKEU_list->ttd->getViewValue(), FALSE) ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKEU_list->ListOptions->render("body", "right", $tblPengesahanKEU_list->RowCount);
?>
	</tr>
<?php if ($tblPengesahanKEU->RowType == ROWTYPE_ADD || $tblPengesahanKEU->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblPengesahanKEUlist", "load"], function() {
	ftblPengesahanKEUlist.updateLists(<?php echo $tblPengesahanKEU_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblPengesahanKEU_list->isGridAdd())
		if (!$tblPengesahanKEU_list->Recordset->EOF)
			$tblPengesahanKEU_list->Recordset->moveNext();
}
?>
<?php
	if ($tblPengesahanKEU_list->isGridAdd() || $tblPengesahanKEU_list->isGridEdit()) {
		$tblPengesahanKEU_list->RowIndex = '$rowindex$';
		$tblPengesahanKEU_list->loadRowValues();

		// Set row properties
		$tblPengesahanKEU->resetAttributes();
		$tblPengesahanKEU->RowAttrs->merge(["data-rowindex" => $tblPengesahanKEU_list->RowIndex, "id" => "r0_tblPengesahanKEU", "data-rowtype" => ROWTYPE_ADD]);
		$tblPengesahanKEU->RowAttrs->appendClass("ew-template");
		$tblPengesahanKEU->RowType = ROWTYPE_ADD;

		// Render row
		$tblPengesahanKEU_list->renderRow();

		// Render list options
		$tblPengesahanKEU_list->renderListOptions();
		$tblPengesahanKEU_list->StartRowCount = 0;
?>
	<tr <?php echo $tblPengesahanKEU->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKEU_list->ListOptions->render("body", "left", $tblPengesahanKEU_list->RowIndex);
?>
	<?php if ($tblPengesahanKEU_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik">
<span id="el$rowindex$_tblPengesahanKEU_Thn_Akademik" class="form-group tblPengesahanKEU_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKEU_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKEU_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKEU_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Thn_Akademik->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode">
<span id="el$rowindex$_tblPengesahanKEU_Periode" class="form-group tblPengesahanKEU_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKEU" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKEU_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKEU_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKEU_list->Periode->selectOptionListHtml("x{$tblPengesahanKEU_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Periode" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Periode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el$rowindex$_tblPengesahanKEU_NIDN" class="form-group tblPengesahanKEU_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKEU_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKEU_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKEU_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKEU_list->NIDN->ReadOnly || $tblPengesahanKEU_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKEU_list->NIDN->Lookup->getParamTag($tblPengesahanKEU_list, "p_x" . $tblPengesahanKEU_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKEU_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKEU_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKEU_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_NIDN" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKEU_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan">
<span id="el$rowindex$_tblPengesahanKEU_Jabatan" class="form-group tblPengesahanKEU_Jabatan">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKEU_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Jabatan->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal">
<span id="el$rowindex$_tblPengesahanKEU_Tanggal" class="form-group tblPengesahanKEU_Tanggal">
<input type="text" data-table="tblPengesahanKEU" data-field="x_Tanggal" data-format="6" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKEU_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKEU_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKEU_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKEU_list->Tanggal->ReadOnly && !$tblPengesahanKEU_list->Tanggal->Disabled && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKEU_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKEUlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKEUlist", "x<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":6});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKEU_list->Tanggal->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKEU_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd">
<span id="el$rowindex$_tblPengesahanKEU_ttd" class="form-group tblPengesahanKEU_ttd">
<div id="fd_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKEU_list->ttd->title() ?>" data-table="tblPengesahanKEU" data-field="x_ttd" name="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKEU_list->ttd->editAttributes() ?><?php if ($tblPengesahanKEU_list->ttd->ReadOnly || $tblPengesahanKEU_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKEU_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKEU" data-field="x_ttd" name="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKEU_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKEU_list->ttd->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKEU_list->ListOptions->render("body", "right", $tblPengesahanKEU_list->RowIndex);
?>
<script>
loadjs.ready(["ftblPengesahanKEUlist", "load"], function() {
	ftblPengesahanKEUlist.updateLists(<?php echo $tblPengesahanKEU_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblPengesahanKEU_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblPengesahanKEU_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKEU_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKEU_list->KeyCount ?>">
<?php echo $tblPengesahanKEU_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblPengesahanKEU_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblPengesahanKEU_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKEU_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKEU_list->KeyCount ?>">
<?php echo $tblPengesahanKEU_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblPengesahanKEU->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblPengesahanKEU_list->Recordset)
	$tblPengesahanKEU_list->Recordset->Close();
?>
<?php if (!$tblPengesahanKEU_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblPengesahanKEU_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblPengesahanKEU_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKEU_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblPengesahanKEU_list->TotalRecords == 0 && !$tblPengesahanKEU->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKEU_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblPengesahanKEU_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblPengesahanKEU_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblPengesahanKEU_list->terminate();
?>