<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblPengesahanKHS_list = new tblPengesahanKHS_list();

// Run the page
$tblPengesahanKHS_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblPengesahanKHS_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblPengesahanKHS_list->isExport()) { ?>
<script>
var ftblPengesahanKHSlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblPengesahanKHSlist = currentForm = new ew.Form("ftblPengesahanKHSlist", "list");
	ftblPengesahanKHSlist.formKeyCountName = '<?php echo $tblPengesahanKHS_list->FormKeyCountName ?>';

	// Validate form
	ftblPengesahanKHSlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblPengesahanKHS_list->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Thn_Akademik->caption(), $tblPengesahanKHS_list->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Periode->caption(), $tblPengesahanKHS_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->Kode_Jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Kode_Jp->caption(), $tblPengesahanKHS_list->Kode_Jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->Status_Akd->Required) { ?>
				elm = this.getElements("x" + infix + "_Status_Akd");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Status_Akd->caption(), $tblPengesahanKHS_list->Status_Akd->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->NIDN->caption(), $tblPengesahanKHS_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->Jabatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Jabatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Jabatan->caption(), $tblPengesahanKHS_list->Jabatan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKHS_list->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->Tanggal->caption(), $tblPengesahanKHS_list->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblPengesahanKHS_list->Tanggal->errorMessage()) ?>");
			<?php if ($tblPengesahanKHS_list->ttd->Required) { ?>
				felm = this.getElements("x" + infix + "_ttd");
				elm = this.getElements("fn_x" + infix + "_ttd");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKHS_list->ttd->caption(), $tblPengesahanKHS_list->ttd->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblPengesahanKHSlist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Thn_Akademik", false)) return false;
		if (ew.valueChanged(fobj, infix, "Periode", false)) return false;
		if (ew.valueChanged(fobj, infix, "Kode_Jp", false)) return false;
		if (ew.valueChanged(fobj, infix, "Status_Akd", false)) return false;
		if (ew.valueChanged(fobj, infix, "NIDN", false)) return false;
		if (ew.valueChanged(fobj, infix, "Jabatan", false)) return false;
		if (ew.valueChanged(fobj, infix, "Tanggal", false)) return false;
		if (ew.valueChanged(fobj, infix, "ttd", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKHSlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKHSlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKHSlist.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlist.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKHSlist.lists["x_Periode"] = <?php echo $tblPengesahanKHS_list->Periode->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlist.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanKHSlist.lists["x_Kode_Jp"] = <?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlist.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Kode_Jp->lookupOptions()) ?>;
	ftblPengesahanKHSlist.lists["x_Status_Akd"] = <?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlist.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Status_Akd->lookupOptions()) ?>;
	ftblPengesahanKHSlist.lists["x_NIDN"] = <?php echo $tblPengesahanKHS_list->NIDN->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlist.lists["x_NIDN"].options = <?php echo JsonEncode($tblPengesahanKHS_list->NIDN->lookupOptions()) ?>;
	loadjs.done("ftblPengesahanKHSlist");
});
var ftblPengesahanKHSlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblPengesahanKHSlistsrch = currentSearchForm = new ew.Form("ftblPengesahanKHSlistsrch");

	// Validate function for search
	ftblPengesahanKHSlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKHSlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKHSlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKHSlistsrch.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Periode"] = <?php echo $tblPengesahanKHS_list->Periode->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Kode_Jp"] = <?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Kode_Jp->lookupOptions()) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Status_Akd"] = <?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->toClientList($tblPengesahanKHS_list) ?>;
	ftblPengesahanKHSlistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblPengesahanKHS_list->Status_Akd->lookupOptions()) ?>;

	// Filters
	ftblPengesahanKHSlistsrch.filterList = <?php echo $tblPengesahanKHS_list->getFilterList() ?>;
	loadjs.done("ftblPengesahanKHSlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblPengesahanKHS_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblPengesahanKHS_list->TotalRecords > 0 && $tblPengesahanKHS_list->ExportOptions->visible()) { ?>
<?php $tblPengesahanKHS_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->ImportOptions->visible()) { ?>
<?php $tblPengesahanKHS_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->SearchOptions->visible()) { ?>
<?php $tblPengesahanKHS_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->FilterOptions->visible()) { ?>
<?php $tblPengesahanKHS_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblPengesahanKHS_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblPengesahanKHS_list->isExport() && !$tblPengesahanKHS->CurrentAction) { ?>
<form name="ftblPengesahanKHSlistsrch" id="ftblPengesahanKHSlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblPengesahanKHSlistsrch-search-panel" class="<?php echo $tblPengesahanKHS_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblPengesahanKHS">
	<div class="ew-extended-search">
<?php

// Render search row
$tblPengesahanKHS->RowType = ROWTYPE_SEARCH;
$tblPengesahanKHS->resetAttributes();
$tblPengesahanKHS_list->renderRow();
?>
<?php if ($tblPengesahanKHS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$tblPengesahanKHS_list->SearchColumnCount++;
		if (($tblPengesahanKHS_list->SearchColumnCount - 1) % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $tblPengesahanKHS_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_tblPengesahanKHS_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKHS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblPengesahanKHS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKHS_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($tblPengesahanKHS_list->SearchColumnCount % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Periode->Visible) { // Periode ?>
	<?php
		$tblPengesahanKHS_list->SearchColumnCount++;
		if (($tblPengesahanKHS_list->SearchColumnCount - 1) % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblPengesahanKHS_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblPengesahanKHS_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKHS_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblPengesahanKHS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblPengesahanKHS_list->SearchColumnCount % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$tblPengesahanKHS_list->SearchColumnCount++;
		if (($tblPengesahanKHS_list->SearchColumnCount - 1) % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $tblPengesahanKHS_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_tblPengesahanKHS_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKHS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $tblPengesahanKHS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKHS_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($tblPengesahanKHS_list->SearchColumnCount % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$tblPengesahanKHS_list->SearchColumnCount++;
		if (($tblPengesahanKHS_list->SearchColumnCount - 1) % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKHS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKHS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $tblPengesahanKHS_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_tblPengesahanKHS_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $tblPengesahanKHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKHS_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($tblPengesahanKHS_list->SearchColumnCount % $tblPengesahanKHS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblPengesahanKHS_list->SearchColumnCount % $tblPengesahanKHS_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblPengesahanKHS_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblPengesahanKHS_list->showPageHeader(); ?>
<?php
$tblPengesahanKHS_list->showMessage();
?>
<?php if ($tblPengesahanKHS_list->TotalRecords > 0 || $tblPengesahanKHS->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblPengesahanKHS_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblPengesahanKHS">
<form name="ftblPengesahanKHSlist" id="ftblPengesahanKHSlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblPengesahanKHS">
<div id="gmp_tblPengesahanKHS" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblPengesahanKHS_list->TotalRecords > 0 || $tblPengesahanKHS_list->isGridEdit()) { ?>
<table id="tbl_tblPengesahanKHSlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblPengesahanKHS->RowType = ROWTYPE_HEADER;

// Render list options
$tblPengesahanKHS_list->renderListOptions();

// Render list options (header, left)
$tblPengesahanKHS_list->ListOptions->render("header", "left");
?>
<?php if ($tblPengesahanKHS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKHS_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Thn_Akademik" class="tblPengesahanKHS_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKHS_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Thn_Akademik) ?>', 1);"><div id="elh_tblPengesahanKHS_Thn_Akademik" class="tblPengesahanKHS_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Periode->Visible) { // Periode ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKHS_list->Periode->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Periode" class="tblPengesahanKHS_Periode"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKHS_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Periode) ?>', 1);"><div id="elh_tblPengesahanKHS_Periode" class="tblPengesahanKHS_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblPengesahanKHS_list->Kode_Jp->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Kode_Jp" class="tblPengesahanKHS_Kode_Jp"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblPengesahanKHS_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Kode_Jp) ?>', 1);"><div id="elh_tblPengesahanKHS_Kode_Jp" class="tblPengesahanKHS_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $tblPengesahanKHS_list->Status_Akd->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Status_Akd" class="tblPengesahanKHS_Status_Akd"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $tblPengesahanKHS_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Status_Akd) ?>', 1);"><div id="elh_tblPengesahanKHS_Status_Akd" class="tblPengesahanKHS_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKHS_list->NIDN->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_NIDN" class="tblPengesahanKHS_NIDN"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKHS_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->NIDN) ?>', 1);"><div id="elh_tblPengesahanKHS_NIDN" class="tblPengesahanKHS_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Jabatan->Visible) { // Jabatan ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Jabatan) == "") { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKHS_list->Jabatan->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Jabatan" class="tblPengesahanKHS_Jabatan"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Jabatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKHS_list->Jabatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Jabatan) ?>', 1);"><div id="elh_tblPengesahanKHS_Jabatan" class="tblPengesahanKHS_Jabatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Jabatan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Jabatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Jabatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKHS_list->Tanggal->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_Tanggal" class="tblPengesahanKHS_Tanggal"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKHS_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->Tanggal) ?>', 1);"><div id="elh_tblPengesahanKHS_Tanggal" class="tblPengesahanKHS_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->ttd->Visible) { // ttd ?>
	<?php if ($tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->ttd) == "") { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKHS_list->ttd->headerCellClass() ?>"><div id="elh_tblPengesahanKHS_ttd" class="tblPengesahanKHS_ttd"><div class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->ttd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKHS_list->ttd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKHS_list->SortUrl($tblPengesahanKHS_list->ttd) ?>', 1);"><div id="elh_tblPengesahanKHS_ttd" class="tblPengesahanKHS_ttd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKHS_list->ttd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKHS_list->ttd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKHS_list->ttd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblPengesahanKHS_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblPengesahanKHS_list->ExportAll && $tblPengesahanKHS_list->isExport()) {
	$tblPengesahanKHS_list->StopRecord = $tblPengesahanKHS_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblPengesahanKHS_list->TotalRecords > $tblPengesahanKHS_list->StartRecord + $tblPengesahanKHS_list->DisplayRecords - 1)
		$tblPengesahanKHS_list->StopRecord = $tblPengesahanKHS_list->StartRecord + $tblPengesahanKHS_list->DisplayRecords - 1;
	else
		$tblPengesahanKHS_list->StopRecord = $tblPengesahanKHS_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblPengesahanKHS->isConfirm() || $tblPengesahanKHS_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblPengesahanKHS_list->FormKeyCountName) && ($tblPengesahanKHS_list->isGridAdd() || $tblPengesahanKHS_list->isGridEdit() || $tblPengesahanKHS->isConfirm())) {
		$tblPengesahanKHS_list->KeyCount = $CurrentForm->getValue($tblPengesahanKHS_list->FormKeyCountName);
		$tblPengesahanKHS_list->StopRecord = $tblPengesahanKHS_list->StartRecord + $tblPengesahanKHS_list->KeyCount - 1;
	}
}
$tblPengesahanKHS_list->RecordCount = $tblPengesahanKHS_list->StartRecord - 1;
if ($tblPengesahanKHS_list->Recordset && !$tblPengesahanKHS_list->Recordset->EOF) {
	$tblPengesahanKHS_list->Recordset->moveFirst();
	$selectLimit = $tblPengesahanKHS_list->UseSelectLimit;
	if (!$selectLimit && $tblPengesahanKHS_list->StartRecord > 1)
		$tblPengesahanKHS_list->Recordset->move($tblPengesahanKHS_list->StartRecord - 1);
} elseif (!$tblPengesahanKHS->AllowAddDeleteRow && $tblPengesahanKHS_list->StopRecord == 0) {
	$tblPengesahanKHS_list->StopRecord = $tblPengesahanKHS->GridAddRowCount;
}

// Initialize aggregate
$tblPengesahanKHS->RowType = ROWTYPE_AGGREGATEINIT;
$tblPengesahanKHS->resetAttributes();
$tblPengesahanKHS_list->renderRow();
if ($tblPengesahanKHS_list->isGridAdd())
	$tblPengesahanKHS_list->RowIndex = 0;
if ($tblPengesahanKHS_list->isGridEdit())
	$tblPengesahanKHS_list->RowIndex = 0;
while ($tblPengesahanKHS_list->RecordCount < $tblPengesahanKHS_list->StopRecord) {
	$tblPengesahanKHS_list->RecordCount++;
	if ($tblPengesahanKHS_list->RecordCount >= $tblPengesahanKHS_list->StartRecord) {
		$tblPengesahanKHS_list->RowCount++;
		if ($tblPengesahanKHS_list->isGridAdd() || $tblPengesahanKHS_list->isGridEdit() || $tblPengesahanKHS->isConfirm()) {
			$tblPengesahanKHS_list->RowIndex++;
			$CurrentForm->Index = $tblPengesahanKHS_list->RowIndex;
			if ($CurrentForm->hasValue($tblPengesahanKHS_list->FormActionName) && ($tblPengesahanKHS->isConfirm() || $tblPengesahanKHS_list->EventCancelled))
				$tblPengesahanKHS_list->RowAction = strval($CurrentForm->getValue($tblPengesahanKHS_list->FormActionName));
			elseif ($tblPengesahanKHS_list->isGridAdd())
				$tblPengesahanKHS_list->RowAction = "insert";
			else
				$tblPengesahanKHS_list->RowAction = "";
		}

		// Set up key count
		$tblPengesahanKHS_list->KeyCount = $tblPengesahanKHS_list->RowIndex;

		// Init row class and style
		$tblPengesahanKHS->resetAttributes();
		$tblPengesahanKHS->CssClass = "";
		if ($tblPengesahanKHS_list->isGridAdd()) {
			$tblPengesahanKHS_list->loadRowValues(); // Load default values
		} else {
			$tblPengesahanKHS_list->loadRowValues($tblPengesahanKHS_list->Recordset); // Load row values
		}
		$tblPengesahanKHS->RowType = ROWTYPE_VIEW; // Render view
		if ($tblPengesahanKHS_list->isGridAdd()) // Grid add
			$tblPengesahanKHS->RowType = ROWTYPE_ADD; // Render add
		if ($tblPengesahanKHS_list->isGridAdd() && $tblPengesahanKHS->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblPengesahanKHS_list->restoreCurrentRowFormValues($tblPengesahanKHS_list->RowIndex); // Restore form values
		if ($tblPengesahanKHS_list->isGridEdit()) { // Grid edit
			if ($tblPengesahanKHS->EventCancelled)
				$tblPengesahanKHS_list->restoreCurrentRowFormValues($tblPengesahanKHS_list->RowIndex); // Restore form values
			if ($tblPengesahanKHS_list->RowAction == "insert")
				$tblPengesahanKHS->RowType = ROWTYPE_ADD; // Render add
			else
				$tblPengesahanKHS->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblPengesahanKHS_list->isGridEdit() && ($tblPengesahanKHS->RowType == ROWTYPE_EDIT || $tblPengesahanKHS->RowType == ROWTYPE_ADD) && $tblPengesahanKHS->EventCancelled) // Update failed
			$tblPengesahanKHS_list->restoreCurrentRowFormValues($tblPengesahanKHS_list->RowIndex); // Restore form values
		if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) // Edit row
			$tblPengesahanKHS_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblPengesahanKHS->RowAttrs->merge(["data-rowindex" => $tblPengesahanKHS_list->RowCount, "id" => "r" . $tblPengesahanKHS_list->RowCount . "_tblPengesahanKHS", "data-rowtype" => $tblPengesahanKHS->RowType]);

		// Render row
		$tblPengesahanKHS_list->renderRow();

		// Render list options
		$tblPengesahanKHS_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblPengesahanKHS_list->RowAction != "delete" && $tblPengesahanKHS_list->RowAction != "insertdelete" && !($tblPengesahanKHS_list->RowAction == "insert" && $tblPengesahanKHS->isConfirm() && $tblPengesahanKHS_list->emptyRow())) {
?>
	<tr <?php echo $tblPengesahanKHS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKHS_list->ListOptions->render("body", "left", $tblPengesahanKHS_list->RowCount);
?>
	<?php if ($tblPengesahanKHS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblPengesahanKHS_list->Thn_Akademik->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Thn_Akademik" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKHS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKHS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKHS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKHS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Thn_Akademik") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Thn_Akademik->OldValue != null ? $tblPengesahanKHS_list->Thn_Akademik->OldValue : $tblPengesahanKHS_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Thn_Akademik">
<span<?php echo $tblPengesahanKHS_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Thn_Akademik->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblPengesahanKHS_list->Periode->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKHS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKHS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Periode->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Periode" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKHS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKHS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Periode->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Periode" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Periode->OldValue != null ? $tblPengesahanKHS_list->Periode->OldValue : $tblPengesahanKHS_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Periode">
<span<?php echo $tblPengesahanKHS_list->Periode->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $tblPengesahanKHS_list->Kode_Jp->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Kode_Jp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKHS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKHS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Kode_Jp->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKHS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKHS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Kode_Jp") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Kode_Jp->OldValue != null ? $tblPengesahanKHS_list->Kode_Jp->OldValue : $tblPengesahanKHS_list->Kode_Jp->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Kode_Jp">
<span<?php echo $tblPengesahanKHS_list->Kode_Jp->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Kode_Jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $tblPengesahanKHS_list->Status_Akd->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Status_Akd" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Status_Akd") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Status_Akd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Status_Akd") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Status_Akd->OldValue != null ? $tblPengesahanKHS_list->Status_Akd->OldValue : $tblPengesahanKHS_list->Status_Akd->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Status_Akd">
<span<?php echo $tblPengesahanKHS_list->Status_Akd->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Status_Akd->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblPengesahanKHS_list->NIDN->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKHS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKHS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKHS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKHS_list->NIDN->ReadOnly || $tblPengesahanKHS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKHS_list->NIDN->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKHS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKHS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKHS_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_NIDN" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKHS_list->NIDN->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKHS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKHS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKHS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKHS_list->NIDN->ReadOnly || $tblPengesahanKHS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKHS_list->NIDN->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKHS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKHS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKHS_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_NIDN">
<span<?php echo $tblPengesahanKHS_list->NIDN->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan" <?php echo $tblPengesahanKHS_list->Jabatan->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKHS_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Jabatan->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKHS_list->Jabatan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Jabatan">
<span<?php echo $tblPengesahanKHS_list->Jabatan->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Jabatan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $tblPengesahanKHS_list->Tanggal->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKHS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKHS_list->Tanggal->ReadOnly && !$tblPengesahanKHS_list->Tanggal->Disabled && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKHSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKHSlist", "x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Tanggal->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKHS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKHS_list->Tanggal->ReadOnly && !$tblPengesahanKHS_list->Tanggal->Disabled && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKHSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKHSlist", "x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_Tanggal">
<span<?php echo $tblPengesahanKHS_list->Tanggal->viewAttributes() ?>><?php echo $tblPengesahanKHS_list->Tanggal->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd" <?php echo $tblPengesahanKHS_list->ttd->cellAttributes() ?>>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKHS_list->ttd->title() ?>" data-table="tblPengesahanKHS" data-field="x_ttd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKHS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKHS_list->ttd->ReadOnly || $tblPengesahanKHS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_ttd" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKHS_list->ttd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKHS_list->ttd->title() ?>" data-table="tblPengesahanKHS" data-field="x_ttd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKHS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKHS_list->ttd->ReadOnly || $tblPengesahanKHS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo (Post("fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd") == "0") ? "0" : "1" ?>">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKHS_list->RowCount ?>_tblPengesahanKHS_ttd">
<span><?php echo GetFileViewTag($tblPengesahanKHS_list->ttd, $tblPengesahanKHS_list->ttd->getViewValue(), FALSE) ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKHS_list->ListOptions->render("body", "right", $tblPengesahanKHS_list->RowCount);
?>
	</tr>
<?php if ($tblPengesahanKHS->RowType == ROWTYPE_ADD || $tblPengesahanKHS->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblPengesahanKHSlist", "load"], function() {
	ftblPengesahanKHSlist.updateLists(<?php echo $tblPengesahanKHS_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblPengesahanKHS_list->isGridAdd())
		if (!$tblPengesahanKHS_list->Recordset->EOF)
			$tblPengesahanKHS_list->Recordset->moveNext();
}
?>
<?php
	if ($tblPengesahanKHS_list->isGridAdd() || $tblPengesahanKHS_list->isGridEdit()) {
		$tblPengesahanKHS_list->RowIndex = '$rowindex$';
		$tblPengesahanKHS_list->loadRowValues();

		// Set row properties
		$tblPengesahanKHS->resetAttributes();
		$tblPengesahanKHS->RowAttrs->merge(["data-rowindex" => $tblPengesahanKHS_list->RowIndex, "id" => "r0_tblPengesahanKHS", "data-rowtype" => ROWTYPE_ADD]);
		$tblPengesahanKHS->RowAttrs->appendClass("ew-template");
		$tblPengesahanKHS->RowType = ROWTYPE_ADD;

		// Render row
		$tblPengesahanKHS_list->renderRow();

		// Render list options
		$tblPengesahanKHS_list->renderListOptions();
		$tblPengesahanKHS_list->StartRowCount = 0;
?>
	<tr <?php echo $tblPengesahanKHS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKHS_list->ListOptions->render("body", "left", $tblPengesahanKHS_list->RowIndex);
?>
	<?php if ($tblPengesahanKHS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik">
<span id="el$rowindex$_tblPengesahanKHS_Thn_Akademik" class="form-group tblPengesahanKHS_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKHS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKHS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Thn_Akademik->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode">
<span id="el$rowindex$_tblPengesahanKHS_Periode" class="form-group tblPengesahanKHS_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKHS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKHS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Periode->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Periode" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Periode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp">
<span id="el$rowindex$_tblPengesahanKHS_Kode_Jp" class="form-group tblPengesahanKHS_Kode_Jp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKHS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKHS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Kode_Jp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd">
<span id="el$rowindex$_tblPengesahanKHS_Status_Akd" class="form-group tblPengesahanKHS_Status_Akd">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKHS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKHS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKHS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKHS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKHS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKHS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_Status_Akd") ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Status_Akd->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el$rowindex$_tblPengesahanKHS_NIDN" class="form-group tblPengesahanKHS_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKHS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKHS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKHS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKHS_list->NIDN->ReadOnly || $tblPengesahanKHS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKHS_list->NIDN->Lookup->getParamTag($tblPengesahanKHS_list, "p_x" . $tblPengesahanKHS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKHS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKHS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKHS_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_NIDN" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKHS_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan">
<span id="el$rowindex$_tblPengesahanKHS_Jabatan" class="form-group tblPengesahanKHS_Jabatan">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" size="30" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKHS_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Jabatan->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal">
<span id="el$rowindex$_tblPengesahanKHS_Tanggal" class="form-group tblPengesahanKHS_Tanggal">
<input type="text" data-table="tblPengesahanKHS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKHS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKHS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKHS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKHS_list->Tanggal->ReadOnly && !$tblPengesahanKHS_list->Tanggal->Disabled && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKHS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKHSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKHSlist", "x<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKHS_list->Tanggal->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKHS_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd">
<span id="el$rowindex$_tblPengesahanKHS_ttd" class="form-group tblPengesahanKHS_ttd">
<div id="fd_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKHS_list->ttd->title() ?>" data-table="tblPengesahanKHS" data-field="x_ttd" name="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKHS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKHS_list->ttd->ReadOnly || $tblPengesahanKHS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKHS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKHS" data-field="x_ttd" name="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKHS_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKHS_list->ttd->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKHS_list->ListOptions->render("body", "right", $tblPengesahanKHS_list->RowIndex);
?>
<script>
loadjs.ready(["ftblPengesahanKHSlist", "load"], function() {
	ftblPengesahanKHSlist.updateLists(<?php echo $tblPengesahanKHS_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblPengesahanKHS_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblPengesahanKHS_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKHS_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKHS_list->KeyCount ?>">
<?php echo $tblPengesahanKHS_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblPengesahanKHS_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblPengesahanKHS_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKHS_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKHS_list->KeyCount ?>">
<?php echo $tblPengesahanKHS_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblPengesahanKHS->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblPengesahanKHS_list->Recordset)
	$tblPengesahanKHS_list->Recordset->Close();
?>
<?php if (!$tblPengesahanKHS_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblPengesahanKHS_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblPengesahanKHS_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKHS_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblPengesahanKHS_list->TotalRecords == 0 && !$tblPengesahanKHS->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKHS_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblPengesahanKHS_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblPengesahanKHS_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblPengesahanKHS_list->terminate();
?>