<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblPengesahanKRS_list = new tblPengesahanKRS_list();

// Run the page
$tblPengesahanKRS_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblPengesahanKRS_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblPengesahanKRS_list->isExport()) { ?>
<script>
var ftblPengesahanKRSlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblPengesahanKRSlist = currentForm = new ew.Form("ftblPengesahanKRSlist", "list");
	ftblPengesahanKRSlist.formKeyCountName = '<?php echo $tblPengesahanKRS_list->FormKeyCountName ?>';

	// Validate form
	ftblPengesahanKRSlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblPengesahanKRS_list->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Thn_Akademik->caption(), $tblPengesahanKRS_list->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Periode->caption(), $tblPengesahanKRS_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->Kode_Jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Kode_Jp->caption(), $tblPengesahanKRS_list->Kode_Jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->Status_Akd->Required) { ?>
				elm = this.getElements("x" + infix + "_Status_Akd");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Status_Akd->caption(), $tblPengesahanKRS_list->Status_Akd->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->NIDN->caption(), $tblPengesahanKRS_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->Jabatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Jabatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Jabatan->caption(), $tblPengesahanKRS_list->Jabatan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanKRS_list->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->Tanggal->caption(), $tblPengesahanKRS_list->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblPengesahanKRS_list->Tanggal->errorMessage()) ?>");
			<?php if ($tblPengesahanKRS_list->ttd->Required) { ?>
				felm = this.getElements("x" + infix + "_ttd");
				elm = this.getElements("fn_x" + infix + "_ttd");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanKRS_list->ttd->caption(), $tblPengesahanKRS_list->ttd->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblPengesahanKRSlist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Thn_Akademik", false)) return false;
		if (ew.valueChanged(fobj, infix, "Periode", false)) return false;
		if (ew.valueChanged(fobj, infix, "Kode_Jp", false)) return false;
		if (ew.valueChanged(fobj, infix, "Status_Akd", false)) return false;
		if (ew.valueChanged(fobj, infix, "NIDN", false)) return false;
		if (ew.valueChanged(fobj, infix, "Jabatan", false)) return false;
		if (ew.valueChanged(fobj, infix, "Tanggal", false)) return false;
		if (ew.valueChanged(fobj, infix, "ttd", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKRSlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKRSlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKRSlist.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlist.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKRSlist.lists["x_Periode"] = <?php echo $tblPengesahanKRS_list->Periode->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlist.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanKRSlist.lists["x_Kode_Jp"] = <?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlist.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Kode_Jp->lookupOptions()) ?>;
	ftblPengesahanKRSlist.lists["x_Status_Akd"] = <?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlist.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Status_Akd->lookupOptions()) ?>;
	ftblPengesahanKRSlist.lists["x_NIDN"] = <?php echo $tblPengesahanKRS_list->NIDN->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlist.lists["x_NIDN"].options = <?php echo JsonEncode($tblPengesahanKRS_list->NIDN->lookupOptions()) ?>;
	loadjs.done("ftblPengesahanKRSlist");
});
var ftblPengesahanKRSlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblPengesahanKRSlistsrch = currentSearchForm = new ew.Form("ftblPengesahanKRSlistsrch");

	// Validate function for search
	ftblPengesahanKRSlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanKRSlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanKRSlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanKRSlistsrch.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Periode"] = <?php echo $tblPengesahanKRS_list->Periode->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Kode_Jp"] = <?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Kode_Jp->lookupOptions()) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Status_Akd"] = <?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->toClientList($tblPengesahanKRS_list) ?>;
	ftblPengesahanKRSlistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($tblPengesahanKRS_list->Status_Akd->lookupOptions()) ?>;

	// Filters
	ftblPengesahanKRSlistsrch.filterList = <?php echo $tblPengesahanKRS_list->getFilterList() ?>;
	loadjs.done("ftblPengesahanKRSlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblPengesahanKRS_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblPengesahanKRS_list->TotalRecords > 0 && $tblPengesahanKRS_list->ExportOptions->visible()) { ?>
<?php $tblPengesahanKRS_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->ImportOptions->visible()) { ?>
<?php $tblPengesahanKRS_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->SearchOptions->visible()) { ?>
<?php $tblPengesahanKRS_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->FilterOptions->visible()) { ?>
<?php $tblPengesahanKRS_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblPengesahanKRS_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblPengesahanKRS_list->isExport() && !$tblPengesahanKRS->CurrentAction) { ?>
<form name="ftblPengesahanKRSlistsrch" id="ftblPengesahanKRSlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblPengesahanKRSlistsrch-search-panel" class="<?php echo $tblPengesahanKRS_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblPengesahanKRS">
	<div class="ew-extended-search">
<?php

// Render search row
$tblPengesahanKRS->RowType = ROWTYPE_SEARCH;
$tblPengesahanKRS->resetAttributes();
$tblPengesahanKRS_list->renderRow();
?>
<?php if ($tblPengesahanKRS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$tblPengesahanKRS_list->SearchColumnCount++;
		if (($tblPengesahanKRS_list->SearchColumnCount - 1) % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKRS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKRS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $tblPengesahanKRS_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_tblPengesahanKRS_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKRS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblPengesahanKRS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKRS_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($tblPengesahanKRS_list->SearchColumnCount % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Periode->Visible) { // Periode ?>
	<?php
		$tblPengesahanKRS_list->SearchColumnCount++;
		if (($tblPengesahanKRS_list->SearchColumnCount - 1) % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKRS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKRS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblPengesahanKRS_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblPengesahanKRS_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKRS_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblPengesahanKRS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblPengesahanKRS_list->SearchColumnCount % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$tblPengesahanKRS_list->SearchColumnCount++;
		if (($tblPengesahanKRS_list->SearchColumnCount - 1) % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKRS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKRS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $tblPengesahanKRS_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_tblPengesahanKRS_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKRS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $tblPengesahanKRS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKRS_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($tblPengesahanKRS_list->SearchColumnCount % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$tblPengesahanKRS_list->SearchColumnCount++;
		if (($tblPengesahanKRS_list->SearchColumnCount - 1) % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) {
			$tblPengesahanKRS_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblPengesahanKRS_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $tblPengesahanKRS_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_tblPengesahanKRS_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKRS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $tblPengesahanKRS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKRS_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($tblPengesahanKRS_list->SearchColumnCount % $tblPengesahanKRS_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblPengesahanKRS_list->SearchColumnCount % $tblPengesahanKRS_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblPengesahanKRS_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblPengesahanKRS_list->showPageHeader(); ?>
<?php
$tblPengesahanKRS_list->showMessage();
?>
<?php if ($tblPengesahanKRS_list->TotalRecords > 0 || $tblPengesahanKRS->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblPengesahanKRS_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblPengesahanKRS">
<form name="ftblPengesahanKRSlist" id="ftblPengesahanKRSlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblPengesahanKRS">
<div id="gmp_tblPengesahanKRS" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblPengesahanKRS_list->TotalRecords > 0 || $tblPengesahanKRS_list->isGridEdit()) { ?>
<table id="tbl_tblPengesahanKRSlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblPengesahanKRS->RowType = ROWTYPE_HEADER;

// Render list options
$tblPengesahanKRS_list->renderListOptions();

// Render list options (header, left)
$tblPengesahanKRS_list->ListOptions->render("header", "left");
?>
<?php if ($tblPengesahanKRS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKRS_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Thn_Akademik" class="tblPengesahanKRS_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanKRS_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Thn_Akademik) ?>', 1);"><div id="elh_tblPengesahanKRS_Thn_Akademik" class="tblPengesahanKRS_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Periode->Visible) { // Periode ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKRS_list->Periode->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Periode" class="tblPengesahanKRS_Periode"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanKRS_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Periode) ?>', 1);"><div id="elh_tblPengesahanKRS_Periode" class="tblPengesahanKRS_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblPengesahanKRS_list->Kode_Jp->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Kode_Jp" class="tblPengesahanKRS_Kode_Jp"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $tblPengesahanKRS_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Kode_Jp) ?>', 1);"><div id="elh_tblPengesahanKRS_Kode_Jp" class="tblPengesahanKRS_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $tblPengesahanKRS_list->Status_Akd->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Status_Akd" class="tblPengesahanKRS_Status_Akd"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $tblPengesahanKRS_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Status_Akd) ?>', 1);"><div id="elh_tblPengesahanKRS_Status_Akd" class="tblPengesahanKRS_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKRS_list->NIDN->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_NIDN" class="tblPengesahanKRS_NIDN"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanKRS_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->NIDN) ?>', 1);"><div id="elh_tblPengesahanKRS_NIDN" class="tblPengesahanKRS_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Jabatan->Visible) { // Jabatan ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Jabatan) == "") { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKRS_list->Jabatan->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Jabatan" class="tblPengesahanKRS_Jabatan"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Jabatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanKRS_list->Jabatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Jabatan) ?>', 1);"><div id="elh_tblPengesahanKRS_Jabatan" class="tblPengesahanKRS_Jabatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Jabatan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Jabatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Jabatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKRS_list->Tanggal->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_Tanggal" class="tblPengesahanKRS_Tanggal"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanKRS_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->Tanggal) ?>', 1);"><div id="elh_tblPengesahanKRS_Tanggal" class="tblPengesahanKRS_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->ttd->Visible) { // ttd ?>
	<?php if ($tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->ttd) == "") { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKRS_list->ttd->headerCellClass() ?>"><div id="elh_tblPengesahanKRS_ttd" class="tblPengesahanKRS_ttd"><div class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->ttd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanKRS_list->ttd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanKRS_list->SortUrl($tblPengesahanKRS_list->ttd) ?>', 1);"><div id="elh_tblPengesahanKRS_ttd" class="tblPengesahanKRS_ttd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanKRS_list->ttd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanKRS_list->ttd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanKRS_list->ttd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblPengesahanKRS_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblPengesahanKRS_list->ExportAll && $tblPengesahanKRS_list->isExport()) {
	$tblPengesahanKRS_list->StopRecord = $tblPengesahanKRS_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblPengesahanKRS_list->TotalRecords > $tblPengesahanKRS_list->StartRecord + $tblPengesahanKRS_list->DisplayRecords - 1)
		$tblPengesahanKRS_list->StopRecord = $tblPengesahanKRS_list->StartRecord + $tblPengesahanKRS_list->DisplayRecords - 1;
	else
		$tblPengesahanKRS_list->StopRecord = $tblPengesahanKRS_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblPengesahanKRS->isConfirm() || $tblPengesahanKRS_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblPengesahanKRS_list->FormKeyCountName) && ($tblPengesahanKRS_list->isGridAdd() || $tblPengesahanKRS_list->isGridEdit() || $tblPengesahanKRS->isConfirm())) {
		$tblPengesahanKRS_list->KeyCount = $CurrentForm->getValue($tblPengesahanKRS_list->FormKeyCountName);
		$tblPengesahanKRS_list->StopRecord = $tblPengesahanKRS_list->StartRecord + $tblPengesahanKRS_list->KeyCount - 1;
	}
}
$tblPengesahanKRS_list->RecordCount = $tblPengesahanKRS_list->StartRecord - 1;
if ($tblPengesahanKRS_list->Recordset && !$tblPengesahanKRS_list->Recordset->EOF) {
	$tblPengesahanKRS_list->Recordset->moveFirst();
	$selectLimit = $tblPengesahanKRS_list->UseSelectLimit;
	if (!$selectLimit && $tblPengesahanKRS_list->StartRecord > 1)
		$tblPengesahanKRS_list->Recordset->move($tblPengesahanKRS_list->StartRecord - 1);
} elseif (!$tblPengesahanKRS->AllowAddDeleteRow && $tblPengesahanKRS_list->StopRecord == 0) {
	$tblPengesahanKRS_list->StopRecord = $tblPengesahanKRS->GridAddRowCount;
}

// Initialize aggregate
$tblPengesahanKRS->RowType = ROWTYPE_AGGREGATEINIT;
$tblPengesahanKRS->resetAttributes();
$tblPengesahanKRS_list->renderRow();
if ($tblPengesahanKRS_list->isGridAdd())
	$tblPengesahanKRS_list->RowIndex = 0;
if ($tblPengesahanKRS_list->isGridEdit())
	$tblPengesahanKRS_list->RowIndex = 0;
while ($tblPengesahanKRS_list->RecordCount < $tblPengesahanKRS_list->StopRecord) {
	$tblPengesahanKRS_list->RecordCount++;
	if ($tblPengesahanKRS_list->RecordCount >= $tblPengesahanKRS_list->StartRecord) {
		$tblPengesahanKRS_list->RowCount++;
		if ($tblPengesahanKRS_list->isGridAdd() || $tblPengesahanKRS_list->isGridEdit() || $tblPengesahanKRS->isConfirm()) {
			$tblPengesahanKRS_list->RowIndex++;
			$CurrentForm->Index = $tblPengesahanKRS_list->RowIndex;
			if ($CurrentForm->hasValue($tblPengesahanKRS_list->FormActionName) && ($tblPengesahanKRS->isConfirm() || $tblPengesahanKRS_list->EventCancelled))
				$tblPengesahanKRS_list->RowAction = strval($CurrentForm->getValue($tblPengesahanKRS_list->FormActionName));
			elseif ($tblPengesahanKRS_list->isGridAdd())
				$tblPengesahanKRS_list->RowAction = "insert";
			else
				$tblPengesahanKRS_list->RowAction = "";
		}

		// Set up key count
		$tblPengesahanKRS_list->KeyCount = $tblPengesahanKRS_list->RowIndex;

		// Init row class and style
		$tblPengesahanKRS->resetAttributes();
		$tblPengesahanKRS->CssClass = "";
		if ($tblPengesahanKRS_list->isGridAdd()) {
			$tblPengesahanKRS_list->loadRowValues(); // Load default values
		} else {
			$tblPengesahanKRS_list->loadRowValues($tblPengesahanKRS_list->Recordset); // Load row values
		}
		$tblPengesahanKRS->RowType = ROWTYPE_VIEW; // Render view
		if ($tblPengesahanKRS_list->isGridAdd()) // Grid add
			$tblPengesahanKRS->RowType = ROWTYPE_ADD; // Render add
		if ($tblPengesahanKRS_list->isGridAdd() && $tblPengesahanKRS->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblPengesahanKRS_list->restoreCurrentRowFormValues($tblPengesahanKRS_list->RowIndex); // Restore form values
		if ($tblPengesahanKRS_list->isGridEdit()) { // Grid edit
			if ($tblPengesahanKRS->EventCancelled)
				$tblPengesahanKRS_list->restoreCurrentRowFormValues($tblPengesahanKRS_list->RowIndex); // Restore form values
			if ($tblPengesahanKRS_list->RowAction == "insert")
				$tblPengesahanKRS->RowType = ROWTYPE_ADD; // Render add
			else
				$tblPengesahanKRS->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblPengesahanKRS_list->isGridEdit() && ($tblPengesahanKRS->RowType == ROWTYPE_EDIT || $tblPengesahanKRS->RowType == ROWTYPE_ADD) && $tblPengesahanKRS->EventCancelled) // Update failed
			$tblPengesahanKRS_list->restoreCurrentRowFormValues($tblPengesahanKRS_list->RowIndex); // Restore form values
		if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) // Edit row
			$tblPengesahanKRS_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblPengesahanKRS->RowAttrs->merge(["data-rowindex" => $tblPengesahanKRS_list->RowCount, "id" => "r" . $tblPengesahanKRS_list->RowCount . "_tblPengesahanKRS", "data-rowtype" => $tblPengesahanKRS->RowType]);

		// Render row
		$tblPengesahanKRS_list->renderRow();

		// Render list options
		$tblPengesahanKRS_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblPengesahanKRS_list->RowAction != "delete" && $tblPengesahanKRS_list->RowAction != "insertdelete" && !($tblPengesahanKRS_list->RowAction == "insert" && $tblPengesahanKRS->isConfirm() && $tblPengesahanKRS_list->emptyRow())) {
?>
	<tr <?php echo $tblPengesahanKRS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKRS_list->ListOptions->render("body", "left", $tblPengesahanKRS_list->RowCount);
?>
	<?php if ($tblPengesahanKRS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblPengesahanKRS_list->Thn_Akademik->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Thn_Akademik" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKRS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKRS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKRS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKRS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Thn_Akademik") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Thn_Akademik->OldValue != null ? $tblPengesahanKRS_list->Thn_Akademik->OldValue : $tblPengesahanKRS_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Thn_Akademik">
<span<?php echo $tblPengesahanKRS_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Thn_Akademik->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblPengesahanKRS_list->Periode->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKRS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKRS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Periode->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Periode" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKRS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKRS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Periode->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Periode" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Periode->OldValue != null ? $tblPengesahanKRS_list->Periode->OldValue : $tblPengesahanKRS_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Periode">
<span<?php echo $tblPengesahanKRS_list->Periode->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $tblPengesahanKRS_list->Kode_Jp->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Kode_Jp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKRS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKRS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Kode_Jp->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKRS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKRS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Kode_Jp") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Kode_Jp->OldValue != null ? $tblPengesahanKRS_list->Kode_Jp->OldValue : $tblPengesahanKRS_list->Kode_Jp->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Kode_Jp">
<span<?php echo $tblPengesahanKRS_list->Kode_Jp->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Kode_Jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $tblPengesahanKRS_list->Status_Akd->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Status_Akd" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKRS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKRS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Status_Akd") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Status_Akd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKRS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKRS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Status_Akd") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Status_Akd->OldValue != null ? $tblPengesahanKRS_list->Status_Akd->OldValue : $tblPengesahanKRS_list->Status_Akd->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Status_Akd">
<span<?php echo $tblPengesahanKRS_list->Status_Akd->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Status_Akd->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblPengesahanKRS_list->NIDN->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKRS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKRS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKRS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKRS_list->NIDN->ReadOnly || $tblPengesahanKRS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKRS_list->NIDN->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKRS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKRS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKRS_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_NIDN" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKRS_list->NIDN->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKRS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKRS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKRS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKRS_list->NIDN->ReadOnly || $tblPengesahanKRS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKRS_list->NIDN->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKRS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKRS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKRS_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_NIDN">
<span<?php echo $tblPengesahanKRS_list->NIDN->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan" <?php echo $tblPengesahanKRS_list->Jabatan->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" size="50" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKRS_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Jabatan->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" size="50" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKRS_list->Jabatan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Jabatan">
<span<?php echo $tblPengesahanKRS_list->Jabatan->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Jabatan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $tblPengesahanKRS_list->Tanggal->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKRS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKRS_list->Tanggal->ReadOnly && !$tblPengesahanKRS_list->Tanggal->Disabled && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKRSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKRSlist", "x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Tanggal->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKRS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKRS_list->Tanggal->ReadOnly && !$tblPengesahanKRS_list->Tanggal->Disabled && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKRSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKRSlist", "x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_Tanggal">
<span<?php echo $tblPengesahanKRS_list->Tanggal->viewAttributes() ?>><?php echo $tblPengesahanKRS_list->Tanggal->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd" <?php echo $tblPengesahanKRS_list->ttd->cellAttributes() ?>>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKRS_list->ttd->title() ?>" data-table="tblPengesahanKRS" data-field="x_ttd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKRS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKRS_list->ttd->ReadOnly || $tblPengesahanKRS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_ttd" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKRS_list->ttd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKRS_list->ttd->title() ?>" data-table="tblPengesahanKRS" data-field="x_ttd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKRS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKRS_list->ttd->ReadOnly || $tblPengesahanKRS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo (Post("fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd") == "0") ? "0" : "1" ?>">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanKRS_list->RowCount ?>_tblPengesahanKRS_ttd">
<span><?php echo GetFileViewTag($tblPengesahanKRS_list->ttd, $tblPengesahanKRS_list->ttd->getViewValue(), FALSE) ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKRS_list->ListOptions->render("body", "right", $tblPengesahanKRS_list->RowCount);
?>
	</tr>
<?php if ($tblPengesahanKRS->RowType == ROWTYPE_ADD || $tblPengesahanKRS->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblPengesahanKRSlist", "load"], function() {
	ftblPengesahanKRSlist.updateLists(<?php echo $tblPengesahanKRS_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblPengesahanKRS_list->isGridAdd())
		if (!$tblPengesahanKRS_list->Recordset->EOF)
			$tblPengesahanKRS_list->Recordset->moveNext();
}
?>
<?php
	if ($tblPengesahanKRS_list->isGridAdd() || $tblPengesahanKRS_list->isGridEdit()) {
		$tblPengesahanKRS_list->RowIndex = '$rowindex$';
		$tblPengesahanKRS_list->loadRowValues();

		// Set row properties
		$tblPengesahanKRS->resetAttributes();
		$tblPengesahanKRS->RowAttrs->merge(["data-rowindex" => $tblPengesahanKRS_list->RowIndex, "id" => "r0_tblPengesahanKRS", "data-rowtype" => ROWTYPE_ADD]);
		$tblPengesahanKRS->RowAttrs->appendClass("ew-template");
		$tblPengesahanKRS->RowType = ROWTYPE_ADD;

		// Render row
		$tblPengesahanKRS_list->renderRow();

		// Render list options
		$tblPengesahanKRS_list->renderListOptions();
		$tblPengesahanKRS_list->StartRowCount = 0;
?>
	<tr <?php echo $tblPengesahanKRS->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanKRS_list->ListOptions->render("body", "left", $tblPengesahanKRS_list->RowIndex);
?>
	<?php if ($tblPengesahanKRS_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik">
<span id="el$rowindex$_tblPengesahanKRS_Thn_Akademik" class="form-group tblPengesahanKRS_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanKRS_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanKRS_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Thn_Akademik->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode">
<span id="el$rowindex$_tblPengesahanKRS_Periode" class="form-group tblPengesahanKRS_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanKRS_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode"<?php echo $tblPengesahanKRS_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Periode->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Periode" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Periode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp">
<span id="el$rowindex$_tblPengesahanKRS_Kode_Jp" class="form-group tblPengesahanKRS_Kode_Jp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" data-value-separator="<?php echo $tblPengesahanKRS_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp"<?php echo $tblPengesahanKRS_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Kode_Jp->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Kode_Jp->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Kode_Jp" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Kode_Jp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd">
<span id="el$rowindex$_tblPengesahanKRS_Status_Akd" class="form-group tblPengesahanKRS_Status_Akd">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanKRS" data-field="x_Status_Akd" data-value-separator="<?php echo $tblPengesahanKRS_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd"<?php echo $tblPengesahanKRS_list->Status_Akd->editAttributes() ?>>
			<?php echo $tblPengesahanKRS_list->Status_Akd->selectOptionListHtml("x{$tblPengesahanKRS_list->RowIndex}_Status_Akd") ?>
		</select>
</div>
<?php echo $tblPengesahanKRS_list->Status_Akd->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_Status_Akd") ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Status_Akd" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Status_Akd" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Status_Akd->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el$rowindex$_tblPengesahanKRS_NIDN" class="form-group tblPengesahanKRS_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanKRS_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanKRS_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanKRS_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanKRS_list->NIDN->ReadOnly || $tblPengesahanKRS_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanKRS_list->NIDN->Lookup->getParamTag($tblPengesahanKRS_list, "p_x" . $tblPengesahanKRS_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanKRS_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanKRS_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanKRS_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_NIDN" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanKRS_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan">
<span id="el$rowindex$_tblPengesahanKRS_Jabatan" class="form-group tblPengesahanKRS_Jabatan">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Jabatan" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" size="50" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanKRS_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Jabatan" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Jabatan->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal">
<span id="el$rowindex$_tblPengesahanKRS_Tanggal" class="form-group tblPengesahanKRS_Tanggal">
<input type="text" data-table="tblPengesahanKRS" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanKRS_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanKRS_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanKRS_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanKRS_list->Tanggal->ReadOnly && !$tblPengesahanKRS_list->Tanggal->Disabled && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanKRS_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanKRSlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanKRSlist", "x<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_Tanggal" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanKRS_list->Tanggal->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanKRS_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd">
<span id="el$rowindex$_tblPengesahanKRS_ttd" class="form-group tblPengesahanKRS_ttd">
<div id="fd_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanKRS_list->ttd->title() ?>" data-table="tblPengesahanKRS" data-field="x_ttd" name="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanKRS_list->ttd->editAttributes() ?><?php if ($tblPengesahanKRS_list->ttd->ReadOnly || $tblPengesahanKRS_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanKRS_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanKRS" data-field="x_ttd" name="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanKRS_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanKRS_list->ttd->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanKRS_list->ListOptions->render("body", "right", $tblPengesahanKRS_list->RowIndex);
?>
<script>
loadjs.ready(["ftblPengesahanKRSlist", "load"], function() {
	ftblPengesahanKRSlist.updateLists(<?php echo $tblPengesahanKRS_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblPengesahanKRS_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblPengesahanKRS_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKRS_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKRS_list->KeyCount ?>">
<?php echo $tblPengesahanKRS_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblPengesahanKRS_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblPengesahanKRS_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanKRS_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanKRS_list->KeyCount ?>">
<?php echo $tblPengesahanKRS_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblPengesahanKRS->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblPengesahanKRS_list->Recordset)
	$tblPengesahanKRS_list->Recordset->Close();
?>
<?php if (!$tblPengesahanKRS_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblPengesahanKRS_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblPengesahanKRS_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKRS_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblPengesahanKRS_list->TotalRecords == 0 && !$tblPengesahanKRS->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblPengesahanKRS_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblPengesahanKRS_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblPengesahanKRS_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblPengesahanKRS_list->terminate();
?>