<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblPengesahanPMB_list = new tblPengesahanPMB_list();

// Run the page
$tblPengesahanPMB_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblPengesahanPMB_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblPengesahanPMB_list->isExport()) { ?>
<script>
var ftblPengesahanPMBlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblPengesahanPMBlist = currentForm = new ew.Form("ftblPengesahanPMBlist", "list");
	ftblPengesahanPMBlist.formKeyCountName = '<?php echo $tblPengesahanPMB_list->FormKeyCountName ?>';

	// Validate form
	ftblPengesahanPMBlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblPengesahanPMB_list->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->Thn_Akademik->caption(), $tblPengesahanPMB_list->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanPMB_list->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->Periode->caption(), $tblPengesahanPMB_list->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanPMB_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->NIDN->caption(), $tblPengesahanPMB_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanPMB_list->Jabatan->Required) { ?>
				elm = this.getElements("x" + infix + "_Jabatan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->Jabatan->caption(), $tblPengesahanPMB_list->Jabatan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblPengesahanPMB_list->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->Tanggal->caption(), $tblPengesahanPMB_list->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblPengesahanPMB_list->Tanggal->errorMessage()) ?>");
			<?php if ($tblPengesahanPMB_list->ttd->Required) { ?>
				felm = this.getElements("x" + infix + "_ttd");
				elm = this.getElements("fn_x" + infix + "_ttd");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblPengesahanPMB_list->ttd->caption(), $tblPengesahanPMB_list->ttd->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblPengesahanPMBlist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Thn_Akademik", false)) return false;
		if (ew.valueChanged(fobj, infix, "Periode", false)) return false;
		if (ew.valueChanged(fobj, infix, "NIDN", false)) return false;
		if (ew.valueChanged(fobj, infix, "Jabatan", false)) return false;
		if (ew.valueChanged(fobj, infix, "Tanggal", false)) return false;
		if (ew.valueChanged(fobj, infix, "ttd", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblPengesahanPMBlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblPengesahanPMBlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblPengesahanPMBlist.lists["x_Thn_Akademik"] = <?php echo $tblPengesahanPMB_list->Thn_Akademik->Lookup->toClientList($tblPengesahanPMB_list) ?>;
	ftblPengesahanPMBlist.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblPengesahanPMB_list->Thn_Akademik->lookupOptions()) ?>;
	ftblPengesahanPMBlist.lists["x_Periode"] = <?php echo $tblPengesahanPMB_list->Periode->Lookup->toClientList($tblPengesahanPMB_list) ?>;
	ftblPengesahanPMBlist.lists["x_Periode"].options = <?php echo JsonEncode($tblPengesahanPMB_list->Periode->options(FALSE, TRUE)) ?>;
	ftblPengesahanPMBlist.lists["x_NIDN"] = <?php echo $tblPengesahanPMB_list->NIDN->Lookup->toClientList($tblPengesahanPMB_list) ?>;
	ftblPengesahanPMBlist.lists["x_NIDN"].options = <?php echo JsonEncode($tblPengesahanPMB_list->NIDN->lookupOptions()) ?>;
	loadjs.done("ftblPengesahanPMBlist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblPengesahanPMB_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblPengesahanPMB_list->TotalRecords > 0 && $tblPengesahanPMB_list->ExportOptions->visible()) { ?>
<?php $tblPengesahanPMB_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->ImportOptions->visible()) { ?>
<?php $tblPengesahanPMB_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblPengesahanPMB_list->renderOtherOptions();
?>
<?php $tblPengesahanPMB_list->showPageHeader(); ?>
<?php
$tblPengesahanPMB_list->showMessage();
?>
<?php if ($tblPengesahanPMB_list->TotalRecords > 0 || $tblPengesahanPMB->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblPengesahanPMB_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblPengesahanPMB">
<form name="ftblPengesahanPMBlist" id="ftblPengesahanPMBlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblPengesahanPMB">
<div id="gmp_tblPengesahanPMB" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblPengesahanPMB_list->TotalRecords > 0 || $tblPengesahanPMB_list->isGridEdit()) { ?>
<table id="tbl_tblPengesahanPMBlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblPengesahanPMB->RowType = ROWTYPE_HEADER;

// Render list options
$tblPengesahanPMB_list->renderListOptions();

// Render list options (header, left)
$tblPengesahanPMB_list->ListOptions->render("header", "left");
?>
<?php if ($tblPengesahanPMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanPMB_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_Thn_Akademik" class="tblPengesahanPMB_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblPengesahanPMB_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Thn_Akademik) ?>', 1);"><div id="elh_tblPengesahanPMB_Thn_Akademik" class="tblPengesahanPMB_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->Periode->Visible) { // Periode ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanPMB_list->Periode->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_Periode" class="tblPengesahanPMB_Periode"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblPengesahanPMB_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Periode) ?>', 1);"><div id="elh_tblPengesahanPMB_Periode" class="tblPengesahanPMB_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanPMB_list->NIDN->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_NIDN" class="tblPengesahanPMB_NIDN"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblPengesahanPMB_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->NIDN) ?>', 1);"><div id="elh_tblPengesahanPMB_NIDN" class="tblPengesahanPMB_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->Jabatan->Visible) { // Jabatan ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Jabatan) == "") { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanPMB_list->Jabatan->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_Jabatan" class="tblPengesahanPMB_Jabatan"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Jabatan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jabatan" class="<?php echo $tblPengesahanPMB_list->Jabatan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Jabatan) ?>', 1);"><div id="elh_tblPengesahanPMB_Jabatan" class="tblPengesahanPMB_Jabatan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Jabatan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->Jabatan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->Jabatan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanPMB_list->Tanggal->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_Tanggal" class="tblPengesahanPMB_Tanggal"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $tblPengesahanPMB_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->Tanggal) ?>', 1);"><div id="elh_tblPengesahanPMB_Tanggal" class="tblPengesahanPMB_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->ttd->Visible) { // ttd ?>
	<?php if ($tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->ttd) == "") { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanPMB_list->ttd->headerCellClass() ?>"><div id="elh_tblPengesahanPMB_ttd" class="tblPengesahanPMB_ttd"><div class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->ttd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ttd" class="<?php echo $tblPengesahanPMB_list->ttd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblPengesahanPMB_list->SortUrl($tblPengesahanPMB_list->ttd) ?>', 1);"><div id="elh_tblPengesahanPMB_ttd" class="tblPengesahanPMB_ttd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblPengesahanPMB_list->ttd->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblPengesahanPMB_list->ttd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblPengesahanPMB_list->ttd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblPengesahanPMB_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblPengesahanPMB_list->ExportAll && $tblPengesahanPMB_list->isExport()) {
	$tblPengesahanPMB_list->StopRecord = $tblPengesahanPMB_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblPengesahanPMB_list->TotalRecords > $tblPengesahanPMB_list->StartRecord + $tblPengesahanPMB_list->DisplayRecords - 1)
		$tblPengesahanPMB_list->StopRecord = $tblPengesahanPMB_list->StartRecord + $tblPengesahanPMB_list->DisplayRecords - 1;
	else
		$tblPengesahanPMB_list->StopRecord = $tblPengesahanPMB_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblPengesahanPMB->isConfirm() || $tblPengesahanPMB_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblPengesahanPMB_list->FormKeyCountName) && ($tblPengesahanPMB_list->isGridAdd() || $tblPengesahanPMB_list->isGridEdit() || $tblPengesahanPMB->isConfirm())) {
		$tblPengesahanPMB_list->KeyCount = $CurrentForm->getValue($tblPengesahanPMB_list->FormKeyCountName);
		$tblPengesahanPMB_list->StopRecord = $tblPengesahanPMB_list->StartRecord + $tblPengesahanPMB_list->KeyCount - 1;
	}
}
$tblPengesahanPMB_list->RecordCount = $tblPengesahanPMB_list->StartRecord - 1;
if ($tblPengesahanPMB_list->Recordset && !$tblPengesahanPMB_list->Recordset->EOF) {
	$tblPengesahanPMB_list->Recordset->moveFirst();
	$selectLimit = $tblPengesahanPMB_list->UseSelectLimit;
	if (!$selectLimit && $tblPengesahanPMB_list->StartRecord > 1)
		$tblPengesahanPMB_list->Recordset->move($tblPengesahanPMB_list->StartRecord - 1);
} elseif (!$tblPengesahanPMB->AllowAddDeleteRow && $tblPengesahanPMB_list->StopRecord == 0) {
	$tblPengesahanPMB_list->StopRecord = $tblPengesahanPMB->GridAddRowCount;
}

// Initialize aggregate
$tblPengesahanPMB->RowType = ROWTYPE_AGGREGATEINIT;
$tblPengesahanPMB->resetAttributes();
$tblPengesahanPMB_list->renderRow();
if ($tblPengesahanPMB_list->isGridAdd())
	$tblPengesahanPMB_list->RowIndex = 0;
if ($tblPengesahanPMB_list->isGridEdit())
	$tblPengesahanPMB_list->RowIndex = 0;
while ($tblPengesahanPMB_list->RecordCount < $tblPengesahanPMB_list->StopRecord) {
	$tblPengesahanPMB_list->RecordCount++;
	if ($tblPengesahanPMB_list->RecordCount >= $tblPengesahanPMB_list->StartRecord) {
		$tblPengesahanPMB_list->RowCount++;
		if ($tblPengesahanPMB_list->isGridAdd() || $tblPengesahanPMB_list->isGridEdit() || $tblPengesahanPMB->isConfirm()) {
			$tblPengesahanPMB_list->RowIndex++;
			$CurrentForm->Index = $tblPengesahanPMB_list->RowIndex;
			if ($CurrentForm->hasValue($tblPengesahanPMB_list->FormActionName) && ($tblPengesahanPMB->isConfirm() || $tblPengesahanPMB_list->EventCancelled))
				$tblPengesahanPMB_list->RowAction = strval($CurrentForm->getValue($tblPengesahanPMB_list->FormActionName));
			elseif ($tblPengesahanPMB_list->isGridAdd())
				$tblPengesahanPMB_list->RowAction = "insert";
			else
				$tblPengesahanPMB_list->RowAction = "";
		}

		// Set up key count
		$tblPengesahanPMB_list->KeyCount = $tblPengesahanPMB_list->RowIndex;

		// Init row class and style
		$tblPengesahanPMB->resetAttributes();
		$tblPengesahanPMB->CssClass = "";
		if ($tblPengesahanPMB_list->isGridAdd()) {
			$tblPengesahanPMB_list->loadRowValues(); // Load default values
		} else {
			$tblPengesahanPMB_list->loadRowValues($tblPengesahanPMB_list->Recordset); // Load row values
		}
		$tblPengesahanPMB->RowType = ROWTYPE_VIEW; // Render view
		if ($tblPengesahanPMB_list->isGridAdd()) // Grid add
			$tblPengesahanPMB->RowType = ROWTYPE_ADD; // Render add
		if ($tblPengesahanPMB_list->isGridAdd() && $tblPengesahanPMB->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblPengesahanPMB_list->restoreCurrentRowFormValues($tblPengesahanPMB_list->RowIndex); // Restore form values
		if ($tblPengesahanPMB_list->isGridEdit()) { // Grid edit
			if ($tblPengesahanPMB->EventCancelled)
				$tblPengesahanPMB_list->restoreCurrentRowFormValues($tblPengesahanPMB_list->RowIndex); // Restore form values
			if ($tblPengesahanPMB_list->RowAction == "insert")
				$tblPengesahanPMB->RowType = ROWTYPE_ADD; // Render add
			else
				$tblPengesahanPMB->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblPengesahanPMB_list->isGridEdit() && ($tblPengesahanPMB->RowType == ROWTYPE_EDIT || $tblPengesahanPMB->RowType == ROWTYPE_ADD) && $tblPengesahanPMB->EventCancelled) // Update failed
			$tblPengesahanPMB_list->restoreCurrentRowFormValues($tblPengesahanPMB_list->RowIndex); // Restore form values
		if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) // Edit row
			$tblPengesahanPMB_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblPengesahanPMB->RowAttrs->merge(["data-rowindex" => $tblPengesahanPMB_list->RowCount, "id" => "r" . $tblPengesahanPMB_list->RowCount . "_tblPengesahanPMB", "data-rowtype" => $tblPengesahanPMB->RowType]);

		// Render row
		$tblPengesahanPMB_list->renderRow();

		// Render list options
		$tblPengesahanPMB_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblPengesahanPMB_list->RowAction != "delete" && $tblPengesahanPMB_list->RowAction != "insertdelete" && !($tblPengesahanPMB_list->RowAction == "insert" && $tblPengesahanPMB->isConfirm() && $tblPengesahanPMB_list->emptyRow())) {
?>
	<tr <?php echo $tblPengesahanPMB->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanPMB_list->ListOptions->render("body", "left", $tblPengesahanPMB_list->RowCount);
?>
	<?php if ($tblPengesahanPMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblPengesahanPMB_list->Thn_Akademik->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Thn_Akademik" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanPMB_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanPMB_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanPMB_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanPMB_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanPMB_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanPMB_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_Thn_Akademik") ?>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Thn_Akademik->OldValue != null ? $tblPengesahanPMB_list->Thn_Akademik->OldValue : $tblPengesahanPMB_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Thn_Akademik">
<span<?php echo $tblPengesahanPMB_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblPengesahanPMB_list->Thn_Akademik->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblPengesahanPMB_list->Periode->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Periode" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanPMB_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode"<?php echo $tblPengesahanPMB_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Periode->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Periode" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanPMB_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode"<?php echo $tblPengesahanPMB_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Periode->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Periode") ?>
		</select>
</div>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Periode" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Periode->OldValue != null ? $tblPengesahanPMB_list->Periode->OldValue : $tblPengesahanPMB_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Periode">
<span<?php echo $tblPengesahanPMB_list->Periode->viewAttributes() ?>><?php echo $tblPengesahanPMB_list->Periode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblPengesahanPMB_list->NIDN->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanPMB_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanPMB_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanPMB_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanPMB_list->NIDN->ReadOnly || $tblPengesahanPMB_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanPMB_list->NIDN->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanPMB_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanPMB_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanPMB_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_NIDN" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanPMB_list->NIDN->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanPMB_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanPMB_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanPMB_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanPMB_list->NIDN->ReadOnly || $tblPengesahanPMB_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanPMB_list->NIDN->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanPMB_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanPMB_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanPMB_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_NIDN">
<span<?php echo $tblPengesahanPMB_list->NIDN->viewAttributes() ?>><?php echo $tblPengesahanPMB_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan" <?php echo $tblPengesahanPMB_list->Jabatan->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Jabatan" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" size="60" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanPMB_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Jabatan" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Jabatan->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Jabatan" class="form-group">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Jabatan" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" size="60" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanPMB_list->Jabatan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Jabatan">
<span<?php echo $tblPengesahanPMB_list->Jabatan->viewAttributes() ?>><?php echo $tblPengesahanPMB_list->Jabatan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $tblPengesahanPMB_list->Tanggal->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanPMB_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanPMB_list->Tanggal->ReadOnly && !$tblPengesahanPMB_list->Tanggal->Disabled && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanPMBlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanPMBlist", "x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Tanggal" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Tanggal->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Tanggal" class="form-group">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanPMB_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanPMB_list->Tanggal->ReadOnly && !$tblPengesahanPMB_list->Tanggal->Disabled && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanPMBlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanPMBlist", "x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_Tanggal">
<span<?php echo $tblPengesahanPMB_list->Tanggal->viewAttributes() ?>><?php echo $tblPengesahanPMB_list->Tanggal->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd" <?php echo $tblPengesahanPMB_list->ttd->cellAttributes() ?>>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanPMB_list->ttd->title() ?>" data-table="tblPengesahanPMB" data-field="x_ttd" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanPMB_list->ttd->editAttributes() ?><?php if ($tblPengesahanPMB_list->ttd->ReadOnly || $tblPengesahanPMB_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_ttd" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanPMB_list->ttd->OldValue) ?>">
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_ttd" class="form-group">
<div id="fd_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanPMB_list->ttd->title() ?>" data-table="tblPengesahanPMB" data-field="x_ttd" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanPMB_list->ttd->editAttributes() ?><?php if ($tblPengesahanPMB_list->ttd->ReadOnly || $tblPengesahanPMB_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo (Post("fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd") == "0") ? "0" : "1" ?>">
<input type="hidden" name="fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblPengesahanPMB_list->RowCount ?>_tblPengesahanPMB_ttd">
<span><?php echo GetFileViewTag($tblPengesahanPMB_list->ttd, $tblPengesahanPMB_list->ttd->getViewValue(), FALSE) ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanPMB_list->ListOptions->render("body", "right", $tblPengesahanPMB_list->RowCount);
?>
	</tr>
<?php if ($tblPengesahanPMB->RowType == ROWTYPE_ADD || $tblPengesahanPMB->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblPengesahanPMBlist", "load"], function() {
	ftblPengesahanPMBlist.updateLists(<?php echo $tblPengesahanPMB_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblPengesahanPMB_list->isGridAdd())
		if (!$tblPengesahanPMB_list->Recordset->EOF)
			$tblPengesahanPMB_list->Recordset->moveNext();
}
?>
<?php
	if ($tblPengesahanPMB_list->isGridAdd() || $tblPengesahanPMB_list->isGridEdit()) {
		$tblPengesahanPMB_list->RowIndex = '$rowindex$';
		$tblPengesahanPMB_list->loadRowValues();

		// Set row properties
		$tblPengesahanPMB->resetAttributes();
		$tblPengesahanPMB->RowAttrs->merge(["data-rowindex" => $tblPengesahanPMB_list->RowIndex, "id" => "r0_tblPengesahanPMB", "data-rowtype" => ROWTYPE_ADD]);
		$tblPengesahanPMB->RowAttrs->appendClass("ew-template");
		$tblPengesahanPMB->RowType = ROWTYPE_ADD;

		// Render row
		$tblPengesahanPMB_list->renderRow();

		// Render list options
		$tblPengesahanPMB_list->renderListOptions();
		$tblPengesahanPMB_list->StartRowCount = 0;
?>
	<tr <?php echo $tblPengesahanPMB->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblPengesahanPMB_list->ListOptions->render("body", "left", $tblPengesahanPMB_list->RowIndex);
?>
	<?php if ($tblPengesahanPMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik">
<span id="el$rowindex$_tblPengesahanPMB_Thn_Akademik" class="form-group tblPengesahanPMB_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblPengesahanPMB_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik"<?php echo $tblPengesahanPMB_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Thn_Akademik->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblPengesahanPMB_list->Thn_Akademik->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_Thn_Akademik") ?>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Thn_Akademik" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Thn_Akademik->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode">
<span id="el$rowindex$_tblPengesahanPMB_Periode" class="form-group tblPengesahanPMB_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblPengesahanPMB" data-field="x_Periode" data-value-separator="<?php echo $tblPengesahanPMB_list->Periode->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode"<?php echo $tblPengesahanPMB_list->Periode->editAttributes() ?>>
			<?php echo $tblPengesahanPMB_list->Periode->selectOptionListHtml("x{$tblPengesahanPMB_list->RowIndex}_Periode") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Periode" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Periode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el$rowindex$_tblPengesahanPMB_NIDN" class="form-group tblPengesahanPMB_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tblPengesahanPMB_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblPengesahanPMB_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblPengesahanPMB_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblPengesahanPMB_list->NIDN->ReadOnly || $tblPengesahanPMB_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblPengesahanPMB_list->NIDN->Lookup->getParamTag($tblPengesahanPMB_list, "p_x" . $tblPengesahanPMB_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblPengesahanPMB_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" value="<?php echo $tblPengesahanPMB_list->NIDN->CurrentValue ?>"<?php echo $tblPengesahanPMB_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_NIDN" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tblPengesahanPMB_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Jabatan->Visible) { // Jabatan ?>
		<td data-name="Jabatan">
<span id="el$rowindex$_tblPengesahanPMB_Jabatan" class="form-group tblPengesahanPMB_Jabatan">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Jabatan" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" size="60" maxlength="75" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Jabatan->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Jabatan->EditValue ?>"<?php echo $tblPengesahanPMB_list->Jabatan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Jabatan" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Jabatan" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Jabatan->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal">
<span id="el$rowindex$_tblPengesahanPMB_Tanggal" class="form-group tblPengesahanPMB_Tanggal">
<input type="text" data-table="tblPengesahanPMB" data-field="x_Tanggal" data-format="7" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblPengesahanPMB_list->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblPengesahanPMB_list->Tanggal->EditValue ?>"<?php echo $tblPengesahanPMB_list->Tanggal->editAttributes() ?>>
<?php if (!$tblPengesahanPMB_list->Tanggal->ReadOnly && !$tblPengesahanPMB_list->Tanggal->Disabled && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["readonly"]) && !isset($tblPengesahanPMB_list->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblPengesahanPMBlist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblPengesahanPMBlist", "x<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_Tanggal" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_Tanggal" value="<?php echo HtmlEncode($tblPengesahanPMB_list->Tanggal->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblPengesahanPMB_list->ttd->Visible) { // ttd ?>
		<td data-name="ttd">
<span id="el$rowindex$_tblPengesahanPMB_ttd" class="form-group tblPengesahanPMB_ttd">
<div id="fd_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblPengesahanPMB_list->ttd->title() ?>" data-table="tblPengesahanPMB" data-field="x_ttd" name="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblPengesahanPMB_list->ttd->editAttributes() ?><?php if ($tblPengesahanPMB_list->ttd->ReadOnly || $tblPengesahanPMB_list->ttd->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fn_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->Upload->FileName ?>">
<input type="hidden" name="fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fa_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="0">
<input type="hidden" name="fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fs_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="75">
<input type="hidden" name="fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fx_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id= "fm_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo $tblPengesahanPMB_list->ttd->UploadMaxFileSize ?>">
</div>
<table id="ft_x<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="tblPengesahanPMB" data-field="x_ttd" name="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" id="o<?php echo $tblPengesahanPMB_list->RowIndex ?>_ttd" value="<?php echo HtmlEncode($tblPengesahanPMB_list->ttd->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblPengesahanPMB_list->ListOptions->render("body", "right", $tblPengesahanPMB_list->RowIndex);
?>
<script>
loadjs.ready(["ftblPengesahanPMBlist", "load"], function() {
	ftblPengesahanPMBlist.updateLists(<?php echo $tblPengesahanPMB_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblPengesahanPMB_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblPengesahanPMB_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanPMB_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanPMB_list->KeyCount ?>">
<?php echo $tblPengesahanPMB_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblPengesahanPMB_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblPengesahanPMB_list->FormKeyCountName ?>" id="<?php echo $tblPengesahanPMB_list->FormKeyCountName ?>" value="<?php echo $tblPengesahanPMB_list->KeyCount ?>">
<?php echo $tblPengesahanPMB_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblPengesahanPMB->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblPengesahanPMB_list->Recordset)
	$tblPengesahanPMB_list->Recordset->Close();
?>
<?php if (!$tblPengesahanPMB_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblPengesahanPMB_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblPengesahanPMB_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblPengesahanPMB_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblPengesahanPMB_list->TotalRecords == 0 && !$tblPengesahanPMB->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblPengesahanPMB_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblPengesahanPMB_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblPengesahanPMB_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblPengesahanPMB_list->terminate();
?>