<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblSK_PMB_Lulus_list = new tblSK_PMB_Lulus_list();

// Run the page
$tblSK_PMB_Lulus_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblSK_PMB_Lulus_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblSK_PMB_Lulus_list->isExport()) { ?>
<script>
var ftblSK_PMB_Luluslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblSK_PMB_Luluslist = currentForm = new ew.Form("ftblSK_PMB_Luluslist", "list");
	ftblSK_PMB_Luluslist.formKeyCountName = '<?php echo $tblSK_PMB_Lulus_list->FormKeyCountName ?>';

	// Validate form
	ftblSK_PMB_Luluslist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblSK_PMB_Lulus_list->Nim->Required) { ?>
				elm = this.getElements("x" + infix + "_Nim");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_Lulus_list->Nim->caption(), $tblSK_PMB_Lulus_list->Nim->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_Lulus_list->kode_jp->Required) { ?>
				elm = this.getElements("x" + infix + "_kode_jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_Lulus_list->kode_jp->caption(), $tblSK_PMB_Lulus_list->kode_jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_Lulus_list->tmplahir->Required) { ?>
				elm = this.getElements("x" + infix + "_tmplahir");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_Lulus_list->tmplahir->caption(), $tblSK_PMB_Lulus_list->tmplahir->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_Lulus_list->tgllahir->Required) { ?>
				elm = this.getElements("x" + infix + "_tgllahir");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_Lulus_list->tgllahir->caption(), $tblSK_PMB_Lulus_list->tgllahir->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tgllahir");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblSK_PMB_Lulus_list->tgllahir->errorMessage()) ?>");
			<?php if ($tblSK_PMB_Lulus_list->Keterangan->Required) { ?>
				elm = this.getElements("x" + infix + "_Keterangan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_Lulus_list->Keterangan->caption(), $tblSK_PMB_Lulus_list->Keterangan->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblSK_PMB_Luluslist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "Nim", false)) return false;
		if (ew.valueChanged(fobj, infix, "kode_jp", false)) return false;
		if (ew.valueChanged(fobj, infix, "tmplahir", false)) return false;
		if (ew.valueChanged(fobj, infix, "tgllahir", false)) return false;
		if (ew.valueChanged(fobj, infix, "Keterangan", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblSK_PMB_Luluslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblSK_PMB_Luluslist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblSK_PMB_Luluslist.lists["x_Nim"] = <?php echo $tblSK_PMB_Lulus_list->Nim->Lookup->toClientList($tblSK_PMB_Lulus_list) ?>;
	ftblSK_PMB_Luluslist.lists["x_Nim"].options = <?php echo JsonEncode($tblSK_PMB_Lulus_list->Nim->lookupOptions()) ?>;
	ftblSK_PMB_Luluslist.lists["x_kode_jp"] = <?php echo $tblSK_PMB_Lulus_list->kode_jp->Lookup->toClientList($tblSK_PMB_Lulus_list) ?>;
	ftblSK_PMB_Luluslist.lists["x_kode_jp"].options = <?php echo JsonEncode($tblSK_PMB_Lulus_list->kode_jp->lookupOptions()) ?>;
	ftblSK_PMB_Luluslist.autoSuggests["x_kode_jp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("ftblSK_PMB_Luluslist");
});
var ftblSK_PMB_Luluslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblSK_PMB_Luluslistsrch = currentSearchForm = new ew.Form("ftblSK_PMB_Luluslistsrch");

	// Dynamic selection lists
	// Filters

	ftblSK_PMB_Luluslistsrch.filterList = <?php echo $tblSK_PMB_Lulus_list->getFilterList() ?>;
	loadjs.done("ftblSK_PMB_Luluslistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblSK_PMB_Lulus_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblSK_PMB_Lulus_list->TotalRecords > 0 && $tblSK_PMB_Lulus_list->ExportOptions->visible()) { ?>
<?php $tblSK_PMB_Lulus_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->ImportOptions->visible()) { ?>
<?php $tblSK_PMB_Lulus_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->SearchOptions->visible()) { ?>
<?php $tblSK_PMB_Lulus_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->FilterOptions->visible()) { ?>
<?php $tblSK_PMB_Lulus_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblSK_PMB_Lulus_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblSK_PMB_Lulus_list->isExport("print")) { ?>
<?php
if ($tblSK_PMB_Lulus_list->DbMasterFilter != "" && $tblSK_PMB_Lulus->getCurrentMasterTable() == "tblSK_PMB") {
	if ($tblSK_PMB_Lulus_list->MasterRecordExists) {
		include_once "tblSK_PMBmaster.php";
	}
}
?>
<?php } ?>
<?php
$tblSK_PMB_Lulus_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblSK_PMB_Lulus_list->isExport() && !$tblSK_PMB_Lulus->CurrentAction) { ?>
<form name="ftblSK_PMB_Luluslistsrch" id="ftblSK_PMB_Luluslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblSK_PMB_Luluslistsrch-search-panel" class="<?php echo $tblSK_PMB_Lulus_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblSK_PMB_Lulus">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $tblSK_PMB_Lulus_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tblSK_PMB_Lulus_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tblSK_PMB_Lulus_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tblSK_PMB_Lulus_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tblSK_PMB_Lulus_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tblSK_PMB_Lulus_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblSK_PMB_Lulus_list->showPageHeader(); ?>
<?php
$tblSK_PMB_Lulus_list->showMessage();
?>
<?php if ($tblSK_PMB_Lulus_list->TotalRecords > 0 || $tblSK_PMB_Lulus->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblSK_PMB_Lulus_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblSK_PMB_Lulus">
<form name="ftblSK_PMB_Luluslist" id="ftblSK_PMB_Luluslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblSK_PMB_Lulus">
<?php if ($tblSK_PMB_Lulus->getCurrentMasterTable() == "tblSK_PMB" && $tblSK_PMB_Lulus->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="tblSK_PMB">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Kode_Fak->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblSK_PMB_Lulus" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblSK_PMB_Lulus_list->TotalRecords > 0 || $tblSK_PMB_Lulus_list->isGridEdit()) { ?>
<table id="tbl_tblSK_PMB_Luluslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblSK_PMB_Lulus->RowType = ROWTYPE_HEADER;

// Render list options
$tblSK_PMB_Lulus_list->renderListOptions();

// Render list options (header, left)
$tblSK_PMB_Lulus_list->ListOptions->render("header", "left");
?>
<?php if ($tblSK_PMB_Lulus_list->Nim->Visible) { // Nim ?>
	<?php if ($tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->Nim) == "") { ?>
		<th data-name="Nim" class="<?php echo $tblSK_PMB_Lulus_list->Nim->headerCellClass() ?>"><div id="elh_tblSK_PMB_Lulus_Nim" class="tblSK_PMB_Lulus_Nim"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->Nim->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nim" class="<?php echo $tblSK_PMB_Lulus_list->Nim->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->Nim) ?>', 1);"><div id="elh_tblSK_PMB_Lulus_Nim" class="tblSK_PMB_Lulus_Nim">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_Lulus_list->Nim->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_Lulus_list->Nim->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->kode_jp->Visible) { // kode_jp ?>
	<?php if ($tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->kode_jp) == "") { ?>
		<th data-name="kode_jp" class="<?php echo $tblSK_PMB_Lulus_list->kode_jp->headerCellClass() ?>"><div id="elh_tblSK_PMB_Lulus_kode_jp" class="tblSK_PMB_Lulus_kode_jp"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->kode_jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kode_jp" class="<?php echo $tblSK_PMB_Lulus_list->kode_jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->kode_jp) ?>', 1);"><div id="elh_tblSK_PMB_Lulus_kode_jp" class="tblSK_PMB_Lulus_kode_jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->kode_jp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_Lulus_list->kode_jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_Lulus_list->kode_jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->tmplahir->Visible) { // tmplahir ?>
	<?php if ($tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->tmplahir) == "") { ?>
		<th data-name="tmplahir" class="<?php echo $tblSK_PMB_Lulus_list->tmplahir->headerCellClass() ?>"><div id="elh_tblSK_PMB_Lulus_tmplahir" class="tblSK_PMB_Lulus_tmplahir"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->tmplahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmplahir" class="<?php echo $tblSK_PMB_Lulus_list->tmplahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->tmplahir) ?>', 1);"><div id="elh_tblSK_PMB_Lulus_tmplahir" class="tblSK_PMB_Lulus_tmplahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->tmplahir->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_Lulus_list->tmplahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_Lulus_list->tmplahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->tgllahir->Visible) { // tgllahir ?>
	<?php if ($tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->tgllahir) == "") { ?>
		<th data-name="tgllahir" class="<?php echo $tblSK_PMB_Lulus_list->tgllahir->headerCellClass() ?>"><div id="elh_tblSK_PMB_Lulus_tgllahir" class="tblSK_PMB_Lulus_tgllahir"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->tgllahir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tgllahir" class="<?php echo $tblSK_PMB_Lulus_list->tgllahir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->tgllahir) ?>', 1);"><div id="elh_tblSK_PMB_Lulus_tgllahir" class="tblSK_PMB_Lulus_tgllahir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->tgllahir->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_Lulus_list->tgllahir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_Lulus_list->tgllahir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->Keterangan->Visible) { // Keterangan ?>
	<?php if ($tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->Keterangan) == "") { ?>
		<th data-name="Keterangan" class="<?php echo $tblSK_PMB_Lulus_list->Keterangan->headerCellClass() ?>"><div id="elh_tblSK_PMB_Lulus_Keterangan" class="tblSK_PMB_Lulus_Keterangan"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->Keterangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Keterangan" class="<?php echo $tblSK_PMB_Lulus_list->Keterangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_Lulus_list->SortUrl($tblSK_PMB_Lulus_list->Keterangan) ?>', 1);"><div id="elh_tblSK_PMB_Lulus_Keterangan" class="tblSK_PMB_Lulus_Keterangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_Lulus_list->Keterangan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_Lulus_list->Keterangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_Lulus_list->Keterangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblSK_PMB_Lulus_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblSK_PMB_Lulus_list->ExportAll && $tblSK_PMB_Lulus_list->isExport()) {
	$tblSK_PMB_Lulus_list->StopRecord = $tblSK_PMB_Lulus_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblSK_PMB_Lulus_list->TotalRecords > $tblSK_PMB_Lulus_list->StartRecord + $tblSK_PMB_Lulus_list->DisplayRecords - 1)
		$tblSK_PMB_Lulus_list->StopRecord = $tblSK_PMB_Lulus_list->StartRecord + $tblSK_PMB_Lulus_list->DisplayRecords - 1;
	else
		$tblSK_PMB_Lulus_list->StopRecord = $tblSK_PMB_Lulus_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblSK_PMB_Lulus->isConfirm() || $tblSK_PMB_Lulus_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblSK_PMB_Lulus_list->FormKeyCountName) && ($tblSK_PMB_Lulus_list->isGridAdd() || $tblSK_PMB_Lulus_list->isGridEdit() || $tblSK_PMB_Lulus->isConfirm())) {
		$tblSK_PMB_Lulus_list->KeyCount = $CurrentForm->getValue($tblSK_PMB_Lulus_list->FormKeyCountName);
		$tblSK_PMB_Lulus_list->StopRecord = $tblSK_PMB_Lulus_list->StartRecord + $tblSK_PMB_Lulus_list->KeyCount - 1;
	}
}
$tblSK_PMB_Lulus_list->RecordCount = $tblSK_PMB_Lulus_list->StartRecord - 1;
if ($tblSK_PMB_Lulus_list->Recordset && !$tblSK_PMB_Lulus_list->Recordset->EOF) {
	$tblSK_PMB_Lulus_list->Recordset->moveFirst();
	$selectLimit = $tblSK_PMB_Lulus_list->UseSelectLimit;
	if (!$selectLimit && $tblSK_PMB_Lulus_list->StartRecord > 1)
		$tblSK_PMB_Lulus_list->Recordset->move($tblSK_PMB_Lulus_list->StartRecord - 1);
} elseif (!$tblSK_PMB_Lulus->AllowAddDeleteRow && $tblSK_PMB_Lulus_list->StopRecord == 0) {
	$tblSK_PMB_Lulus_list->StopRecord = $tblSK_PMB_Lulus->GridAddRowCount;
}

// Initialize aggregate
$tblSK_PMB_Lulus->RowType = ROWTYPE_AGGREGATEINIT;
$tblSK_PMB_Lulus->resetAttributes();
$tblSK_PMB_Lulus_list->renderRow();
if ($tblSK_PMB_Lulus_list->isGridAdd())
	$tblSK_PMB_Lulus_list->RowIndex = 0;
if ($tblSK_PMB_Lulus_list->isGridEdit())
	$tblSK_PMB_Lulus_list->RowIndex = 0;
while ($tblSK_PMB_Lulus_list->RecordCount < $tblSK_PMB_Lulus_list->StopRecord) {
	$tblSK_PMB_Lulus_list->RecordCount++;
	if ($tblSK_PMB_Lulus_list->RecordCount >= $tblSK_PMB_Lulus_list->StartRecord) {
		$tblSK_PMB_Lulus_list->RowCount++;
		if ($tblSK_PMB_Lulus_list->isGridAdd() || $tblSK_PMB_Lulus_list->isGridEdit() || $tblSK_PMB_Lulus->isConfirm()) {
			$tblSK_PMB_Lulus_list->RowIndex++;
			$CurrentForm->Index = $tblSK_PMB_Lulus_list->RowIndex;
			if ($CurrentForm->hasValue($tblSK_PMB_Lulus_list->FormActionName) && ($tblSK_PMB_Lulus->isConfirm() || $tblSK_PMB_Lulus_list->EventCancelled))
				$tblSK_PMB_Lulus_list->RowAction = strval($CurrentForm->getValue($tblSK_PMB_Lulus_list->FormActionName));
			elseif ($tblSK_PMB_Lulus_list->isGridAdd())
				$tblSK_PMB_Lulus_list->RowAction = "insert";
			else
				$tblSK_PMB_Lulus_list->RowAction = "";
		}

		// Set up key count
		$tblSK_PMB_Lulus_list->KeyCount = $tblSK_PMB_Lulus_list->RowIndex;

		// Init row class and style
		$tblSK_PMB_Lulus->resetAttributes();
		$tblSK_PMB_Lulus->CssClass = "";
		if ($tblSK_PMB_Lulus_list->isGridAdd()) {
			$tblSK_PMB_Lulus_list->loadRowValues(); // Load default values
		} else {
			$tblSK_PMB_Lulus_list->loadRowValues($tblSK_PMB_Lulus_list->Recordset); // Load row values
		}
		$tblSK_PMB_Lulus->RowType = ROWTYPE_VIEW; // Render view
		if ($tblSK_PMB_Lulus_list->isGridAdd()) // Grid add
			$tblSK_PMB_Lulus->RowType = ROWTYPE_ADD; // Render add
		if ($tblSK_PMB_Lulus_list->isGridAdd() && $tblSK_PMB_Lulus->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblSK_PMB_Lulus_list->restoreCurrentRowFormValues($tblSK_PMB_Lulus_list->RowIndex); // Restore form values
		if ($tblSK_PMB_Lulus_list->isGridEdit()) { // Grid edit
			if ($tblSK_PMB_Lulus->EventCancelled)
				$tblSK_PMB_Lulus_list->restoreCurrentRowFormValues($tblSK_PMB_Lulus_list->RowIndex); // Restore form values
			if ($tblSK_PMB_Lulus_list->RowAction == "insert")
				$tblSK_PMB_Lulus->RowType = ROWTYPE_ADD; // Render add
			else
				$tblSK_PMB_Lulus->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblSK_PMB_Lulus_list->isGridEdit() && ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT || $tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) && $tblSK_PMB_Lulus->EventCancelled) // Update failed
			$tblSK_PMB_Lulus_list->restoreCurrentRowFormValues($tblSK_PMB_Lulus_list->RowIndex); // Restore form values
		if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) // Edit row
			$tblSK_PMB_Lulus_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblSK_PMB_Lulus->RowAttrs->merge(["data-rowindex" => $tblSK_PMB_Lulus_list->RowCount, "id" => "r" . $tblSK_PMB_Lulus_list->RowCount . "_tblSK_PMB_Lulus", "data-rowtype" => $tblSK_PMB_Lulus->RowType]);

		// Render row
		$tblSK_PMB_Lulus_list->renderRow();

		// Render list options
		$tblSK_PMB_Lulus_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblSK_PMB_Lulus_list->RowAction != "delete" && $tblSK_PMB_Lulus_list->RowAction != "insertdelete" && !($tblSK_PMB_Lulus_list->RowAction == "insert" && $tblSK_PMB_Lulus->isConfirm() && $tblSK_PMB_Lulus_list->emptyRow())) {
?>
	<tr <?php echo $tblSK_PMB_Lulus->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblSK_PMB_Lulus_list->ListOptions->render("body", "left", $tblSK_PMB_Lulus_list->RowCount);
?>
	<?php if ($tblSK_PMB_Lulus_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim" <?php echo $tblSK_PMB_Lulus_list->Nim->cellAttributes() ?>>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_Nim" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim"><?php echo EmptyValue(strval($tblSK_PMB_Lulus_list->Nim->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblSK_PMB_Lulus_list->Nim->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblSK_PMB_Lulus_list->Nim->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblSK_PMB_Lulus_list->Nim->ReadOnly || $tblSK_PMB_Lulus_list->Nim->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblSK_PMB_Lulus_list->Nim->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_Nim") ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->Nim->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo $tblSK_PMB_Lulus_list->Nim->CurrentValue ?>"<?php echo $tblSK_PMB_Lulus_list->Nim->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Nim->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim"><?php echo EmptyValue(strval($tblSK_PMB_Lulus_list->Nim->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblSK_PMB_Lulus_list->Nim->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblSK_PMB_Lulus_list->Nim->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblSK_PMB_Lulus_list->Nim->ReadOnly || $tblSK_PMB_Lulus_list->Nim->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblSK_PMB_Lulus_list->Nim->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_Nim") ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->Nim->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo $tblSK_PMB_Lulus_list->Nim->CurrentValue ?>"<?php echo $tblSK_PMB_Lulus_list->Nim->editAttributes() ?>>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Nim->OldValue != null ? $tblSK_PMB_Lulus_list->Nim->OldValue : $tblSK_PMB_Lulus_list->Nim->CurrentValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_Nim">
<span<?php echo $tblSK_PMB_Lulus_list->Nim->viewAttributes() ?>><?php echo $tblSK_PMB_Lulus_list->Nim->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Thn_Akademik" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Thn_Akademik->CurrentValue) ?>">
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Thn_Akademik" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Thn_Akademik->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT || $tblSK_PMB_Lulus->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Thn_Akademik" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Periode" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Periode->CurrentValue) ?>">
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Periode" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Periode->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT || $tblSK_PMB_Lulus->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Periode" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Kode_Fak" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Kode_Fak->CurrentValue) ?>">
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Kode_Fak" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Kode_Fak->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT || $tblSK_PMB_Lulus->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Kode_Fak" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Kode_Fak->CurrentValue) ?>">
<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->kode_jp->Visible) { // kode_jp ?>
		<td data-name="kode_jp" <?php echo $tblSK_PMB_Lulus_list->kode_jp->cellAttributes() ?>>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_kode_jp" class="form-group">
<?php
$onchange = $tblSK_PMB_Lulus_list->kode_jp->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblSK_PMB_Lulus_list->kode_jp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp">
	<input type="text" class="form-control" name="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo RemoveHtml($tblSK_PMB_Lulus_list->kode_jp->EditValue) ?>" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>"<?php echo $tblSK_PMB_Lulus_list->kode_jp->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_kode_jp" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->kode_jp->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist"], function() {
	ftblSK_PMB_Luluslist.createAutoSuggest({"id":"x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp","forceSelect":false});
});
</script>
<?php echo $tblSK_PMB_Lulus_list->kode_jp->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_kode_jp") ?>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_kode_jp" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_kode_jp" class="form-group">
<?php
$onchange = $tblSK_PMB_Lulus_list->kode_jp->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblSK_PMB_Lulus_list->kode_jp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp">
	<input type="text" class="form-control" name="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo RemoveHtml($tblSK_PMB_Lulus_list->kode_jp->EditValue) ?>" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>"<?php echo $tblSK_PMB_Lulus_list->kode_jp->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_kode_jp" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->kode_jp->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist"], function() {
	ftblSK_PMB_Luluslist.createAutoSuggest({"id":"x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp","forceSelect":false});
});
</script>
<?php echo $tblSK_PMB_Lulus_list->kode_jp->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_kode_jp") ?>
</span>
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_kode_jp">
<span<?php echo $tblSK_PMB_Lulus_list->kode_jp->viewAttributes() ?>><?php echo $tblSK_PMB_Lulus_list->kode_jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->tmplahir->Visible) { // tmplahir ?>
		<td data-name="tmplahir" <?php echo $tblSK_PMB_Lulus_list->tmplahir->cellAttributes() ?>>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tmplahir" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tmplahir" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tmplahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tmplahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tmplahir->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_tmplahir" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tmplahir->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tmplahir" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tmplahir" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tmplahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tmplahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tmplahir->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tmplahir">
<span<?php echo $tblSK_PMB_Lulus_list->tmplahir->viewAttributes() ?>><?php echo $tblSK_PMB_Lulus_list->tmplahir->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->tgllahir->Visible) { // tgllahir ?>
		<td data-name="tgllahir" <?php echo $tblSK_PMB_Lulus_list->tgllahir->cellAttributes() ?>>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tgllahir" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tgllahir" data-format="7" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" maxlength="8" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tgllahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tgllahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tgllahir->editAttributes() ?>>
<?php if (!$tblSK_PMB_Lulus_list->tgllahir->ReadOnly && !$tblSK_PMB_Lulus_list->tgllahir->Disabled && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["readonly"]) && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblSK_PMB_Luluslist", "x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_tgllahir" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tgllahir->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tgllahir" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tgllahir" data-format="7" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" maxlength="8" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tgllahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tgllahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tgllahir->editAttributes() ?>>
<?php if (!$tblSK_PMB_Lulus_list->tgllahir->ReadOnly && !$tblSK_PMB_Lulus_list->tgllahir->Disabled && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["readonly"]) && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblSK_PMB_Luluslist", "x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_tgllahir">
<span<?php echo $tblSK_PMB_Lulus_list->tgllahir->viewAttributes() ?>><?php echo $tblSK_PMB_Lulus_list->tgllahir->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->Keterangan->Visible) { // Keterangan ?>
		<td data-name="Keterangan" <?php echo $tblSK_PMB_Lulus_list->Keterangan->cellAttributes() ?>>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_Keterangan" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_Keterangan" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" size="30" maxlength="59" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Keterangan->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->Keterangan->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->Keterangan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Keterangan" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Keterangan->OldValue) ?>">
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_Keterangan" class="form-group">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_Keterangan" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" size="30" maxlength="59" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Keterangan->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->Keterangan->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->Keterangan->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSK_PMB_Lulus_list->RowCount ?>_tblSK_PMB_Lulus_Keterangan">
<span<?php echo $tblSK_PMB_Lulus_list->Keterangan->viewAttributes() ?>><?php echo $tblSK_PMB_Lulus_list->Keterangan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblSK_PMB_Lulus_list->ListOptions->render("body", "right", $tblSK_PMB_Lulus_list->RowCount);
?>
	</tr>
<?php if ($tblSK_PMB_Lulus->RowType == ROWTYPE_ADD || $tblSK_PMB_Lulus->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist", "load"], function() {
	ftblSK_PMB_Luluslist.updateLists(<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblSK_PMB_Lulus_list->isGridAdd())
		if (!$tblSK_PMB_Lulus_list->Recordset->EOF)
			$tblSK_PMB_Lulus_list->Recordset->moveNext();
}
?>
<?php
	if ($tblSK_PMB_Lulus_list->isGridAdd() || $tblSK_PMB_Lulus_list->isGridEdit()) {
		$tblSK_PMB_Lulus_list->RowIndex = '$rowindex$';
		$tblSK_PMB_Lulus_list->loadRowValues();

		// Set row properties
		$tblSK_PMB_Lulus->resetAttributes();
		$tblSK_PMB_Lulus->RowAttrs->merge(["data-rowindex" => $tblSK_PMB_Lulus_list->RowIndex, "id" => "r0_tblSK_PMB_Lulus", "data-rowtype" => ROWTYPE_ADD]);
		$tblSK_PMB_Lulus->RowAttrs->appendClass("ew-template");
		$tblSK_PMB_Lulus->RowType = ROWTYPE_ADD;

		// Render row
		$tblSK_PMB_Lulus_list->renderRow();

		// Render list options
		$tblSK_PMB_Lulus_list->renderListOptions();
		$tblSK_PMB_Lulus_list->StartRowCount = 0;
?>
	<tr <?php echo $tblSK_PMB_Lulus->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblSK_PMB_Lulus_list->ListOptions->render("body", "left", $tblSK_PMB_Lulus_list->RowIndex);
?>
	<?php if ($tblSK_PMB_Lulus_list->Nim->Visible) { // Nim ?>
		<td data-name="Nim">
<span id="el$rowindex$_tblSK_PMB_Lulus_Nim" class="form-group tblSK_PMB_Lulus_Nim">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim"><?php echo EmptyValue(strval($tblSK_PMB_Lulus_list->Nim->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblSK_PMB_Lulus_list->Nim->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblSK_PMB_Lulus_list->Nim->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblSK_PMB_Lulus_list->Nim->ReadOnly || $tblSK_PMB_Lulus_list->Nim->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblSK_PMB_Lulus_list->Nim->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_Nim") ?>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->Nim->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo $tblSK_PMB_Lulus_list->Nim->CurrentValue ?>"<?php echo $tblSK_PMB_Lulus_list->Nim->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Nim" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Nim" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Nim->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->kode_jp->Visible) { // kode_jp ?>
		<td data-name="kode_jp">
<span id="el$rowindex$_tblSK_PMB_Lulus_kode_jp" class="form-group tblSK_PMB_Lulus_kode_jp">
<?php
$onchange = $tblSK_PMB_Lulus_list->kode_jp->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$tblSK_PMB_Lulus_list->kode_jp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp">
	<input type="text" class="form-control" name="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="sv_x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo RemoveHtml($tblSK_PMB_Lulus_list->kode_jp->EditValue) ?>" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->getPlaceHolder()) ?>"<?php echo $tblSK_PMB_Lulus_list->kode_jp->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_kode_jp" data-value-separator="<?php echo $tblSK_PMB_Lulus_list->kode_jp->displayValueSeparatorAttribute() ?>" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist"], function() {
	ftblSK_PMB_Luluslist.createAutoSuggest({"id":"x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp","forceSelect":false});
});
</script>
<?php echo $tblSK_PMB_Lulus_list->kode_jp->Lookup->getParamTag($tblSK_PMB_Lulus_list, "p_x" . $tblSK_PMB_Lulus_list->RowIndex . "_kode_jp") ?>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_kode_jp" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_kode_jp" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->kode_jp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->tmplahir->Visible) { // tmplahir ?>
		<td data-name="tmplahir">
<span id="el$rowindex$_tblSK_PMB_Lulus_tmplahir" class="form-group tblSK_PMB_Lulus_tmplahir">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tmplahir" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tmplahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tmplahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tmplahir->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_tmplahir" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tmplahir" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tmplahir->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->tgllahir->Visible) { // tgllahir ?>
		<td data-name="tgllahir">
<span id="el$rowindex$_tblSK_PMB_Lulus_tgllahir" class="form-group tblSK_PMB_Lulus_tgllahir">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_tgllahir" data-format="7" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" maxlength="8" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tgllahir->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->tgllahir->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->tgllahir->editAttributes() ?>>
<?php if (!$tblSK_PMB_Lulus_list->tgllahir->ReadOnly && !$tblSK_PMB_Lulus_list->tgllahir->Disabled && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["readonly"]) && !isset($tblSK_PMB_Lulus_list->tgllahir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblSK_PMB_Luluslist", "x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_tgllahir" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_tgllahir" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->tgllahir->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_Lulus_list->Keterangan->Visible) { // Keterangan ?>
		<td data-name="Keterangan">
<span id="el$rowindex$_tblSK_PMB_Lulus_Keterangan" class="form-group tblSK_PMB_Lulus_Keterangan">
<input type="text" data-table="tblSK_PMB_Lulus" data-field="x_Keterangan" name="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" id="x<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" size="30" maxlength="59" placeholder="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Keterangan->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_Lulus_list->Keterangan->EditValue ?>"<?php echo $tblSK_PMB_Lulus_list->Keterangan->editAttributes() ?>>
</span>
<input type="hidden" data-table="tblSK_PMB_Lulus" data-field="x_Keterangan" name="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" id="o<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>_Keterangan" value="<?php echo HtmlEncode($tblSK_PMB_Lulus_list->Keterangan->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblSK_PMB_Lulus_list->ListOptions->render("body", "right", $tblSK_PMB_Lulus_list->RowIndex);
?>
<script>
loadjs.ready(["ftblSK_PMB_Luluslist", "load"], function() {
	ftblSK_PMB_Luluslist.updateLists(<?php echo $tblSK_PMB_Lulus_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblSK_PMB_Lulus_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblSK_PMB_Lulus_list->FormKeyCountName ?>" id="<?php echo $tblSK_PMB_Lulus_list->FormKeyCountName ?>" value="<?php echo $tblSK_PMB_Lulus_list->KeyCount ?>">
<?php echo $tblSK_PMB_Lulus_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblSK_PMB_Lulus_list->FormKeyCountName ?>" id="<?php echo $tblSK_PMB_Lulus_list->FormKeyCountName ?>" value="<?php echo $tblSK_PMB_Lulus_list->KeyCount ?>">
<?php echo $tblSK_PMB_Lulus_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblSK_PMB_Lulus->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblSK_PMB_Lulus_list->Recordset)
	$tblSK_PMB_Lulus_list->Recordset->Close();
?>
<?php if (!$tblSK_PMB_Lulus_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblSK_PMB_Lulus_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblSK_PMB_Lulus_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblSK_PMB_Lulus_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblSK_PMB_Lulus_list->TotalRecords == 0 && !$tblSK_PMB_Lulus->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblSK_PMB_Lulus_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblSK_PMB_Lulus_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblSK_PMB_Lulus_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblSK_PMB_Lulus_list->terminate();
?>