<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblSK_PMB_add = new tblSK_PMB_add();

// Run the page
$tblSK_PMB_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblSK_PMB_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftblSK_PMBadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	ftblSK_PMBadd = currentForm = new ew.Form("ftblSK_PMBadd", "add");

	// Validate form
	ftblSK_PMBadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tblSK_PMB_add->Thn_Akademik->Required) { ?>
				elm = this.getElements("x" + infix + "_Thn_Akademik");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->Thn_Akademik->caption(), $tblSK_PMB_add->Thn_Akademik->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->Periode->Required) { ?>
				elm = this.getElements("x" + infix + "_Periode");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->Periode->caption(), $tblSK_PMB_add->Periode->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->Kode_Fak->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Fak");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->Kode_Fak->caption(), $tblSK_PMB_add->Kode_Fak->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->Tanggal->Required) { ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->Tanggal->caption(), $tblSK_PMB_add->Tanggal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_Tanggal");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tblSK_PMB_add->Tanggal->errorMessage()) ?>");
			<?php if ($tblSK_PMB_add->NoSK->Required) { ?>
				elm = this.getElements("x" + infix + "_NoSK");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->NoSK->caption(), $tblSK_PMB_add->NoSK->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->NamaPejabat->Required) { ?>
				elm = this.getElements("x" + infix + "_NamaPejabat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->NamaPejabat->caption(), $tblSK_PMB_add->NamaPejabat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->NIDN->caption(), $tblSK_PMB_add->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->Pejabat->Required) { ?>
				elm = this.getElements("x" + infix + "_Pejabat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->Pejabat->caption(), $tblSK_PMB_add->Pejabat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSK_PMB_add->filesk->Required) { ?>
				felm = this.getElements("x" + infix + "_filesk");
				elm = this.getElements("fn_x" + infix + "_filesk");
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $tblSK_PMB_add->filesk->caption(), $tblSK_PMB_add->filesk->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftblSK_PMBadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblSK_PMBadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblSK_PMBadd.lists["x_Thn_Akademik"] = <?php echo $tblSK_PMB_add->Thn_Akademik->Lookup->toClientList($tblSK_PMB_add) ?>;
	ftblSK_PMBadd.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblSK_PMB_add->Thn_Akademik->lookupOptions()) ?>;
	ftblSK_PMBadd.lists["x_Periode"] = <?php echo $tblSK_PMB_add->Periode->Lookup->toClientList($tblSK_PMB_add) ?>;
	ftblSK_PMBadd.lists["x_Periode"].options = <?php echo JsonEncode($tblSK_PMB_add->Periode->options(FALSE, TRUE)) ?>;
	ftblSK_PMBadd.lists["x_Kode_Fak"] = <?php echo $tblSK_PMB_add->Kode_Fak->Lookup->toClientList($tblSK_PMB_add) ?>;
	ftblSK_PMBadd.lists["x_Kode_Fak"].options = <?php echo JsonEncode($tblSK_PMB_add->Kode_Fak->lookupOptions()) ?>;
	ftblSK_PMBadd.lists["x_NIDN"] = <?php echo $tblSK_PMB_add->NIDN->Lookup->toClientList($tblSK_PMB_add) ?>;
	ftblSK_PMBadd.lists["x_NIDN"].options = <?php echo JsonEncode($tblSK_PMB_add->NIDN->lookupOptions()) ?>;
	loadjs.done("ftblSK_PMBadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $tblSK_PMB_add->showPageHeader(); ?>
<?php
$tblSK_PMB_add->showMessage();
?>
<form name="ftblSK_PMBadd" id="ftblSK_PMBadd" class="<?php echo $tblSK_PMB_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblSK_PMB">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$tblSK_PMB_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($tblSK_PMB_add->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<div id="r_Thn_Akademik" class="form-group row">
		<label id="elh_tblSK_PMB_Thn_Akademik" for="x_Thn_Akademik" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->Thn_Akademik->caption() ?><?php echo $tblSK_PMB_add->Thn_Akademik->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->Thn_Akademik->cellAttributes() ?>>
<span id="el_tblSK_PMB_Thn_Akademik">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblSK_PMB_add->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblSK_PMB_add->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblSK_PMB_add->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblSK_PMB_add->Thn_Akademik->Lookup->getParamTag($tblSK_PMB_add, "p_x_Thn_Akademik") ?>
</span>
<?php echo $tblSK_PMB_add->Thn_Akademik->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->Periode->Visible) { // Periode ?>
	<div id="r_Periode" class="form-group row">
		<label id="elh_tblSK_PMB_Periode" for="x_Periode" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->Periode->caption() ?><?php echo $tblSK_PMB_add->Periode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->Periode->cellAttributes() ?>>
<span id="el_tblSK_PMB_Periode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Periode" data-value-separator="<?php echo $tblSK_PMB_add->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblSK_PMB_add->Periode->editAttributes() ?>>
			<?php echo $tblSK_PMB_add->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
<?php echo $tblSK_PMB_add->Periode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->Kode_Fak->Visible) { // Kode_Fak ?>
	<div id="r_Kode_Fak" class="form-group row">
		<label id="elh_tblSK_PMB_Kode_Fak" for="x_Kode_Fak" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->Kode_Fak->caption() ?><?php echo $tblSK_PMB_add->Kode_Fak->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->Kode_Fak->cellAttributes() ?>>
<span id="el_tblSK_PMB_Kode_Fak">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Kode_Fak" data-value-separator="<?php echo $tblSK_PMB_add->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $tblSK_PMB_add->Kode_Fak->editAttributes() ?>>
			<?php echo $tblSK_PMB_add->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $tblSK_PMB_add->Kode_Fak->Lookup->getParamTag($tblSK_PMB_add, "p_x_Kode_Fak") ?>
</span>
<?php echo $tblSK_PMB_add->Kode_Fak->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->Tanggal->Visible) { // Tanggal ?>
	<div id="r_Tanggal" class="form-group row">
		<label id="elh_tblSK_PMB_Tanggal" for="x_Tanggal" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->Tanggal->caption() ?><?php echo $tblSK_PMB_add->Tanggal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->Tanggal->cellAttributes() ?>>
<span id="el_tblSK_PMB_Tanggal">
<input type="text" data-table="tblSK_PMB" data-field="x_Tanggal" data-format="7" name="x_Tanggal" id="x_Tanggal" maxlength="8" placeholder="<?php echo HtmlEncode($tblSK_PMB_add->Tanggal->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_add->Tanggal->EditValue ?>"<?php echo $tblSK_PMB_add->Tanggal->editAttributes() ?>>
<?php if (!$tblSK_PMB_add->Tanggal->ReadOnly && !$tblSK_PMB_add->Tanggal->Disabled && !isset($tblSK_PMB_add->Tanggal->EditAttrs["readonly"]) && !isset($tblSK_PMB_add->Tanggal->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftblSK_PMBadd", "datetimepicker"], function() {
	ew.createDateTimePicker("ftblSK_PMBadd", "x_Tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $tblSK_PMB_add->Tanggal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->NoSK->Visible) { // NoSK ?>
	<div id="r_NoSK" class="form-group row">
		<label id="elh_tblSK_PMB_NoSK" for="x_NoSK" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->NoSK->caption() ?><?php echo $tblSK_PMB_add->NoSK->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->NoSK->cellAttributes() ?>>
<span id="el_tblSK_PMB_NoSK">
<input type="text" data-table="tblSK_PMB" data-field="x_NoSK" name="x_NoSK" id="x_NoSK" size="15" maxlength="50" placeholder="<?php echo HtmlEncode($tblSK_PMB_add->NoSK->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_add->NoSK->EditValue ?>"<?php echo $tblSK_PMB_add->NoSK->editAttributes() ?>>
</span>
<?php echo $tblSK_PMB_add->NoSK->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->NamaPejabat->Visible) { // NamaPejabat ?>
	<div id="r_NamaPejabat" class="form-group row">
		<label id="elh_tblSK_PMB_NamaPejabat" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->NamaPejabat->caption() ?><?php echo $tblSK_PMB_add->NamaPejabat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->NamaPejabat->cellAttributes() ?>>
<span id="el_tblSK_PMB_NamaPejabat">
<input type="text" data-table="tblSK_PMB" data-field="x_NamaPejabat" name="x_NamaPejabat" id="x_NamaPejabat" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tblSK_PMB_add->NamaPejabat->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_add->NamaPejabat->EditValue ?>"<?php echo $tblSK_PMB_add->NamaPejabat->editAttributes() ?>>
</span>
<?php echo $tblSK_PMB_add->NamaPejabat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->NIDN->Visible) { // NIDN ?>
	<div id="r_NIDN" class="form-group row">
		<label id="elh_tblSK_PMB_NIDN" for="x_NIDN" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->NIDN->caption() ?><?php echo $tblSK_PMB_add->NIDN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->NIDN->cellAttributes() ?>>
<span id="el_tblSK_PMB_NIDN">
<?php $tblSK_PMB_add->NIDN->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_NIDN"><?php echo EmptyValue(strval($tblSK_PMB_add->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tblSK_PMB_add->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tblSK_PMB_add->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tblSK_PMB_add->NIDN->ReadOnly || $tblSK_PMB_add->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tblSK_PMB_add->NIDN->Lookup->getParamTag($tblSK_PMB_add, "p_x_NIDN") ?>
<input type="hidden" data-table="tblSK_PMB" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tblSK_PMB_add->NIDN->displayValueSeparatorAttribute() ?>" name="x_NIDN" id="x_NIDN" value="<?php echo $tblSK_PMB_add->NIDN->CurrentValue ?>"<?php echo $tblSK_PMB_add->NIDN->editAttributes() ?>>
</span>
<?php echo $tblSK_PMB_add->NIDN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->Pejabat->Visible) { // Pejabat ?>
	<div id="r_Pejabat" class="form-group row">
		<label id="elh_tblSK_PMB_Pejabat" for="x_Pejabat" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->Pejabat->caption() ?><?php echo $tblSK_PMB_add->Pejabat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->Pejabat->cellAttributes() ?>>
<span id="el_tblSK_PMB_Pejabat">
<input type="text" data-table="tblSK_PMB" data-field="x_Pejabat" name="x_Pejabat" id="x_Pejabat" size="20" maxlength="20" placeholder="<?php echo HtmlEncode($tblSK_PMB_add->Pejabat->getPlaceHolder()) ?>" value="<?php echo $tblSK_PMB_add->Pejabat->EditValue ?>"<?php echo $tblSK_PMB_add->Pejabat->editAttributes() ?>>
</span>
<?php echo $tblSK_PMB_add->Pejabat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tblSK_PMB_add->filesk->Visible) { // filesk ?>
	<div id="r_filesk" class="form-group row">
		<label id="elh_tblSK_PMB_filesk" class="<?php echo $tblSK_PMB_add->LeftColumnClass ?>"><?php echo $tblSK_PMB_add->filesk->caption() ?><?php echo $tblSK_PMB_add->filesk->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tblSK_PMB_add->RightColumnClass ?>"><div <?php echo $tblSK_PMB_add->filesk->cellAttributes() ?>>
<span id="el_tblSK_PMB_filesk">
<div id="fd_x_filesk">
<div class="input-group">
	<div class="custom-file">
		<input type="file" class="custom-file-input" title="<?php echo $tblSK_PMB_add->filesk->title() ?>" data-table="tblSK_PMB" data-field="x_filesk" name="x_filesk" id="x_filesk" lang="<?php echo CurrentLanguageID() ?>"<?php echo $tblSK_PMB_add->filesk->editAttributes() ?><?php if ($tblSK_PMB_add->filesk->ReadOnly || $tblSK_PMB_add->filesk->Disabled) echo " disabled"; ?>>
		<label class="custom-file-label ew-file-label" for="x_filesk"><?php echo $Language->phrase("ChooseFile") ?></label>
	</div>
</div>
<input type="hidden" name="fn_x_filesk" id= "fn_x_filesk" value="<?php echo $tblSK_PMB_add->filesk->Upload->FileName ?>">
<input type="hidden" name="fa_x_filesk" id= "fa_x_filesk" value="0">
<input type="hidden" name="fs_x_filesk" id= "fs_x_filesk" value="100">
<input type="hidden" name="fx_x_filesk" id= "fx_x_filesk" value="<?php echo $tblSK_PMB_add->filesk->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_filesk" id= "fm_x_filesk" value="<?php echo $tblSK_PMB_add->filesk->UploadMaxFileSize ?>">
</div>
<table id="ft_x_filesk" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $tblSK_PMB_add->filesk->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("tblSK_PMB_Lulus", explode(",", $tblSK_PMB->getCurrentDetailTable())) && $tblSK_PMB_Lulus->DetailAdd) {
?>
<?php if ($tblSK_PMB->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("tblSK_PMB_Lulus", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "tblSK_PMB_Lulusgrid.php" ?>
<?php } ?>
<?php if (!$tblSK_PMB_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tblSK_PMB_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tblSK_PMB_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tblSK_PMB_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$tblSK_PMB_add->terminate();
?>