<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblSK_PMB_list = new tblSK_PMB_list();

// Run the page
$tblSK_PMB_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblSK_PMB_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblSK_PMB_list->isExport()) { ?>
<script>
var ftblSK_PMBlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblSK_PMBlist = currentForm = new ew.Form("ftblSK_PMBlist", "list");
	ftblSK_PMBlist.formKeyCountName = '<?php echo $tblSK_PMB_list->FormKeyCountName ?>';
	loadjs.done("ftblSK_PMBlist");
});
var ftblSK_PMBlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftblSK_PMBlistsrch = currentSearchForm = new ew.Form("ftblSK_PMBlistsrch");

	// Validate function for search
	ftblSK_PMBlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftblSK_PMBlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblSK_PMBlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblSK_PMBlistsrch.lists["x_Thn_Akademik"] = <?php echo $tblSK_PMB_list->Thn_Akademik->Lookup->toClientList($tblSK_PMB_list) ?>;
	ftblSK_PMBlistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($tblSK_PMB_list->Thn_Akademik->lookupOptions()) ?>;
	ftblSK_PMBlistsrch.lists["x_Periode"] = <?php echo $tblSK_PMB_list->Periode->Lookup->toClientList($tblSK_PMB_list) ?>;
	ftblSK_PMBlistsrch.lists["x_Periode"].options = <?php echo JsonEncode($tblSK_PMB_list->Periode->options(FALSE, TRUE)) ?>;
	ftblSK_PMBlistsrch.lists["x_Kode_Fak"] = <?php echo $tblSK_PMB_list->Kode_Fak->Lookup->toClientList($tblSK_PMB_list) ?>;
	ftblSK_PMBlistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($tblSK_PMB_list->Kode_Fak->lookupOptions()) ?>;

	// Filters
	ftblSK_PMBlistsrch.filterList = <?php echo $tblSK_PMB_list->getFilterList() ?>;
	loadjs.done("ftblSK_PMBlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblSK_PMB_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblSK_PMB_list->TotalRecords > 0 && $tblSK_PMB_list->ExportOptions->visible()) { ?>
<?php $tblSK_PMB_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_list->ImportOptions->visible()) { ?>
<?php $tblSK_PMB_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_list->SearchOptions->visible()) { ?>
<?php $tblSK_PMB_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tblSK_PMB_list->FilterOptions->visible()) { ?>
<?php $tblSK_PMB_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tblSK_PMB_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tblSK_PMB_list->isExport() && !$tblSK_PMB->CurrentAction) { ?>
<form name="ftblSK_PMBlistsrch" id="ftblSK_PMBlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftblSK_PMBlistsrch-search-panel" class="<?php echo $tblSK_PMB_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tblSK_PMB">
	<div class="ew-extended-search">
<?php

// Render search row
$tblSK_PMB->RowType = ROWTYPE_SEARCH;
$tblSK_PMB->resetAttributes();
$tblSK_PMB_list->renderRow();
?>
<?php if ($tblSK_PMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$tblSK_PMB_list->SearchColumnCount++;
		if (($tblSK_PMB_list->SearchColumnCount - 1) % $tblSK_PMB_list->SearchFieldsPerRow == 0) {
			$tblSK_PMB_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblSK_PMB_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $tblSK_PMB_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_tblSK_PMB_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Thn_Akademik" data-value-separator="<?php echo $tblSK_PMB_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $tblSK_PMB_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $tblSK_PMB_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $tblSK_PMB_list->Thn_Akademik->Lookup->getParamTag($tblSK_PMB_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($tblSK_PMB_list->SearchColumnCount % $tblSK_PMB_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Periode->Visible) { // Periode ?>
	<?php
		$tblSK_PMB_list->SearchColumnCount++;
		if (($tblSK_PMB_list->SearchColumnCount - 1) % $tblSK_PMB_list->SearchFieldsPerRow == 0) {
			$tblSK_PMB_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblSK_PMB_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $tblSK_PMB_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_tblSK_PMB_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Periode" data-value-separator="<?php echo $tblSK_PMB_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $tblSK_PMB_list->Periode->editAttributes() ?>>
			<?php echo $tblSK_PMB_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($tblSK_PMB_list->SearchColumnCount % $tblSK_PMB_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$tblSK_PMB_list->SearchColumnCount++;
		if (($tblSK_PMB_list->SearchColumnCount - 1) % $tblSK_PMB_list->SearchFieldsPerRow == 0) {
			$tblSK_PMB_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tblSK_PMB_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $tblSK_PMB_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_tblSK_PMB_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSK_PMB" data-field="x_Kode_Fak" data-value-separator="<?php echo $tblSK_PMB_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $tblSK_PMB_list->Kode_Fak->editAttributes() ?>>
			<?php echo $tblSK_PMB_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $tblSK_PMB_list->Kode_Fak->Lookup->getParamTag($tblSK_PMB_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($tblSK_PMB_list->SearchColumnCount % $tblSK_PMB_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tblSK_PMB_list->SearchColumnCount % $tblSK_PMB_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tblSK_PMB_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tblSK_PMB_list->showPageHeader(); ?>
<?php
$tblSK_PMB_list->showMessage();
?>
<?php if ($tblSK_PMB_list->TotalRecords > 0 || $tblSK_PMB->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblSK_PMB_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblSK_PMB">
<form name="ftblSK_PMBlist" id="ftblSK_PMBlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblSK_PMB">
<div id="gmp_tblSK_PMB" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblSK_PMB_list->TotalRecords > 0 || $tblSK_PMB_list->isGridEdit()) { ?>
<table id="tbl_tblSK_PMBlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblSK_PMB->RowType = ROWTYPE_HEADER;

// Render list options
$tblSK_PMB_list->renderListOptions();

// Render list options (header, left)
$tblSK_PMB_list->ListOptions->render("header", "left");
?>
<?php if ($tblSK_PMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblSK_PMB_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_tblSK_PMB_Thn_Akademik" class="tblSK_PMB_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $tblSK_PMB_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->Thn_Akademik) ?>', 1);"><div id="elh_tblSK_PMB_Thn_Akademik" class="tblSK_PMB_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Periode->Visible) { // Periode ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $tblSK_PMB_list->Periode->headerCellClass() ?>"><div id="elh_tblSK_PMB_Periode" class="tblSK_PMB_Periode"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $tblSK_PMB_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->Periode) ?>', 1);"><div id="elh_tblSK_PMB_Periode" class="tblSK_PMB_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $tblSK_PMB_list->Kode_Fak->headerCellClass() ?>"><div id="elh_tblSK_PMB_Kode_Fak" class="tblSK_PMB_Kode_Fak"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $tblSK_PMB_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->Kode_Fak) ?>', 1);"><div id="elh_tblSK_PMB_Kode_Fak" class="tblSK_PMB_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $tblSK_PMB_list->Tanggal->headerCellClass() ?>"><div id="elh_tblSK_PMB_Tanggal" class="tblSK_PMB_Tanggal"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $tblSK_PMB_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->Tanggal) ?>', 1);"><div id="elh_tblSK_PMB_Tanggal" class="tblSK_PMB_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->NoSK->Visible) { // NoSK ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->NoSK) == "") { ?>
		<th data-name="NoSK" class="<?php echo $tblSK_PMB_list->NoSK->headerCellClass() ?>"><div id="elh_tblSK_PMB_NoSK" class="tblSK_PMB_NoSK"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->NoSK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoSK" class="<?php echo $tblSK_PMB_list->NoSK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->NoSK) ?>', 1);"><div id="elh_tblSK_PMB_NoSK" class="tblSK_PMB_NoSK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->NoSK->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->NoSK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->NoSK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tblSK_PMB_list->NIDN->headerCellClass() ?>"><div id="elh_tblSK_PMB_NIDN" class="tblSK_PMB_NIDN"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tblSK_PMB_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->NIDN) ?>', 1);"><div id="elh_tblSK_PMB_NIDN" class="tblSK_PMB_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->Pejabat->Visible) { // Pejabat ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->Pejabat) == "") { ?>
		<th data-name="Pejabat" class="<?php echo $tblSK_PMB_list->Pejabat->headerCellClass() ?>"><div id="elh_tblSK_PMB_Pejabat" class="tblSK_PMB_Pejabat"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Pejabat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Pejabat" class="<?php echo $tblSK_PMB_list->Pejabat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->Pejabat) ?>', 1);"><div id="elh_tblSK_PMB_Pejabat" class="tblSK_PMB_Pejabat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->Pejabat->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->Pejabat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->Pejabat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSK_PMB_list->filesk->Visible) { // filesk ?>
	<?php if ($tblSK_PMB_list->SortUrl($tblSK_PMB_list->filesk) == "") { ?>
		<th data-name="filesk" class="<?php echo $tblSK_PMB_list->filesk->headerCellClass() ?>"><div id="elh_tblSK_PMB_filesk" class="tblSK_PMB_filesk"><div class="ew-table-header-caption"><?php echo $tblSK_PMB_list->filesk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="filesk" class="<?php echo $tblSK_PMB_list->filesk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSK_PMB_list->SortUrl($tblSK_PMB_list->filesk) ?>', 1);"><div id="elh_tblSK_PMB_filesk" class="tblSK_PMB_filesk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSK_PMB_list->filesk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSK_PMB_list->filesk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSK_PMB_list->filesk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblSK_PMB_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblSK_PMB_list->ExportAll && $tblSK_PMB_list->isExport()) {
	$tblSK_PMB_list->StopRecord = $tblSK_PMB_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblSK_PMB_list->TotalRecords > $tblSK_PMB_list->StartRecord + $tblSK_PMB_list->DisplayRecords - 1)
		$tblSK_PMB_list->StopRecord = $tblSK_PMB_list->StartRecord + $tblSK_PMB_list->DisplayRecords - 1;
	else
		$tblSK_PMB_list->StopRecord = $tblSK_PMB_list->TotalRecords;
}
$tblSK_PMB_list->RecordCount = $tblSK_PMB_list->StartRecord - 1;
if ($tblSK_PMB_list->Recordset && !$tblSK_PMB_list->Recordset->EOF) {
	$tblSK_PMB_list->Recordset->moveFirst();
	$selectLimit = $tblSK_PMB_list->UseSelectLimit;
	if (!$selectLimit && $tblSK_PMB_list->StartRecord > 1)
		$tblSK_PMB_list->Recordset->move($tblSK_PMB_list->StartRecord - 1);
} elseif (!$tblSK_PMB->AllowAddDeleteRow && $tblSK_PMB_list->StopRecord == 0) {
	$tblSK_PMB_list->StopRecord = $tblSK_PMB->GridAddRowCount;
}

// Initialize aggregate
$tblSK_PMB->RowType = ROWTYPE_AGGREGATEINIT;
$tblSK_PMB->resetAttributes();
$tblSK_PMB_list->renderRow();
while ($tblSK_PMB_list->RecordCount < $tblSK_PMB_list->StopRecord) {
	$tblSK_PMB_list->RecordCount++;
	if ($tblSK_PMB_list->RecordCount >= $tblSK_PMB_list->StartRecord) {
		$tblSK_PMB_list->RowCount++;

		// Set up key count
		$tblSK_PMB_list->KeyCount = $tblSK_PMB_list->RowIndex;

		// Init row class and style
		$tblSK_PMB->resetAttributes();
		$tblSK_PMB->CssClass = "";
		if ($tblSK_PMB_list->isGridAdd()) {
		} else {
			$tblSK_PMB_list->loadRowValues($tblSK_PMB_list->Recordset); // Load row values
		}
		$tblSK_PMB->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tblSK_PMB->RowAttrs->merge(["data-rowindex" => $tblSK_PMB_list->RowCount, "id" => "r" . $tblSK_PMB_list->RowCount . "_tblSK_PMB", "data-rowtype" => $tblSK_PMB->RowType]);

		// Render row
		$tblSK_PMB_list->renderRow();

		// Render list options
		$tblSK_PMB_list->renderListOptions();
?>
	<tr <?php echo $tblSK_PMB->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblSK_PMB_list->ListOptions->render("body", "left", $tblSK_PMB_list->RowCount);
?>
	<?php if ($tblSK_PMB_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $tblSK_PMB_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_Thn_Akademik">
<span<?php echo $tblSK_PMB_list->Thn_Akademik->viewAttributes() ?>><?php echo $tblSK_PMB_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $tblSK_PMB_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_Periode">
<span<?php echo $tblSK_PMB_list->Periode->viewAttributes() ?>><?php echo $tblSK_PMB_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $tblSK_PMB_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_Kode_Fak">
<span<?php echo $tblSK_PMB_list->Kode_Fak->viewAttributes() ?>><?php echo $tblSK_PMB_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $tblSK_PMB_list->Tanggal->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_Tanggal">
<span<?php echo $tblSK_PMB_list->Tanggal->viewAttributes() ?>><?php echo $tblSK_PMB_list->Tanggal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->NoSK->Visible) { // NoSK ?>
		<td data-name="NoSK" <?php echo $tblSK_PMB_list->NoSK->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_NoSK">
<span<?php echo $tblSK_PMB_list->NoSK->viewAttributes() ?>><?php echo $tblSK_PMB_list->NoSK->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tblSK_PMB_list->NIDN->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_NIDN">
<span<?php echo $tblSK_PMB_list->NIDN->viewAttributes() ?>><?php echo $tblSK_PMB_list->NIDN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->Pejabat->Visible) { // Pejabat ?>
		<td data-name="Pejabat" <?php echo $tblSK_PMB_list->Pejabat->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_Pejabat">
<span<?php echo $tblSK_PMB_list->Pejabat->viewAttributes() ?>><?php echo $tblSK_PMB_list->Pejabat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tblSK_PMB_list->filesk->Visible) { // filesk ?>
		<td data-name="filesk" <?php echo $tblSK_PMB_list->filesk->cellAttributes() ?>>
<span id="el<?php echo $tblSK_PMB_list->RowCount ?>_tblSK_PMB_filesk">
<span<?php echo $tblSK_PMB_list->filesk->viewAttributes() ?>><?php echo GetFileViewTag($tblSK_PMB_list->filesk, $tblSK_PMB_list->filesk->getViewValue(), FALSE) ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblSK_PMB_list->ListOptions->render("body", "right", $tblSK_PMB_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$tblSK_PMB_list->isGridAdd())
		$tblSK_PMB_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$tblSK_PMB->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblSK_PMB_list->Recordset)
	$tblSK_PMB_list->Recordset->Close();
?>
<?php if (!$tblSK_PMB_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblSK_PMB_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblSK_PMB_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblSK_PMB_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblSK_PMB_list->TotalRecords == 0 && !$tblSK_PMB->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblSK_PMB_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblSK_PMB_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblSK_PMB_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblSK_PMB_list->terminate();
?>