<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblSK_PMB_view = new tblSK_PMB_view();

// Run the page
$tblSK_PMB_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblSK_PMB_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblSK_PMB_view->isExport()) { ?>
<script>
var ftblSK_PMBview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	ftblSK_PMBview = currentForm = new ew.Form("ftblSK_PMBview", "view");
	loadjs.done("ftblSK_PMBview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblSK_PMB_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $tblSK_PMB_view->ExportOptions->render("body") ?>
<?php $tblSK_PMB_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $tblSK_PMB_view->showPageHeader(); ?>
<?php
$tblSK_PMB_view->showMessage();
?>
<form name="ftblSK_PMBview" id="ftblSK_PMBview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblSK_PMB">
<input type="hidden" name="modal" value="<?php echo (int)$tblSK_PMB_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($tblSK_PMB_view->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<tr id="r_Thn_Akademik">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_Thn_Akademik"><?php echo $tblSK_PMB_view->Thn_Akademik->caption() ?></span></td>
		<td data-name="Thn_Akademik" <?php echo $tblSK_PMB_view->Thn_Akademik->cellAttributes() ?>>
<span id="el_tblSK_PMB_Thn_Akademik">
<span<?php echo $tblSK_PMB_view->Thn_Akademik->viewAttributes() ?>><?php echo $tblSK_PMB_view->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->Periode->Visible) { // Periode ?>
	<tr id="r_Periode">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_Periode"><?php echo $tblSK_PMB_view->Periode->caption() ?></span></td>
		<td data-name="Periode" <?php echo $tblSK_PMB_view->Periode->cellAttributes() ?>>
<span id="el_tblSK_PMB_Periode">
<span<?php echo $tblSK_PMB_view->Periode->viewAttributes() ?>><?php echo $tblSK_PMB_view->Periode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->Kode_Fak->Visible) { // Kode_Fak ?>
	<tr id="r_Kode_Fak">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_Kode_Fak"><?php echo $tblSK_PMB_view->Kode_Fak->caption() ?></span></td>
		<td data-name="Kode_Fak" <?php echo $tblSK_PMB_view->Kode_Fak->cellAttributes() ?>>
<span id="el_tblSK_PMB_Kode_Fak">
<span<?php echo $tblSK_PMB_view->Kode_Fak->viewAttributes() ?>><?php echo $tblSK_PMB_view->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->Tanggal->Visible) { // Tanggal ?>
	<tr id="r_Tanggal">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_Tanggal"><?php echo $tblSK_PMB_view->Tanggal->caption() ?></span></td>
		<td data-name="Tanggal" <?php echo $tblSK_PMB_view->Tanggal->cellAttributes() ?>>
<span id="el_tblSK_PMB_Tanggal">
<span<?php echo $tblSK_PMB_view->Tanggal->viewAttributes() ?>><?php echo $tblSK_PMB_view->Tanggal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->NoSK->Visible) { // NoSK ?>
	<tr id="r_NoSK">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_NoSK"><?php echo $tblSK_PMB_view->NoSK->caption() ?></span></td>
		<td data-name="NoSK" <?php echo $tblSK_PMB_view->NoSK->cellAttributes() ?>>
<span id="el_tblSK_PMB_NoSK">
<span<?php echo $tblSK_PMB_view->NoSK->viewAttributes() ?>><?php echo $tblSK_PMB_view->NoSK->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->NamaPejabat->Visible) { // NamaPejabat ?>
	<tr id="r_NamaPejabat">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_NamaPejabat"><?php echo $tblSK_PMB_view->NamaPejabat->caption() ?></span></td>
		<td data-name="NamaPejabat" <?php echo $tblSK_PMB_view->NamaPejabat->cellAttributes() ?>>
<span id="el_tblSK_PMB_NamaPejabat">
<span<?php echo $tblSK_PMB_view->NamaPejabat->viewAttributes() ?>><?php echo $tblSK_PMB_view->NamaPejabat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->NIDN->Visible) { // NIDN ?>
	<tr id="r_NIDN">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_NIDN"><?php echo $tblSK_PMB_view->NIDN->caption() ?></span></td>
		<td data-name="NIDN" <?php echo $tblSK_PMB_view->NIDN->cellAttributes() ?>>
<span id="el_tblSK_PMB_NIDN">
<span<?php echo $tblSK_PMB_view->NIDN->viewAttributes() ?>><?php echo $tblSK_PMB_view->NIDN->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->Pejabat->Visible) { // Pejabat ?>
	<tr id="r_Pejabat">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_Pejabat"><?php echo $tblSK_PMB_view->Pejabat->caption() ?></span></td>
		<td data-name="Pejabat" <?php echo $tblSK_PMB_view->Pejabat->cellAttributes() ?>>
<span id="el_tblSK_PMB_Pejabat">
<span<?php echo $tblSK_PMB_view->Pejabat->viewAttributes() ?>><?php echo $tblSK_PMB_view->Pejabat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tblSK_PMB_view->filesk->Visible) { // filesk ?>
	<tr id="r_filesk">
		<td class="<?php echo $tblSK_PMB_view->TableLeftColumnClass ?>"><span id="elh_tblSK_PMB_filesk"><?php echo $tblSK_PMB_view->filesk->caption() ?></span></td>
		<td data-name="filesk" <?php echo $tblSK_PMB_view->filesk->cellAttributes() ?>>
<span id="el_tblSK_PMB_filesk">
<span<?php echo $tblSK_PMB_view->filesk->viewAttributes() ?>><?php echo GetFileViewTag($tblSK_PMB_view->filesk, $tblSK_PMB_view->filesk->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("tblSK_PMB_Lulus", explode(",", $tblSK_PMB->getCurrentDetailTable())) && $tblSK_PMB_Lulus->DetailView) {
?>
<?php if ($tblSK_PMB->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("tblSK_PMB_Lulus", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "tblSK_PMB_Lulusgrid.php" ?>
<?php } ?>
</form>
<?php
$tblSK_PMB_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblSK_PMB_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblSK_PMB_view->terminate();
?>