<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tblSilabus_list = new tblSilabus_list();

// Run the page
$tblSilabus_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tblSilabus_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tblSilabus_list->isExport()) { ?>
<script>
var ftblSilabuslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftblSilabuslist = currentForm = new ew.Form("ftblSilabuslist", "list");
	ftblSilabuslist.formKeyCountName = '<?php echo $tblSilabus_list->FormKeyCountName ?>';

	// Validate form
	ftblSilabuslist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($tblSilabus_list->PertemuanKe->Required) { ?>
				elm = this.getElements("x" + infix + "_PertemuanKe");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSilabus_list->PertemuanKe->caption(), $tblSilabus_list->PertemuanKe->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSilabus_list->PokokBahasan->Required) { ?>
				elm = this.getElements("x" + infix + "_PokokBahasan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSilabus_list->PokokBahasan->caption(), $tblSilabus_list->PokokBahasan->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tblSilabus_list->SubPokokBahasan->Required) { ?>
				elm = this.getElements("x" + infix + "_SubPokokBahasan");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tblSilabus_list->SubPokokBahasan->caption(), $tblSilabus_list->SubPokokBahasan->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	ftblSilabuslist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "PertemuanKe", false)) return false;
		if (ew.valueChanged(fobj, infix, "PokokBahasan", false)) return false;
		if (ew.valueChanged(fobj, infix, "SubPokokBahasan", false)) return false;
		return true;
	}

	// Form_CustomValidate
	ftblSilabuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftblSilabuslist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftblSilabuslist.lists["x_PertemuanKe"] = <?php echo $tblSilabus_list->PertemuanKe->Lookup->toClientList($tblSilabus_list) ?>;
	ftblSilabuslist.lists["x_PertemuanKe"].options = <?php echo JsonEncode($tblSilabus_list->PertemuanKe->options(FALSE, TRUE)) ?>;
	loadjs.done("ftblSilabuslist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tblSilabus_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tblSilabus_list->TotalRecords > 0 && $tblSilabus_list->ExportOptions->visible()) { ?>
<?php $tblSilabus_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tblSilabus_list->ImportOptions->visible()) { ?>
<?php $tblSilabus_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tblSilabus_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tblSilabus_list->isExport("print")) { ?>
<?php
if ($tblSilabus_list->DbMasterFilter != "" && $tblSilabus->getCurrentMasterTable() == "tblSilabusMaster") {
	if ($tblSilabus_list->MasterRecordExists) {
		include_once "tblSilabusMastermaster.php";
	}
}
?>
<?php } ?>
<?php
$tblSilabus_list->renderOtherOptions();
?>
<?php $tblSilabus_list->showPageHeader(); ?>
<?php
$tblSilabus_list->showMessage();
?>
<?php if ($tblSilabus_list->TotalRecords > 0 || $tblSilabus->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tblSilabus_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tblSilabus">
<form name="ftblSilabuslist" id="ftblSilabuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tblSilabus">
<?php if ($tblSilabus->getCurrentMasterTable() == "tblSilabusMaster" && $tblSilabus->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="tblSilabusMaster">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($tblSilabus_list->Kode_Fak->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_MK" value="<?php echo HtmlEncode($tblSilabus_list->Kode_MK->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tblSilabus" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tblSilabus_list->TotalRecords > 0 || $tblSilabus_list->isGridEdit()) { ?>
<table id="tbl_tblSilabuslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tblSilabus->RowType = ROWTYPE_HEADER;

// Render list options
$tblSilabus_list->renderListOptions();

// Render list options (header, left)
$tblSilabus_list->ListOptions->render("header", "left");
?>
<?php if ($tblSilabus_list->PertemuanKe->Visible) { // PertemuanKe ?>
	<?php if ($tblSilabus_list->SortUrl($tblSilabus_list->PertemuanKe) == "") { ?>
		<th data-name="PertemuanKe" class="<?php echo $tblSilabus_list->PertemuanKe->headerCellClass() ?>"><div id="elh_tblSilabus_PertemuanKe" class="tblSilabus_PertemuanKe"><div class="ew-table-header-caption"><?php echo $tblSilabus_list->PertemuanKe->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PertemuanKe" class="<?php echo $tblSilabus_list->PertemuanKe->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSilabus_list->SortUrl($tblSilabus_list->PertemuanKe) ?>', 1);"><div id="elh_tblSilabus_PertemuanKe" class="tblSilabus_PertemuanKe">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSilabus_list->PertemuanKe->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSilabus_list->PertemuanKe->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSilabus_list->PertemuanKe->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSilabus_list->PokokBahasan->Visible) { // PokokBahasan ?>
	<?php if ($tblSilabus_list->SortUrl($tblSilabus_list->PokokBahasan) == "") { ?>
		<th data-name="PokokBahasan" class="<?php echo $tblSilabus_list->PokokBahasan->headerCellClass() ?>"><div id="elh_tblSilabus_PokokBahasan" class="tblSilabus_PokokBahasan"><div class="ew-table-header-caption"><?php echo $tblSilabus_list->PokokBahasan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PokokBahasan" class="<?php echo $tblSilabus_list->PokokBahasan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSilabus_list->SortUrl($tblSilabus_list->PokokBahasan) ?>', 1);"><div id="elh_tblSilabus_PokokBahasan" class="tblSilabus_PokokBahasan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSilabus_list->PokokBahasan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSilabus_list->PokokBahasan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSilabus_list->PokokBahasan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tblSilabus_list->SubPokokBahasan->Visible) { // SubPokokBahasan ?>
	<?php if ($tblSilabus_list->SortUrl($tblSilabus_list->SubPokokBahasan) == "") { ?>
		<th data-name="SubPokokBahasan" class="<?php echo $tblSilabus_list->SubPokokBahasan->headerCellClass() ?>"><div id="elh_tblSilabus_SubPokokBahasan" class="tblSilabus_SubPokokBahasan"><div class="ew-table-header-caption"><?php echo $tblSilabus_list->SubPokokBahasan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubPokokBahasan" class="<?php echo $tblSilabus_list->SubPokokBahasan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tblSilabus_list->SortUrl($tblSilabus_list->SubPokokBahasan) ?>', 1);"><div id="elh_tblSilabus_SubPokokBahasan" class="tblSilabus_SubPokokBahasan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tblSilabus_list->SubPokokBahasan->caption() ?></span><span class="ew-table-header-sort"><?php if ($tblSilabus_list->SubPokokBahasan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tblSilabus_list->SubPokokBahasan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tblSilabus_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tblSilabus_list->ExportAll && $tblSilabus_list->isExport()) {
	$tblSilabus_list->StopRecord = $tblSilabus_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tblSilabus_list->TotalRecords > $tblSilabus_list->StartRecord + $tblSilabus_list->DisplayRecords - 1)
		$tblSilabus_list->StopRecord = $tblSilabus_list->StartRecord + $tblSilabus_list->DisplayRecords - 1;
	else
		$tblSilabus_list->StopRecord = $tblSilabus_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tblSilabus->isConfirm() || $tblSilabus_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tblSilabus_list->FormKeyCountName) && ($tblSilabus_list->isGridAdd() || $tblSilabus_list->isGridEdit() || $tblSilabus->isConfirm())) {
		$tblSilabus_list->KeyCount = $CurrentForm->getValue($tblSilabus_list->FormKeyCountName);
		$tblSilabus_list->StopRecord = $tblSilabus_list->StartRecord + $tblSilabus_list->KeyCount - 1;
	}
}
$tblSilabus_list->RecordCount = $tblSilabus_list->StartRecord - 1;
if ($tblSilabus_list->Recordset && !$tblSilabus_list->Recordset->EOF) {
	$tblSilabus_list->Recordset->moveFirst();
	$selectLimit = $tblSilabus_list->UseSelectLimit;
	if (!$selectLimit && $tblSilabus_list->StartRecord > 1)
		$tblSilabus_list->Recordset->move($tblSilabus_list->StartRecord - 1);
} elseif (!$tblSilabus->AllowAddDeleteRow && $tblSilabus_list->StopRecord == 0) {
	$tblSilabus_list->StopRecord = $tblSilabus->GridAddRowCount;
}

// Initialize aggregate
$tblSilabus->RowType = ROWTYPE_AGGREGATEINIT;
$tblSilabus->resetAttributes();
$tblSilabus_list->renderRow();
if ($tblSilabus_list->isGridAdd())
	$tblSilabus_list->RowIndex = 0;
if ($tblSilabus_list->isGridEdit())
	$tblSilabus_list->RowIndex = 0;
while ($tblSilabus_list->RecordCount < $tblSilabus_list->StopRecord) {
	$tblSilabus_list->RecordCount++;
	if ($tblSilabus_list->RecordCount >= $tblSilabus_list->StartRecord) {
		$tblSilabus_list->RowCount++;
		if ($tblSilabus_list->isGridAdd() || $tblSilabus_list->isGridEdit() || $tblSilabus->isConfirm()) {
			$tblSilabus_list->RowIndex++;
			$CurrentForm->Index = $tblSilabus_list->RowIndex;
			if ($CurrentForm->hasValue($tblSilabus_list->FormActionName) && ($tblSilabus->isConfirm() || $tblSilabus_list->EventCancelled))
				$tblSilabus_list->RowAction = strval($CurrentForm->getValue($tblSilabus_list->FormActionName));
			elseif ($tblSilabus_list->isGridAdd())
				$tblSilabus_list->RowAction = "insert";
			else
				$tblSilabus_list->RowAction = "";
		}

		// Set up key count
		$tblSilabus_list->KeyCount = $tblSilabus_list->RowIndex;

		// Init row class and style
		$tblSilabus->resetAttributes();
		$tblSilabus->CssClass = "";
		if ($tblSilabus_list->isGridAdd()) {
			$tblSilabus_list->loadRowValues(); // Load default values
		} else {
			$tblSilabus_list->loadRowValues($tblSilabus_list->Recordset); // Load row values
		}
		$tblSilabus->RowType = ROWTYPE_VIEW; // Render view
		if ($tblSilabus_list->isGridAdd()) // Grid add
			$tblSilabus->RowType = ROWTYPE_ADD; // Render add
		if ($tblSilabus_list->isGridAdd() && $tblSilabus->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$tblSilabus_list->restoreCurrentRowFormValues($tblSilabus_list->RowIndex); // Restore form values
		if ($tblSilabus_list->isGridEdit()) { // Grid edit
			if ($tblSilabus->EventCancelled)
				$tblSilabus_list->restoreCurrentRowFormValues($tblSilabus_list->RowIndex); // Restore form values
			if ($tblSilabus_list->RowAction == "insert")
				$tblSilabus->RowType = ROWTYPE_ADD; // Render add
			else
				$tblSilabus->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($tblSilabus_list->isGridEdit() && ($tblSilabus->RowType == ROWTYPE_EDIT || $tblSilabus->RowType == ROWTYPE_ADD) && $tblSilabus->EventCancelled) // Update failed
			$tblSilabus_list->restoreCurrentRowFormValues($tblSilabus_list->RowIndex); // Restore form values
		if ($tblSilabus->RowType == ROWTYPE_EDIT) // Edit row
			$tblSilabus_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tblSilabus->RowAttrs->merge(["data-rowindex" => $tblSilabus_list->RowCount, "id" => "r" . $tblSilabus_list->RowCount . "_tblSilabus", "data-rowtype" => $tblSilabus->RowType]);

		// Render row
		$tblSilabus_list->renderRow();

		// Render list options
		$tblSilabus_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($tblSilabus_list->RowAction != "delete" && $tblSilabus_list->RowAction != "insertdelete" && !($tblSilabus_list->RowAction == "insert" && $tblSilabus->isConfirm() && $tblSilabus_list->emptyRow())) {
?>
	<tr <?php echo $tblSilabus->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblSilabus_list->ListOptions->render("body", "left", $tblSilabus_list->RowCount);
?>
	<?php if ($tblSilabus_list->PertemuanKe->Visible) { // PertemuanKe ?>
		<td data-name="PertemuanKe" <?php echo $tblSilabus_list->PertemuanKe->cellAttributes() ?>>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_PertemuanKe" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSilabus" data-field="x_PertemuanKe" data-value-separator="<?php echo $tblSilabus_list->PertemuanKe->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" name="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe"<?php echo $tblSilabus_list->PertemuanKe->editAttributes() ?>>
			<?php echo $tblSilabus_list->PertemuanKe->selectOptionListHtml("x{$tblSilabus_list->RowIndex}_PertemuanKe") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_PertemuanKe" name="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" id="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" value="<?php echo HtmlEncode($tblSilabus_list->PertemuanKe->OldValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSilabus" data-field="x_PertemuanKe" data-value-separator="<?php echo $tblSilabus_list->PertemuanKe->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" name="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe"<?php echo $tblSilabus_list->PertemuanKe->editAttributes() ?>>
			<?php echo $tblSilabus_list->PertemuanKe->selectOptionListHtml("x{$tblSilabus_list->RowIndex}_PertemuanKe") ?>
		</select>
</div>
<input type="hidden" data-table="tblSilabus" data-field="x_PertemuanKe" name="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" id="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" value="<?php echo HtmlEncode($tblSilabus_list->PertemuanKe->OldValue != null ? $tblSilabus_list->PertemuanKe->OldValue : $tblSilabus_list->PertemuanKe->CurrentValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_PertemuanKe">
<span<?php echo $tblSilabus_list->PertemuanKe->viewAttributes() ?>><?php echo $tblSilabus_list->PertemuanKe->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_Fak" name="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" id="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSilabus_list->Kode_Fak->CurrentValue) ?>">
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_Fak" name="o<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" id="o<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSilabus_list->Kode_Fak->OldValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_EDIT || $tblSilabus->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_Fak" name="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" id="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_Fak" value="<?php echo HtmlEncode($tblSilabus_list->Kode_Fak->CurrentValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_MK" name="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblSilabus_list->Kode_MK->CurrentValue) ?>">
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_MK" name="o<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" id="o<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblSilabus_list->Kode_MK->OldValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_EDIT || $tblSilabus->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tblSilabus" data-field="x_Kode_MK" name="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" id="x<?php echo $tblSilabus_list->RowIndex ?>_Kode_MK" value="<?php echo HtmlEncode($tblSilabus_list->Kode_MK->CurrentValue) ?>">
<?php } ?>
	<?php if ($tblSilabus_list->PokokBahasan->Visible) { // PokokBahasan ?>
		<td data-name="PokokBahasan" <?php echo $tblSilabus_list->PokokBahasan->cellAttributes() ?>>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_PokokBahasan" class="form-group">
<textarea data-table="tblSilabus" data-field="x_PokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" cols="75" rows="4" placeholder="<?php echo HtmlEncode($tblSilabus_list->PokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->PokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->PokokBahasan->EditValue ?></textarea>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_PokokBahasan" name="o<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" id="o<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" value="<?php echo HtmlEncode($tblSilabus_list->PokokBahasan->OldValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_PokokBahasan" class="form-group">
<textarea data-table="tblSilabus" data-field="x_PokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" cols="75" rows="4" placeholder="<?php echo HtmlEncode($tblSilabus_list->PokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->PokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->PokokBahasan->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_PokokBahasan">
<span<?php echo $tblSilabus_list->PokokBahasan->viewAttributes() ?>><?php echo $tblSilabus_list->PokokBahasan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tblSilabus_list->SubPokokBahasan->Visible) { // SubPokokBahasan ?>
		<td data-name="SubPokokBahasan" <?php echo $tblSilabus_list->SubPokokBahasan->cellAttributes() ?>>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_SubPokokBahasan" class="form-group">
<?php $tblSilabus_list->SubPokokBahasan->EditAttrs->appendClass("editor"); ?>
<textarea data-table="tblSilabus" data-field="x_SubPokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" cols="75" rows="5" placeholder="<?php echo HtmlEncode($tblSilabus_list->SubPokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->SubPokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->SubPokokBahasan->EditValue ?></textarea>
<script>
loadjs.ready(["ftblSilabuslist", "editor"], function() {
	ew.createEditor("ftblSilabuslist", "x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan", 75, 5, <?php echo $tblSilabus_list->SubPokokBahasan->ReadOnly || FALSE ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_SubPokokBahasan" name="o<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" id="o<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" value="<?php echo HtmlEncode($tblSilabus_list->SubPokokBahasan->OldValue) ?>">
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_SubPokokBahasan" class="form-group">
<?php $tblSilabus_list->SubPokokBahasan->EditAttrs->appendClass("editor"); ?>
<textarea data-table="tblSilabus" data-field="x_SubPokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" cols="75" rows="5" placeholder="<?php echo HtmlEncode($tblSilabus_list->SubPokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->SubPokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->SubPokokBahasan->EditValue ?></textarea>
<script>
loadjs.ready(["ftblSilabuslist", "editor"], function() {
	ew.createEditor("ftblSilabuslist", "x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan", 75, 5, <?php echo $tblSilabus_list->SubPokokBahasan->ReadOnly || FALSE ? "true" : "false" ?>);
});
</script>
</span>
<?php } ?>
<?php if ($tblSilabus->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tblSilabus_list->RowCount ?>_tblSilabus_SubPokokBahasan">
<span<?php echo $tblSilabus_list->SubPokokBahasan->viewAttributes() ?>><?php echo $tblSilabus_list->SubPokokBahasan->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblSilabus_list->ListOptions->render("body", "right", $tblSilabus_list->RowCount);
?>
	</tr>
<?php if ($tblSilabus->RowType == ROWTYPE_ADD || $tblSilabus->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftblSilabuslist", "load"], function() {
	ftblSilabuslist.updateLists(<?php echo $tblSilabus_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$tblSilabus_list->isGridAdd())
		if (!$tblSilabus_list->Recordset->EOF)
			$tblSilabus_list->Recordset->moveNext();
}
?>
<?php
	if ($tblSilabus_list->isGridAdd() || $tblSilabus_list->isGridEdit()) {
		$tblSilabus_list->RowIndex = '$rowindex$';
		$tblSilabus_list->loadRowValues();

		// Set row properties
		$tblSilabus->resetAttributes();
		$tblSilabus->RowAttrs->merge(["data-rowindex" => $tblSilabus_list->RowIndex, "id" => "r0_tblSilabus", "data-rowtype" => ROWTYPE_ADD]);
		$tblSilabus->RowAttrs->appendClass("ew-template");
		$tblSilabus->RowType = ROWTYPE_ADD;

		// Render row
		$tblSilabus_list->renderRow();

		// Render list options
		$tblSilabus_list->renderListOptions();
		$tblSilabus_list->StartRowCount = 0;
?>
	<tr <?php echo $tblSilabus->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tblSilabus_list->ListOptions->render("body", "left", $tblSilabus_list->RowIndex);
?>
	<?php if ($tblSilabus_list->PertemuanKe->Visible) { // PertemuanKe ?>
		<td data-name="PertemuanKe">
<span id="el$rowindex$_tblSilabus_PertemuanKe" class="form-group tblSilabus_PertemuanKe">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tblSilabus" data-field="x_PertemuanKe" data-value-separator="<?php echo $tblSilabus_list->PertemuanKe->displayValueSeparatorAttribute() ?>" id="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" name="x<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe"<?php echo $tblSilabus_list->PertemuanKe->editAttributes() ?>>
			<?php echo $tblSilabus_list->PertemuanKe->selectOptionListHtml("x{$tblSilabus_list->RowIndex}_PertemuanKe") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_PertemuanKe" name="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" id="o<?php echo $tblSilabus_list->RowIndex ?>_PertemuanKe" value="<?php echo HtmlEncode($tblSilabus_list->PertemuanKe->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSilabus_list->PokokBahasan->Visible) { // PokokBahasan ?>
		<td data-name="PokokBahasan">
<span id="el$rowindex$_tblSilabus_PokokBahasan" class="form-group tblSilabus_PokokBahasan">
<textarea data-table="tblSilabus" data-field="x_PokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" cols="75" rows="4" placeholder="<?php echo HtmlEncode($tblSilabus_list->PokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->PokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->PokokBahasan->EditValue ?></textarea>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_PokokBahasan" name="o<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" id="o<?php echo $tblSilabus_list->RowIndex ?>_PokokBahasan" value="<?php echo HtmlEncode($tblSilabus_list->PokokBahasan->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tblSilabus_list->SubPokokBahasan->Visible) { // SubPokokBahasan ?>
		<td data-name="SubPokokBahasan">
<span id="el$rowindex$_tblSilabus_SubPokokBahasan" class="form-group tblSilabus_SubPokokBahasan">
<?php $tblSilabus_list->SubPokokBahasan->EditAttrs->appendClass("editor"); ?>
<textarea data-table="tblSilabus" data-field="x_SubPokokBahasan" name="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" id="x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" cols="75" rows="5" placeholder="<?php echo HtmlEncode($tblSilabus_list->SubPokokBahasan->getPlaceHolder()) ?>"<?php echo $tblSilabus_list->SubPokokBahasan->editAttributes() ?>><?php echo $tblSilabus_list->SubPokokBahasan->EditValue ?></textarea>
<script>
loadjs.ready(["ftblSilabuslist", "editor"], function() {
	ew.createEditor("ftblSilabuslist", "x<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan", 75, 5, <?php echo $tblSilabus_list->SubPokokBahasan->ReadOnly || FALSE ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="tblSilabus" data-field="x_SubPokokBahasan" name="o<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" id="o<?php echo $tblSilabus_list->RowIndex ?>_SubPokokBahasan" value="<?php echo HtmlEncode($tblSilabus_list->SubPokokBahasan->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tblSilabus_list->ListOptions->render("body", "right", $tblSilabus_list->RowIndex);
?>
<script>
loadjs.ready(["ftblSilabuslist", "load"], function() {
	ftblSilabuslist.updateLists(<?php echo $tblSilabus_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tblSilabus_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $tblSilabus_list->FormKeyCountName ?>" id="<?php echo $tblSilabus_list->FormKeyCountName ?>" value="<?php echo $tblSilabus_list->KeyCount ?>">
<?php echo $tblSilabus_list->MultiSelectKey ?>
<?php } ?>
<?php if ($tblSilabus_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $tblSilabus_list->FormKeyCountName ?>" id="<?php echo $tblSilabus_list->FormKeyCountName ?>" value="<?php echo $tblSilabus_list->KeyCount ?>">
<?php echo $tblSilabus_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$tblSilabus->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tblSilabus_list->Recordset)
	$tblSilabus_list->Recordset->Close();
?>
<?php if (!$tblSilabus_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tblSilabus_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tblSilabus_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tblSilabus_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tblSilabus_list->TotalRecords == 0 && !$tblSilabus->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tblSilabus_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tblSilabus_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tblSilabus_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tblSilabus_list->terminate();
?>