<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tbljadwal_list = new tbljadwal_list();

// Run the page
$tbljadwal_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tbljadwal_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tbljadwal_list->isExport()) { ?>
<script>
var ftbljadwallist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftbljadwallist = currentForm = new ew.Form("ftbljadwallist", "list");
	ftbljadwallist.formKeyCountName = '<?php echo $tbljadwal_list->FormKeyCountName ?>';

	// Validate form
	ftbljadwallist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tbljadwal_list->Kode_Jp->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Jp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tbljadwal_list->Kode_Jp->caption(), $tbljadwal_list->Kode_Jp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tbljadwal_list->Kode_Mk->Required) { ?>
				elm = this.getElements("x" + infix + "_Kode_Mk");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tbljadwal_list->Kode_Mk->caption(), $tbljadwal_list->Kode_Mk->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tbljadwal_list->Kelas->Required) { ?>
				elm = this.getElements("x" + infix + "_Kelas");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tbljadwal_list->Kelas->caption(), $tbljadwal_list->Kelas->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tbljadwal_list->NIDN->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tbljadwal_list->NIDN->caption(), $tbljadwal_list->NIDN->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tbljadwal_list->NIDN1->Required) { ?>
				elm = this.getElements("x" + infix + "_NIDN1");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tbljadwal_list->NIDN1->caption(), $tbljadwal_list->NIDN1->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftbljadwallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftbljadwallist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftbljadwallist.lists["x_Kode_Jp"] = <?php echo $tbljadwal_list->Kode_Jp->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallist.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tbljadwal_list->Kode_Jp->lookupOptions()) ?>;
	ftbljadwallist.lists["x_Kode_Mk"] = <?php echo $tbljadwal_list->Kode_Mk->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallist.lists["x_Kode_Mk"].options = <?php echo JsonEncode($tbljadwal_list->Kode_Mk->lookupOptions()) ?>;
	ftbljadwallist.lists["x_Kelas"] = <?php echo $tbljadwal_list->Kelas->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallist.lists["x_Kelas"].options = <?php echo JsonEncode($tbljadwal_list->Kelas->options(FALSE, TRUE)) ?>;
	ftbljadwallist.lists["x_NIDN"] = <?php echo $tbljadwal_list->NIDN->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallist.lists["x_NIDN"].options = <?php echo JsonEncode($tbljadwal_list->NIDN->lookupOptions()) ?>;
	ftbljadwallist.lists["x_NIDN1"] = <?php echo $tbljadwal_list->NIDN1->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallist.lists["x_NIDN1"].options = <?php echo JsonEncode($tbljadwal_list->NIDN1->lookupOptions()) ?>;
	loadjs.done("ftbljadwallist");
});
var ftbljadwallistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftbljadwallistsrch = currentSearchForm = new ew.Form("ftbljadwallistsrch");

	// Validate function for search
	ftbljadwallistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	ftbljadwallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftbljadwallistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	ftbljadwallistsrch.lists["x_Kode_Jp"] = <?php echo $tbljadwal_list->Kode_Jp->Lookup->toClientList($tbljadwal_list) ?>;
	ftbljadwallistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($tbljadwal_list->Kode_Jp->lookupOptions()) ?>;

	// Filters
	ftbljadwallistsrch.filterList = <?php echo $tbljadwal_list->getFilterList() ?>;
	loadjs.done("ftbljadwallistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tbljadwal_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tbljadwal_list->TotalRecords > 0 && $tbljadwal_list->ExportOptions->visible()) { ?>
<?php $tbljadwal_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tbljadwal_list->ImportOptions->visible()) { ?>
<?php $tbljadwal_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tbljadwal_list->SearchOptions->visible()) { ?>
<?php $tbljadwal_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tbljadwal_list->FilterOptions->visible()) { ?>
<?php $tbljadwal_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$tbljadwal_list->isExport() || Config("EXPORT_MASTER_RECORD") && $tbljadwal_list->isExport("print")) { ?>
<?php
if ($tbljadwal_list->DbMasterFilter != "" && $tbljadwal->getCurrentMasterTable() == "tblMasterJadwal") {
	if ($tbljadwal_list->MasterRecordExists) {
		include_once "tblMasterJadwalmaster.php";
	}
}
?>
<?php } ?>
<?php
$tbljadwal_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tbljadwal_list->isExport() && !$tbljadwal->CurrentAction) { ?>
<form name="ftbljadwallistsrch" id="ftbljadwallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftbljadwallistsrch-search-panel" class="<?php echo $tbljadwal_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tbljadwal">
	<div class="ew-extended-search">
<?php

// Render search row
$tbljadwal->RowType = ROWTYPE_SEARCH;
$tbljadwal->resetAttributes();
$tbljadwal_list->renderRow();
?>
<?php if ($tbljadwal_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$tbljadwal_list->SearchColumnCount++;
		if (($tbljadwal_list->SearchColumnCount - 1) % $tbljadwal_list->SearchFieldsPerRow == 0) {
			$tbljadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $tbljadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $tbljadwal_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_tbljadwal_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tbljadwal" data-field="x_Kode_Jp" data-value-separator="<?php echo $tbljadwal_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $tbljadwal_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tbljadwal_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $tbljadwal_list->Kode_Jp->Lookup->getParamTag($tbljadwal_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($tbljadwal_list->SearchColumnCount % $tbljadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($tbljadwal_list->SearchColumnCount % $tbljadwal_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $tbljadwal_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tbljadwal_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tbljadwal_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tbljadwal_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tbljadwal_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tbljadwal_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tbljadwal_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tbljadwal_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tbljadwal_list->showPageHeader(); ?>
<?php
$tbljadwal_list->showMessage();
?>
<?php if ($tbljadwal_list->TotalRecords > 0 || $tbljadwal->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tbljadwal_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tbljadwal">
<form name="ftbljadwallist" id="ftbljadwallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tbljadwal">
<?php if ($tbljadwal->getCurrentMasterTable() == "tblMasterJadwal" && $tbljadwal->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="tblMasterJadwal">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($tbljadwal_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($tbljadwal_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas_Akd" value="<?php echo HtmlEncode($tbljadwal_list->Kelas_Akd->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($tbljadwal_list->Kode_Fak->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_tbljadwal" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tbljadwal_list->TotalRecords > 0 || $tbljadwal_list->isAdd() || $tbljadwal_list->isCopy() || $tbljadwal_list->isGridEdit()) { ?>
<table id="tbl_tbljadwallist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tbljadwal->RowType = ROWTYPE_HEADER;

// Render list options
$tbljadwal_list->renderListOptions();

// Render list options (header, left)
$tbljadwal_list->ListOptions->render("header", "left");
?>
<?php if ($tbljadwal_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($tbljadwal_list->SortUrl($tbljadwal_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $tbljadwal_list->Kode_Jp->headerCellClass() ?>"><div id="elh_tbljadwal_Kode_Jp" class="tbljadwal_Kode_Jp"><div class="ew-table-header-caption"><?php echo $tbljadwal_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $tbljadwal_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tbljadwal_list->SortUrl($tbljadwal_list->Kode_Jp) ?>', 1);"><div id="elh_tbljadwal_Kode_Jp" class="tbljadwal_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tbljadwal_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tbljadwal_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tbljadwal_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tbljadwal_list->Kode_Mk->Visible) { // Kode_Mk ?>
	<?php if ($tbljadwal_list->SortUrl($tbljadwal_list->Kode_Mk) == "") { ?>
		<th data-name="Kode_Mk" class="<?php echo $tbljadwal_list->Kode_Mk->headerCellClass() ?>"><div id="elh_tbljadwal_Kode_Mk" class="tbljadwal_Kode_Mk"><div class="ew-table-header-caption"><?php echo $tbljadwal_list->Kode_Mk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Mk" class="<?php echo $tbljadwal_list->Kode_Mk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tbljadwal_list->SortUrl($tbljadwal_list->Kode_Mk) ?>', 1);"><div id="elh_tbljadwal_Kode_Mk" class="tbljadwal_Kode_Mk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tbljadwal_list->Kode_Mk->caption() ?></span><span class="ew-table-header-sort"><?php if ($tbljadwal_list->Kode_Mk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tbljadwal_list->Kode_Mk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tbljadwal_list->Kelas->Visible) { // Kelas ?>
	<?php if ($tbljadwal_list->SortUrl($tbljadwal_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $tbljadwal_list->Kelas->headerCellClass() ?>"><div id="elh_tbljadwal_Kelas" class="tbljadwal_Kelas"><div class="ew-table-header-caption"><?php echo $tbljadwal_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $tbljadwal_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tbljadwal_list->SortUrl($tbljadwal_list->Kelas) ?>', 1);"><div id="elh_tbljadwal_Kelas" class="tbljadwal_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tbljadwal_list->Kelas->caption() ?></span><span class="ew-table-header-sort"><?php if ($tbljadwal_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tbljadwal_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tbljadwal_list->NIDN->Visible) { // NIDN ?>
	<?php if ($tbljadwal_list->SortUrl($tbljadwal_list->NIDN) == "") { ?>
		<th data-name="NIDN" class="<?php echo $tbljadwal_list->NIDN->headerCellClass() ?>"><div id="elh_tbljadwal_NIDN" class="tbljadwal_NIDN"><div class="ew-table-header-caption"><?php echo $tbljadwal_list->NIDN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN" class="<?php echo $tbljadwal_list->NIDN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tbljadwal_list->SortUrl($tbljadwal_list->NIDN) ?>', 1);"><div id="elh_tbljadwal_NIDN" class="tbljadwal_NIDN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tbljadwal_list->NIDN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tbljadwal_list->NIDN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tbljadwal_list->NIDN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tbljadwal_list->NIDN1->Visible) { // NIDN1 ?>
	<?php if ($tbljadwal_list->SortUrl($tbljadwal_list->NIDN1) == "") { ?>
		<th data-name="NIDN1" class="<?php echo $tbljadwal_list->NIDN1->headerCellClass() ?>"><div id="elh_tbljadwal_NIDN1" class="tbljadwal_NIDN1"><div class="ew-table-header-caption"><?php echo $tbljadwal_list->NIDN1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDN1" class="<?php echo $tbljadwal_list->NIDN1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tbljadwal_list->SortUrl($tbljadwal_list->NIDN1) ?>', 1);"><div id="elh_tbljadwal_NIDN1" class="tbljadwal_NIDN1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tbljadwal_list->NIDN1->caption() ?></span><span class="ew-table-header-sort"><?php if ($tbljadwal_list->NIDN1->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tbljadwal_list->NIDN1->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tbljadwal_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
	if ($tbljadwal_list->isAdd() || $tbljadwal_list->isCopy()) {
		$tbljadwal_list->RowIndex = 0;
		$tbljadwal_list->KeyCount = $tbljadwal_list->RowIndex;
		if ($tbljadwal_list->isAdd())
			$tbljadwal_list->loadRowValues();
		if ($tbljadwal->EventCancelled) // Insert failed
			$tbljadwal_list->restoreFormValues(); // Restore form values

		// Set row properties
		$tbljadwal->resetAttributes();
		$tbljadwal->RowAttrs->merge(["data-rowindex" => 0, "id" => "r0_tbljadwal", "data-rowtype" => ROWTYPE_ADD]);
		$tbljadwal->RowType = ROWTYPE_ADD;

		// Render row
		$tbljadwal_list->renderRow();

		// Render list options
		$tbljadwal_list->renderListOptions();
		$tbljadwal_list->StartRowCount = 0;
?>
	<tr <?php echo $tbljadwal->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tbljadwal_list->ListOptions->render("body", "left", $tbljadwal_list->RowCount);
?>
	<?php if ($tbljadwal_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp">
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kode_Jp" class="form-group tbljadwal_Kode_Jp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tbljadwal" data-field="x_Kode_Jp" data-value-separator="<?php echo $tbljadwal_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp"<?php echo $tbljadwal_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tbljadwal_list->Kode_Jp->selectOptionListHtml("x{$tbljadwal_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tbljadwal_list->Kode_Jp->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_Kode_Jp") ?>
</span>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Jp" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tbljadwal_list->Kode_Jp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->Kode_Mk->Visible) { // Kode_Mk ?>
		<td data-name="Kode_Mk">
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kode_Mk" class="form-group tbljadwal_Kode_Mk">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk"><?php echo EmptyValue(strval($tbljadwal_list->Kode_Mk->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->Kode_Mk->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->Kode_Mk->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->Kode_Mk->ReadOnly || $tbljadwal_list->Kode_Mk->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->Kode_Mk->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_Kode_Mk") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Mk" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->Kode_Mk->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" value="<?php echo $tbljadwal_list->Kode_Mk->CurrentValue ?>"<?php echo $tbljadwal_list->Kode_Mk->editAttributes() ?>>
</span>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Mk" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" value="<?php echo HtmlEncode($tbljadwal_list->Kode_Mk->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas">
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kelas" class="form-group tbljadwal_Kelas">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tbljadwal" data-field="x_Kelas" data-value-separator="<?php echo $tbljadwal_list->Kelas->displayValueSeparatorAttribute() ?>" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas"<?php echo $tbljadwal_list->Kelas->editAttributes() ?>>
			<?php echo $tbljadwal_list->Kelas->selectOptionListHtml("x{$tbljadwal_list->RowIndex}_Kelas") ?>
		</select>
</div>
</span>
<input type="hidden" data-table="tbljadwal" data-field="x_Kelas" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kelas" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kelas" value="<?php echo HtmlEncode($tbljadwal_list->Kelas->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN">
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN" class="form-group tbljadwal_NIDN">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tbljadwal_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->NIDN->ReadOnly || $tbljadwal_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->NIDN->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN" id="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN" value="<?php echo $tbljadwal_list->NIDN->CurrentValue ?>"<?php echo $tbljadwal_list->NIDN->editAttributes() ?>>
</span>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN" name="o<?php echo $tbljadwal_list->RowIndex ?>_NIDN" id="o<?php echo $tbljadwal_list->RowIndex ?>_NIDN" value="<?php echo HtmlEncode($tbljadwal_list->NIDN->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->NIDN1->Visible) { // NIDN1 ?>
		<td data-name="NIDN1">
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN1" class="form-group tbljadwal_NIDN1">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1"><?php echo EmptyValue(strval($tbljadwal_list->NIDN1->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->NIDN1->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->NIDN1->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->NIDN1->ReadOnly || $tbljadwal_list->NIDN1->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->NIDN1->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_NIDN1") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->NIDN1->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" id="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" value="<?php echo $tbljadwal_list->NIDN1->CurrentValue ?>"<?php echo $tbljadwal_list->NIDN1->editAttributes() ?>>
</span>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN1" name="o<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" id="o<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" value="<?php echo HtmlEncode($tbljadwal_list->NIDN1->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tbljadwal_list->ListOptions->render("body", "right", $tbljadwal_list->RowCount);
?>
<script>
loadjs.ready(["ftbljadwallist", "load"], function() {
	ftbljadwallist.updateLists(<?php echo $tbljadwal_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
<?php
if ($tbljadwal_list->ExportAll && $tbljadwal_list->isExport()) {
	$tbljadwal_list->StopRecord = $tbljadwal_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tbljadwal_list->TotalRecords > $tbljadwal_list->StartRecord + $tbljadwal_list->DisplayRecords - 1)
		$tbljadwal_list->StopRecord = $tbljadwal_list->StartRecord + $tbljadwal_list->DisplayRecords - 1;
	else
		$tbljadwal_list->StopRecord = $tbljadwal_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($tbljadwal->isConfirm() || $tbljadwal_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($tbljadwal_list->FormKeyCountName) && ($tbljadwal_list->isGridAdd() || $tbljadwal_list->isGridEdit() || $tbljadwal->isConfirm())) {
		$tbljadwal_list->KeyCount = $CurrentForm->getValue($tbljadwal_list->FormKeyCountName);
		$tbljadwal_list->StopRecord = $tbljadwal_list->StartRecord + $tbljadwal_list->KeyCount - 1;
	}
}
$tbljadwal_list->RecordCount = $tbljadwal_list->StartRecord - 1;
if ($tbljadwal_list->Recordset && !$tbljadwal_list->Recordset->EOF) {
	$tbljadwal_list->Recordset->moveFirst();
	$selectLimit = $tbljadwal_list->UseSelectLimit;
	if (!$selectLimit && $tbljadwal_list->StartRecord > 1)
		$tbljadwal_list->Recordset->move($tbljadwal_list->StartRecord - 1);
} elseif (!$tbljadwal->AllowAddDeleteRow && $tbljadwal_list->StopRecord == 0) {
	$tbljadwal_list->StopRecord = $tbljadwal->GridAddRowCount;
}

// Initialize aggregate
$tbljadwal->RowType = ROWTYPE_AGGREGATEINIT;
$tbljadwal->resetAttributes();
$tbljadwal_list->renderRow();
$tbljadwal_list->EditRowCount = 0;
if ($tbljadwal_list->isEdit())
	$tbljadwal_list->RowIndex = 1;
while ($tbljadwal_list->RecordCount < $tbljadwal_list->StopRecord) {
	$tbljadwal_list->RecordCount++;
	if ($tbljadwal_list->RecordCount >= $tbljadwal_list->StartRecord) {
		$tbljadwal_list->RowCount++;

		// Set up key count
		$tbljadwal_list->KeyCount = $tbljadwal_list->RowIndex;

		// Init row class and style
		$tbljadwal->resetAttributes();
		$tbljadwal->CssClass = "";
		if ($tbljadwal_list->isGridAdd()) {
			$tbljadwal_list->loadRowValues(); // Load default values
		} else {
			$tbljadwal_list->loadRowValues($tbljadwal_list->Recordset); // Load row values
		}
		$tbljadwal->RowType = ROWTYPE_VIEW; // Render view
		if ($tbljadwal_list->isEdit()) {
			if ($tbljadwal_list->checkInlineEditKey() && $tbljadwal_list->EditRowCount == 0) { // Inline edit
				$tbljadwal->RowType = ROWTYPE_EDIT; // Render edit
			}
		}
		if ($tbljadwal_list->isEdit() && $tbljadwal->RowType == ROWTYPE_EDIT && $tbljadwal->EventCancelled) { // Update failed
			$CurrentForm->Index = 1;
			$tbljadwal_list->restoreFormValues(); // Restore form values
		}
		if ($tbljadwal->RowType == ROWTYPE_EDIT) // Edit row
			$tbljadwal_list->EditRowCount++;

		// Set up row id / data-rowindex
		$tbljadwal->RowAttrs->merge(["data-rowindex" => $tbljadwal_list->RowCount, "id" => "r" . $tbljadwal_list->RowCount . "_tbljadwal", "data-rowtype" => $tbljadwal->RowType]);

		// Render row
		$tbljadwal_list->renderRow();

		// Render list options
		$tbljadwal_list->renderListOptions();
?>
	<tr <?php echo $tbljadwal->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tbljadwal_list->ListOptions->render("body", "left", $tbljadwal_list->RowCount);
?>
	<?php if ($tbljadwal_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $tbljadwal_list->Kode_Jp->cellAttributes() ?>>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tbljadwal" data-field="x_Kode_Jp" data-value-separator="<?php echo $tbljadwal_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp"<?php echo $tbljadwal_list->Kode_Jp->editAttributes() ?>>
			<?php echo $tbljadwal_list->Kode_Jp->selectOptionListHtml("x{$tbljadwal_list->RowIndex}_Kode_Jp") ?>
		</select>
</div>
<?php echo $tbljadwal_list->Kode_Jp->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_Kode_Jp") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Jp" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Jp" value="<?php echo HtmlEncode($tbljadwal_list->Kode_Jp->OldValue != null ? $tbljadwal_list->Kode_Jp->OldValue : $tbljadwal_list->Kode_Jp->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kode_Jp">
<span<?php echo $tbljadwal_list->Kode_Jp->viewAttributes() ?>><?php echo $tbljadwal_list->Kode_Jp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT || $tbljadwal->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Thn_Akademik" name="x<?php echo $tbljadwal_list->RowIndex ?>_Thn_Akademik" id="x<?php echo $tbljadwal_list->RowIndex ?>_Thn_Akademik" value="<?php echo HtmlEncode($tbljadwal_list->Thn_Akademik->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT || $tbljadwal->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Periode" name="x<?php echo $tbljadwal_list->RowIndex ?>_Periode" id="x<?php echo $tbljadwal_list->RowIndex ?>_Periode" value="<?php echo HtmlEncode($tbljadwal_list->Periode->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT || $tbljadwal->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Kelas_Akd" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas_Akd" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas_Akd" value="<?php echo HtmlEncode($tbljadwal_list->Kelas_Akd->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT || $tbljadwal->CurrentMode == "edit") { ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Jenis" name="x<?php echo $tbljadwal_list->RowIndex ?>_Jenis" id="x<?php echo $tbljadwal_list->RowIndex ?>_Jenis" value="<?php echo HtmlEncode($tbljadwal_list->Jenis->CurrentValue) ?>">
<?php } ?>
	<?php if ($tbljadwal_list->Kode_Mk->Visible) { // Kode_Mk ?>
		<td data-name="Kode_Mk" <?php echo $tbljadwal_list->Kode_Mk->cellAttributes() ?>>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk"><?php echo EmptyValue(strval($tbljadwal_list->Kode_Mk->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->Kode_Mk->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->Kode_Mk->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->Kode_Mk->ReadOnly || $tbljadwal_list->Kode_Mk->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->Kode_Mk->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_Kode_Mk") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Mk" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->Kode_Mk->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" value="<?php echo $tbljadwal_list->Kode_Mk->CurrentValue ?>"<?php echo $tbljadwal_list->Kode_Mk->editAttributes() ?>>
<input type="hidden" data-table="tbljadwal" data-field="x_Kode_Mk" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kode_Mk" value="<?php echo HtmlEncode($tbljadwal_list->Kode_Mk->OldValue != null ? $tbljadwal_list->Kode_Mk->OldValue : $tbljadwal_list->Kode_Mk->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kode_Mk">
<span<?php echo $tbljadwal_list->Kode_Mk->viewAttributes() ?>><?php echo $tbljadwal_list->Kode_Mk->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $tbljadwal_list->Kelas->cellAttributes() ?>>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tbljadwal" data-field="x_Kelas" data-value-separator="<?php echo $tbljadwal_list->Kelas->displayValueSeparatorAttribute() ?>" id="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas" name="x<?php echo $tbljadwal_list->RowIndex ?>_Kelas"<?php echo $tbljadwal_list->Kelas->editAttributes() ?>>
			<?php echo $tbljadwal_list->Kelas->selectOptionListHtml("x{$tbljadwal_list->RowIndex}_Kelas") ?>
		</select>
</div>
<input type="hidden" data-table="tbljadwal" data-field="x_Kelas" name="o<?php echo $tbljadwal_list->RowIndex ?>_Kelas" id="o<?php echo $tbljadwal_list->RowIndex ?>_Kelas" value="<?php echo HtmlEncode($tbljadwal_list->Kelas->OldValue != null ? $tbljadwal_list->Kelas->OldValue : $tbljadwal_list->Kelas->CurrentValue) ?>">
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_Kelas">
<span<?php echo $tbljadwal_list->Kelas->viewAttributes() ?>><?php echo $tbljadwal_list->Kelas->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->NIDN->Visible) { // NIDN ?>
		<td data-name="NIDN" <?php echo $tbljadwal_list->NIDN->cellAttributes() ?>>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_NIDN"><?php echo EmptyValue(strval($tbljadwal_list->NIDN->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->NIDN->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->NIDN->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->NIDN->ReadOnly || $tbljadwal_list->NIDN->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_NIDN',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->NIDN->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_NIDN") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->NIDN->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN" id="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN" value="<?php echo $tbljadwal_list->NIDN->CurrentValue ?>"<?php echo $tbljadwal_list->NIDN->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN">
<span<?php echo $tbljadwal_list->NIDN->viewAttributes() ?>><?php echo $tbljadwal_list->NIDN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($tbljadwal_list->NIDN1->Visible) { // NIDN1 ?>
		<td data-name="NIDN1" <?php echo $tbljadwal_list->NIDN1->cellAttributes() ?>>
<?php if ($tbljadwal->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN1" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1"><?php echo EmptyValue(strval($tbljadwal_list->NIDN1->ViewValue)) ? $Language->phrase("PleaseSelect") : $tbljadwal_list->NIDN1->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tbljadwal_list->NIDN1->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($tbljadwal_list->NIDN1->ReadOnly || $tbljadwal_list->NIDN1->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $tbljadwal_list->NIDN1->Lookup->getParamTag($tbljadwal_list, "p_x" . $tbljadwal_list->RowIndex . "_NIDN1") ?>
<input type="hidden" data-table="tbljadwal" data-field="x_NIDN1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tbljadwal_list->NIDN1->displayValueSeparatorAttribute() ?>" name="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" id="x<?php echo $tbljadwal_list->RowIndex ?>_NIDN1" value="<?php echo $tbljadwal_list->NIDN1->CurrentValue ?>"<?php echo $tbljadwal_list->NIDN1->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($tbljadwal->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $tbljadwal_list->RowCount ?>_tbljadwal_NIDN1">
<span<?php echo $tbljadwal_list->NIDN1->viewAttributes() ?>><?php echo $tbljadwal_list->NIDN1->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tbljadwal_list->ListOptions->render("body", "right", $tbljadwal_list->RowCount);
?>
	</tr>
<?php if ($tbljadwal->RowType == ROWTYPE_ADD || $tbljadwal->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftbljadwallist", "load"], function() {
	ftbljadwallist.updateLists(<?php echo $tbljadwal_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	if (!$tbljadwal_list->isGridAdd())
		$tbljadwal_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($tbljadwal_list->isAdd() || $tbljadwal_list->isCopy()) { ?>
<input type="hidden" name="<?php echo $tbljadwal_list->FormKeyCountName ?>" id="<?php echo $tbljadwal_list->FormKeyCountName ?>" value="<?php echo $tbljadwal_list->KeyCount ?>">
<?php } ?>
<?php if ($tbljadwal_list->isEdit()) { ?>
<input type="hidden" name="<?php echo $tbljadwal_list->FormKeyCountName ?>" id="<?php echo $tbljadwal_list->FormKeyCountName ?>" value="<?php echo $tbljadwal_list->KeyCount ?>">
<?php } ?>
<?php if (!$tbljadwal->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tbljadwal_list->Recordset)
	$tbljadwal_list->Recordset->Close();
?>
<?php if (!$tbljadwal_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tbljadwal_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tbljadwal_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tbljadwal_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tbljadwal_list->TotalRecords == 0 && !$tbljadwal->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tbljadwal_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tbljadwal_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tbljadwal_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tbljadwal_list->terminate();
?>