<?php
session_start();

// Fungsi untuk koneksi database MSSQL
function Conn() {
	$serverName = "localhost";
	$connectionInfo = array(
		"Database" => "SIAP",
		"Uid" => "Akademik",
		"PWD" => "134nj4r4n",
		"CharacterSet" => "UTF-8"
	);
	
	$conn = sqlsrv_connect($serverName, $connectionInfo);
	
	if ($conn === false) {
		die(print_r(sqlsrv_errors(), true));
	}
	return $conn;
}

// Fungsi untuk encoding HTML
function HtmlEncode($value) {
	return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
	$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$tokenValue = $_SESSION['csrf_token'];

// Proses utama
$id_jadwal = $_GET['id'] ?? '';
$conn = Conn();

// Handle POST request
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
		die("Invalid request");
	}

	$id_jadwal = $_POST['id_jadwal'];
	$imageData = $_POST['signature'] ?? '';
	
	if (!empty($imageData)) {
		$filename = md5($id_jadwal . time()) . ".png";
		$folderPath = "paraf/";
		
		if (!file_exists($folderPath)) {
			mkdir($folderPath, 0777, true);
		}
		
		$fullPath = $folderPath . $filename;
		$data = explode(',', $imageData);
		$decodedData = base64_decode($data[1]);
		file_put_contents($fullPath, $decodedData);

		// UPDATE menggunakan sqlsrv
		$sql = "UPDATE RKP_AbsenDosen SET parafbaak = ? WHERE id_jadwal = ?";
		$params = array($filename, $id_jadwal);
		$stmt = sqlsrv_prepare($conn, $sql, $params);
		
		if (sqlsrv_execute($stmt)) {
			$message = "<div class='alert alert-success alert-dismissible fade show' role='alert'>
						  <strong>Berhasil!</strong> Tanda tangan berhasil disimpan.
						  <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
						</div>";
		} else {
			$error = sqlsrv_errors();
			$message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
						  <strong>Error!</strong> Gagal menyimpan data: " . $error[0]['message'] . "
						  <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
						</div>";
		}
	} else {
		$message = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
					  <strong>Error!</strong> Data tanda tangan tidak valid.
					  <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
					</div>";
	}
}

// Ambil data dari database
$id_jadwal_display = $id_jadwal;
$ttdfile = '';
if (!empty($id_jadwal)) {
	$sql = "SELECT id_jadwal, parafbaak FROM RKP_AbsenDosen WHERE id_jadwal = ?";
	$params = array($id_jadwal);
	$stmt = sqlsrv_query($conn, $sql, $params);
	
	if ($stmt === false) {
		die(print_r(sqlsrv_errors(), true));
	}

	$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	if ($row) {
		$id_jadwal_display = $row['id_jadwal'];
		$ttdfile = $row['parafbaak'];
	}
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Sistem Presensi - Akademik</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
	<style>
		body {
			background: linear-gradient(135deg,rgb(12, 84, 209) 0%,rgb(227, 162, 13) 100%);
			min-height: 100vh;
			padding: 20px;
			font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
		}
		.card {
			border-radius: 15px;
			overflow: hidden;
			box-shadow: 0 10px 30px rgba(0,0,0,0.15);
			transition: transform 0.3s;
		}
		.card:hover {
			transform: translateY(-5px);
		}
		.card-header {
			font-weight: 600;
			letter-spacing: 0.5px;
		}
		#signature-pad {
			border: 2px dashed #6c757d;
			background-color: #f8f9fa;
			cursor: crosshair;
			border-radius: 8px;
		}
		.preview-container {
			border: 2px dashed #0d6efd;
			border-radius: 8px;
			padding: 15px;
			background-color: #f8f9fa;
			min-height: 200px;
			display: flex;
			align-items: center;
			justify-content: center;
		}
		.action-buttons .btn {
			min-width: 100px;
			margin: 5px;
			box-shadow: 0 4px 6px rgba(0,0,0,0.1);
		}
		.info-card {
			background: rgba(255,255,255,0.9);
			border-radius: 10px;
			padding: 15px;
			margin-bottom: 20px;
		}
		.info-card i {
			font-size: 1.5rem;
			margin-right: 10px;
			color: #0d6efd;
		}
		.signature-instructions {
			background: #e9f7fe;
			border-left: 4px solid #0d6efd;
			padding: 15px;
			border-radius: 0 8px 8px 0;
			margin-bottom: 20px;
		}
		footer {
			color: white;
			text-align: center;
			padding: 20px 0;
			font-size: 0.9rem;
			margin-top: 30px;
		}
		.system-title {
			text-align: center;
			color: white;
			margin-bottom: 30px;
			text-shadow: 0 2px 4px rgba(0,0,0,0.3);
		}
		.system-title h1 {
			font-weight: 700;
			font-size: 2.5rem;
			letter-spacing: 1px;
		}
		.system-title p {
			font-size: 1.1rem;
			opacity: 0.9;
		}
	</style>
</head>
<body>
	<div class="container">
		<div class="system-title">
			<h1><i class="fas fa-signature me-3"></i>SISTEM PRESENSI</h1>
			<p>STMIK IM & STIE STAN IM</p>
		</div>
		
		<?php if(!empty($message)) echo $message; ?>
		
		<div class="info-card">
			<div class="row">
				<div class="col-md-4 d-flex align-items-center">
					<i class="fas fa-info-circle"></i>
					<div>
						<h5 class="mb-0">ID Jadwal</h5>
						<p class="mb-0 fw-bold"><?= HtmlEncode($id_jadwal_display) ?></p>
					</div>
				</div>
				<div class="col-md-4 d-flex align-items-center">
					<i class="fas fa-calendar-alt"></i>
					<div>
						<h5 class="mb-0">Tanggal</h5>
						<p class="mb-0 fw-bold"><?= date('d F Y') ?></p>
					</div>
				</div>
				<div class="col-md-4 d-flex align-items-center">
					<i class="fas fa-user-tie"></i>
					<div>
						<h5 class="mb-0">Petugas BAAK</h5>
						<p class="mb-0 fw-bold">Dr. Ahmad S.T., M.Kom.</p>
					</div>
				</div>
			</div>
		</div>
		
		<div class="signature-instructions">
			<h5><i class="fas fa-pencil-alt me-2"></i>Petunjuk Tanda Tangan:</h5>
			<p class="mb-0">Gunakan mouse atau jari (pada perangkat touchscreen) untuk membuat tanda tangan pada area yang disediakan. Pastikan tanda tangan jelas dan sesuai dengan tanda tangan resmi Anda.</p>
		</div>

		<div class="card shadow-lg">
			<div class="card-header bg-primary text-white py-3">
				<h4 class="mb-0"><i class="fas fa-file-signature me-2"></i>Pengesahhan Presensi Perkuliahan</h4>
			</div>
			<div class="card-body">
				<div class="row">
					<!-- Kolom Kiri: Canvas dan Form -->
					<div class="col-lg-6 mb-4 mb-lg-0">
						<form method="POST" id="signatureForm">
							<input type="hidden" name="csrf_token" value="<?= $tokenValue ?>">
							<input type="hidden" name="id_jadwal" value="<?= HtmlEncode($id_jadwal_display) ?>">
							<input type="hidden" name="signature" id="signature">
							
							<div class="mb-4">
								<label class="form-label fw-bold">Area Tanda Tangan:</label>
								<div class="border rounded p-2 bg-light">
									<canvas id="signature-pad" width="450" height="250"></canvas>
								</div>
								<small class="text-muted">Gambar tanda tangan Anda di area ini</small>
							</div>
							
							<div class="d-flex justify-content-center action-buttons mt-4">
								<button type="submit" class="btn btn-success btn-lg px-4">
									<i class="fas fa-save me-2"></i>Simpan
								</button>
								<button type="button" class="btn btn-outline-danger btn-lg px-4" onclick="clearPad()">
									<i class="fas fa-eraser me-2"></i>Hapus
								</button>
							</div>
						</form>
					</div>

					<!-- Kolom Kanan: Preview Gambar Tanda Tangan -->
					<div class="col-lg-6">
						<div class="mb-3">
							<label class="form-label fw-bold">Preview Tanda Tangan:</label>
							<div class="preview-container">
								<?php if (!empty($ttdfile)): ?>
									<img src="paraf/<?= HtmlEncode($ttdfile) ?>" 
										 class="img-fluid"
										 alt="Tanda Tangan"
										 style="max-height: 200px;">
								<?php else: ?>
									<div class="text-center text-muted py-4">
										<i class="fas fa-signature display-4 mb-3"></i>
										<p class="mb-0">Belum ada tanda tangan</p>
										<small>Tanda tangan akan muncul di sini setelah disimpan</small>
									</div>
								<?php endif; ?>
							</div>
						</div>
						
						<div class="mt-4">
							<div class="alert alert-info">
								<h5><i class="fas fa-lightbulb me-2"></i>Informasi Penting:</h5>
								<ul class="mb-0">
									<li>Tanda tangan ini bersifat resmi dan mengikat</li>
									<li>Pastikan tanda tangan jelas dan terbaca</li>
									<li>Klik "Simpan" untuk menyimpan secara permanen</li>
									<li>Hubungi BLAK jika terjadi kesalahan</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<footer>
			<p class="mb-1">Sistem Informasi Akademik (SIAP)&copy; 2023 - Indonesia Mandiri</p>
			<p class="mb-0">Versi 2.1.5 | Terakhir diperbarui: 15 Maret 2025</p>
		</footer>
	</div>

	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script>
	document.addEventListener('DOMContentLoaded', function() {
		const canvas = document.getElementById('signature-pad');
		const ctx = canvas.getContext('2d');
		let drawing = false;
		
		// Set canvas size
		canvas.width = canvas.offsetWidth;
		canvas.height = canvas.offsetHeight;
		
		// Set drawing style
		ctx.lineWidth = 2.5;
		ctx.lineJoin = 'round';
		ctx.lineCap = 'round';
		ctx.strokeStyle = '#0d6efd';
		
		// Function to get position
		function getPos(e) {
			const rect = canvas.getBoundingClientRect();
			return {
				x: e.clientX - rect.left,
				y: e.clientY - rect.top
			};
		}
		
		// Mouse events
		canvas.addEventListener('mousedown', (e) => {
			drawing = true;
			const pos = getPos(e);
			ctx.beginPath();
			ctx.moveTo(pos.x, pos.y);
		});
		
		canvas.addEventListener('mousemove', (e) => {
			if (!drawing) return;
			const pos = getPos(e);
			ctx.lineTo(pos.x, pos.y);
			ctx.stroke();
		});
		
		canvas.addEventListener('mouseup', () => drawing = false);
		canvas.addEventListener('mouseout', () => drawing = false);
		
		// Touch events
		canvas.addEventListener('touchstart', (e) => {
			e.preventDefault();
			drawing = true;
			const touch = e.touches[0];
			const pos = getPos(touch);
			ctx.beginPath();
			ctx.moveTo(pos.x, pos.y);
		});
		
		canvas.addEventListener('touchmove', (e) => {
			if (!drawing) return;
			e.preventDefault();
			const touch = e.touches[0];
			const pos = getPos(touch);
			ctx.lineTo(pos.x, pos.y);
			ctx.stroke();
		});
		
		canvas.addEventListener('touchend', () => drawing = false);
		
		// Form submission
		document.getElementById('signatureForm').addEventListener('submit', function(e) {
			const signatureInput = document.getElementById('signature');
			if (isCanvasBlank(canvas)) {
				e.preventDefault();
				alert('Harap membuat tanda tangan terlebih dahulu!');
			} else {
				signatureInput.value = canvas.toDataURL();
			}
		});
		
		// Check if canvas is blank
		function isCanvasBlank(canvas) {
			const context = canvas.getContext('2d');
			const pixelBuffer = new Uint32Array(
				context.getImageData(0, 0, canvas.width, canvas.height).data.buffer
			);
			return !pixelBuffer.some(color => color !== 0);
		}
	});
	
	// Clear canvas function
	function clearPad() {
		const canvas = document.getElementById('signature-pad');
		const ctx = canvas.getContext('2d');
		ctx.clearRect(0, 0, canvas.width, canvas.height);
	}
	</script>
</body>
</html>