<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$v_jadwal_list = new v_jadwal_list();

// Run the page
$v_jadwal_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$v_jadwal_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$v_jadwal_list->isExport()) { ?>
<script>
var fv_jadwallist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fv_jadwallist = currentForm = new ew.Form("fv_jadwallist", "list");
	fv_jadwallist.formKeyCountName = '<?php echo $v_jadwal_list->FormKeyCountName ?>';
	loadjs.done("fv_jadwallist");
});
var fv_jadwallistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fv_jadwallistsrch = currentSearchForm = new ew.Form("fv_jadwallistsrch");

	// Validate function for search
	fv_jadwallistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fv_jadwallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fv_jadwallistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fv_jadwallistsrch.lists["x_Kode_Fak"] = <?php echo $v_jadwal_list->Kode_Fak->Lookup->toClientList($v_jadwal_list) ?>;
	fv_jadwallistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($v_jadwal_list->Kode_Fak->lookupOptions()) ?>;
	fv_jadwallistsrch.lists["x_Thn_Akademik"] = <?php echo $v_jadwal_list->Thn_Akademik->Lookup->toClientList($v_jadwal_list) ?>;
	fv_jadwallistsrch.lists["x_Thn_Akademik"].options = <?php echo JsonEncode($v_jadwal_list->Thn_Akademik->lookupOptions()) ?>;
	fv_jadwallistsrch.lists["x_Periode"] = <?php echo $v_jadwal_list->Periode->Lookup->toClientList($v_jadwal_list) ?>;
	fv_jadwallistsrch.lists["x_Periode"].options = <?php echo JsonEncode($v_jadwal_list->Periode->options(FALSE, TRUE)) ?>;
	fv_jadwallistsrch.lists["x_Kelas_Akd"] = <?php echo $v_jadwal_list->Kelas_Akd->Lookup->toClientList($v_jadwal_list) ?>;
	fv_jadwallistsrch.lists["x_Kelas_Akd"].options = <?php echo JsonEncode($v_jadwal_list->Kelas_Akd->lookupOptions()) ?>;

	// Filters
	fv_jadwallistsrch.filterList = <?php echo $v_jadwal_list->getFilterList() ?>;
	loadjs.done("fv_jadwallistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$v_jadwal_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($v_jadwal_list->TotalRecords > 0 && $v_jadwal_list->ExportOptions->visible()) { ?>
<?php $v_jadwal_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($v_jadwal_list->ImportOptions->visible()) { ?>
<?php $v_jadwal_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($v_jadwal_list->SearchOptions->visible()) { ?>
<?php $v_jadwal_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($v_jadwal_list->FilterOptions->visible()) { ?>
<?php $v_jadwal_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$v_jadwal_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$v_jadwal_list->isExport() && !$v_jadwal->CurrentAction) { ?>
<form name="fv_jadwallistsrch" id="fv_jadwallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fv_jadwallistsrch-search-panel" class="<?php echo $v_jadwal_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="v_jadwal">
	<div class="ew-extended-search">
<?php

// Render search row
$v_jadwal->RowType = ROWTYPE_SEARCH;
$v_jadwal->resetAttributes();
$v_jadwal_list->renderRow();
?>
<?php if ($v_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$v_jadwal_list->SearchColumnCount++;
		if (($v_jadwal_list->SearchColumnCount - 1) % $v_jadwal_list->SearchFieldsPerRow == 0) {
			$v_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $v_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $v_jadwal_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_v_jadwal_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="v_jadwal" data-field="x_Kode_Fak" data-value-separator="<?php echo $v_jadwal_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $v_jadwal_list->Kode_Fak->editAttributes() ?>>
			<?php echo $v_jadwal_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $v_jadwal_list->Kode_Fak->Lookup->getParamTag($v_jadwal_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($v_jadwal_list->SearchColumnCount % $v_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php
		$v_jadwal_list->SearchColumnCount++;
		if (($v_jadwal_list->SearchColumnCount - 1) % $v_jadwal_list->SearchFieldsPerRow == 0) {
			$v_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $v_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Thn_Akademik" class="ew-cell form-group">
		<label for="x_Thn_Akademik" class="ew-search-caption ew-label"><?php echo $v_jadwal_list->Thn_Akademik->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Thn_Akademik" id="z_Thn_Akademik" value="LIKE">
</span>
		<span id="el_v_jadwal_Thn_Akademik" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="v_jadwal" data-field="x_Thn_Akademik" data-value-separator="<?php echo $v_jadwal_list->Thn_Akademik->displayValueSeparatorAttribute() ?>" id="x_Thn_Akademik" name="x_Thn_Akademik"<?php echo $v_jadwal_list->Thn_Akademik->editAttributes() ?>>
			<?php echo $v_jadwal_list->Thn_Akademik->selectOptionListHtml("x_Thn_Akademik") ?>
		</select>
</div>
<?php echo $v_jadwal_list->Thn_Akademik->Lookup->getParamTag($v_jadwal_list, "p_x_Thn_Akademik") ?>
</span>
	</div>
	<?php if ($v_jadwal_list->SearchColumnCount % $v_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Periode->Visible) { // Periode ?>
	<?php
		$v_jadwal_list->SearchColumnCount++;
		if (($v_jadwal_list->SearchColumnCount - 1) % $v_jadwal_list->SearchFieldsPerRow == 0) {
			$v_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $v_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $v_jadwal_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_v_jadwal_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="v_jadwal" data-field="x_Periode" data-value-separator="<?php echo $v_jadwal_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $v_jadwal_list->Periode->editAttributes() ?>>
			<?php echo $v_jadwal_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($v_jadwal_list->SearchColumnCount % $v_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php
		$v_jadwal_list->SearchColumnCount++;
		if (($v_jadwal_list->SearchColumnCount - 1) % $v_jadwal_list->SearchFieldsPerRow == 0) {
			$v_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $v_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kelas_Akd" class="ew-cell form-group">
		<label for="x_Kelas_Akd" class="ew-search-caption ew-label"><?php echo $v_jadwal_list->Kelas_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kelas_Akd" id="z_Kelas_Akd" value="LIKE">
</span>
		<span id="el_v_jadwal_Kelas_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="v_jadwal" data-field="x_Kelas_Akd" data-value-separator="<?php echo $v_jadwal_list->Kelas_Akd->displayValueSeparatorAttribute() ?>" id="x_Kelas_Akd" name="x_Kelas_Akd"<?php echo $v_jadwal_list->Kelas_Akd->editAttributes() ?>>
			<?php echo $v_jadwal_list->Kelas_Akd->selectOptionListHtml("x_Kelas_Akd") ?>
		</select>
</div>
<?php echo $v_jadwal_list->Kelas_Akd->Lookup->getParamTag($v_jadwal_list, "p_x_Kelas_Akd") ?>
</span>
	</div>
	<?php if ($v_jadwal_list->SearchColumnCount % $v_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($v_jadwal_list->SearchColumnCount % $v_jadwal_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $v_jadwal_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($v_jadwal_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($v_jadwal_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $v_jadwal_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($v_jadwal_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($v_jadwal_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($v_jadwal_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($v_jadwal_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $v_jadwal_list->showPageHeader(); ?>
<?php
$v_jadwal_list->showMessage();
?>
<?php if ($v_jadwal_list->TotalRecords > 0 || $v_jadwal->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($v_jadwal_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> v_jadwal">
<form name="fv_jadwallist" id="fv_jadwallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="v_jadwal">
<div id="gmp_v_jadwal" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($v_jadwal_list->TotalRecords > 0 || $v_jadwal_list->isGridEdit()) { ?>
<table id="tbl_v_jadwallist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$v_jadwal->RowType = ROWTYPE_HEADER;

// Render list options
$v_jadwal_list->renderListOptions();

// Render list options (header, left)
$v_jadwal_list->ListOptions->render("header", "left");
?>
<?php if ($v_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $v_jadwal_list->Kode_Fak->headerCellClass() ?>"><div id="elh_v_jadwal_Kode_Fak" class="v_jadwal_Kode_Fak"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $v_jadwal_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Kode_Fak) ?>', 1);"><div id="elh_v_jadwal_Kode_Fak" class="v_jadwal_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Thn_Akademik) == "") { ?>
		<th data-name="Thn_Akademik" class="<?php echo $v_jadwal_list->Thn_Akademik->headerCellClass() ?>"><div id="elh_v_jadwal_Thn_Akademik" class="v_jadwal_Thn_Akademik"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Thn_Akademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Thn_Akademik" class="<?php echo $v_jadwal_list->Thn_Akademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Thn_Akademik) ?>', 1);"><div id="elh_v_jadwal_Thn_Akademik" class="v_jadwal_Thn_Akademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Thn_Akademik->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Thn_Akademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Thn_Akademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Periode->Visible) { // Periode ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $v_jadwal_list->Periode->headerCellClass() ?>"><div id="elh_v_jadwal_Periode" class="v_jadwal_Periode"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $v_jadwal_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Periode) ?>', 1);"><div id="elh_v_jadwal_Periode" class="v_jadwal_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Kelas_Akd) == "") { ?>
		<th data-name="Kelas_Akd" class="<?php echo $v_jadwal_list->Kelas_Akd->headerCellClass() ?>"><div id="elh_v_jadwal_Kelas_Akd" class="v_jadwal_Kelas_Akd"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Kelas_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas_Akd" class="<?php echo $v_jadwal_list->Kelas_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Kelas_Akd) ?>', 1);"><div id="elh_v_jadwal_Kelas_Akd" class="v_jadwal_Kelas_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Kelas_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Kelas_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Kelas_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Kode_Mk->Visible) { // Kode_Mk ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Kode_Mk) == "") { ?>
		<th data-name="Kode_Mk" class="<?php echo $v_jadwal_list->Kode_Mk->headerCellClass() ?>"><div id="elh_v_jadwal_Kode_Mk" class="v_jadwal_Kode_Mk"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Kode_Mk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Mk" class="<?php echo $v_jadwal_list->Kode_Mk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Kode_Mk) ?>', 1);"><div id="elh_v_jadwal_Kode_Mk" class="v_jadwal_Kode_Mk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Kode_Mk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Kode_Mk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Kode_Mk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Nama_Mk_Ind) == "") { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $v_jadwal_list->Nama_Mk_Ind->headerCellClass() ?>"><div id="elh_v_jadwal_Nama_Mk_Ind" class="v_jadwal_Nama_Mk_Ind"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Nama_Mk_Ind->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama_Mk_Ind" class="<?php echo $v_jadwal_list->Nama_Mk_Ind->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Nama_Mk_Ind) ?>', 1);"><div id="elh_v_jadwal_Nama_Mk_Ind" class="v_jadwal_Nama_Mk_Ind">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Nama_Mk_Ind->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Nama_Mk_Ind->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Nama_Mk_Ind->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->SKS->Visible) { // SKS ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->SKS) == "") { ?>
		<th data-name="SKS" class="<?php echo $v_jadwal_list->SKS->headerCellClass() ?>"><div id="elh_v_jadwal_SKS" class="v_jadwal_SKS"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->SKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SKS" class="<?php echo $v_jadwal_list->SKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->SKS) ?>', 1);"><div id="elh_v_jadwal_SKS" class="v_jadwal_SKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->SKS->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->SKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->SKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Kelas->Visible) { // Kelas ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Kelas) == "") { ?>
		<th data-name="Kelas" class="<?php echo $v_jadwal_list->Kelas->headerCellClass() ?>"><div id="elh_v_jadwal_Kelas" class="v_jadwal_Kelas"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Kelas->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kelas" class="<?php echo $v_jadwal_list->Kelas->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Kelas) ?>', 1);"><div id="elh_v_jadwal_Kelas" class="v_jadwal_Kelas">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Kelas->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Kelas->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Kelas->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->Nama->Visible) { // Nama ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->Nama) == "") { ?>
		<th data-name="Nama" class="<?php echo $v_jadwal_list->Nama->headerCellClass() ?>"><div id="elh_v_jadwal_Nama" class="v_jadwal_Nama"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->Nama->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nama" class="<?php echo $v_jadwal_list->Nama->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->Nama) ?>', 1);"><div id="elh_v_jadwal_Nama" class="v_jadwal_Nama">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->Nama->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->Nama->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->Nama->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->UTS->Visible) { // UTS ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->UTS) == "") { ?>
		<th data-name="UTS" class="<?php echo $v_jadwal_list->UTS->headerCellClass() ?>"><div id="elh_v_jadwal_UTS" class="v_jadwal_UTS"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->UTS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UTS" class="<?php echo $v_jadwal_list->UTS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->UTS) ?>', 1);"><div id="elh_v_jadwal_UTS" class="v_jadwal_UTS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->UTS->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->UTS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->UTS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($v_jadwal_list->UAS->Visible) { // UAS ?>
	<?php if ($v_jadwal_list->SortUrl($v_jadwal_list->UAS) == "") { ?>
		<th data-name="UAS" class="<?php echo $v_jadwal_list->UAS->headerCellClass() ?>"><div id="elh_v_jadwal_UAS" class="v_jadwal_UAS"><div class="ew-table-header-caption"><?php echo $v_jadwal_list->UAS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UAS" class="<?php echo $v_jadwal_list->UAS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $v_jadwal_list->SortUrl($v_jadwal_list->UAS) ?>', 1);"><div id="elh_v_jadwal_UAS" class="v_jadwal_UAS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $v_jadwal_list->UAS->caption() ?></span><span class="ew-table-header-sort"><?php if ($v_jadwal_list->UAS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($v_jadwal_list->UAS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$v_jadwal_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($v_jadwal_list->ExportAll && $v_jadwal_list->isExport()) {
	$v_jadwal_list->StopRecord = $v_jadwal_list->TotalRecords;
} else {

	// Set the last record to display
	if ($v_jadwal_list->TotalRecords > $v_jadwal_list->StartRecord + $v_jadwal_list->DisplayRecords - 1)
		$v_jadwal_list->StopRecord = $v_jadwal_list->StartRecord + $v_jadwal_list->DisplayRecords - 1;
	else
		$v_jadwal_list->StopRecord = $v_jadwal_list->TotalRecords;
}
$v_jadwal_list->RecordCount = $v_jadwal_list->StartRecord - 1;
if ($v_jadwal_list->Recordset && !$v_jadwal_list->Recordset->EOF) {
	$v_jadwal_list->Recordset->moveFirst();
	$selectLimit = $v_jadwal_list->UseSelectLimit;
	if (!$selectLimit && $v_jadwal_list->StartRecord > 1)
		$v_jadwal_list->Recordset->move($v_jadwal_list->StartRecord - 1);
} elseif (!$v_jadwal->AllowAddDeleteRow && $v_jadwal_list->StopRecord == 0) {
	$v_jadwal_list->StopRecord = $v_jadwal->GridAddRowCount;
}

// Initialize aggregate
$v_jadwal->RowType = ROWTYPE_AGGREGATEINIT;
$v_jadwal->resetAttributes();
$v_jadwal_list->renderRow();
while ($v_jadwal_list->RecordCount < $v_jadwal_list->StopRecord) {
	$v_jadwal_list->RecordCount++;
	if ($v_jadwal_list->RecordCount >= $v_jadwal_list->StartRecord) {
		$v_jadwal_list->RowCount++;

		// Set up key count
		$v_jadwal_list->KeyCount = $v_jadwal_list->RowIndex;

		// Init row class and style
		$v_jadwal->resetAttributes();
		$v_jadwal->CssClass = "";
		if ($v_jadwal_list->isGridAdd()) {
		} else {
			$v_jadwal_list->loadRowValues($v_jadwal_list->Recordset); // Load row values
		}
		$v_jadwal->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$v_jadwal->RowAttrs->merge(["data-rowindex" => $v_jadwal_list->RowCount, "id" => "r" . $v_jadwal_list->RowCount . "_v_jadwal", "data-rowtype" => $v_jadwal->RowType]);

		// Render row
		$v_jadwal_list->renderRow();

		// Render list options
		$v_jadwal_list->renderListOptions();
?>
	<tr <?php echo $v_jadwal->rowAttributes() ?>>
<?php

// Render list options (body, left)
$v_jadwal_list->ListOptions->render("body", "left", $v_jadwal_list->RowCount);
?>
	<?php if ($v_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $v_jadwal_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Kode_Fak">
<span<?php echo $v_jadwal_list->Kode_Fak->viewAttributes() ?>><?php echo $v_jadwal_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Thn_Akademik->Visible) { // Thn_Akademik ?>
		<td data-name="Thn_Akademik" <?php echo $v_jadwal_list->Thn_Akademik->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Thn_Akademik">
<span<?php echo $v_jadwal_list->Thn_Akademik->viewAttributes() ?>><?php echo $v_jadwal_list->Thn_Akademik->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $v_jadwal_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Periode">
<span<?php echo $v_jadwal_list->Periode->viewAttributes() ?>><?php echo $v_jadwal_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Kelas_Akd->Visible) { // Kelas_Akd ?>
		<td data-name="Kelas_Akd" <?php echo $v_jadwal_list->Kelas_Akd->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Kelas_Akd">
<span<?php echo $v_jadwal_list->Kelas_Akd->viewAttributes() ?>><?php echo $v_jadwal_list->Kelas_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Kode_Mk->Visible) { // Kode_Mk ?>
		<td data-name="Kode_Mk" <?php echo $v_jadwal_list->Kode_Mk->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Kode_Mk">
<span<?php echo $v_jadwal_list->Kode_Mk->viewAttributes() ?>><?php echo $v_jadwal_list->Kode_Mk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Nama_Mk_Ind->Visible) { // Nama_Mk_Ind ?>
		<td data-name="Nama_Mk_Ind" <?php echo $v_jadwal_list->Nama_Mk_Ind->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Nama_Mk_Ind">
<span<?php echo $v_jadwal_list->Nama_Mk_Ind->viewAttributes() ?>><?php echo $v_jadwal_list->Nama_Mk_Ind->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->SKS->Visible) { // SKS ?>
		<td data-name="SKS" <?php echo $v_jadwal_list->SKS->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_SKS">
<span<?php echo $v_jadwal_list->SKS->viewAttributes() ?>><?php echo $v_jadwal_list->SKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Kelas->Visible) { // Kelas ?>
		<td data-name="Kelas" <?php echo $v_jadwal_list->Kelas->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Kelas">
<span<?php echo $v_jadwal_list->Kelas->viewAttributes() ?>><?php echo $v_jadwal_list->Kelas->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->Nama->Visible) { // Nama ?>
		<td data-name="Nama" <?php echo $v_jadwal_list->Nama->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_Nama">
<span<?php echo $v_jadwal_list->Nama->viewAttributes() ?>><?php echo $v_jadwal_list->Nama->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->UTS->Visible) { // UTS ?>
		<td data-name="UTS" <?php echo $v_jadwal_list->UTS->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_UTS">
<span<?php echo $v_jadwal_list->UTS->viewAttributes() ?>><?php echo $v_jadwal_list->UTS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($v_jadwal_list->UAS->Visible) { // UAS ?>
		<td data-name="UAS" <?php echo $v_jadwal_list->UAS->cellAttributes() ?>>
<span id="el<?php echo $v_jadwal_list->RowCount ?>_v_jadwal_UAS">
<span<?php echo $v_jadwal_list->UAS->viewAttributes() ?>><?php echo $v_jadwal_list->UAS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$v_jadwal_list->ListOptions->render("body", "right", $v_jadwal_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$v_jadwal_list->isGridAdd())
		$v_jadwal_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$v_jadwal->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($v_jadwal_list->Recordset)
	$v_jadwal_list->Recordset->Close();
?>
<?php if (!$v_jadwal_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$v_jadwal_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $v_jadwal_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $v_jadwal_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($v_jadwal_list->TotalRecords == 0 && !$v_jadwal->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $v_jadwal_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$v_jadwal_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$v_jadwal_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$v_jadwal_list->terminate();
?>